const canvas = document.getElementById("cv");
const ctx = canvas.getContext("2d");

let n = 100;
let l = 450;
let ax = 389.71143;
let ay = 225;
let wl = 80;

let x1 = 100;
let y1 = canvas.height - 50;

let v = 0;
let f1 = 0;   // 0=自由端 1=固定端
let f2 = 0;   // 動く/止まる
let f3 = 0;   // 腹線
let f4 = 0;   // 節線

let running = false;

/* ========= 描画 ========= */
function draw() {

  ctx.clearRect(0,0,canvas.width,canvas.height);

  /* 腹線 */
  if (f3 === 1) {
    ctx.strokeStyle = "red";
    for (let i=0;i<15;i++){
      let y = y1 - (i*wl*l/(2*ax) + f1*wl*l/(4*ax));
      ctx.beginPath();
      ctx.moveTo(0,y);
      ctx.lineTo(canvas.width,y);
      ctx.stroke();
    }
  }

  /* 節線 */
  if (f4 === 1) {
    ctx.strokeStyle = "black";
    for (let i=0;i<15;i++){
      let y = y1 - (wl*l/(4*ax) + i*wl*l/(2*ax) - f1*wl*l/(4*ax));
      ctx.beginPath();
      ctx.moveTo(0,y);
      ctx.lineTo(canvas.width,y);
      ctx.stroke();
    }
  }

  /* 入射波 */
  for (let i=0;i<n;i++){
    let x = x1 - wl*(5+i)*ay/l + v*ay/l;
    let y = y1 - wl*(5+i)*ax/l + v*ax/l;

    ctx.strokeStyle = "blue";
    ctx.beginPath();
    ctx.moveTo(x,y);
    ctx.lineTo(x+ax,y-ay);
    ctx.stroke();

    /* 反射波 */
    let rx = x1 - wl*(5+i)*ay/l + v*ay/l - f1*wl*ay/(l*2);
    let ry = y1 + wl*(5+i)*ax/l - v*ax/l + f1*wl*ax/(l*2);

    ctx.strokeStyle = "cyan";
    ctx.beginPath();
    ctx.moveTo(rx,ry);
    ctx.lineTo(rx+ax,ry+ay);
    ctx.stroke();
  }

  ctx.fillStyle = "gray";
  ctx.fillRect(0,canvas.height-49,canvas.width,50);

  ctx.fillStyle = "black";
  ctx.font = "16px Arial";

  if (f1 === 0) ctx.fillText("FreeEndReflection",50,50);
  if (f1 === 1) ctx.fillText("FixedEndReflection",50,50);

  if (ax < 410) ctx.fillText("30°",50,70);
  if (ax > 420) ctx.fillText("0°",50,70);
}

/* ========= アニメーション ========= */
function animate(){
  if (!running) return;

  v += 1 * f2;
  if (v > 1200) v = 1200 - wl;

  draw();
  requestAnimationFrame(animate);
}

/* ========= ボタン制御 ========= */

document.getElementById("free").onclick = () => {
	f1=0;draw();
};
document.getElementById("fixed").onclick = () => {
	f1=1;draw();
};

document.getElementById("zero").onclick = () => {
  ax=450; ay=0;draw();
};

document.getElementById("deg30").onclick = () => {
  ax=389.71143; ay=225;draw();
};

document.getElementById("start").onclick = () => {
  if(!running){
    f2=1;
    running=true;
    animate();
  }
};

document.getElementById("stop").onclick = () => {
  f2=0;
  running=false;
};

document.getElementById("step").onclick = () => {
  f2=0;
  v += 1;
  draw();running=false;
};

document.getElementById("reset").onclick = () => {
  f1=0; f2=0; f3=0; f4=0; v=0;
  running=false;
  draw();
};

document.getElementById("antinodeOn").onclick = () => f3=1;
document.getElementById("antinodeOff").onclick = () => f3=0;
document.getElementById("nodeOn").onclick = () => f4=1;
document.getElementById("nodeOff").onclick = () => f4=0;

draw();