/*grating.java
 *2006/9/11
 *grating.js
 *2025/11/29
 *Suzuki,Tetsuo 鈴木徹夫
 */

const canvas = document.getElementById("myCanvas");
const ctx = canvas.getContext("2d");
let n=4;
let i,ct,ct0;
let sl;//sleep time
let scale=1;
let k;
let x=[];
let y=[];
let r=[];
let dy=[];
let gr;
let f1,f2,f3;
let cl=[];//color
let d = { width: canvas.width, height: canvas.height };

function init() {
	ct=0;
	sl=30;
	gr=0.2;//重力加速度0.4
	k=0.8;
	f1=0;
	f2=0;
	f3=0;
	for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
			}
    r[0]=2*2.00;
	r[1]=2*1.732;
	r[2]=2*1.414;
	r[3]=2*1.00;
	cl[0]="red";
	cl[1]="magenta";
    cl[2]="blue";
	cl[3]="cyan";
	buffer = createBuffer(d.width, d.height);
    drawToBuffer();
	const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
	
}

function createBuffer(width, height) {
    const offscreenCanvas = document.createElement('canvas');
    offscreenCanvas.width = width;
    offscreenCanvas.height = height;
    return offscreenCanvas;
}

function drawToBuffer() {
	const g = buffer.getContext("2d");
	g.strokeStyle = "black";
	g.beginPath();
    g.moveTo(d.width/2,d.height-50);
    g.lineTo(d.width/2,200);
    g.moveTo(d.width/2,d.height-50);
    g.lineTo(d.width-120,d.height-50);	
	g.stroke();
	g.fillStyle ="black";
    g.font = "italic 17px Bookman Old Style";//	Arial
	g.fillText("v",d.width/2,180);
	g.fillText("t",d.width-100,d.height-50); 
	g.fillText("r =2.00",(d.width/10)-10,30);
	g.fillText("r =1.73",(2*d.width/10)-10,30);
	g.fillText("r =1.41",(3*d.width/10)-10,30);
	g.fillText("r =1.00",(4*d.width/10)-10,30); 
	for(i=0;i<=3;i++){
		g.fillStyle =cl[i];
		if(k==0){g.fillStyle="black";
		}
		g.beginPath();	
		g.arc((d.width/2)+2*(ct+1),(d.height-50-18*dy[i]),scale, 0, Math.PI * 2);
		g.fill();
	}
	if(f2==0){
		g.fillStyle = "white";
		g.fillRect(0,40,d.width/2,d.height);		
		for(i=0;i<=3;i++){
	    g.fillStyle =cl[i];
		g.beginPath();
		g.arc((x[i]),(y[i]),scale*r[i], 0, Math.PI * 2);
		g.fill();
		}
	}
	if(f2==1&&ct0%7==0){
		for(i=0;i<=3;i++){
	    g.fillStyle =cl[i];
		g.beginPath();
		g.arc((x[i]),(y[i]),scale*r[i], 0, Math.PI * 2);
		g.fill(); 
		}
	}	
	
 }
		
		
function move() {
	    ct=ct+f1*1;
		ct0=ct-1;
		for(i=0;i<=3;i++){
		dy[i]=dy[i]+gr*f1-k*dy[i]*f1/(r[i]*r[i]);
		y[i]=y[i]+dy[i]*f1; 
		}
}

function start() {
    setInterval(function() {
        move();
        drawToBuffer();
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.drawImage(buffer, 0, 0);
    }, 30);
}

document.getElementById('kl').addEventListener('click', kl);
document.getElementById('km').addEventListener('click', km);
document.getElementById('ks').addEventListener('click', ks);
document.getElementById('k0').addEventListener('click', k0);
document.getElementById('st').addEventListener('click', st);
document.getElementById('ex').addEventListener('click', ex);
document.getElementById('Run').addEventListener('click', Run);
document.getElementById('Strobo').addEventListener('click', Strobo);
document.getElementById('Reset').addEventListener('click', Reset);



function kl() {
	    k=0.8;	
		f1=0;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
			}
}
function km() {
	    k=0.5;
		f1=0;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
			}
}
function ks() {
        k=0.2;
		f1=0;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
			}	
}

function k0() {
        k=0;
		f1=0;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
			}	
}
function st() {
        scale=1;		
}
function ex() {
        scale=2;
}
function Run() {
        f1=1;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,40,d.width/2,d.height);
		for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;		 
}
}
function Strobo() {
	    f1=1;f2=1;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,40,d.width/2,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
}
}
function Reset() {
        f1=0;f2=0;ct=0;
		const g = buffer.getContext("2d");
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height);
			for(i=0;i<=3;i++){
 			x[i]=(i+1)*d.width/10;
			y[i]=50;
			dy[i]=0;
}
}

init();
start();




