const canvas = document.getElementById("myCanvas");
const ctx = canvas.getContext("2d");

let x,y,t,xbox,xini;
let v;
let dv;
let av;
let f;
let r,k1,m1;
let k,l,m;

let buffer = null;
let d = { width: canvas.width, height: canvas.height };

function init() {
	l=7900;
	xini=20+0.04*l-4*Math.sin(2*l*3.14159*2/360)+0.02*l;
	v=0;
	f=1;
	av=0;	
	dv=av;
	r=20;
	k1=0;m1=0;
	k=1.0;m=1.0;
				
    buffer = createBuffer(d.width, d.height);
    drawToBuffer();
}

function createBuffer(width, height) {
    const offscreenCanvas = document.createElement('canvas');
    offscreenCanvas.width = width;
    offscreenCanvas.height = height;
    return offscreenCanvas;
}

function drawToBuffer() {
    const g = buffer.getContext("2d");
	g.fillStyle = "white";
	g.fillRect(0,0,d.width,d.height);
	g.fillStyle = "black"; 
	g.font = ' 12px sans-serif'; 
    g.fillText("x。",xini,3*d.height/4+9);
	g.fillText("0",20+0.04*l-4*Math.sin(2*l*3.14159*2/360),3*d.height/4+9);
	g.fillText("-x。",xini-0.04*l,3*d.height/4+9);
	    if (m1==0){
			g.fillText("質量：m",3*d.width/4,20); 
			} 
		if (m1==1){
			g.fillText("質量：4m",3*d.width/4,20); 
			} 
        if (k1==0){
			g.fillText("ばね定数：k",3*d.width/4,40); 
			} 
		if (k1==1){
			g.fillText("ばね定数：4k",3*d.width/4,40); 
			} 			
		
		if (k1==0&&m1==0){
			g.fillText("T=2π√(m/k)",3*d.width/4,60); 
			}
		if (k1==0&&m1==1){
			g.fillText("T=2π√(4m/k)=4π√(m/k)",3*d.width/4,60); 
			}
		if (k1==1&&m1==0){
			g.fillText("T=2π√(m/4k)=π√(m/k)",3*d.width/4,60); 
			}
		if (k1==1&&m1==1){
			g.fillText("T=2π√(4m/4k)=2π√(m/k)",3*d.width/4,60); 
			}
		for (t=0;t<=l;t=t+2){				
		y=125+18*Math.cos(2*t*3.14159*2/360);//12--18
        x=20+0.04*t-4*Math.sin(2*t*3.14159*2/360)+0.02*t*Math.cos(k*m*v*2*3.1415*2/5000);
		g.fillStyle = "blue";
	    g.fillRect(x,y,1,1);
			}
		g.fillStyle = "orange";
	    g.fillRect(0,0,15,3*d.height/4);
		g.fillRect(0,3*d.height/4-4,d.width,4);
		g.strokeStyle = "blue";	
		g.beginPath();
		g.moveTo(15,125);
		g.lineTo(18,125);
		g.stroke();
		
		xbox=20+0.04*l-4*Math.sin(2*l*3.14159*2/360)+0.02*t*Math.cos(k*m*v*2*3.1415*2/5000);
		g.fillStyle = "blue";
		g.fillRect(xbox+2,18+88,40,40);	//23----20   25---35    
		
} 

function move() {
	dv=f*av;
	v=v+dv;
}

function startprogram() {
    setInterval(function() {
        move();
        drawToBuffer();
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.drawImage(buffer, 0, 0);
    }, 50);
}

document.getElementById('ma1').addEventListener('click', ma1);
document.getElementById('ma4').addEventListener('click', ma4);
document.getElementById('ke1').addEventListener('click', ke1);
document.getElementById('ke4').addEventListener('click', ke4);
document.getElementById('Start').addEventListener('click', Start);
document.getElementById('Reset').addEventListener('click', Reset);




function ke1() {
       k=1;t=0;v=0;dv=0;x=xini;av=0;k1=0;
}
function ke4() {
        k=2.0;t=0;v=0;dv=0;x=xini;av=0;k1=1;
}
function ma1() {
       m=1.0;t=0;v=0;dv=0;x=xini;av=0;m1=0;
}
function ma4() {
         m=0.5;t=0;v=0;dv=0;x=xini;av=0;m1=1;
}
function Start(){
        av=30;t=0;dv=0;v=0;
}
function Reset() {
        av=0;t=0;v=0;dv=0;v=0;m=1.0;k=1.0;m1=0;k1=0;
}



init();
startprogram();




