#!/usr/bin/ruby
# $Id: fwd2nmz.rb,v 1.3 2001/01/08 01:34:34 jh4xsy Exp $

Spldir = "/var/ax25/spool"
Expfil = "news"

# Print ERROR messages
def error_msg()
    $stderr.puts("Text Format ERROR!")
    $stderr.puts("This file is not F6FBB export file format?")
end

# Clean up PREVIOUS LOG files.
def clean_up()
    dirp = Dir.open("/var/tmp")
    for f in dirp
        $_ = f
        if /^[A-Z0-9]*.txt/ then
            file = sprintf("/var/tmp/%s", $_)
            File.unlink file
        end
    end
    dirp.close

    if Time.now.strftime('%U') == "00" then
        dirp = Dir.open(Spldir)
        for f in dirp
            $_ = f
            if /\W[0-9]/ then
                file = sprintf("%s/%s", Spldir, $_)
                File.unlink file
            end
        end
        dirp.close
    end

end

# FILE-FWD MESSAGE SELECTOR - MAIN PROGRAM -
# original C program by JK1IOR, JH4XSY 
def selmsg()
    source = sprintf("%s/%s.0%02d", Spldir, Expfil, Time.now.strftime('%U'))
    f = open(source, "r")

    until f.eof?
        line = f.gets()
        line.chop!				# convert \r\n -> \n
        field = line.split(" ")
        if field[3] == nil			# File format check!
            error_msg()
            break
        end
        file = sprintf("/var/tmp/%s.txt", field[3])
        p = open(file, "a")			# Export to @BBS.txt
        p.puts(line)
        while line = f.gets()
	    line.chop!				# convert \r\n -> \n
            p.puts(line)
            break if line =~ /^\/EX/		# Export until "/EX"
        end
        if line == nil				# File format check!
            error_msg()
        end
        p.close
    end
    f.close
end

# LOG FILE CUTTER - MAIN PROGRAM -
#
def nmzmtn()

    index = sprintf("%s/nmzmtn.idx", Spldir)
    t_dir = "/home/htdocs/pocket"

    f = open(index, "r")
    line = f.gets()
    f.close
    i = line.to_i			# Get current index number

    i = i+1				# Set new index number
    if Time.now.strftime('%U') == "01"
        i = 1				# reset index number at new year
    end 

    f = open("/var/tmp/POCKET.txt", "r")
    until f.eof?
        line = f.gets()

        path = sprintf("%s/%s", t_dir, Time.now.strftime('%Y'))
        if !File.exist? path 
            Dir.mkdir(path)		# create new diretory if new year!
        end

	file = sprintf("%s/%s/msg%04d.txt", t_dir, Time.now.strftime('%Y'), i)
        p = open(file, "w")		# Create namazu log-file
        while line = f.gets()
            p.puts(line)
            if line =~ /^\/EX/
                i = i+1
                p.close
                break
            end
        end

    end
    f.close

    f = open(index, "w")
    i = i-1
    line = sprintf("%s", i)
    f.puts(line)			# Save current index number
    f.close 

end



if Time.now.strftime('%w') == "0" then

    clean_up()

    from = sprintf("%s/%s", Spldir, Expfil)
    to   = sprintf("%s/%s.0%02d", Spldir, Expfil, Time.now.strftime('%U'))
    File.rename(from, to)

    selmsg()
    nmzmtn()

end
