* 8Queen.asm -- Solve 8 Queens
* ASSIST09 SERVICE ENTRY CODE
INCHP   EQU     0       GET CHARACTER FROM CONSOLE
OUTCH   EQU     1       PUT CHARACTER TO CONSOLE
PDATA1  EQU     2       PUT STRING TO CONSOLE
PDATA   EQU     3       PUT CR/LF AND STRING TO CONSOLE
OUT2HS  EQU     4       PUT HEX CHARACTERS 8 BITS VALUE IN X-REG
OUT4HS  EQU     5       PUT HEX CHARACTERS 16 BITS VALUE IN X-REG
PCRLF   EQU     6       PUT CR/LF TO CONSOLE
SPACE   EQU     7       PUT BLANK CHARACTER TO CONSOLE
MONITR  EQU     8       ENTER ASSIST09 MONITOR
VCTSW   EQU     9       EXAMINE/SWAP VECTOR TABLE
BRKPT   EQU     10      PUT REGISTER VALUES THEN ENTER COMMAND HANDLER
PAUSE   EQU     11      TERMINATE PROCESS THEN CHECK FREEZE/CANCEL STATE
*
* CONSTANT VALUES
EOT     EQU     $04     END OF TEXT
CR      EQU     $0D
LF      EQU     $0A
FALSE   EQU     0
TRUE    EQU     1
*
QUEENS  EQU     8
TBLSIZE EQU     QUEENS
*
RAMTOP  EQU     $C000
*
        ORG     RAMTOP
MAIN:
        LEAU    USTACK,PCR
*
        LEAX    QOPEN,PCR
        SWI
        FCB     PDATA1
*
        CLR     N,PCR
        LBSR    INIT
        BSR     TRY
*
        RTS                     RETURN TO ASSIST09
*
*       Solve 8 Queens
TRY:
*
        LDA     H,PCR
        PSHU    A
*
        LDA     #0
        STA     H,PCR
TRY1:
*
        LDB     H,PCR
        LEAX    COL,PCR
        LDA     B,X
*
        LDB     N,PCR
        SUBB    H,PCR
        ADDB    #TBLSIZE-1
        LEAX    UP,PCR
        ANDA    B,X
*
        LDB     N,PCR
        ADDB    H,PCR
        LEAX    DOWN,PCR
        ANDA    B,X
*
        CMPA    #TRUE
        LBNE    TRY2
*
        LDA     H,PCR
        LDB     N,PCR
        LEAX    Q,PCR
        STA     B,X
*
        LDA     #FALSE
*
        LDB     H,PCR
        LEAX    COL,PCR
        STA     B,X
*
        LDB     N,PCR
        SUBB    H,PCR
        ADDB    #TBLSIZE-1
        LEAX    UP,PCR
        STA     B,X
*
        LDB     N,PCR
        ADDB    H,PCR
        LEAX    DOWN,PCR
        STA     B,X
*
        INC     N,PCR
        LDA     N,PCR
        CMPA    #TBLSIZE
        BNE     TRY4
*
        BSR     PRINT
        BRA     TRY5
TRY4:
        LBSR    TRY
        PULU    A
        STA     H,PCR
TRY5:
*
        DEC     N,PCR
*
        LDA     #TRUE
*
        LDB     N,PCR
        ADDB    H,PCR
        LEAX    DOWN,PCR
        STA     B,X
*
        LDB     N,PCR
        SUBB    H,PCR
        ADDB    #TBLSIZE-1
        LEAX    UP,PCR
        STA     B,X
*
        LDB     H,PCR
        LEAX    COL,PCR
        STA     B,X
*
        BRA     TRY3
*
TRY3:
TRY2:
*
        INC     H,PCR
        LDA     H,PCR
        CMPA    #TBLSIZE
        LBNE    TRY1
        RTS
*
INIT:
        LDA     #TRUE
        LDB     #0
        LEAX    COL,PCR
INIT1:
        STA     B,X
        INCB
        CMPB    #TBLSIZE
        BLT     INIT1
*
        LDB     #0
        LEAX    UP,PCR
        LEAY    DOWN,PCR
INIT2:
        STA     B,X
        STA     B,Y
        INCB
        CMPB    #TBLSIZE*2
        BLT     INIT2
*
        RTS
*
PRINT:
        SWI
        FCB     SPACE
        LDB     #0
        LEAX    Q,PCR
PRINT1:
        LDA     B,X
        ADDA    #'0
        SWI
        FCB     OUTCH
        SWI
        FCB     SPACE
        INCB
        CMPB    #8
        BLT     PRINT1
        BSR     NEWLINE
        RTS
*
NEWLINE:
        SWI
        FCB     PCRLF
        RTS
*
QOPEN:  FCB     CR,LF
        FCC     '=== 8 Queens ==='
        FCB     CR,LF,EOT
*
        FCB     '*
Q:      RMB     TBLSIZE
COL:    RMB     TBLSIZE
UP:     RMB     TBLSIZE*2
DOWN:   RMB     TBLSIZE*2
        FCB     '*
N:      RMB     1
K:      RMB     1
H:      RMB     1
        FCB     '*
TMP:    RMB     1
        FCB     '*
*
        RMB     TBLSIZE
USTACK:
        FCB     '*
*
        END
