/** ݒϐ
 */
/*
 * Copyright (c) 2000-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	ifmmainH
#define	ifmmainH

#include "critsect.h"
#include "ifmmedia.h"

extern void __fastcall getSusieCompatiAppName(TStringList* AppList) ;
extern HICON __fastcall getIconHandle(const char *filename, const DWORD filetype, DWORD flag) ;
extern bool __fastcall matchesExt(const AnsiString &filename, char *ext) ;

typedef struct
{
    /* IvVݒ */
#define OPTION_MemoryPlay	0	// ͎Đ
#define OPTION_ReturnErr	1	// 킴ƃG[Ԃ
#define OPTION_StayOnTop	2	// EBhEɑOʂ
#define OPTION_NoActive		3	// EBhEANeBu
#define OPTION_WindowPos	4	// EBhEʒuŒ
#define OPTION_WindowPosX	5	// v[[̈ʒu
#define OPTION_WindowPosY	6	// v[[̈ʒu
#define OPTION_Minimized	7	// EBhEŏŋN
#define OPTION_PreviewMovie	8	// vr[
#define OPTION_PreviewPos1	9	// vr[ʒu
#define OPTION_PreviewPos2	10	// vr[ʒu
#define OPTION_MovieCenter	11	// 𒆉ɕ\
#define OPTION_MovieSize	12	// ̃TCY{
#define OPTION_MoviePosX	13	// v[[̈ʒu
#define OPTION_MoviePosY	14	// v[[̈ʒu
#define OPTION_MovieHeight	15	// ̃JX^TCY
#define OPTION_MovieWidth	16	// ̃JX^TCY
#define OPTION_DebugMode	17	// t@C`FbNȂōĐ݂
#define OPTION_SusieOnly	18	// SusieȊO̎gps
#define OPTION_IsSusie		19	// ĂяoSusieH
#define OPTION_PlayByViX	20	// ViXŃvr[݂̂𗘗pIvVBGetPictureŃG[ԂB
#define OPTION_IsViX		21	// ĂяoViXH
#define OPTION_COUNT 22
  DWORD option[ OPTION_COUNT ] ;

  /* T|[g` */
  bool playable[ FILETYPE_COUNT ] ;
#define WAVEPLAY 0
#define MIDIPLAY 1
#define AVIPLAY  2
#define AIFFPLAY 3
#define MOVPLAY  4
#define MPEGPLAY 5
#define MPAPLAY  6
#define AUPLAY   7
#define OGGPLAY  8
#define RMPLAY   9
#define USERPLAY 10
} IFMMVAR_STRUCT ;

class TPluginVar
{
public:
    TPluginVar() {} ;
    ~TPluginVar() {} ;

    DWORD getOption(DWORD id)
    {
        TCriticalSection cs ;
        return m_var.option[ id ] ;
    }

    void getPreviewPos(double *pd)
    {
        TCriticalSection cs ;
        pd[0] = m_var.option[ OPTION_PreviewPos1 ] ;
        pd[1] = m_var.option[ OPTION_PreviewPos2 ] ;
    }

    void getPlayableTable(bool *pb)
    {
        TCriticalSection cs ;
        for (int i=0; i < FILETYPE_COUNT; i++)
        {
            pb[i] = m_var.playable[i] ;
        }
    }

    void set(IFMMVAR_STRUCT *ps, const AnsiString &userDefExt)
    {
        TCriticalSection cs ;
        m_var = *ps ;
        m_userDefExt = userDefExt ;
    }

    void get(IFMMVAR_STRUCT *ps, AnsiString &userDefExt)
    {
        TCriticalSection cs ;
        *ps = m_var ;
        userDefExt = m_userDefExt ;
    }

    void getVar(IFMMVAR_STRUCT *ps)
    {
        TCriticalSection cs ;
        *ps = m_var ;
    }

    void setUserDefExt(const AnsiString &userDefExt)
    {
        TCriticalSection cs ;
        m_userDefExt = userDefExt ;
    }

    char* getUserDefExt(void)
    {
        TCriticalSection cs ;
        return m_userDefExt.c_str() ;
    }

private:
    IFMMVAR_STRUCT m_var ;
    AnsiString m_userDefExt ;
} ;
extern TPluginVar g_var ; /* O[o */

#endif /* ifmmainH */

