/** DLLC^[tF[X
 */
/*
 * Copyright (c) 2000-2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <Registry.hpp>
#include <Masks.hpp>
#include <memory>
#pragma hdrstop

#include "ifmmain.h"
#include "ifmmedia.h"
#include "OptionUnit.h"
//---------------------------------------------------------------------------
USEFORM("PlayerUnit.cpp", PlayForm);
USEFORM("OptionUnit.cpp", DialogForm);
//---------------------------------------------------------------------------
void  __fastcall loadOptions(void) ;
bool __fastcall putTempFile(char *aFilename, const char *aBuff, const long aLen) ;
bool __fastcall getFileIcon(const char *aFilename, HANDLE *pHBInfo, HANDLE *pHBm, const DWORD aFileType) ;
int __fastcall GetPictureEx(const LPSTR aBuff, const long aLen, const unsigned int aFlag,
									 HANDLE *pHBInfo, HANDLE *pHBm,
									 const SPI_PROGRESS lpPrgressCallback,
                   const long lData, const bool isPreview) ;
//---------------------------------------------------------------------------

/* O[o */
TPluginVar g_var ;
const char *g_ifmmCopyrightString = "MediaPlayer v1.4.0" ;
const char *g_titleString = "ifmm.spi" ;
//---------------------------------------------------------------------------
/** ȂR[obN
 * R[obN֐NULL̏ꍇɂgpB
 * xNULL`FbNȂĂǂ悤ɂ邽߁B
 */
static int __stdcall nopCallback(int nNum, int nDenom, long lData)
{
	return 0 ;
}
//---------------------------------------------------------------------------
/** DLLGg[|Cg
 */
BOOL WINAPI DllMain(HINSTANCE /*hinstDLL*/, DWORD fwdReason, LPVOID /*lpvReserved*/)
{
	BOOL result = TRUE ;

	switch ( fwdReason )
	{
		case DLL_PROCESS_ATTACH :
			loadOptions() ;
			break ;
	}

	return result ;
}
//---------------------------------------------------------------------------
/** ݒ
 */
void __fastcall _loadDefault(IFMMVAR_STRUCT &aVar, AnsiString &aUserExt)
{
	// ɓinjĐ
	aVar.option[ OPTION_MemoryPlay ] = TRUE ;
	// 킴ƃG[Ԃ
	aVar.option[ OPTION_ReturnErr ]  = FALSE ;
	// EBhEɑOʂɂ
	aVar.option[ OPTION_StayOnTop ]  = FALSE ;
	// v[[̃EBhEANeBuɂ
	aVar.option[ OPTION_NoActive ]   = FALSE ;
	// v[[̃EBhEʒuŒ肷
	aVar.option[ OPTION_WindowPos ]  = FALSE ;
	aVar.option[ OPTION_WindowPosX ] = 0 ;
	aVar.option[ OPTION_WindowPosY ] = 0 ;
	// v[[̃EBhEŏŋN
	aVar.option[ OPTION_Minimized ]  = FALSE ;
	// Susieɓ̍ŏ̃t[Ԃ
	aVar.option[ OPTION_PreviewMovie ] = TRUE ;
	// ̃vr[ʒu(PʁFb)
	aVar.option[ OPTION_PreviewPos1 ] = 0 ;
	aVar.option[ OPTION_PreviewPos2 ] = 5 ;
	// vC[̃EBhEʒɕ\
	aVar.option[ OPTION_MovieCenter ] = FALSE ;
	// \̃TCY{
	aVar.option[ OPTION_MovieSize ] = MOVIESIZE_X1 ;
	// debugƂ... `sȂŉłĐ݂
	aVar.option[ OPTION_DebugMode ] = FALSE ;
	// Susie݊ȊOgpsɂ
	aVar.option[ OPTION_SusieOnly ] = TRUE ;

	// JX^TCY
	aVar.option[ OPTION_MovieHeight ] = Screen->WorkAreaHeight * 2 / 3 ;
	aVar.option[ OPTION_MovieWidth ]  = Screen->WorkAreaWidth  * 2 / 3 ;
	aVar.option[ OPTION_MoviePosY ] = ( (Screen->WorkAreaHeight - aVar.option[ OPTION_MovieHeight ] -78/*PlayForm->Height*/) /2 ) ;
	aVar.option[ OPTION_MoviePosX ] = ( (Screen->WorkAreaWidth - aVar.option[ OPTION_MovieWidth ]  -(284 -276)/*PlayForm->Width  -PlayForm->ClientWidth*/)  /2 ) ;

	//uSusie݊vH
	/*
		Susie ̂悤ɃJ^OiTlCj쐬Ƃ GetPreviewA
		ʂɕ\Ƃ GetPicture ĂяoB
		܂ ifmm.spi ɓ삷邱ƂmFĂ\tgB
		vOCĂяoexe̖OŃ`FbN
		"susie"܂"ccnn"܂܂ĂΗǂ
		̃\tg̓WXgɓo^
	*/
	AnsiString exename = ExtractFileName( ParamStr(0) ).LowerCase() ;
	if (   exename.AnsiPos( "susie" )
			|| exename.AnsiPos( "ccnn" )
		 )
	{
	 aVar.option[ OPTION_IsSusie ] = TRUE ;
	}
	else
	{
		aVar.option[ OPTION_IsSusie ] = FALSE ;
		// WXgSusie݊`FbN
		std::auto_ptr<TStringList> sl( new TStringList() ) ;
		getSusieCompatiAppName( sl.get() ) ;
		int count = sl->Count ;
		for (int i=0; i < count; i++)
		{
			if ( exename.AnsiPos( sl->Strings[i].LowerCase() ) != 0 )
			{
				aVar.option[ OPTION_IsSusie ] = TRUE ;
				break ;
			}
		}
	}
	// ViXōĐ
	aVar.option[ OPTION_PlayByViX ] = TRUE ;
	//ĂяoViXH
	if ( exename.AnsiPos( "vix" ) != 0 )
	{
	 aVar.option[ OPTION_IsViX ] = TRUE ;
	}
	else
	{
	 aVar.option[ OPTION_IsViX ] = FALSE ;
	}

	// T|[g`
	for (int i=0; i < FILETYPE_COUNT; i++)
	{
	 aVar.playable[i] = true;
	}
	// ̂̓ftHg̓It
	aVar.playable[ MOVPLAY ] = false ;
	aVar.playable[ OGGPLAY ] = false ;
	aVar.playable[ RMPLAY ] = false ;

	// [U[`gq
	aUserExt = "*.wma;*.wmv;*.asf;" ;
}
//---------------------------------------------------------------------------
/** ݒWXgǂ݂
 */
void __fastcall loadOptions(void)
{
	AnsiString user_ext ;
	IFMMVAR_STRUCT var ;
	_loadDefault( var, user_ext ) ;

	std::auto_ptr<TRegistry> reg( new TRegistry( KEY_EXECUTE ) ) ;
try
{
	//reg->RootKey = HKEY_CURRENT_USER ;
	bool opened = reg->OpenKey( "\\Software\\shimitei\\ifmm", false ) ;
	if ( opened )
	{
	
#define IFEXIST_READ_OPTION(type, index, opt) \
	if ( reg->ValueExists( opt ) ) \
	{ \
		var.option[ index ] = reg->Read ## type( opt ) ; \
	}

		IFEXIST_READ_OPTION( Bool, OPTION_MemoryPlay, "Memory" ) ;
		IFEXIST_READ_OPTION( Bool, OPTION_ReturnErr, "Error" ) ;
		IFEXIST_READ_OPTION( Bool, OPTION_StayOnTop, "StayOnTop" ) ;
		IFEXIST_READ_OPTION( Bool, OPTION_NoActive, "NoActive" ) ;

		IFEXIST_READ_OPTION( Bool, OPTION_WindowPos, "WindowPos" ) ;
		IFEXIST_READ_OPTION( Integer, OPTION_WindowPosX, "WindowPosX" ) ;
		IFEXIST_READ_OPTION( Integer, OPTION_WindowPosY, "WindowPosY" ) ;

		IFEXIST_READ_OPTION( Bool, OPTION_PreviewMovie, "PreviewMovieFrame" ) ;

		IFEXIST_READ_OPTION( Integer, OPTION_PreviewPos1, "PreviewPos1" ) ;
		IFEXIST_READ_OPTION( Integer, OPTION_PreviewPos2, "PreviewPos2" ) ;

		IFEXIST_READ_OPTION( Bool, OPTION_Minimized, "Minimized" ) ;
		IFEXIST_READ_OPTION( Integer, OPTION_MovieSize, "MovieSize" ) ;
		IFEXIST_READ_OPTION( Bool, OPTION_MovieCenter, "MovieCenter" ) ;

		// JX^TCY
		int tmpX = 0 ;
		int tmpY = 0 ;
		int tmpH = 0 ;
		int tmpW = 0 ;
#define IFEXIST_READ_VALUE(type, var, opt) \
  if ( reg->ValueExists( opt ) ) \
  { \
		var = reg->Read ## type( opt ) ; \
  }
		IFEXIST_READ_VALUE( Integer, tmpX, "MoviePosX" ) ;
		IFEXIST_READ_VALUE( Integer, tmpY, "MoviePosY" ) ;
		IFEXIST_READ_VALUE( Integer, tmpH, "MovieHeight" ) ;
		IFEXIST_READ_VALUE( Integer, tmpW, "MovieWidth" ) ;
		if ( (tmpH != 0) && (tmpW != 0) )
		{
			var.option[ OPTION_MoviePosX   ] = tmpX ;
			var.option[ OPTION_MoviePosY   ] = tmpY ;
			var.option[ OPTION_MovieHeight ] = tmpH ;
			var.option[ OPTION_MovieWidth  ] = tmpW ;
	  }

		IFEXIST_READ_OPTION( Bool, OPTION_SusieOnly, "SusieOnly" ) ;
		IFEXIST_READ_OPTION( Bool, OPTION_PlayByViX, "PlayByViX" ) ;
  	IFEXIST_READ_OPTION( Bool, OPTION_DebugMode, "Debug" ) ;

	  // T|[g`
#define IFEXIST_READ_PLAYABLE(opt) \
	if ( reg->ValueExists( #opt ) ) \
	{ \
		var.playable[ opt##PLAY ] = reg->ReadBool( #opt ) ; \
  }
		IFEXIST_READ_PLAYABLE( WAVE ) ;
		IFEXIST_READ_PLAYABLE( MIDI ) ;
		IFEXIST_READ_PLAYABLE( AVI ) ;
		IFEXIST_READ_PLAYABLE( AIFF ) ;
		IFEXIST_READ_PLAYABLE( MOV ) ;
		IFEXIST_READ_PLAYABLE( MPEG ) ;
		IFEXIST_READ_PLAYABLE( MPA ) ;
		IFEXIST_READ_PLAYABLE( AU ) ;
		IFEXIST_READ_PLAYABLE( OGG ) ;
		IFEXIST_READ_PLAYABLE( RM ) ;
		IFEXIST_READ_PLAYABLE( USER ) ;

		if ( reg->ValueExists( "UserDefExt" ) )
		{
			user_ext = reg->ReadString( "UserDefExt" ) ;
		}
	}
}
catch (const Exception &E)
{
	//throw ;
}
catch (...)
{
	//throw ;
}

	g_var.set( &var, user_ext ) ;
}
//---------------------------------------------------------------------------
/** Susie݊o^Avǂ
 * ֐...
 */
void __fastcall getSusieCompatiAppName(TStringList* aAppList)
{
	aAppList->Clear() ;
  std::auto_ptr<TRegistry> reg( new TRegistry(KEY_EXECUTE) );
  //reg->RootKey = HKEY_CURRENT_USER ;
  bool opened = reg->OpenKey( "\\Software\\shimitei\\ifmm\\SusieCompati", false ) ;
  if ( opened )
  {
		reg->GetValueNames( aAppList ) ;
  }
}
//---------------------------------------------------------------------------
/** ꎞt@C쐬
 * @param[out] aFilename 쐬e|t@CԂ
 * @param[in] aBuff f[^ւ̃|C^
 * @param[in] aLen f[^TCY
 * @return 쐬ɐtrueAsfalseԂ
 */
bool __fastcall putTempFile(char *aFilename, const char *aBuff, const long aLen)
{
	char dir[ MAX_PATH ] ;

	if ( GetTempPath( MAX_PATH, dir ) == 0 )
	{
		//MessageBox( NULL, "e|tH_̎擾ɎsB", "ifmm.spi", MB_OK ) ;
		return false ;
	}
	if ( GetTempFileName( dir, "ifm", 0, aFilename ) == 0 )
	{
		//MessageBox( NULL, "e|t@C̍쐬ɎsB", "ifmm.spi", MB_OK ) ;
		return false ;
	}

	bool result = false ;
	HANDLE hf = CreateFile( aFilename, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL ) ;
	if ( hf == INVALID_HANDLE_VALUE )
	{
		//MessageBox( NULL, "e|t@C̍쐬ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
	}
	else
	{
		try
		{
			DWORD read_bytes ;
			BOOL api_ret = WriteFile( hf, aBuff, aLen, &read_bytes, NULL ) ;
			if ( api_ret != 0)
			{
				// function succeeds
				result = true ;
			}
			else
			{
				//MessageBox( NULL, "e|t@C݂̏ɎsB", "ifmm.spi", MB_OK ) ;
				result = false ;
			}
		}
		__finally
		{
			CloseHandle( hf ) ;
			if ( ! result )	DeleteFile( aFilename ) ;
		}
	}

	return result ;
}
//---------------------------------------------------------------------------
/** t@C^CṽACRnh𓾂
 * @param[in] aFilename t@CBNULL
 * @param[in] aFileType t@C^Cv
 * @return ACRnhԂ
 */
HICON __fastcall getIconHandle(const char *aFilename, const DWORD aFileType, DWORD flag)
{
  /* t@C^CvƓ悤ȕ */
  char *extTable[] =
  {
    "*.wav", /* 0 */
    "*.wav", /* 1 */
    "*.aif",
    "*.mid",
    "*.avi",
    "*.mov", /* 5 */
    "*.mpg",
    "*.mpa",
    "*.au",
    "*.ogg",
    "*.rm",  /* 10 */
  } ;
  SHFILEINFO fi ;
  DWORD index = (aFileType & 0xff) ;

  if ( index >= (sizeof(extTable)/sizeof(extTable[0])) ) index = 0 ;
  AnsiString ext = extTable[ index ];

  if ( aFileType == FILETYPE_USER )
  {
    if ( aFilename == NULL )
    {
			ext = "*.spi" ;
		}
		else
		{
			ext = "*" ;
			ext += ExtractFileExt(aFilename) ;
		}
  }

  SHGetFileInfo( ext.c_str(), NULL, &fi, sizeof(SHFILEINFO),
              SHGFI_USEFILEATTRIBUTES | SHGFI_ICON | flag ) ;
  return fi.hIcon ;
}
//---------------------------------------------------------------------------
/** ACRnhDIB쐬
 * @param[in] aFilename t@CBNULL
 * @param[in,out] pHBInfo SusieɕԂBITMAPINFO߂nh̃|C^
 * @param[in,out] pHBm SusieɕԂBITMAPf[^߂nh̃|C^
 * @param[in] aFileType
 * @return 
 */
bool __fastcall getFileIcon(const char *aFilename, HANDLE *pHBInfo, HANDLE *pHBm, const DWORD aFileType)
{
//TODO:܂肭ǂ
  std::auto_ptr<Graphics::TBitmap> bmp( new (Graphics::TBitmap) ) ;
  bmp->Height = 32 ; //32x32Ɍߕt
  bmp->Width  = 32 ;
  bmp->PixelFormat = pf24bit ;

	HICON h_icon = getIconHandle( aFilename, aFileType, SHGFI_LARGEICON ) ;
	bool result = false ;
try
{
	result = DrawIconEx( bmp->Canvas->Handle, 0, 0, h_icon, 0, 0, 0, NULL, DI_NORMAL ) ;

	if ( result )
	{
		std::auto_ptr<TMemoryStream> ms( new TMemoryStream() ) ;
		bmp->SaveToStream( ms.get() );
		char *buffer = static_cast<char*>( ms->Memory ) ;

		BITMAPFILEHEADER *pbm_fh ;
		BITMAPINFOHEADER *pbm_info ;
		pbm_fh = reinterpret_cast<BITMAPFILEHEADER *>( buffer ) ;
		pbm_info = reinterpret_cast<BITMAPINFOHEADER *>( buffer + sizeof(BITMAPFILEHEADER) ) ;
		int img_size = pbm_info->biWidth * 3;
		img_size = (img_size +3) & ~3 ; // 4byteEɍ킹
		img_size *= abs( pbm_info->biHeight ) ;
		*pHBInfo = LocalAlloc( LMEM_FIXED, sizeof(BITMAPINFOHEADER) ) ;
		if ( *pHBInfo == NULL )
		{
			result = false ;
		}
		else
		{
			*pHBm = LocalAlloc( LMEM_FIXED, img_size ) ;
			if ( *pHBm == NULL )
			{
				LocalFree( *pHBInfo ) ;
				result = false ;
			}
			else
			{
				BITMAPINFOHEADER *pInfo ;
				pInfo = reinterpret_cast<BITMAPINFOHEADER *>( *pHBInfo ) ;
				pInfo->biSize          = sizeof(BITMAPINFOHEADER) ;
				pInfo->biWidth         = pbm_info->biWidth ;
				pInfo->biHeight        = pbm_info->biHeight ;
				pInfo->biPlanes        = 1 ;
				pInfo->biBitCount      = 24 ;
				pInfo->biCompression   = 0 ;
				pInfo->biSizeImage     = img_size ;
				pInfo->biXPelsPerMeter = 0 ;
				pInfo->biYPelsPerMeter = 0 ;
				pInfo->biClrUsed       = 0 ;
				pInfo->biClrImportant  = 0 ;

				char *Bm = reinterpret_cast<char *>( *pHBm ) ;
				char *p = buffer + pbm_fh->bfOffBits ;
				CopyMemory( Bm, p, img_size ) ;
			}
		}
	}
}
__finally
{
	DestroyIcon( h_icon ) ;
}

	return result ;
}
//---------------------------------------------------------------------------
/** gq̃}b`eXg
 * @param[in] filename t@C
 * @param[in,out] ext̓J}؂ "*.html;*.htm;*.eml"
 *        ext ̓e *j* .
 * @return }b`trueԂ
 */
bool __fastcall matchesExt(const AnsiString &aFilename, char *aExt)
{
	char *msk = aExt ;
	for (;;)
	{
		if ( *msk == '\0' ) return false ;
		char *p = AnsiStrScan( msk, ';' ) ;
		if ( p )
		{
			*p = '\0' ;
		}
		if ( MatchesMask( aFilename, msk ) ) return true ;
		if ( p == NULL )
		{
			return false ;
		}
		msk = p +1 ;
	}
}
//---------------------------------------------------------------------------

//ȉSusievOCAPI
//---------------------------------------------------------------------------
int __stdcall GetPluginInfo(int aInfoNum, LPSTR aBuff, int aBuffLen)
{
	char *infomation[] =
	{
  /* 0     */  "00IN",
  /* 1     */  const_cast<char*>( g_ifmmCopyrightString ),
  /* 2*0+2 */  NULL, /* filemask */
  /* 2*0+3 */  "Media file",
  } ;

  // ͈͊O
  if ( aInfoNum < 0 ) return 0 ;
  if ( aInfoNum >= (sizeof(infomation) / sizeof(infomation[0])) ) return 0 ;

  if ( aInfoNum == 2 )
  {
    // Ήt@C̊gq
    AnsiString filemask = "" ;
    bool playable[ FILETYPE_COUNT ] ;
    g_var.getPlayableTable( playable ) ;
    if (playable[WAVEPLAY]) filemask += "*.wav;" ;
    if (playable[MIDIPLAY]) filemask += "*.mid;*.midi;" ;
    if (playable[AVIPLAY] ) filemask += "*.avi;" ;
    if (playable[AIFFPLAY]) filemask += "*.aif;*.aiff;" ;
    if (playable[MOVPLAY] ) filemask += "*.mov;" ;
    if (playable[MPEGPLAY]) filemask += "*.mpg;*.mpeg;*.mpe;*.m1v;*.m2v;*.mpv2;*.mp2v;" ;
    if (playable[MPAPLAY] ) filemask += "*.mp3;*.mpa;*.mp2;*.m1a;*.m2a;" ;
    if (playable[AUPLAY]  ) filemask += "*.au;*.snd;" ;
    if (playable[OGGPLAY] ) filemask += "*.ogg;" ;
    if (playable[RMPLAY]  ) filemask += "*.rm;*.ra;" ;
    if (playable[USERPLAY] ) filemask += g_var.getUserDefExt() ;

    if ( filemask.IsEmpty() )
    {
			lstrcpyn( aBuff, "", aBuffLen ) ;
		}
		else
		{
			lstrcpyn( aBuff, filemask.c_str(), aBuffLen ) ;
		}
	}
	else
	{
		// K'\0'H
    lstrcpyn( aBuff, infomation[ aInfoNum ], aBuffLen ) ;
  }

  // '\0'͐Ȃ
  return lstrlen( aBuff ) ;
}
//---------------------------------------------------------------------------
int __stdcall IsSupported(LPSTR aFilename, DWORD aDword)
{
  char header_buff[ HEAD_BUFF ] ;
  char *data ;

  if ( (aDword & 0xFFFF0000) == 0 )
  {
    /* t@Cnh */
    DWORD read_bytes ;
    ZeroMemory( header_buff, HEAD_BUFF ) ;
    if ( ! ReadFile( (HANDLE)aDword, header_buff, HEAD_BUFF, &read_bytes, NULL) )
    {
			return 0 ;
    }
		data = header_buff ;
	}
	else
	{
		/*  */
		data = reinterpret_cast<char *>( aDword ) ;
	}

	/* Ήt@CmF */
	if ( getFileType(data, aFilename) != FILETYPE_UNKNOWN )
	{
		return 1 ;
  }

  return 0 ;
}
//---------------------------------------------------------------------------
int __stdcall GetPictureInfo
(LPSTR aBuff, long aLen, unsigned int aFlag, struct PictureInfo *lpInfo)
{
/* ŒԂĂ */

  char header_buff[ HEAD_BUFF ] ;
  char *data ;
  char *filename ;

  switch ( aFlag & 7 )
  {
    case 0: /* t@C */
    {
      HANDLE hf ;
      DWORD read_bytes ;
      hf = CreateFile( aBuff, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL ) ;
      if ( hf == INVALID_HANDLE_VALUE )
      {
				return SPI_FILE_READ_ERROR ;
      }
      /* }bNoCiɂ͑ΉłȂ̂ŃV[NȂ
       */
      //SetFilePointer( hf, len, NULL, FILE_BEGIN ) ;
      if ( ! ReadFile( hf, header_buff, HEAD_BUFF, &read_bytes, NULL ) )
      {
        CloseHandle( hf ) ;
        return SPI_FILE_READ_ERROR ;
      }
      CloseHandle( hf ) ;
      data = header_buff ;
      filename = aBuff ;
      break ;
    }
    case 1: /*  */
			data = aBuff ;
      filename = NULL ;
			break ;
		default:
			return SPI_NO_FUNCTION ;
  }

  /* Ήt@CmF */
  if ( getFileType( data, filename ) == FILETYPE_UNKNOWN )
  {
		return SPI_NOT_SUPPORT ;
  }

  lpInfo->left       = 0 ;
  lpInfo->top        = 0 ;
  lpInfo->width      = 32 ;
  lpInfo->height     = 32 ;
  lpInfo->x_density  = 0 ;
  lpInfo->y_density  = 0 ;
  lpInfo->colorDepth = 24 ;
  lpInfo->hInfo      = NULL ;

  return SPI_ALL_RIGHT ;
}
//---------------------------------------------------------------------------
/** GetPreviewGetPicturȅ܂Ƃ߂
 */
int __fastcall GetPictureEx(
				const LPSTR aBuff, const long aLen, const unsigned int aFlag,
        HANDLE *pHBInfo, HANDLE *pHBm,
        const SPI_PROGRESS lpPrgressCallback,
        const long lData, const bool isPreview)
{
  char header_buff[ HEAD_BUFF ] ;
  char *data ;
  char *filename ;
  bool is_in_memory ;

	switch ( aFlag & 7 )
	{
		case 0: /* t@C */
		{
			HANDLE hf ;
			DWORD read_bytes ;
			hf = CreateFile( aBuff, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL ) ;
			if ( hf == INVALID_HANDLE_VALUE )
			{
				return SPI_FILE_READ_ERROR ;
			}
			/* }bNoCiɂ͑ΉłȂ̂ŃV[NȂ
			 */
			//SetFilePointer( hf, len, NULL, FILE_BEGIN) ;
			if ( ! ReadFile( hf, header_buff, HEAD_BUFF, &read_bytes, NULL ) )
			{
				CloseHandle( hf ) ;
				return SPI_FILE_READ_ERROR ;
			}
			CloseHandle( hf ) ;
			is_in_memory = false ;
			filename = aBuff ;
			data = header_buff ;
			break ;
		}
		case 1: /*  */
			//ɓinjĐH
			if ( ! g_var.getOption( OPTION_MemoryPlay ) )
			{
				return SPI_NOT_SUPPORT ;
			}
			data = aBuff ;
			is_in_memory = true ;
			filename = NULL ;
			break ;
		default:
			return SPI_NO_FUNCTION ;
	}

	/* Ήt@CmF */
	DWORD filetype = getFileType( data, filename ) ;
	if ( filetype == FILETYPE_UNKNOWN ) return SPI_NOT_SUPPORT ;

	char tempfname[ MAX_PATH ] = "" ;
	// vr[łȂ΍Đ
	if ( ! isPreview )
	{
		if ( is_in_memory )
		{
			if ( ! putTempFile( tempfname, aBuff, aLen ) )
			{
				return SPI_FILE_READ_ERROR ;
			}
		}
		else
		{
			lstrcat( tempfname, aBuff ) ;
		}
		int ret = playMedia( tempfname, is_in_memory, filetype, lpPrgressCallback, lData ) ;
		if ( is_in_memory ) DeleteFile( tempfname ) ;
		if ( ret != SPI_ALL_RIGHT ) return ret ;
		// Susie摜\Ȃ悤ɂ킴ƁuG[vԂ
		if ( g_var.getOption( OPTION_ReturnErr ) )
		{
			return SPI_OTHER_ERROR ;
		}
	}

	if (   ! g_var.getOption( OPTION_PreviewMovie )
			|| ! isPreview
			|| ! IS_MOVIE( filetype )
		 )
	{
		if ( ! getFileIcon( filename, pHBInfo, pHBm, filetype ) )
		{
			return SPI_OTHER_ERROR ;
		}
	}
	else
	{
		bool result ;
		if ( is_in_memory )
		{
			if ( ! putTempFile( tempfname, aBuff, aLen ) )
			{
				return SPI_FILE_READ_ERROR ;
			}
			result = getMovieFrame( tempfname, pHBInfo, pHBm ) ;
			DeleteFile( tempfname ) ;
		}
		else
		{
			lstrcpy( tempfname, aBuff ) ;
			result = getMovieFrame( tempfname, pHBInfo, pHBm ) ;
		}
		if ( ! result )
		{
			if ( ! getFileIcon( filename, pHBInfo, pHBm, filetype ) )
			{
				return SPI_OTHER_ERROR ;
			}
		}
	}

	return SPI_ALL_RIGHT ;
}
//---------------------------------------------------------------------------
int __stdcall GetPicture(
				LPSTR aBuff, long aLen, unsigned int aFlag,
				HANDLE *pHBInfo, HANDLE *pHBm,
				SPI_PROGRESS lpPrgressCallback, long lData)
{
	if (    g_var.getOption( OPTION_IsViX )
       && g_var.getOption( OPTION_PlayByViX )
     )
  {
    // ViXōĐ邽߂ɂ킴ƃG[Ԃ
		return SPI_OTHER_ERROR ;
	}

	if ( lpPrgressCallback == NULL ) lpPrgressCallback = nopCallback ;

	if (   ! g_var.getOption( OPTION_IsSusie )
			&& g_var.getOption( OPTION_SusieOnly )
		 )
	{
		// Susie݊ȊO
		return GetPreview( aBuff, aLen, aFlag, pHBInfo, pHBm, lpPrgressCallback, lData ) ;
	}

	// Susie݊
	return GetPictureEx( aBuff, aLen, aFlag, pHBInfo, pHBm, lpPrgressCallback, lData, false ) ;
}
//---------------------------------------------------------------------------
int __stdcall GetPreview(
		LPSTR aBuff, long aLen, unsigned int aFlag,
		HANDLE *pHBInfo, HANDLE *pHBm,
		SPI_PROGRESS lpPrgressCallback, long lData)
{
	if ( lpPrgressCallback == NULL ) lpPrgressCallback = nopCallback ;

	if ( lpPrgressCallback(0, 1, lData) ) return SPI_ABORT ;

  int err_code = GetPictureEx( aBuff, aLen, aFlag, pHBInfo, pHBm, lpPrgressCallback, lData, true ) ;

  if ( lpPrgressCallback(1, 1, lData) ) return SPI_ABORT ;

  return err_code ;
}
//---------------------------------------------------------------------------
int __stdcall ConfigurationDlg(HWND aParent, int aFnc)
{
//#define SPI_CFGDLG_ABOUT    0
#define SPI_CFGDLG_SETTING  1
//#define SPI_CFGDLG_RESERVED 2

#ifdef SPI_CFGDLG_ABOUT
	if ( aFnc == SPI_CFGDLG_SETTING )
	{
		MessageBox( aParent, g_ifmmCopyrightString, g_titleString, MB_ICONINFORMATION | MB_OK ) ;
		return SPI_ALL_RIGHT ;
	}
#endif

	if ( aFnc == SPI_CFGDLG_SETTING )
	{
		HWND parent = aParent ;
#ifndef SetDlgH
		parent = NULL ;
#endif
		std::auto_ptr<TDialogForm> form( new TDialogForm( parent ) ) ;
		form->FormInit() ;
		form->ShowModal() ;
		return SPI_ALL_RIGHT ;
	}

	return SPI_NO_FUNCTION ;
}
//---------------------------------------------------------------------------



