/** vC[tH[
 */
/*
 * Copyright (c) 2000-2005, 2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <dshow.h>
/*
 * DShow.h
 * DirectShow ֘A DirectX SDK 폜ꂽB
 * DirectShow SDK  Microsoft Platform SDK Ɋ܂܂悤ɂȂB
 */
#pragma hdrstop

#include "PlayerUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
__fastcall TPlayForm::TPlayForm(TComponent* Owner)
    : TForm(Owner)
{
  //KeyPreview = true ;
  //TrackBar->Enabled = false ;
	m_mediaState = EStateMediaReady ;
}
//---------------------------------------------------------------------------
/** DirectShow 
 */
bool __fastcall TPlayForm::initMediaControl(void)
{
  ::CoInitialize(NULL) ;
  HRESULT hr ;
  m_MediaRate = 1.0 ;

  hr = ::CoCreateInstance( CLSID_FilterGraph,
                        NULL,
                        CLSCTX_INPROC_SERVER,
												IID_IGraphBuilder,
												(void**)&m_pGraphBuilder ) ;
	if ( FAILED( hr ) )
	{
		return false ;
	}
	hr = m_pGraphBuilder->QueryInterface( IID_IMediaControl, (void**)&m_pMediaControl ) ;
	if ( FAILED( hr ) )
	{
		goto MEDIACLOSE ;
	}
	hr = m_pGraphBuilder->QueryInterface( IID_IMediaEventEx, (void**)&m_pMediaEventEx ) ;
	if ( FAILED( hr ) )
	{
		goto MEDIACLOSE ;
	}
	hr = m_pGraphBuilder->QueryInterface( IID_IVideoWindow, (void**)&m_pVideoWindow ) ;
	if ( FAILED( hr ) )
	{
		goto MEDIACLOSE ;
	}
	hr = m_pGraphBuilder->QueryInterface( IID_IMediaPosition, (void**)&m_pMediaPosition ) ;
	if ( FAILED( hr ) )
	{
		goto MEDIACLOSE ;
	}
#ifdef USE_IBA
	hr = m_pGraphBuilder->QueryInterface( IID_IBasicAudio, (void**)&m_pBasicAudio ) ;
	if ( FAILED( hr ) )
	{
		goto MEDIACLOSE ;
	}
#endif

	return true ;

MEDIACLOSE:
	MediaClose() ;
	return false ;
}
//---------------------------------------------------------------------------
/** fBAt@CJ
 */
bool __fastcall TPlayForm::MediaOpen(const char *aFilePath, bool isFilenameForCaption, const DWORD aFileType)
{
  if ( ! initMediaControl() )
  {
		//::MessageBox( NULL, "DirectShow̏ɎsB", "ifmm.spi", MB_OK ) ;
		return false ;
	}

	if ( isFilenameForCaption )
	{
		this->Caption = ::ExtractFileName( aFilePath ) ;
	}

	WCHAR w_filename[ MAX_PATH ] ;
	int result = ::MultiByteToWideChar( CP_ACP, 0, aFilePath, -1, w_filename, MAX_PATH ) ;
	if ( result == 0 )
	{
		//::MessageBox( NULL, "multibyteւ̕ϊɎsB", "ifmm.spi", MB_OK ) ;
		return false ;
	}

	HRESULT hr;
	hr = m_pGraphBuilder->RenderFile( w_filename, NULL ) ;

	if ( SUCCEEDED( hr ) )
	{
		initStatus() ;
		return initGUI( aFileType ) ;
	}

	return false ;
}
//---------------------------------------------------------------------------
/** fBA̒𕶎ɕϊ
 * @param mediaLength fBA̒BmsecP
 * @return "12:34" 1234b̂悤
 */
AnsiString __fastcall TPlayForm::formatTimeLength(const DWORD aMediaLength)
{
  AnsiString time_str ;
	int min = aMediaLength / (1000 * 60) ;
	int sec = aMediaLength % (1000 * 60) ;

	time_str = FormatFloat( "00", min ) ;
	time_str += ":" ;
  time_str += FormatFloat( "00", sec / 1000 ) ;

  return time_str ;
}
//---------------------------------------------------------------------------
/** fBAݒ
 */
void __fastcall TPlayForm::initStatus(void)
{
  /* fBA̒ */
  REFTIME duration ;
  m_pMediaPosition->get_Duration( &duration ) ;
  int media_length = duration * 1000 ; // msec
  m_MediaLength = media_length ;
  MediaTrackBar->Enabled = true ;

  /* ڐ蕝ύX */
  AnsiString per_str ;
#define PER_01SEC " 1sec"
#define PER_10SEC "10sec"
#define PER_30SEC "30sec"
#define PER_01MIN " 1min"
#define PER_05MIN " 5min"
#define PER_10MIN "10min"
// 
#define TIME_01SEC     1*1000
#define TIME_10SEC    10*1000
#define TIME_30SEC    30*1000
#define TIME_01MIN    60*1000
#define TIME_05MIN  5*60*1000
#define TIME_10MIN 10*60*1000
  if ( media_length > TIME_05MIN *10 )
  {
    MediaTrackBar->Frequency = TIME_10MIN ;
    PerMin10->Checked = true ;
		per_str = PER_10MIN ;
	}
	else if ( media_length > TIME_01MIN *10 )
	{
		MediaTrackBar->Frequency = TIME_05MIN ;
		PerMin05->Checked = true ;
		per_str = PER_05MIN ;
	}
	else if ( media_length > TIME_30SEC *10 )
	{
		MediaTrackBar->Frequency = TIME_01MIN ;
		PerMin01->Checked = true ;
		per_str = PER_01MIN ;
	}
	else if ( media_length > TIME_10SEC *10 )
	{
		MediaTrackBar->Frequency = TIME_30SEC ;
		PerSec30->Checked = true ;
		per_str = PER_30SEC ;
	}
	else if ( media_length > TIME_01SEC *10 )
	{
		MediaTrackBar->Frequency = TIME_10SEC ;
		PerSec10->Checked = true ;
		per_str = PER_10SEC ;
	}
	else
	{
		MediaTrackBar->Frequency = TIME_01SEC ;
		PerSec01->Checked = true ;
		per_str = PER_01SEC ;
	}
  
  // Xe[^Xo[ɕ\
  m_LengthStr = formatTimeLength( media_length ) ;
  StatusBar->Panels->Items[0]->Text = m_LengthStr ;
  StatusBar->Panels->Items[1]->Text = per_str ;
  StatusBar->Panels->Items[2]->Text = FormatFloat( (AnsiString)"0.0", m_MediaRate ) ;
  MediaTrackBar->Min = 0 ;
  MediaTrackBar->Max = media_length ;
}
//---------------------------------------------------------------------------
/** C^[tF[Xݒ
 */
bool __fastcall TPlayForm::initGUI(const DWORD aFileType)
{
  bool soundonly = false ;
  if ( ! IS_MOVIE( aFileType ) )
  {
    soundonly = true ;
  }
  else
  {
    //form->ScrollBox1->HorzScrollBar->Visible = false ;
    HRESULT hr ;
    IBasicVideo *pibv = NULL ;
		m_MoviewWidth = 0 ;
    m_MovieHeight = 0 ;
    hr = m_pGraphBuilder->QueryInterface( IID_IBasicVideo, (void**)&pibv ) ;
    if ( FAILED( hr ) )
    {
			return false ;
		}
		pibv->GetVideoSize( &m_MoviewWidth, &m_MovieHeight ) ;
		HELPER_RELEASE( pibv ) ;
		if ( (m_MoviewWidth < 1) || (m_MovieHeight < 1) )
		{
      soundonly = true ;
    }
    else
		{
#define DEFAULT_WIDTH 276
			RECT rc ;
			this->BorderStyle = bsSizeable ;
			TBorderIcons bi = BorderIcons;
			bi << biMaximize ; // ő剻L
			this->BorderIcons = bi ;
			ScaleMenuItem->Enabled = true ;
			ScaleX1->Checked = true ;
			this->ClientWidth = (m_MoviewWidth < DEFAULT_WIDTH +2)? DEFAULT_WIDTH: m_MoviewWidth +2 ;
			this->ClientHeight = m_MovieHeight + Panel->Height + StatusBar->Height +2 ;
			MediaTrackBar->Width = ClientWidth - MediaTrackBar->Left ;
			StatusBar->Panels->Items[0]->Width = ClientWidth
					-50 -30 ;
					//- StatusBar1->Panels->Items[1]->Width - StatusBar1->Panels->Items[2]->Width ;

			OnResize = FormResizeMovie ;
			char key ;
			switch ( Var.option[ OPTION_MovieSize ] )
			{
				case MOVIESIZE_X1:
					key = 'c' ;
					FormKeyPress( NULL, key ) ;
					break ;
				case MOVIESIZE_X2:
					key = 'x' ;
					FormKeyPress( NULL, key ) ;
					break ;
				case MOVIESIZE_X4:
					key = 'z' ;
					FormKeyPress( NULL, key ) ;
					break ;
				case MOVIESIZE_CS: // JX^TCY
					key = 'v' ;
					FormKeyPress(NULL, key);
					break ;
				case MOVIESIZE_FL: // tXN[(𑜓x͕ύX
					key = 'b' ;
					FormKeyPress( NULL, key ) ;
					break ;
			}
		}
	}

	PauseSpeedButton->Enabled = true ;
	PrevSpeedButton->Enabled = true ;
	VolumeTrackBar->Enabled  = true ;
	if ( soundonly )
	{
		if ( Var.option[ OPTION_WindowPos ] )
		{
			this->Position = poDesigned ;
			this->Left = Var.option[ OPTION_WindowPosX ] ;
			this->Top  = Var.option[ OPTION_WindowPosY ] ;
		}
		// ݂̂̏ꍇŏ/ANeBu
		HWND h_wnd = GetForegroundWindow() ; // ݃ANeBuWindownh
		Show() ;
		Application->ProcessMessages() ;
		if ( Var.option[ OPTION_NoActive ] )
		{
			SetForegroundWindow( h_wnd ) ;
		}
		if ( Var.option[ OPTION_Minimized ] )
		{
			WindowState = wsMinimized ;
		}
	}
	else
	{
		ScaleMenuItem->Enabled = true ;
		Show() ;
	}

	return true ;
}
//---------------------------------------------------------------------------
/** DirectShow n
 */
void __fastcall TPlayForm::MediaClose(void)
{
	if ( m_pVideoWindow )
	{
		m_pVideoWindow->put_Visible( OAFALSE ) ;
		m_pVideoWindow->put_Owner( NULL ) ;
		HELPER_RELEASE( m_pVideoWindow ) ;
	}
#ifdef USE_IBA
	HELPER_RELEASE( m_pBasicAudio ) ;
#endif
	HELPER_RELEASE( m_pMediaPosition ) ;
	HELPER_RELEASE( m_pMediaEventEx ) ;
	HELPER_RELEASE( m_pMediaControl ) ;
	HELPER_RELEASE( m_pGraphBuilder ) ;
  ::CoUninitialize() ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  m_mediaState = EStateMediaStop ;
  Visible = false ;
  ScaleX1Click( ScaleX1 ) ; // Form ʂ傫Ƀ^XNo[Ɏĉh
}
//---------------------------------------------------------------------------
/** sb`̕ύX
 */
void __fastcall TPlayForm::changeRate(void)
{
  if ( m_MediaRate > 9.99 )
  {
    // MAX:10.0
		m_MediaRate = 10.0 ;
	}
	else if ( m_MediaRate < 0.1 )
	{
		// MIN:0.1
    m_MediaRate = 0.1 ;
  }
  m_pMediaPosition->put_Rate( m_MediaRate ) ;
  // ύXłȂꍇ邽ߕύX̃sb`擾
  m_pMediaPosition->get_Rate( &m_MediaRate ) ;

  // \XV
  StatusBar->Panels->Items[2]->Text = FormatFloat( (AnsiString)"0.0", m_MediaRate ) ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::FormKeyPress(TObject *Sender, char &Key)
{
  if ( ! m_pVideoWindow ) return ;
  switch ( Key )
  {
    //case 'Q':
    //case 'q':
    case VK_ESCAPE:
      Close() ;
      break ;
    case VK_SPACE:
    case VK_RETURN:
      if ( m_mediaState == EStateMediaPlay )
      {
				MediaClick( buttonMediaPause ) ;
			}
			else
			{
				MediaClick( buttonMediaPlay ) ;
			}
			break ;
    case VK_BACK:
      MediaClick( buttonMediaPrev ) ;
			break ;
		case 'C' :
		case 'c' :
			ScaleX1Click( ScaleX1 ) ;
      break ;
    case 'X':
    case 'x':
      ScaleX1Click( ScaleX2 ) ;
			break ;
		case 'Z':
		case 'z':
			ScaleX1Click( ScaleX4 ) ;
			break ;
		case 'V':
		case 'v':
			ScaleX1Click( ScaleCustom ) ;
			break ;
		case 'B':
		case 'b':
			ScaleX1Click( ScaleFull ) ;
			break ;
		case 'A':
		case 'a':
			m_MediaRate = 1.0 ;
			changeRate() ;
			break ;
		case 'S':
		case 's':
			m_MediaRate += 0.1 ;
			changeRate() ;
			break ;
		case 'D':
		case 'd':
			m_MediaRate -= 0.1 ;
			changeRate() ;
			break;
		case 'F':
		case 'f':
			// smȂ̂1.0
			m_MediaRate += 1.0 ;
			changeRate() ;
			break ;
		case 'G':
		case 'g':
			m_MediaRate = 0.1 ;
			changeRate() ;
			break ;
		case 'M':
		case 'm':
			toggleMute() ;
			break ;
		case ',': // <
			if ( VolumeTrackBar->Enabled )
			{
					VolumeTrackBar->Position -= 10 ;
			}
			break ;
		case '.': // >
			if ( VolumeTrackBar->Enabled )
			{
					VolumeTrackBar->Position += 10 ;
			}
			break ;
		default:
      ;
  }
  Key = 0 ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::MediaClick(MediaButton aButton)
{
  switch ( aButton )
	{
		case buttonMediaPlay:
			PlaySpeedButton->Enabled = false ;
			PauseSpeedButton->Enabled = true ;
			m_pMediaControl->Run() ;
			m_mediaState = EStateMediaPlay ;
			break ;
		case buttonMediaPause:
			PlaySpeedButton->Enabled = true ;
			PauseSpeedButton->Enabled = false ;
			m_pMediaControl->Pause() ;
			m_mediaState = EStateMediaPause ;
			break ;
		case buttonMediaPrev:
			PlaySpeedButton->Enabled = true ;
			PauseSpeedButton->Enabled = false ;
			m_pMediaControl->Pause() ;
			m_pMediaPosition->put_CurrentPosition( 0.0 ) ;
			m_mediaState = EStateMediaPause ;
			break ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::WMGraphNotify(TMessage &aMsg)
{
  LONG evCode ;
  LONG evParam1, evParam2 ;

  if ( m_pMediaEventEx == NULL ) return ;
  while ( SUCCEEDED( m_pMediaEventEx->GetEvent( &evCode, &evParam1, &evParam2, 0 ) ) )
  {
		m_pMediaEventEx->FreeEventParams( evCode, evParam1, evParam2 ) ;
		if (   (evCode == EC_COMPLETE)
				|| (evCode == EC_USERABORT)
				|| (evCode == EC_ERRORABORT)
			 )
		{
			// ɏILq
			//m_mediaState = ST_STOP ;
			Close() ;
			break ;
		}
	}
}
//---------------------------------------------------------------------------
int __fastcall TPlayForm::Play(void)
{
  if ( PrgressCallback( 0, m_MediaLength, Data ) )
  {
    return SPI_ABORT ;
  }

  m_pMediaEventEx->SetNotifyWindow( (OAHWND)Handle, WM_GRAPHNOTIFY, 0 ) ;

	m_ChangingVolume = true ;
#ifdef USE_IBA
	// 0 ő{[
	// -10,000 
	long vol ;
	pba->get_Volume( &vol ) ;
	VolumeTrackBar->Position = pow( 10.0, (double)vol/5000 ) * 100.0 ;
#else
	m_Volume.Init( this->Handle ) ;
	int vol ;
	m_Volume.GetVolume( &vol ) ;
	VolumeTrackBar->Position = vol ;
#endif
	m_ChangingVolume = false ;

	m_mediaState = EStateMediaPlay ;
	m_pMediaControl->Run() ;

	int timer = 0 ;
	while (   (m_mediaState == EStateMediaPlay)
				 || (m_mediaState == EStateMediaPause)
				)
	{
		if ( timer >= 4 )
		{
			updateStatusText() ;
			timer = 0 ;
		}
		else
		{
			timer++ ;
		}
		::Sleep( 50 ) ;
		Application->ProcessMessages() ;
	}

	if ( PrgressCallback( m_MediaLength, m_MediaLength, Data ) )
	{
		return SPI_ABORT ;
	}
	return SPI_ALL_RIGHT ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::MediaTrackBarChange(TObject *Sender)
{
	if ( m_ChangingAuto ) return ;
	if ( m_mediaState == EStateMediaStop ) return ;

	m_ChangingManual = true ;
	try
	{
		REFTIME tpos = MediaTrackBar->Position ;
		m_pMediaPosition->put_CurrentPosition( tpos / 1000 ) ;

		updateStatusText() ;
	}
	__finally
	{
		m_ChangingManual = false ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::PerSec10Click(TObject *Sender)
{
/** ڐ̊ԊuύX
 */
	TMenuItem *menu_item = dynamic_cast<TMenuItem *>( Sender ) ;
	if ( ! menu_item ) return ;
	int per_time = menu_item->Tag ;
  MediaTrackBar->Frequency = per_time ;

  PerSec01->Checked  = false ;
  PerSec10->Checked = false ;
  PerSec30->Checked = false ;
  PerMin01->Checked  = false ;
  PerMin05->Checked  = false ;
  PerMin10->Checked = false ;

  AnsiString per_str ;
  switch ( per_time )
  {
    case TIME_01SEC:
			per_str = PER_01SEC ;
			PerSec01->Checked = true ;
			break;
		case TIME_10SEC:
			per_str = PER_10SEC ;
			PerSec10->Checked = true ;
			break;
		case TIME_30SEC:
			per_str = PER_30SEC ;
			PerSec30->Checked = true ;
			break;
		case TIME_01MIN:
			per_str = PER_01MIN ;
			PerMin01->Checked = true ;
			break;
		case TIME_05MIN:
			per_str = PER_05MIN ;
			PerMin05->Checked = true ;
			break;
		case TIME_10MIN:
			per_str = PER_10MIN ;
			PerMin10->Checked = true ;
			break;
  }

  StatusBar->Panels->Items[1]->Text = per_str ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::PlaySpeedButtonClick(TObject *Sender)
{
#define PLAYBUTTON  0
#define PAUSEBUTTON 1
#define PREVBUTTON  2

	if ( TSpeedButton *sb = dynamic_cast<TSpeedButton*>( Sender ) )
	{
		MediaButton button ;
		switch ( sb->Tag )
		{
			case PLAYBUTTON:
				button = buttonMediaPlay ;
				break ;
			case PAUSEBUTTON:
				button = buttonMediaPause ;
				break ;
			case PREVBUTTON:
				button = buttonMediaPrev ;
				break ;
		}
		MediaClick( button ) ;
	}
}
//---------------------------------------------------------------------------
/** \{ύX
 */
void __fastcall TPlayForm::ScaleX1Click(TObject *Sender)
{
  if ( ScaleMenuItem->Enabled == false ) return ;

	TMenuItem *menu_item = dynamic_cast<TMenuItem *>( Sender ) ;
	if ( ! menu_item ) return ;

	RECT rc ;
	int view_width  = m_MoviewWidth ;
  int view_height = m_MovieHeight ;
	int movie_size = menu_item->Tag ;

  ScaleX1->Checked = false ;
  ScaleX2->Checked = false ;
  ScaleX4->Checked = false ;
  ScaleCustom->Checked = false ;
  ScaleFull->Checked = false ;

  if ( movie_size == -1 )
  {
    // tXN[
		view_width  = Screen->Width ;
		view_height = Screen->Height ;
	}
	else
	{
		if ( movie_size == 0 )
		{
			// JX^TCY
			view_width  = Var.option[ OPTION_MovieWidth ] ;
			view_height = Var.option[ OPTION_MovieHeight ] ;
		}
		else if ( movie_size != 1 )
		{
			view_width  *= movie_size ;
			view_height *= movie_size ;
			if (   (view_width > Screen->WorkAreaWidth )
					|| (view_height > Screen->WorkAreaHeight )
				 )
			{
				// ʗ̈傫
				if ( movie_size == 4 )
				{
					ScaleX1Click( ScaleX2 ) ;
				}
				else
				{
					ScaleX1Click( ScaleX1 ) ;
				}
				return ;
			}
		}
	}

	menu_item->Checked = true ;

	if ( m_pVideoWindow )
	{
		m_pVideoWindow->put_Visible( OAFALSE ) ;
		m_pVideoWindow->put_Owner( NULL ) ;
    HELPER_RELEASE( m_pVideoWindow ) ;
  }
  m_pGraphBuilder->QueryInterface( IID_IVideoWindow, (void**)&m_pVideoWindow ) ;

#define DEFAULT_WIDTH 276
	this->Visible = false ;
	this->WindowState = wsNormal ;
	if ( movie_size == -1 )
	{
		// tXN[
		this->FormStyle = fsStayOnTop ; // őO
		this->BorderStyle = bsNone ; // 󂢂Ă܂
		StatusBar->Visible = false ;
		Panel->Visible = false ;
		this->ClientWidth  = view_width ;
		this->ClientHeight = view_height ; // ɏk߂Ă܂H
		getCustomRect( &rc, ClientWidth, ClientHeight ) ;
	}
	else
	{
		TPoint p ;
		p.x = MoviePanel->Left ;
		p.y = MoviePanel->Top ;
		p = ClientToScreen( p ) ;
		int dh = p.y - this->Top ;
		int dw = p.x - this->Left ;

		this->BorderStyle = bsSizeable ;
		if ( Var.option[ OPTION_StayOnTop ] )
		{
			this->FormStyle = fsStayOnTop ;
		}
		else
		{
			this->FormStyle = fsNormal ;
		}
		StatusBar->Visible = true ;
		Panel->Visible = true ;
		this->Width  = (view_width < DEFAULT_WIDTH) ? DEFAULT_WIDTH: view_width + dw*2 ;
		this->Height =  view_height + Panel->Height + StatusBar->Height + dh ;
		if ( movie_size == 0 )
		{
			//JX^TCY
			getCustomRect( &rc, Var.option[ OPTION_MovieWidth ], Var.option[ OPTION_MovieHeight ] ) ;
		}
		else
		{
			::GetClientRect( ScrollBox->Handle, &rc ) ;
			if ( view_width < DEFAULT_WIDTH )
			{
				// 悪ꍇEBhEɕ\
				getCustomRect( &rc, rc.right - rc.left, rc.bottom - rc.top ) ;
			}
		}
	}
	setMovieRect( &rc ) ;

	// EBhEʒu
	if ( movie_size == -1 )
	{
		// tXN[
		this->Top  = Screen->DesktopTop ;
		this->Left = Screen->DesktopLeft ;
	}
	else if ( movie_size == 0 )
	{
		// JX^TCY
		this->Top  = Var.option[ OPTION_MoviePosY ] ;
		this->Left = Var.option[ OPTION_MoviePosX ] ;
	}
	else
	{
		if (  (Screen->WorkAreaHeight < Height)
				|| (Screen->WorkAreaWidth < Width)
			 )
		{
			// ʂ傫
			this->Top  = Screen->WorkAreaTop ;
			this->Left = Screen->WorkAreaLeft ;
		}
		else
		{
			// ʂ͂ݏoĂȂ璲
			if ( Screen->WorkAreaTop > Top )
			{
				// 
				this->Top = Screen->WorkAreaTop ;
			}
			else
			if ( (Screen->WorkAreaTop + Screen->WorkAreaHeight) < (Top + Height) )
			{
				// 
				this->Top = Screen->WorkAreaTop + Screen->WorkAreaHeight - Height ;
			}

			if ( Screen->WorkAreaLeft > Left )
			{
				// 
				this->Left = Screen->WorkAreaLeft ;
			}
			else
			if ( (Screen->WorkAreaLeft + Screen->WorkAreaWidth) < (Left + Width) )
			{
				// E
				this->Left = Screen->WorkAreaLeft + Screen->WorkAreaWidth -Width ;
			}
		}

		if ( Var.option[ OPTION_MovieCenter ] )
		{
			// JX^TCY̓Z^[w𖳎
			this->Top  = Screen->WorkAreaTop  + (Screen->WorkAreaHeight - Height) /2 ;
			this->Left = Screen->WorkAreaLeft + (Screen->WorkAreaWidth  - Width)  /2 ;
		}
	}

	// EBhEnhႤ̂ɂȂ邽ߍēo^
	m_pVideoWindow->put_Owner( (OAHWND)ScrollBox->Handle ) ;
	m_pVideoWindow->put_WindowStyle( WS_CHILD | WS_CLIPSIBLINGS | WS_CLIPCHILDREN ) ;
	m_pVideoWindow->put_Visible( OATRUE ) ;
	m_pVideoWindow->put_MessageDrain( (OAHWND)ScrollBox->Handle ) ;
	m_pMediaEventEx->SetNotifyWindow( (OAHWND)Handle, WM_GRAPHNOTIFY, 0 ) ;
	if ( m_mediaState == EStateMediaStop ) return ;
#ifndef USE_IBA
	m_Volume.Release() ;
	m_Volume.Init( this->Handle ) ;
#endif
  this->Visible = true ;
}
//---------------------------------------------------------------------------
/** DirectShowɂtXN[
 * gpȂ
 */
#if 0
void __fastcall TPlayForm::putFullScreen(void)
{
  if ( ScaleMenuItem->Enabled == false ) return ;

  this->FormStyle = fsNormal ; // őOʉ
  m_pVideoWindow->put_MessageDrain( (OAHWND)ScrollBox->Handle ) ;
  m_pMediaEventEx->SetNotifyWindow( (OAHWND)Handle, WM_GRAPHNOTIFY, 0 ) ;
  m_pVideoWindow->put_FullScreenMode( OATRUE ) ;
}
#endif
//---------------------------------------------------------------------------
void __fastcall TPlayForm::updateStatusText(void)
{
  REFTIME pos ;
  m_pMediaPosition->get_CurrentPosition( &pos ) ;
  pos *= 1000 ; // msecP
  m_ChangingAuto = true ;
  if ( ! m_ChangingManual ) MediaTrackBar->Position = pos ;
  m_ChangingAuto = false ;

  StatusBar->Panels->Items[0]->Text = formatTimeLength( pos ) + " / " + m_LengthStr ;

  if ( PrgressCallback( pos, m_MediaLength, Data) )
  {
    m_mediaState = EStateMediaAbort ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::ScrollBoxClick(TObject *Sender)
{
  if ( m_mediaState == EStateMediaPlay )
  {
    MediaClick( buttonMediaPause ) ;
	}
	else
	{
		MediaClick( buttonMediaPlay ) ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::FormResizeEx(TObject *Sender)
{
  AnsiString xy = "W, H = " ;
  xy += (AnsiString)(MoviePanel->Width -2) + ", " + (AnsiString)(MoviePanel->Height -2) ;
  StatusBar->Panels->Items[0]->Text = xy ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::setMovieRect(RECT *pRect)
{
  m_pVideoWindow->SetWindowPosition( pRect->left, pRect->top, pRect->right, pRect->bottom ) ;
  MediaTrackBar->Width = ClientWidth - MediaTrackBar->Left ;
  VolumeTrackBar->Left = ClientWidth - VolumeTrackBar->Width -14 ;
  StatusBar->Panels->Items[0]->Width = ClientWidth
     -50 -30 ;
     //- StatusBar1->Panels->Items[1]->Width - StatusBar1->Panels->Items[2]->Width ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::getCustomRect(RECT *pRect, int aClientWidth, int aClientHeight)
{
  double xrate, yrate ;
  int xsize, ysize ;

  if ( (m_MoviewWidth == 0) || (m_MovieHeight == 0) )
  {
    xrate = 0 ;
		//yrate = 0 ;
	}
	else
	{
		xrate = aClientWidth  / (double)m_MoviewWidth ;
		yrate = aClientHeight / (double)m_MovieHeight ;
		if ( xrate > yrate ) xrate = yrate ; // 䗦ɍ킹
	}

	xsize = m_MoviewWidth  * xrate ;
  ysize = m_MovieHeight * xrate ;
	pRect->left   = (aClientWidth  - xsize) /2 ;
	pRect->top    = (aClientHeight - ysize) /2 ;
	pRect->right  = xsize ;
  pRect->bottom = ysize ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::FormResizeMovie(TObject *Sender)
{
  RECT rc ;
  int w, h ;
  w = MoviePanel->Width  -2 ;
  h = MoviePanel->Height -2 ;
  getCustomRect( &rc, w, h ) ;
  setMovieRect( &rc ) ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::VolumeTrackBarChange(TObject *Sender)
{
  VolumeTrackBar->SelEnd = VolumeTrackBar->Position ;
  if ( m_ChangingVolume ) return ;
  changeVolume( VolumeTrackBar->Position ) ;
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::changeVolume(int aVol)
{
#ifdef USE_IBA
  if ( ! m_pBasicAudio ) return ;
  // 0 ő{[
  // -10,000 
	m_pBasicAudio->put_Volume( log10( vol/100.0 ) * 5000 ) ; // ΐڐ!
#else
	// 0(min) - 100(max)
  m_Volume.SetVolume( aVol ) ;
#endif
}
//---------------------------------------------------------------------------
inline void __fastcall TPlayForm::toggleMute()
{
#ifdef USE_IBA
	return ;
#else
  m_Volume.ToggleMute() ;
#endif
}
//---------------------------------------------------------------------------
void __fastcall TPlayForm::MM_MixCtrChange(TMessage &aMsg)
{
#ifdef USE_IBA
	return ;
#else
	if ( m_pGraphBuilder == NULL ) return ;

	//hMixer = Msg.WParam ;
	//dwControlID = Msg.LParam ;
	// 蔲
	int vol ;
	m_Volume.GetVolume( &vol ) ;
	m_ChangingVolume = true ;
	VolumeTrackBar->Position = vol ;
	m_ChangingVolume = false ;
	bool mute ;
	m_Volume.GetMuteState( &mute ) ;
  VolumeTrackBar->Enabled = ! mute ;
#endif
}
//---------------------------------------------------------------------------

