/** mixerNX
 * http://hp.vector.co.jp/authors/VA016117/mixer1.html
 * NX́B
 */

#ifndef mixerctrH
#define mixerctrH

#include <windows.h>
#include <mmsystem.h>

class TMixerCtr
{
public:
	TMixerCtr()
	{
		initValue() ;
	}

	~TMixerCtr()
	{
		Release() ;
	}

  /** Mixeȑ
   * hw  MM_MIXM_LINE_CHANGE, MM_MIXM_CONTROL_CHANGE 
   */
	bool Init(HWND aHWnd)
  {
    if ( m_hMixer ) return true ;

		if ( ::mixerOpen( &m_hMixer, 0, (DWORD)aHWnd, 0, CALLBACK_WINDOW ) != MMSYSERR_NOERROR )
		{
			return false ;
		}
		//if ( ::mixerGetDevCaps( (UINT)m_hMixer, &m_mxcaps, sizeof(MIXERCAPS))!=MMSYSERR_NOERROR ) return false ;

		return	true ;
	}

    /** Mixeřn
     */
	void Release(void)
  {
    if ( m_hMixer ) ::mixerClose( m_hMixer ) ;
      initValue() ;
	}

	bool GetVolume(int *aVal) ; //Val:0(Min) - 100(Max)
	bool SetVolume(int aVal) ;

	bool AddVolume(int aDiff)
	{
		int	val ;
		if ( GetVolume( &val ) == false ) return false ;

		val += aDiff ;
		if ( val > 100 ) val = 100 ;
		else if( val < 0 ) val = 0 ;

		if ( SetVolume( val ) == false ) return false ;

		return true ;
	}

	bool GetMuteState(bool *isMute) ;
	bool SetMuteState(bool isMute) ;
	bool ToggleMute(void)
	{
		bool mute ;
		if ( GetMuteState( &mute ) == false ) return false ;
		return SetMuteState( ! mute ) ;
	}

private:
	/** ȍ
	 */
	void initValue(void)
	{
		m_hMixer = NULL ;
		m_dwVolumeControlID = 0xffffffff ;
		m_dwMuteControlID   = 0xffffffff ;
	}

	bool initMasterVolumeControl(void) ;
	bool initMasterMuteControl(void) ;
	HMIXER		m_hMixer ;
	//MIXERCAPS	m_mxcaps ;
	DWORD		m_dwMinimum ;
	DWORD		m_dwMaximum ;
	DWORD		m_cChannels ;
	DWORD		m_dwVolumeControlID ;
	DWORD		m_dwMuteControlID ;

} ;

#endif /* mixerctrH */

