#include <windows.h>
#include <mmsystem.h>
#pragma hdrstop

#include "mixerctr.h"
//---------------------------------------------------------------------------

//***********
// {[
//***********
bool TMixerCtr::initMasterVolumeControl(void)
{
	MIXERLINE mxl ;
	MIXERCONTROL mxc ;
	MIXERLINECONTROLS mxlc ;

	if ( m_dwVolumeControlID != 0xffffffff ) return true ;
	if ( Init( NULL ) == false ) return false ;

	mxl.cbStruct = sizeof(MIXERLINE) ;
	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS ;
	if ( ::mixerGetLineInfo( (HMIXEROBJ)m_hMixer,&mxl,
				MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	mxlc.cbStruct = sizeof(MIXERLINECONTROLS) ;
	mxlc.dwLineID = mxl.dwLineID ;
	mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME ;
	mxlc.cControls = 1 ;
	mxlc.cbmxctrl = sizeof(MIXERCONTROL) ;
	mxlc.pamxctrl = &mxc ;
	if ( ::mixerGetLineControls( (HMIXEROBJ)m_hMixer,&mxlc,
			   MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) != MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	m_dwMinimum = mxc.Bounds.dwMinimum ;
	m_dwMaximum = mxc.Bounds.dwMaximum ;
	m_dwVolumeControlID = mxc.dwControlID ;

	return true ;
}
//---------------------------------------------------------------------------
bool TMixerCtr::GetVolume(int *aVal)
{
	MIXERCONTROLDETAILS_UNSIGNED mxcd_volume ;
	MIXERCONTROLDETAILS mxcd ;

	if ( initMasterVolumeControl() == false ) return false ;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS) ;
	mxcd.dwControlID = m_dwVolumeControlID ;
	mxcd.cChannels = 1 ;
	mxcd.cMultipleItems = 0 ;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED) ;
	mxcd.paDetails = &mxcd_volume ;
	if ( ::mixerGetControlDetails( (HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	*aVal = ((mxcd_volume.dwValue - m_dwMinimum)*100 + (m_dwMaximum - m_dwMinimum)/2) / (m_dwMaximum - m_dwMinimum) ;

	return true ;
}
//---------------------------------------------------------------------------
bool TMixerCtr::SetVolume(int aVal)
{
	MIXERCONTROLDETAILS_UNSIGNED	mxcd_volume ;
	MIXERCONTROLDETAILS						mxcd ;

	if ( initMasterVolumeControl() == false ) return false ;

	mxcd_volume.dwValue = aVal * (m_dwMaximum - m_dwMinimum)/100 + m_dwMinimum ;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS) ;
	mxcd.dwControlID = m_dwVolumeControlID ;
	mxcd.cChannels = 1 ;
	mxcd.cMultipleItems = 0 ;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED) ;
	mxcd.paDetails = &mxcd_volume ;
	if ( ::mixerSetControlDetails( (HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_SETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}
    
	return true ;
}
//---------------------------------------------------------------------------

//*********
// ~[g
//*********
bool TMixerCtr::initMasterMuteControl()
{
	MIXERLINE mxl ;
	MIXERCONTROL mxc ;
	MIXERLINECONTROLS mxlc ;

	if ( m_dwMuteControlID != 0xffffffff ) return true ;
	if ( Init( NULL ) == false ) return false ;

	mxl.cbStruct = sizeof(MIXERLINE) ;
	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS ;
	if ( ::mixerGetLineInfo( (HMIXEROBJ)m_hMixer,&mxl,
				MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	mxlc.cbStruct = sizeof(MIXERLINECONTROLS) ;
	mxlc.dwLineID = mxl.dwLineID ;
	mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_MUTE ;
	mxlc.cControls = 1 ;
	mxlc.cbmxctrl = sizeof(MIXERCONTROL) ;
	mxlc.pamxctrl = &mxc ;
	if ( ::mixerGetLineControls( (HMIXEROBJ)m_hMixer,&mxlc,
			   MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) != MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	m_dwMuteControlID = mxc.dwControlID ;

	return true ;
}
//---------------------------------------------------------------------------
bool TMixerCtr::GetMuteState(bool *isMute)
{
	MIXERCONTROLDETAILS_BOOLEAN mxcd_mute ;
	MIXERCONTROLDETAILS mxcd ;

	if ( initMasterMuteControl() == false ) return false ;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS) ;
	mxcd.dwControlID = m_dwMuteControlID ;
	mxcd.cChannels = 1 ;
	mxcd.cMultipleItems = 0 ;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_BOOLEAN) ;
	mxcd.paDetails = &mxcd_mute ;
	if ( ::mixerGetControlDetails( (HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	*isMute = mxcd_mute.fValue ;

	return true ;
}
//---------------------------------------------------------------------------
bool TMixerCtr::SetMuteState(bool isMute)
{
	MIXERCONTROLDETAILS_BOOLEAN mxcd_mute ;
	MIXERCONTROLDETAILS mxcd ;

	if ( initMasterMuteControl() == false ) return false ;

	mxcd_mute.fValue = isMute ;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS) ;
	mxcd.dwControlID = m_dwMuteControlID ;
	mxcd.cChannels = 1 ;
	mxcd.cMultipleItems = 0 ;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_BOOLEAN) ;
	mxcd.paDetails = &mxcd_mute ;
	if ( ::mixerSetControlDetails( (HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_SETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR
       )
	{
		return false ;
	}

	return true ;
}
//---------------------------------------------------------------------------

