/** fBA̎舵
 */
/*
 * Copyright (c) 2000-2005, 2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	ifmmediaH
#define	ifmmediaH

#include "spi_api.h"

#pragma pack(push)
#pragma pack(1) // \̂̃oE1oCgɂ pragma
/* 4oCgPʂň */
typedef struct
{
	DWORD uk1 ;
	DWORD uk2 ;
	DWORD uk3 ;
	DWORD uk4 ;
} UNKNOWN_FILE ;
#pragma pack(pop)

/* t@C`FbNɍŒKvȃTCY */
#define HEAD_BUFF 32

/* t@CID */
// WAVE
#define RIFF_TYPE_ID	0x46464952 /* "RIFF" */
#define WAVE_TYPE_ID	0x45564157 /* "WAVE" */
// AIFF
#define FORM_TYPE_ID	0x4d524f46 /* "FORM" */
#define AIFF_TYPE_ID	0x46464941 /* "AIFF" */
#define COMM_TYPE_ID	0x4d4d4f43 /* "COMM" */
// MIDI
#define MTHD_TYPE_ID	0x6468544d /* "MThd" */
#define MIDI_H_SIZE		0x06000000 /* 00 00 00 06 */
#define MTRK_TYPE_ID	0x6b72544d /* "MTrk" */
#define RMID_TYPE_ID	0x44494d52 /* "RMID" */
#define MIDS_TYPE_ID	0x5344494d /* "MIDS" */
// AVI
#define AVI_TYPE_ID		0x20495641 /* "AVI " */
// MOV
#define MDAT_TYPE_ID	0x7461646d /* "mdat" */
#define MOOV_TYPE_ID	0x766f6f6d /* "moov" */
// MPEG
#define MPEG_A_TYPE_ID	0xba010000 /* 00 00 01 BA */
#define MPEG_B_TYPE_ID	0xb3010000 /* 00 00 01 B3 */
#define CDXA_TYPE_ID	0x41584443 /* "CDXA" */
#define FMT_TYPE_ID		0x20746D66 /* "fmt " */
#define XA_TYPE_ID		0x41581131 /* 31 11 "XA" */
// MP3
#define MPA_TYPE_ID		0x0000f0ff /* 12bit܂1 */
#define ID3TAG_ID		0x00334449 /* "ID3" */
#define RMP3_TYPE_ID	0x33504d52 /* "RMP3" */
// AU
#define SND_TYPE_ID		0x646e732e /* ".snd" */
// OGG
#define OGG_TYPE_ID		0x5367674f /* "OggS" */
// RealMedia
#define RM_TYPE_ID		0x464d522e /* ".RMF" */

/* t@C^Cv */
// ͂̂悤
#define ADD_MOVIE_FLAG(ft) ( (ft) | 0x80000000 )
#define IS_MOVIE(ft) ( ((ft) & 0x80000000)? true: false )
#define FILETYPE_DEBUG	( 0x40000000 | 0x80000000 )
#define FILETYPE_UNKNOWN 0x00000000
#define FILETYPE_WAVE	1
#define FILETYPE_AIFF	2
#define FILETYPE_MIDI	3
#define FILETYPE_AVI	ADD_MOVIE_FLAG(4)
#define FILETYPE_MOV	ADD_MOVIE_FLAG(5)
#define FILETYPE_MPEG	ADD_MOVIE_FLAG(6)
#define FILETYPE_MPA	7
#define FILETYPE_AU		8
#define FILETYPE_OGG	9
#define FILETYPE_RM		ADD_MOVIE_FLAG(10)
#define FILETYPE_USER   ADD_MOVIE_FLAG(11)
#define FILETYPE_COUNT	11

/* TCY{ */
#define MOVIESIZE_X1 0 // 1{
#define MOVIESIZE_X2 1 // 2{
#define MOVIESIZE_X4 2 // 4{
#define MOVIESIZE_CS 3 // JX^TCY
#define MOVIESIZE_FL 4 // tXN[

extern DWORD __fastcall getFileType(const char *aData, const char *aFilename) ;
extern bool __fastcall getMovieFrame(const char *aFilename, HANDLE *pHBInfo, HANDLE *pHBm) ;
extern int __fastcall playMedia(const char *aFilename, const bool isInMem, const DWORD aFileType,
									 const SPI_PROGRESS lpPrgressCallback, const long lData) ;

#endif /* ifmmediaH */
