/** fBA̎舵
 */
/*
 * Copyright (c) 2000-2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <shellapi.h> //SHGetFileInfo API
#include <DShow.h>
	/*
	 * DShow.h
	 * DirectShow ֘A DirectX SDK 폜ꂽB
	 * DirectShow SDK  Microsoft Platform SDK Ɋ܂܂悤ɂȂB
	 */
#include <memory>
#pragma hdrstop

#include "ifmmedia.h"
#include "ifmmain.h"
#include "PlayerUnit.h"

//#define USE_SAMPLEGRABBER
	/*
	 * SampleGrabberBorlandpCuł͎gpłȂ
	 */


bool __fastcall to24bit(const char *aDibImage, DWORD aImageSize, HANDLE *pHBInfo, HANDLE *pHBm) ;
bool __fastcall isBlackOrWhite(HANDLE *pHBInfo, HANDLE *pHBm) ;
//---------------------------------------------------------------------------
/** t@C̎ނ𔻒
 * @param[in] aData t@C擪̃f[^
 * @param[in] aFilename t@C̃tpX
 * @return t@C^CvԂ
 */
DWORD __fastcall getFileType(const char *aData, const char *aFilename)
{
  DWORD result = FILETYPE_UNKNOWN ;
  const UNKNOWN_FILE *mm_h = reinterpret_cast<const UNKNOWN_FILE *>( aData ) ;
  bool playable[ FILETYPE_COUNT ] ;
  g_var.getPlayableTable( playable ) ;

  if ( g_var.getOption( OPTION_DebugMode ) )
  {
    // SusieɁuΉĂvƕԎ
    // ̂ŁAĐł邩Ƃ\
		return FILETYPE_DEBUG ;
	}

	/* WAVE */
	if (   playable[ WAVEPLAY ]
			&& (   mm_h->uk1 == RIFF_TYPE_ID
					&& mm_h->uk3 == WAVE_TYPE_ID
				 )
		 )
	{
    result = FILETYPE_WAVE ;
  }
  else
  /* AIFF */
  if (   playable[ AIFFPLAY ]
      && (   mm_h->uk1 == FORM_TYPE_ID
          && mm_h->uk3 == AIFF_TYPE_ID
          && mm_h->uk4 == COMM_TYPE_ID
         )
     )
  {
		result = FILETYPE_AIFF ;
	}
	else
	/* MIDI */
	if (   playable[ MIDIPLAY ]
			&& (   (   mm_h->uk1 == MTHD_TYPE_ID
							&& mm_h->uk2 == MIDI_H_SIZE
							&& *((int *)(aData +0x0e)) == MTRK_TYPE_ID
						 )
					|| (   mm_h->uk1 == RIFF_TYPE_ID
							&& (mm_h->uk3 == RMID_TYPE_ID /*|| mm_h->uk3 == MIDS_TYPE_ID*/)
						 )
				 )
		 )
	{
		result = FILETYPE_MIDI ;
	}
	else
	/* AVI */
	if (   playable[ AVIPLAY ]
			&& (   mm_h->uk1 == RIFF_TYPE_ID
					&& mm_h->uk3 == AVI_TYPE_ID
				 )
		 )
	{
		result = FILETYPE_AVI ;
	}
	/* MOV */
	else
	if (   playable[ MOVPLAY ]
			&& (   mm_h->uk2 == MDAT_TYPE_ID
					|| mm_h->uk2 == MOOV_TYPE_ID
					|| mm_h->uk4 == MDAT_TYPE_ID
					|| mm_h->uk4 == MOOV_TYPE_ID
				 )
		 )
	{
		result = FILETYPE_MOV ;
	}
	else
	/* MPEG */
	if (   playable[MPEGPLAY]
			&& (   (mm_h->uk1 == MPEG_A_TYPE_ID)
					|| (mm_h->uk1 == MPEG_B_TYPE_ID)
					|| (   mm_h->uk1 == RIFF_TYPE_ID
							&& mm_h->uk3 == CDXA_TYPE_ID
							&& mm_h->uk4 == FMT_TYPE_ID
							//&& *((int *)(data +0x18)) == XA_TYPE_ID
						 )
				 )
		 )
	{
    result = FILETYPE_MPEG ;
  }
  else
  /* MPEG Audio */
  if (   playable[ MPAPLAY ]
      && (   (mm_h->uk1 & 0x00ffffff) == ID3TAG_ID
          || (   (mm_h->uk1 & 0xf0ff) == MPA_TYPE_ID //wb_
							&& (*(aData +1) & 0x06) != 0x00      //C
							&& (*(aData +2) & 0xf0) != 0xf0      //rbg[g
              && (*(aData +2) & 0x0c) != 0x0c      //TvO[g
              //&& (*(aData +3) & 0x03) != 0x02      //Gt@VX
             )
          || (   mm_h->uk1 == RIFF_TYPE_ID
              && mm_h->uk3 == RMP3_TYPE_ID
             )
         )
     )
  {
		result = FILETYPE_MPA ;
	}
	else
	/* AU */
	if (   playable[ AUPLAY ]
			&& (mm_h->uk1 == SND_TYPE_ID)
		 )
	{
		result = FILETYPE_AU ;
	}
	else
	/* OGG */
	if (   playable[ OGGPLAY ]
			&& (mm_h->uk1 == OGG_TYPE_ID)
		 )
	{
		result = FILETYPE_OGG ;
	}
	else
	/* RealMedia */
	if (   playable[ RMPLAY ]
			&& (mm_h->uk1 == RM_TYPE_ID)
		 )
	{
		result = FILETYPE_RM ;
	}
	/* gqŔf */
	else
	{
		AnsiString ext = g_var.getUserDefExt() ;
		try
		{
			if (   playable[ USERPLAY ]
					&& matchesExt( ::ExtractFileName( aFilename ), ext.c_str() )
				 )
			{
				result = FILETYPE_USER ;
			}
		}catch(...){}
  }

  return result ;
}
//---------------------------------------------------------------------------
#ifndef USE_SAMPLEGRABBER
/** ̓C[W24bitɕϊ
 * Susie16bit,32bitΉ₵ߕϊB
 * @param[in,out] aDibImage DIBC[Wւ̃|C^
 * @param[in] aImageSize DIBC[Wobt@̃TCY
 * @param[in,out] pHBInfo SusieɕԂBITMAPINFO߂nh̃|C^
 * @param[in,out] pHBm SusieɕԂBITMAPf[^߂nh̃|C^
 * @return trueAsfalseԂ
 */
bool __fastcall to24bit(char *aDibImage, DWORD aImageSize, HANDLE *pHBInfo, HANDLE *pHBm)
{
  BYTE *pbmdata ;
  BITMAPINFOHEADER *pbmih ;
  BITMAPINFOHEADER *pbmpinfo = reinterpret_cast<BITMAPINFOHEADER *>( aDibImage ) ;
  long infosize = pbmpinfo->biSize ;
  if ( (pbmpinfo->biBitCount != 16) && (pbmpinfo->biBitCount != 32) )
  {
    if ( pbmpinfo->biBitCount != 24 )
    {
      // pbg̕𑫂
			infosize += sizeof(RGBQUAD) * (1 << pbmpinfo->biBitCount) ;
		}
		if ( pbmpinfo->biSizeImage == 0 )
		{
			// ĂƂ
			pbmpinfo->biSizeImage = aImageSize - infosize ;
		}
		*pHBInfo = ::LocalAlloc( LMEM_FIXED, infosize ) ;
		if ( *pHBInfo == NULL )
		{
			return false ;
		}
		*pHBm = ::LocalAlloc( LMEM_FIXED, pbmpinfo->biSizeImage ) ;
		if ( *pHBm == NULL )
		{
			::LocalFree( *pHBInfo ) ;
      return false ;
    }
    pbmih = reinterpret_cast<BITMAPINFOHEADER *>( *pHBInfo ) ;
    pbmdata = reinterpret_cast<BYTE *>( *pHBm ) ;
    ::CopyMemory( pbmih, aDibImage, infosize ) ;
    ::CopyMemory( pbmdata, aDibImage + infosize, pbmpinfo->biSizeImage ) ;
	}
	else
	{
		if ( pbmpinfo->biCompression == BI_BITFIELDS )
		{
			// }XN
			infosize += sizeof(DWORD) * 3 ;
		}
		int linesize24 = (pbmpinfo->biWidth * 3 +3) & ~3 ; // 4byteE
		long dib24imgsize = linesize24 * abs( pbmpinfo->biHeight ) ;
		pbmpinfo->biSizeImage = dib24imgsize ;
		*pHBInfo = ::LocalAlloc( LMEM_FIXED, sizeof(BITMAPINFOHEADER) ) ;
		if ( *pHBInfo == NULL )
		{
			return false ;
		}
		*pHBm = ::LocalAlloc( LMEM_FIXED, dib24imgsize ) ;
		if ( *pHBm == NULL )
		{
			::LocalFree( *pHBInfo ) ;
			return false ;
		}
		pbmdata = reinterpret_cast<BYTE *>( *pHBm ) ;

		// 16bit, 32bit24bitɕϊ
		// SusieuSɂ́vΉĂȂ
		// BI_BITFIELDSɑΉĂȂ悤
		if ( pbmpinfo->biBitCount == 16 )
		{
			WORD r_mask ;
			WORD g_mask ;
			WORD b_mask ;
			BYTE *pbmp ;
			WORD tshort ;
			BYTE *pimg_base = reinterpret_cast<BYTE *>( aDibImage ) + infosize ;
			WORD *pimg ;
			// 4byteE
			int linesize16 = (pbmpinfo->biWidth * 2 +3) & ~3 ;
			int r_shift = 0 ;
			int g_shift = 0 ;
			int b_shift = 0 ;
			int r_bit = 0 ;
			int g_bit = 0 ;
			int b_bit = 0 ;
			if ( pbmpinfo->biCompression == BI_BITFIELDS )
			{
				DWORD *mask = reinterpret_cast<DWORD *>(aDibImage + pbmpinfo->biSize) ;
				r_mask = *(mask +0) ;
				g_mask = *(mask +1) ;
				b_mask = *(mask +2) ;
				// Vtgrbg
				while ( ((r_mask >> r_shift) & 1) == 0 ) r_shift++ ;
				while ( ((g_mask >> g_shift) & 1) == 0 ) g_shift++ ;
				while ( ((b_mask >> b_shift) & 1) == 0 ) b_shift++ ;
				// rbg邩
				while ( ((r_mask >> (r_shift +r_bit)) & 1) == 1 ) r_bit++ ;
				while ( ((g_mask >> (g_shift +g_bit)) & 1) == 1 ) g_bit++ ;
				while ( ((b_mask >> (b_shift +b_bit)) & 1) == 1 ) b_bit++ ;
			}
			else
			{
				// ftHg555
				r_mask = 0x7c00 ;
				g_mask = 0x03e0 ;
				b_mask = 0x001f ;
				r_shift = 10 ;
				g_shift = 5 ;
				b_shift = 0 ;
				r_bit = 5 ;
				g_bit = 5 ;
				b_bit = 5 ;
			}
			int height = abs( pbmpinfo->biHeight ) ;
			for (int y=0; y < height; y++)
			{
				pbmp = pbmdata + linesize24 * y ;
				pimg = reinterpret_cast<WORD *>(pimg_base + linesize16 * y) ;
				for (int x=0; x < pbmpinfo->biWidth; x++)
				{
					BYTE r, g, b ;
					tshort = *(pimg++) ;
					b = ((tshort & b_mask) >> b_shift) << (8 -b_bit) ;
					g = ((tshort & g_mask) >> g_shift) << (8 -g_bit) ;
					r = ((tshort & r_mask) >> r_shift) << (8 -r_bit) ;
					// PɃVtgł͐FςB
					// VtgʂĂƗǂB
					b = b | (b >> b_bit) ;
					g = g | (g >> g_bit) ;
					r = r | (r >> r_bit) ;
					*(pbmp++) = b ;
					*(pbmp++) = g ;
					*(pbmp++) = r ;
				}
			}
		}
		else
		{
			// 32bit
			DWORD r_mask ;
			DWORD g_mask ;
			DWORD b_mask ;
			BYTE *pbmp;
			BYTE *temp = reinterpret_cast<BYTE *>( aDibImage ) + infosize ;
			DWORD *pimg = reinterpret_cast<DWORD *>( temp ) ;
			int r_shift = 0 ;
			int g_shift = 0 ;
			int b_shift = 0 ;
			int r_bit = 0 ;
			int g_bit = 0 ;
			int b_bit = 0 ;
			if ( pbmpinfo->biCompression == BI_BITFIELDS )
			{
				DWORD *mask = reinterpret_cast<DWORD *>(aDibImage + pbmpinfo->biSize) ;
				r_mask = *(mask +0) ;
				g_mask = *(mask +1) ;
				b_mask = *(mask +2) ;
				while ( ((r_mask >> r_shift) & 1) == 0 ) r_shift++ ;
				while ( ((g_mask >> g_shift) & 1) == 0 ) g_shift++ ;
				while ( ((b_mask >> b_shift) & 1) == 0 ) b_shift++ ;
				while ( ((r_mask >> (r_shift +r_bit)) & 1) == 1 ) r_bit++ ;
				while ( ((g_mask >> (g_shift +g_bit)) & 1) == 1 ) g_bit++ ;
				while ( ((b_mask >> (b_shift +b_bit)) & 1) == 1 ) b_bit++ ;
			}
			else
			{
				r_mask = 0x00ff0000 ;
				g_mask = 0x0000ff00 ;
				b_mask = 0x000000ff ;
				r_shift = 16 ;
				g_shift = 8 ;
				b_shift = 0 ;
				r_bit = 8 ;
				g_bit = 8 ;
				b_bit = 8 ;
			}
			int height = abs( pbmpinfo->biHeight ) ;
			for (int y=0; y < height; y++)
			{
				pbmp = pbmdata + linesize24 * y ;
				for (int x=0; x < pbmpinfo->biWidth; x++)
				{
					*(pbmp++) = (BYTE)(((*pimg & b_mask) >> b_shift) >> (b_bit -8)) ;
					*(pbmp++) = (BYTE)(((*pimg & g_mask) >> g_shift) >> (g_bit -8)) ;
					*(pbmp++) = (BYTE)(((*pimg & r_mask) >> r_shift) >> (r_bit -8)) ;
					pimg++ ;
				}
			}
		}
		pbmpinfo->biSize          = sizeof(BITMAPINFOHEADER) ;
		pbmpinfo->biBitCount      = 24 ;
		pbmpinfo->biCompression   = BI_RGB ;
		pbmpinfo->biXPelsPerMeter = 0 ;
		pbmpinfo->biYPelsPerMeter = 0 ;
		pbmpinfo->biClrUsed       = 0 ;
		pbmpinfo->biClrImportant  = 0 ;
		pbmih = reinterpret_cast<BITMAPINFOHEADER *>( *pHBInfo ) ;
		::CopyMemory( pbmih, aDibImage, sizeof(BITMAPINFOHEADER) ) ;
	}

	return true ;
}
#endif
//---------------------------------------------------------------------------
/** 摜܂͔摜`FbN(24bit)
 * ȂtrueԂ
 * @param[in] pHBInfo SusieɕԂBITMAPINFO߂nh̃|C^
 * @param[in] pHBm SusieɕԂBITMAPf[^߂nh̃|C^
 * *pHBInfo, *pHBm LocalAlloc(LMEM_FIXED, ...)ŊmۂĂ邽
 * ̂܂܃|C^ɃLXgĎgB
 */
bool __fastcall isBlackOrWhite(HANDLE *pHBInfo, HANDLE *pHBm)
{
  bool result = true ;

  BITMAPINFOHEADER *pbmih ;
  pbmih = reinterpret_cast<BITMAPINFOHEADER *>( *pHBInfo ) ;
  BYTE *pbmdata ;
  pbmdata = reinterpret_cast<BYTE *>( *pHBm ) ;

  DWORD linesize = (pbmih->biWidth * 3 + 3) & ~3 ;
  DWORD height = abs(pbmih->biHeight) ;
  for (DWORD y=0; y < height; y++)
  {
    DWORD *p = reinterpret_cast<DWORD*>(pbmdata + linesize*y) ;
    DWORD b = 0 ; // 
    DWORD w = 0 ; // 

    // ȃ`FbNŗǂ̂
    for (DWORD x=0; x < linesize/4; x++)
    {
      b |= *p ;
			w |= ~(*p) ;
			p++ ;
		}
		b = (b >> 24) | (b >> 16) | (b >> 8) | b ;
		b = (b & 0xf8) ;
		w = (w >> 24) | (w >> 16) | (w >> 8) | w ;
		w = (w & 0xf8) ;
		if ( (b != 0) && (w != 0) )
		{
			result = false ;
			break ;
		}
  }

  return result ;
}
//---------------------------------------------------------------------------
/** ̃t[DIBɕϊ
 * @param filename t@CpX
 * @param pHBInfo SusieɕԂBITMAPINFO߂nh̃|C^
 * @param pHBm SusieɕԂBITMAPf[^߂nh̃|C^
 * @return trueAsfalseԂ
 */
#ifdef USE_SAMPLEGRABBER
#include <qedit.h> // ISampleGrabber
#pragma link "strmiids.lib" // ISampleGrabber
bool __fastcall getMovieFrame(const char *aFilename, HANDLE *pHBInfo, HANDLE *pHBm)
{
	bool result = true ;
	HRESULT hr ;
	IGraphBuilder *pigb = NULL ;
	IBaseFilter     *pF = NULL ;
	ISampleGrabber  *pGrab = NULL ;
	AM_MEDIA_TYPE   mt ;
	IMediaControl   *pMediaControl = NULL ;
	IMediaSeeking   *pSeek = NULL ;
	IMediaEvent     *pEvent = NULL ;

	double seektime[2] = {0.0, 0.0} ;
	ifmmvar.GetPreviewPos( seektime ) ;


	::CoInitialize( NULL ) ;
	hr = ::CoCreateInstance( CLSID_FilterGraph,
												NULL,
												CLSCTX_INPROC_SERVER,
												IID_IGraphBuilder,
												(void**)&pigb ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "DirectShow̏ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto CREATE_ERR ;
	}
	hr = ::CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER,
									IID_IBaseFilter, (LPVOID *)&pF ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "IBaseFilter̍쐬ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto CREATE_ERR ;
	}
	hr = pF->QueryInterface( IID_ISampleGrabber, (void **)&pGrab ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "ISampleGrabber̎擾ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NO_INTERFACE ;
	}
	hr = pigb->QueryInterface( IID_IMediaControl, (void**)&pMediaControl ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "IMediaControl̎擾ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NO_INTERFACE ;
	}
	hr = pigb->QueryInterface( IID_IMediaSeeking, (void **)&pSeek ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "IMediaSeeking̎擾ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NO_INTERFACE ;
	}
	hr = pigb->QueryInterface( IID_IMediaEvent, (void **)&pEvent ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "IMediaEvent̎擾ɎsB", "ifmm.spi", MB_OK ) ;
		ret = false ;
		goto NO_INTERFACE ;
	}


	pigb->AddFilter( pF, L"Grabber" ) ;
	::ZeroMemory( &mt, sizeof(AM_MEDIA_TYPE) ) ;
	mt.majortype = MEDIATYPE_Video ;
	mt.subtype = MEDIASUBTYPE_RGB24 ;
	mt.formattype = FORMAT_VideoInfo ;
	hr = pGrab->SetMediaType( &mt ) ;

	WCHAR w_filename[ MAX_PATH ] ;
	::MultiByteToWideChar( CP_ACP, 0, aFilename, -1, w_filename, MAX_PATH ) ;
	hr = pigb->RenderFile( w_filename, NULL ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "RenderFile()ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto OPEN_ERR ;
	}

	// Vbg [hݒ肷
	pGrab->SetBufferSamples( TRUE ) ;
	pGrab->SetOneShot( TRUE ) ;

	for (int i=0; i<2; i++)
	{
		// wbV[NB
		REFERENCE_TIME rtStart = seektime[i] * 10000000 ;
		REFERENCE_TIME rtStop = rtStart ;
		hr = pSeek->SetPositions( &rtStart, AM_SEEKING_AbsolutePositioning,
												 &rtStop, AM_SEEKING_AbsolutePositioning ) ;

		// _O҂
		long evCode ;
		hr = pMediaControl->Run() ;
		hr = pEvent->WaitForCompletion( INFINITE, &evCode ) ;
		//OAFilterState fs ;
		//hr = pMediaControl->StopWhenReady() ;
		//pMediaControl->GetState( INFINITE, &fs ) ; // _O҂


		AM_MEDIA_TYPE MediaType ;
		pGrab->GetConnectedMediaType( &MediaType ) ;

		// rfI wb_[ւ̃|C^l
		VIDEOINFOHEADER *pVideoHeader = (VIDEOINFOHEADER*)MediaType.pbFormat ;

		// rfI wb_[ɂ́Arbg}bv񂪊܂܂
		*pHBInfo = ::LocalAlloc( LMEM_FIXED, sizeof(BITMAPINFOHEADER) ) ;
		if ( *pHBInfo == NULL )
		{
			ret = false ;
			//::MessageBox( NULL, "s", "ifmm.spi", MB_OK ) ;
			goto NO_MEMORY_BMH ;
		}
		::CopyMemory( *pHBInfo, &(pVideoHeader->bmiHeader), sizeof(BITMAPINFOHEADER) ) ;
		// C[WRs[
		long BufferSize = 0 ;
		hr = pGrab->GetCurrentBuffer( &BufferSize, NULL ) ;
		*pHBm = ::LocalAlloc( LMEM_FIXED, BufferSize ) ;
		if ( *pHBm == NULL )
		{
			ret = false ;
			//::MessageBox( NULL, "s", "ifmm.spi", MB_OK ) ;
			goto NO_MEMORY_IMG ;
		}
		hr = pGrab->GetCurrentBuffer( &BufferSize, (long*)*pHBm ) ;

		// ^肷Ƃ͂x
		if ( i == 1 ) break ; //
		ret = ! isBlackOrWhite( pHBInfo, pHBm ) ;
		if ( result ) break ;
		::LocalFree( *pHBInfo ) ;
		*pHBInfo = NULL ;
		::LocalFree( *pHBm ) ;
		*pHBm = NULL ;
	}

ERR_ERR:
NO_MEMORY_IMG:
	::LocalFree( *pHBm ) ;
NO_MEMORY_BMH:
//NOT_MOVIE:
OPEN_ERR:
NO_INTERFACE:
	HELPER_RELEASE( pEvent) ;
	HELPER_RELEASE( pSeek) ;
	HELPER_RELEASE( pMediaControl ) ;
	HELPER_RELEASE( pGrab ) ;
	HELPER_RELEASE( pF ) ;
	HELPER_RELEASE( pigb ) ;
CREATE_ERR:
	::CoUninitialize() ;

	return result ;
}
#else
/* GetCurrentImage()̓_ DirectDraw ANZ[VgpĂƎsB
 * ISampleGrabber C^[tFCX̎gpĂB
 */
bool __fastcall getMovieFrame(const char *aFilename, HANDLE *pHBInfo, HANDLE *pHBm)
{
	bool result = true ;
	IGraphBuilder *pGraphBuilder = NULL ;
	IBasicVideo *pBasicVideo = NULL ;
	IMediaPosition *pMediaPosition = NULL ;
	long buffer_size = 0 ;
	char *dibimg = NULL ;
	long movie_width  = 0 ;
	long movie_height = 0 ;
	*pHBInfo = NULL ;
	*pHBm = NULL ;

	double seektime[2] = {0.0, 0.0} ;
	g_var.getPreviewPos( seektime ) ;


  ::CoInitialize( NULL ) ;
  HRESULT hr ;
  hr = CoCreateInstance( CLSID_FilterGraph,
                        NULL,
                        CLSCTX_INPROC_SERVER,
                        IID_IGraphBuilder,
                        (void**)&pGraphBuilder ) ;
  if ( FAILED( hr ) )
  {
    //::MessageBox( NULL, "DirectShow̏ɎsB", "ifmm.spi", MB_OK ) ;
    result = false ;
		goto CREATE_ERR ;
	}
	hr = pGraphBuilder->QueryInterface( IID_IMediaPosition, (void**)&pMediaPosition ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox(NULL, "DirectShow̏ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NO_INTERFACE ;
	}
	hr = pGraphBuilder->QueryInterface( IID_IBasicVideo, (void**)&pBasicVideo ) ;
	if ( FAILED( hr ) )
	{
		//::MessageBox( NULL, "DirectShow̏ɎsB", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NO_INTERFACE ;
	}
#if 0
{
	// IDirectDrawVideo 擾łȂ̂ł...
	IDirectDrawVideo *pDirectDrawVideo = NULL ;
	hr = pBasicVideo->QueryInterface( IID_IDirectDrawVideo, (void**)&pDirectDrawVideo ) ;
	if ( SUCCEEDED( hr ) )
	{
		// I[o[C؂肽
		pDirectDrawVideo->SetSwitches( AMDDS_NONE ) ;
		HELPER_RELEASE( pDirectDrawVideo ) ;
	}
}
#endif

	/* t@CI[v */
	WCHAR w_filename[ MAX_PATH ] ;
	::MultiByteToWideChar( CP_ACP, 0, aFilename, -1, w_filename, MAX_PATH ) ;
	hr = pGraphBuilder->RenderFile( w_filename, NULL ) ;
	if ( FAILED( hr ) )
  {
		//::MessageBox( NULL, "DirectShowł͍ĐłȂH", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto OPEN_ERR ;
	}
	// {ɓ悩m߂
	pBasicVideo->GetVideoSize( &movie_width, &movie_height ) ;
	if ( (movie_width < 1) || (movie_height < 1) )
	{
		// H
		//::MessageBox( NULL, "H", "ifmm.spi", MB_OK ) ;
		result = false ;
		goto NOT_MOVIE ;
	}
#if 0
{
	// IDirectDrawVideo 擾łȂ̂ł...
	IDirectDrawVideo *pDirectDrawVideo = NULL;
	IBaseFilter *pBaseFilter = NULL;
	hr = pGraphBuilder->FindFilterByName( L"Video Renderer", &pibf ) ;
	if ( SUCCEEDED( hr ) )
	{
		hr = pBaseFilter->QueryInterface( IID_IDirectDrawVideo, (void**)&pDirectDrawVideo ) ;
		if ( SUCCEEDED( hr ) )
		{
			//I[o[C؂肽
			pDirectDrawVideo->SetSwitches( AMDDS_NONE ) ;
			HELPER_RELEASE( pDirectDrawVideo ) ;
		}
	}
}
#endif

	for (int i=0; i<2; i++)
	{
		pMediaPosition->put_CurrentPosition( seektime[i] ) ;

		// DIB̃TCY𓾂
		pBasicVideo->GetCurrentImage( &buffer_size, NULL ) ;
		// DIBC[W𓾂
		if ( dibimg != NULL ) ::LocalFree( dibimg ) ;
		dibimg = static_cast<char *>( ::LocalAlloc( LMEM_FIXED, buffer_size ) ) ;
		if ( dibimg == NULL )
		{
			result = false ;
			//::MessageBox( NULL, "s", "ifmm.spi", MB_OK ) ;
			goto NO_MEMORY_DIBIMAGE ;
		}
		hr = pBasicVideo->GetCurrentImage( &buffer_size, (long *)dibimg ) ;
		if ( FAILED( hr ) )
		{
			result = false ;
			//::MessageBox( NULL, "C[W擾Ɏs", "ifmm.spi", MB_OK ) ;
			continue;
		}
#if 0
{
		FILE *fp = ::fopen( "D:\\test\\ifmm0.bmp", "wb" ) ;
		if ( fp )
		{
			::fwrite( dibimg, BufferSize, 1, fp ) ;
			::fclose( fp ) ;
		}
}
#endif

		// 24bitɕϊ
		result = to24bit( dibimg, buffer_size, pHBInfo, pHBm ) ;
#if 0
{
		FILE *fp = ::fopen( "D:\\test\\ifmm1.bmp", "wb" ) ;
		if ( fp )
		{
			::fwrite( (char*)*pHBm, ::LocalSize(*pHBm), 1, fp ) ;
			::fclose( fp ) ;
		}
}
#endif

		if ( ! result )
		{
			//::MessageBox( NULL, "24bitϊs", "ifmm.spi", MB_OK ) ;
			goto NO_MEMORY ;
		}

		// ^肷Ƃ͂x
		if ( i == 1 ) break ;
		result = ! isBlackOrWhite( pHBInfo, pHBm ) ;
		if ( result ) break ;
		::LocalFree( *pHBInfo ) ;
		*pHBInfo = NULL ;
		::LocalFree( *pHBm ) ;
		*pHBm = NULL ;
	}

ERR_ERR:
NO_MEMORY:
	::LocalFree( dibimg ) ;
NO_MEMORY_DIBIMAGE:
NOT_MOVIE:
OPEN_ERR:
NO_INTERFACE:
	HELPER_RELEASE( pBasicVideo ) ;
	HELPER_RELEASE( pMediaPosition ) ;
	HELPER_RELEASE( pGraphBuilder ) ;
CREATE_ERR:
	::CoUninitialize() ;

	return result ;
}
#endif
//---------------------------------------------------------------------------
/** fBAĐ
 * @param[in] aFilename t@C
 * @param[in] isInMemory ͂ȂtrueAt@C͂false
 * @param[in] aFileType t@C^Cv
 * @param[in] lpPrgressCallback SusiẽR[obN֐̃|C^
 * @param[in] lData R[obN֐Ŏgpf[^
 * @return SusiẽG[R[hԂ
 */
int __fastcall playMedia(const char *aFilename, const bool isInMemory, const DWORD aFileType,
							 const SPI_PROGRESS lpPrgressCallback, const long lData)
{
	int errCode = SPI_OTHER_ERROR ;
	std::auto_ptr<TPlayForm> form( new TPlayForm( NULL ) ) ;
	try
	{
		form->Icon->Handle = getIconHandle( aFilename, aFileType, SHGFI_SMALLICON ) ;
		g_var.getVar( &form->Var ) ;
		if ( form->Var.option[ OPTION_StayOnTop ] )
		{
			form->FormStyle = fsStayOnTop ;
		}

		if ( ! form->MediaOpen( aFilename, ! isInMemory, aFileType ) )
		{
			//::MessageBox( NULL, "DirectShowł͍ĐłȂH", "ifmm.spi", MB_OK ) ;
			return SPI_OUT_OF_ORDER ;
		}

		form->PrgressCallback = lpPrgressCallback ;
		form->Data = lData ;
		//form->Show() ; //
		errCode = form->Play() ;
		form->Visible = false ;
	}
	__finally
	{
		form->MediaClose() ;
	}

	return errCode ;
}
//---------------------------------------------------------------------------

