/** vC[tH[
 */
/*
 * Copyright (c) 2000-2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef PlayerUnitH
#define PlayerUnitH
//---------------------------------------------------------------------------
#include <strmif.h>
#include <control.h>
#include <uuids.h>
#include <evcode.h>
#include "spi_api.h"
#include "ifmmain.h"
#include "mixerctr.h"

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <Menus.hpp>
//---------------------------------------------------------------------------
#define WM_GRAPHNOTIFY	WM_USER+500
class TPlayForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
  TPanel *MoviePanel;
		TPanel *Panel;
		TScrollBox *ScrollBox;
		TStatusBar *StatusBar;
	TTrackBar *MediaTrackBar;
	TPopupMenu *PopupMenu;
	TMenuItem *PerSec10;
	TMenuItem *PerMin01;
	TMenuItem *PerMin05;
	TMenuItem *PerMin10;
	TMenuItem *PerSec30;
	TMenuItem *PerSec01;
	TSpeedButton *PlaySpeedButton;
	TSpeedButton *PauseSpeedButton;
	TSpeedButton *PrevSpeedButton;
	TMenuItem *ScaleMenuItem;
	TMenuItem *ScaleX1;
	TMenuItem *ScaleX2;
	TMenuItem *ScaleX4;
	TMenuItem *m1MenuItem;
	TMenuItem *ScaleCustom;
	TMenuItem *ScaleFull;
	TTrackBar *VolumeTrackBar;
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall FormKeyPress(TObject *Sender, char &Key);
	void __fastcall MediaTrackBarChange(TObject *Sender);
	void __fastcall PerSec10Click(TObject *Sender);
	void __fastcall PlaySpeedButtonClick(TObject *Sender);
	void __fastcall ScaleX1Click(TObject *Sender);
	void __fastcall ScrollBoxClick(TObject *Sender);
	void __fastcall VolumeTrackBarChange(TObject *Sender);
private:	// [U[錾
  void __fastcall WMGraphNotify(TMessage &Msg) ;
  void __fastcall MM_MixCtrChange(TMessage &Msg) ;
	void __fastcall getCustomRect(RECT *pRect, int aClientWidth, int aClientHeight) ;
	void __fastcall setMovieRect(RECT *pRect) ;
  void __fastcall changeRate(void) ;
  void __fastcall updateStatusText(void) ;
  void __fastcall changeVolume(int aVol) ;
  inline void __fastcall toggleMute(void) ;
  //void __fastcall putFullScreen(void) ;
  bool __fastcall mediaInit(void) ;
  void __fastcall statusInit(void) ;
  bool __fastcall uiInit(const DWORD aFileType) ;
  AnsiString __fastcall formatTimeLength(const DWORD aMediaLength) ;

	/* DirectShow֌W */
#define HELPER_RELEASE(x) { if ((x)) {(x)->Release(); (x) = NULL;} }
	IGraphBuilder  *m_pGraphBuilder ;
	IMediaControl  *m_pMediaControl ;
	IMediaEventEx  *m_pMediaEventEx ;
	IVideoWindow   *m_pVideoWindow ;
	IMediaPosition *m_pMediaPosition ;
//#define USE_IBA
#ifdef USE_IBA
	IBasicAudio *m_pBasicAudio ;
#else //g
  TMixerCtr m_Volume ;
#endif

typedef enum
{
	EStateMediaReady,
	EStateMediaPlay,
	EStateMediaStop,
	EStateMediaPause,
	EStateMediaAbort,
} MediaState ;
	MediaState m_mediaState ; // v[[(fBA)̏

	long m_MoviewWidth ;  // ̎ۂ̕
	long m_MovieHeight ; // ̎ۂ̍

	bool m_ChangingAuto ;
	bool m_ChangingManual ;
	bool m_ChangingVolume ;
	int m_MediaLength ;
	double m_MediaRate ; // sb`
	AnsiString m_LengthStr ;

public:		// [U[錾
	__fastcall TPlayForm(TComponent* Owner);
	void __fastcall FormResizeEx(TObject *Sender) ;
	void __fastcall FormResizeMovie(TObject *Sender) ;
	int __fastcall Play(void) ;
	void __fastcall FormMouseMoveEx(TObject *Sender,
		TShiftState Shift, int X, int Y) ;
	bool __fastcall MediaOpen(const char *aFilePath, bool isFilenameForCaption, const DWORD aFileType) ;
	void __fastcall MediaClose(void) ;
	BEGIN_MESSAGE_MAP
		MESSAGE_HANDLER(WM_GRAPHNOTIFY, TMessage, WMGraphNotify)
		MESSAGE_HANDLER(MM_MIXM_CONTROL_CHANGE, TMessage, MM_MixCtrChange)
		//MESSAGE_HANDLER(MM_MIXM_LINE_CHANGE, TMessage, MM_MixCtrChange)
	END_MESSAGE_MAP(TForm) ;
typedef enum
{
	buttonMediaPlay,
	buttonMediaPause,
	buttonMediaPrev,
} MediaButton ;
	void __fastcall MediaClick(MediaButton aButton) ;

	SPI_PROGRESS PrgressCallback ;
	long Data ;

	IFMMVAR_STRUCT Var ;
	
};

//---------------------------------------------------------------------------
#endif
