//---------------------------------------------------------------------------
/** o̓vOCǗNX
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef xpi_namage_h
#define xpi_namage_h

#include <vcl.h>
#include <vector>
#include "plugin_abc.h"

//---------------------------------------------------------------------------
class AXpiManager
{
private:
    std::vector <APluginABC *> m_xpiArray ;
    int m_xpiCount ;
    /** vOCzCfbNXԍ͈̔̓`FbN
     */
    bool __fastcall boundCheck(const int num)
    {
        return (num >= 0) && (num < m_xpiCount) ;
    }
    APluginABC *m_xpi8bit ;   // 8bitȉ̂Ƃgpo̓vOC
    APluginABC *m_xpi16bit ;  // 16bitȏ̂Ƃgpo̓vOC
    APluginABC *m_xpi ; // ݎgĂo̓vOC

    bool __fastcall setXpi(const int num) ; // m_xpiZbg

    bool __fastcall getPluginInfo(const int num, const int infoNum, const LPSTR buf, const int buflen) ;

public:
    AXpiManager()
    {
        m_xpiCount = 0 ;
    }
    ~AXpiManager() ;
    int __fastcall getXpiCount(void)
    {
        return m_xpiCount ;
    }
    void __fastcall loadAll(const char *path) ;
    void __fastcall loadXpi(const char *path) ;
    bool __fastcall setXpi8bit(const int num) ;
    bool __fastcall setXpi16bit(const int num) ;

    AnsiString __fastcall getXpiInfo(const int num, const int infoNum) ;
    bool __fastcall checkSupport8(const short color) ;
    bool __fastcall checkSupport16(const short color) ;
    int __fastcall convertPicture(char *filepath, const DWORD flag,
                        HANDLE *pHBInfo, HANDLE *pHBm, PictureInfo *lpInfo,
                        SPI_PROGRESS lpPrgressCallback, const long lData) ;
    bool __fastcall xpiConfig(const int num, const HWND parent, const int fnc) ;

};
/* O[o */
extern AXpiManager g_xpiManager ;

/** G[R[h
 */
#define XPI_FATAL_ERR       -102  /* vIG[iOj */

#endif /* xpi_manage.h */

