//---------------------------------------------------------------------------
/** SusievOCǗNX
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef spi_manage_h
#define spi_manage_h

#include "plugin_spi.h"
#include <vector>

#define SPI_FMASK_SSS    0x7
#define SPI_FMASK_I      0x80
#define SPI_FMASK_DDD    0x700
#define SPI_FLAG_I_SAME  0x80 //Ȃ񂾂킩񂼁H
#define SPI_FLAG_FILE    0
#define SPI_FLAG_MEM     1
#define SPI_FLAG_OUTFILE 0
#define SPI_FLAG_OUTMEM  0x100
#define IS_FILEIN(f) (((f) & SPI_FMASK_SSS) == SPI_FLAG_FILE)
#define IS_MEMIN(f) (((f) & SPI_FMASK_SSS) == SPI_FLAG_MEM)
//---------------------------------------------------------------------------
class ASpiManager
{
private:
    std::vector <APluginSusie *> m_array00AM;
    int m_count00AM;
    std::vector <APluginSusie *> m_array00IN;
    int m_count00IN;
    /** vOCzCfbNXԍ͈̔̓`FbN
     */
    bool __fastcall boundCheck(const int num)
    {
        return (num >= 0) && (num < m_count00AM + m_count00IN) ;
    }

    //pcspiNULL̏ꍇ̓t@C`FbN
    //vOCm肵ĂȂn
    bool __fastcall getPluginInfo(APluginSusie *pcspi, const int infoNum, const LPSTR buf, const int buflen);
    bool __fastcall configDlg(APluginSusie *pcspi, const HWND parent, const int fnc);

public:
    ASpiManager()
    {
        m_count00IN = 0 ;
        m_count00AM = 0 ;
    }
    ~ASpiManager() ;
    int __fastcall getCount00AM(void)
    {
        return m_count00AM ;
    }
    int __fastcall getCount00IN(void)
    {
        return m_count00IN ;
    }

    void __fastcall loadAll(const char *path);
    void __fastcall loadSpi(const char *path);
    AnsiString __fastcall getSpiInfo(int num, int infono);
    APluginSusie* __fastcall filecheck(char *src, char *mem);

    int __fastcall spi_picinfo(APluginSusie *pcspi, const LPSTR buf, const long len,
                      const DWORD flag, PictureInfo *lpInfo);
    int __fastcall spi_pic(APluginSusie *pcspi, const LPSTR buf, const long len, const DWORD flag,
                     HANDLE *pHBInfo, HANDLE *pHBm,
                   SPI_PROGRESS lpPrgressCallback, const long lData);
    int __fastcall spi_prev(APluginSusie *pcspi, const LPSTR buf, const long len, const DWORD flag,
                     HANDLE *pHBInfo, HANDLE *pHBm,
                   SPI_PROGRESS lpPrgressCallback, const long lData);
    int __fastcall spi_arcinfo(APluginSusie *pcspi, const LPSTR buf, const long len,
                      const DWORD flag, HLOCAL *lphInf);
    int __fastcall spi_fileinfo(APluginSusie *pcspi, const LPSTR buf, const long len, const LPSTR filename,
                                 const DWORD flag, fileInfo *lpInfo);
    int __fastcall spi_getfile(APluginSusie *pcspi, const LPSTR src, const long len, const LPSTR dest, const DWORD flag,
                        SPI_PROGRESS lpPrgressCallback, const long lData);
    bool __fastcall spiConfig(const int num, const HWND parent, const int fnc);

    int __fastcall spi2dib(const AnsiString &filename, HANDLE *pHBInfo, HANDLE *pHBm, HANDLE *pHfile, const bool preview);
    int __fastcall GetFileEx(const AnsiString &filename, const AnsiString &arcname, HANDLE *src, HANDLE *dest);
};
extern ASpiManager g_spiManager ;

/** G[R[h
  */
#define SPI_FATAL_ERR -2  /* vIG[iOj */

#endif /* spi_manage.h */
