//---------------------------------------------------------------------------
/** SusievOCǗNX
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <stdio.h>
#include <vcl.h>
#pragma hdrstop

#include "spi_manage.h"
#include "misc.h"

/* O[o */
ASpiManager g_spiManager ;
//---------------------------------------------------------------------------
/** ɉȂR[obN֐
 * R[obNw肵ȂƗvOC邽
 */
static int __stdcall nopSpiCallback(int nNum, int nDenom, long lData)
{
    return 0 ;
}
//---------------------------------------------------------------------------
/** fXgN^
 * vOC
 */
ASpiManager::~ASpiManager()
{
    std::vector<APluginSusie *>::iterator ite ;
    if ( ! m_array00IN.empty() )
    {
        for (ite = m_array00IN.begin(); ite != m_array00IN.end(); ite++)
        {
            delete *ite ;
        }
    }
    if ( ! m_array00AM.empty() )
    {
        for (ite = m_array00AM.begin(); ite != m_array00AM.end(); ite++)
        {
            delete *ite ;
        }
    }
}
//---------------------------------------------------------------------------
/** wtH_ɂSusievOC[h
 * @param path \\ŏItH_̃pX
 */
void __fastcall ASpiManager::loadAll(const char *path)
{
    AnsiString findpath = (AnsiString)path + "*.spi" ;
    loadSpi( findpath.c_str() ) ;
}
//---------------------------------------------------------------------------
/** wpX̃vOC[h
 * @param path ChJ[hL
 */
void __fastcall ASpiManager::loadSpi(const char *path)
{
    AnsiString spipath ;
    AnsiString pathdir = ExtractFilePath( path ) ;

    WIN32_FIND_DATA ff ;
    HANDLE hf = FindFirstFile( path, &ff ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return ;

    while ( hf != INVALID_HANDLE_VALUE )
    {
        APluginSusie *spi = new APluginSusie ;
        spipath = pathdir + ff.cFileName ;

        if ( ! spi->load( spipath.c_str() ) )
        {
            delete spi ;
        }
        else
        {
            if ( spi->getType() == TYPE_00AM )
            {
                m_array00AM.push_back( spi ) ;
                m_count00AM++ ;
            }
            else
            {
                m_array00IN.push_back( spi ) ;
                m_count00IN++ ;
            }
        }
        if ( FindNextFile( hf, &ff ) == 0 ) break ;
    }
    FindClose( hf ) ;
}
//---------------------------------------------------------------------------
/** SusievOC̏𓾂
 * @param pcspi vOCNX
 * @param infoNum ԍ
 * @param buf ރobt@
 * @param buflen buf̃TCY
 */
bool __fastcall ASpiManager::getPluginInfo(APluginSusie *pcspi,
                    const int infoNum, const LPSTR buf, const int buflen)
{
    bool ret = false ;

    if ( pcspi != NULL )
    {
        try
        {
            ret = pcspi->GetPluginInfo( infoNum, buf, buflen ) ;
        }
        catch (...)
        {
            //throw ;
        }
    }
    return ret ;
}
//---------------------------------------------------------------------------
/** vOC̏𓾂
 * getPluginInfo()̃bv
 * @param num vOCz̃CfbNXԍ
 * @param infoNum ԍ
 */
AnsiString __fastcall ASpiManager::getSpiInfo(int num, int infoNum)
{
    AnsiString retstr = "" ;

    if ( ! boundCheck( num ) ) retstr ;

    APluginSusie *pspi ;
    const infoBufSize = 512 ;
    const buflen = infoBufSize -1 ; // vOCŏI[܂łv
    char buf[ infoBufSize ] = "" ;

    // 00AMJEg
    if ( num < m_count00AM )
    {
        pspi = m_array00AM[ num ] ;
    }
    else
    {
        pspi = m_array00IN[ num - m_count00AM ] ;
    }
    if ( getPluginInfo( pspi, infoNum, buf, buflen ) )
    {
        buf[ buflen ] = '\0' ; // vOC͐MpȂ
        retstr = buf ;
    }

    return retstr ;
}
//---------------------------------------------------------------------------
/** t@C̓WJ`FbN
 * @param src t@CpX
 * @param mem f[^
 * @return ΉĂvOCNXւ̃|C^Ԃ
 *         ΉNULLԂ
 */
APluginSusie* __fastcall ASpiManager::filecheck(char *src, char *mem)
{
    const headerBufSize = 4000 ;
    char data[ headerBufSize ] ;
    char *pdata ;

    if ( mem == NULL )
    {
        /* t@C */
        FILE *fp = fopen( src, "rb" ) ;
        if ( fp == NULL ) return NULL ;
        fread( data, 1, headerBufSize, fp ) ;
        fclose( fp ) ;
        pdata = data ;
    }
    else
    {
        /*  */
        pdata = mem ;
    }

    // 00AMD
    std::vector<APluginSusie *>::iterator ite ;
    for (ite = m_array00AM.begin(); ite != m_array00AM.end(); ite++)
    {
        try
        {
            if ( *ite != NULL )
            {
                if ( (*ite)->IsSupported( src, (DWORD)pdata ) != 0 )
                {
                    return  *ite ;
                }
            }
        }
        catch (...)
        {
            //throw ;
        }
    }

    // 00IN
    for (ite = m_array00IN.begin(); ite != m_array00IN.end(); ite++) {
        try
        {
            if ( *ite != NULL )
            {
                if ( (*ite)->IsSupported( src, (DWORD)pdata ) != 0 )
                {
                    return *ite ;
                }
            }
        }
        catch (...)
        {
            //throw ;
        }
    }

    return NULL ;
}
//---------------------------------------------------------------------------
/** 摜̏𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param flag
 * @param lpInfo ԋpPictureInfof[^ւ̃|C^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_picinfo(APluginSusie *pcspi,
                   const LPSTR buf, const long len, const DWORD flag,
                      PictureInfo *lpInfo)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( buf, NULL ) ;
        }
        else
        {
            // ̃C[W
            pcspi = filecheck( NULL, buf ) ;
        }
        if ( pcspi == NULL ) return SPI_NOT_SUPPORT ;
    }

    if ( pcspi->getType() == TYPE_00IN )
    {
        try
        {
            ret = pcspi->GetPictureInfo( buf, len, flag, lpInfo ) ;
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** 摜𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param flag
 * @param pHBInfo ԋpBITMAPINFOf[^nhւ̃|C^
 * @param pHBm ԋprbg}bvf[^nhւ̃|C^
 * @param lpPrgressCallback R[obN֐
 * @param lData R[obN֐ɓnf[^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_pic(APluginSusie *pcspi,
                     const LPSTR buf, const long len, const DWORD flag,
                     HANDLE *pHBInfo, HANDLE *pHBm,
                     SPI_PROGRESS lpPrgressCallback, const long lData)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( buf, NULL ) ;
        }
        else
        {
            // ̃C[W
            pcspi = filecheck( NULL, buf ) ;
        }
        if ( pcspi == NULL ) return ret ;
    }

    if ( pcspi->getType() == TYPE_00IN )
    {
        if ( lpPrgressCallback == NULL )
        {
            lpPrgressCallback = nopSpiCallback ;
        }
        try
        {
            ret = pcspi->GetPicture( buf, len, flag, pHBInfo, pHBm,
                               lpPrgressCallback, lData ) ;
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** vr[摜𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param flag
 * @param pHBInfo ԋpBITMAPINFOf[^nhւ̃|C^
 * @param pHBm ԋprbg}bvf[^nhւ̃|C^
 * @param lpPrgressCallback R[obN֐
 * @param lData R[obN֐ɓnf[^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_prev(APluginSusie *pcspi,
                     const LPSTR buf, const long len, const DWORD flag,
                     HANDLE *pHBInfo, HANDLE *pHBm,
                     SPI_PROGRESS lpPrgressCallback, const long lData)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( buf, NULL ) ;
        }
        else
        {
            // ̃C[W
            pcspi = filecheck( NULL, buf ) ;
        }
        if ( pcspi == NULL ) return ret ;
    }

    if ( pcspi->getType() == TYPE_00IN )
    {
        if ( lpPrgressCallback == NULL)
        {
            lpPrgressCallback = nopSpiCallback ;
        }
        try
        {
            ret = pcspi->GetPreview( buf, len, flag, pHBInfo, pHBm,
                               lpPrgressCallback, lData ) ;
            if ( ret == SPI_NO_FUNCTION )
            {
                ret = pcspi->GetPicture( buf, len, flag, pHBInfo, pHBm,
                               lpPrgressCallback, lData ) ;
            }
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** A[JCȕ𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param flag
 * @param pHBInfo ԋpfileInfozf[^nhւ̃|C^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_arcinfo(APluginSusie *pcspi,
                      const LPSTR buf, const long len,
                      const DWORD flag, HLOCAL *lphInf)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( buf, NULL ) ;
        }
        else
        {
            // ̃C[W
            pcspi = filecheck( NULL, buf ) ;
        }
        if ( pcspi == NULL ) return ret ;
    }

    if ( pcspi->getType() == TYPE_00AM )
    {
        *lphInf = NULL ; // for lhasad.spi
        try
        {
            ret = pcspi->GetArchiveInfo( buf, len, flag, lphInf ) ;
            // for lhasad.spi's bug
            if ( ret == SPI_NOT_SUPPORT && *lphInf != NULL )
            {
                ret = SPI_ALL_RIGHT ;
            }
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** A[JCut@C̏𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param filename ׂA[JCut@C
 * @param flag
 * @param pHBInfo ԋpfileInfof[^ւ̃|C^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_fileinfo(APluginSusie *pcspi,
                    const LPSTR buf, const long len, const LPSTR filename,
                    const DWORD flag, fileInfo *lpInfo)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( buf, NULL ) ;
        }
        else
        {
            // ̃C[W
            pcspi = filecheck( NULL, buf ) ;
        }
        if ( pcspi == NULL ) return ret ;
    }

    if ( pcspi->getType() == TYPE_00AM )
    {
        try
        {
            ret = pcspi->GetFileInfo( buf, len, filename, flag, lpInfo ) ;
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** A[JCũt@C𓾂
 * @param pcspi vOCNXւ̃|C^
 * @param buf t@CpX܂̓f[^ւ̃|C^
 * @param len
 * @param dest
 * @param flag
 * @param pHBInfo ԋpfileInfof[^ւ̃|C^
 * @return G[R[h
 */
int __fastcall ASpiManager::spi_getfile(APluginSusie *pcspi,
                    const LPSTR src, const long len, const LPSTR dest, const DWORD flag,
                    SPI_PROGRESS lpPrgressCallback, const long lData)
{
    int ret = SPI_NO_FUNCTION ;

    if ( pcspi == NULL )
    {
        if ( IS_FILEIN( flag ) )
        {
            // fBXNt@C
            pcspi = filecheck( src, NULL ) ;
        } else {
            // ̃C[W
            pcspi = filecheck( NULL, src ) ;
        }
        if ( pcspi == NULL ) return ret ;
    }

    if ( pcspi->getType() == TYPE_00AM )
    {
        if ( lpPrgressCallback == NULL)
        {
            lpPrgressCallback = nopSpiCallback ;
        }
        try
        {
           ret = pcspi->GetFile( src, len, dest, flag,
                        lpPrgressCallback, lData ) ;
        }
        catch (...)
        {
            ret = SPI_FATAL_ERR ;
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------
/** SusievOC̐ݒ_CAO\
 * z񂩂vOCݒ肵configDlg()Ɉn
 * @param num vOCz̃CfbNXԍ
 * @param parent _CAO̐eEBhEnh
 * @param func _CAOԍ
 */
bool __fastcall ASpiManager::spiConfig(const int num, const HWND parent, const int func)
{
    if ( ! boundCheck( num ) ) return false ;

    APluginSusie *pcspi ;
    if ( num < m_count00AM )
    {
        pcspi = m_array00AM[ num ] ;
    }
    else
    {
        pcspi = m_array00IN[ num - m_count00AM ] ;
    }

    return configDlg( pcspi, parent, func ) ;
}
//---------------------------------------------------------------------------
/** SusievOC̐ݒ_CAO\
 * @param pcspi vOCNX
 * @param parent _CAO̐eEBhEnh
 * @param func _CAOԍ
 */
bool __fastcall ASpiManager::configDlg(APluginSusie *pcspi, const HWND parent, const int func)
{
    bool ret = false ;
    if ( pcspi == NULL ) return ret ;
    if ( pcspi->ConfigurationDlg != NULL )
    {
        try
        {
            if ( pcspi->ConfigurationDlg( parent, func ) != 0 )
            {
                ret = true ;
            }
        }
        catch (...)
        {
            //throw ;
        }
    }

    return ret ;
}
//---------------------------------------------------------------------------


/** pX摜𓾂
 * ɓɓΉ
 * @return G[R[hԂ
 */
int __fastcall ASpiManager::spi2dib(const AnsiString &filename,
    HANDLE *pHBInfo, HANDLE *pHBm, HANDLE *pHfile, const bool preview)
{
    //Ή`FbN
    int ret;
    APluginSusie *pcspi;
    char *pfimg = NULL;
    AnsiString tmpname = filename;
    AnsiString arcpath = ""; //ɓ̃pX
    unsigned int flag = SPI_FLAG_FILE;
    ret = ExistsCheck(tmpname);
if (pHfile == NULL && ret != NO_EXISTS) {
//t@C̃pXϊ
    if (ret == IS_DIR) {
        //tH_͖낤...
        return SPI_FILE_READ_ERROR;
    }
    //t@C݂
    //DIBQbg
    pcspi = filecheck(tmpname.c_str(), pfimg);
    if (pcspi->getType() == TYPE_00IN) {
        if (preview) {
            ret = spi_prev(pcspi, tmpname.c_str(), 0, flag, pHBInfo, pHBm, NULL, 0);
            if (ret != SPI_ALL_RIGHT) {
                ret = spi_pic(pcspi, tmpname.c_str(), 0, flag, pHBInfo, pHBm, NULL, 0);
            }
        } else {
            ret = spi_pic(pcspi, tmpname.c_str(), 0, flag, pHBInfo, pHBm, NULL, 0);
        }
    } else {
        return SPI_NOT_SUPPORT;
    }
    return ret;

}

//C[Wϊ
    flag = SPI_FLAG_MEM;
if (tmpname == "") {
    //C[W̓t@C炵
    //DIBQbg
    pfimg = (char *)LocalLock(*pHfile);
    pcspi = filecheck(tmpname.c_str(), pfimg);
    if (pcspi->getType() == TYPE_00IN) {
        if (preview) {
            ret = spi_prev(pcspi, pfimg, LocalSize(*pHfile), flag, pHBInfo, pHBm, NULL, 0);
            if (ret != SPI_ALL_RIGHT) {
                ret = spi_pic(pcspi, pfimg, LocalSize(*pHfile), flag, pHBInfo, pHBm, NULL, 0);
            }
        } else {
            ret = spi_pic(pcspi, pfimg, LocalSize(*pHfile), flag, pHBInfo, pHBm, NULL, 0);
        }
        LocalUnlock(*pHfile);
        return ret;
    }
    LocalUnlock(*pHfile);
    return SPI_NOT_SUPPORT;
}

//wt@Co
    HANDLE dest = NULL;
    ret = GetFileEx(tmpname, "", pHfile, &dest);
    if (ret != SPI_ALL_RIGHT) {
        if (dest != NULL) LocalFree(dest);
        return ret;
    }
    ret = spi2dib("", pHBInfo, pHBm, &dest, preview);
    if (dest != NULL) LocalFree(dest);
    return ret;
}
//---------------------------------------------------------------------------
//ɂt@C𓾂iɓɑΉj
//G[R[hԂ
//filename:~t@C̃pX
//arcname:~ɓ̃pXBċApBʂ""Ă
//HANDLE *src:ɃC[WBt@C͂NULLI
//HANDLE *dest:ԋpp
int __fastcall ASpiManager::GetFileEx(const AnsiString &filename, const AnsiString &arcname,
                   HANDLE *src, HANDLE *dest)
{
    int ret;
    APluginSusie *pcspi;
    fileInfo finfo;
    HANDLE htmp = NULL;
    AnsiString tmpname = filename;
    AnsiString arcpath = arcname;

if (arcpath == "") {
    //t@C
    //Ƃ̏ɂ
for (;;) {
    ret = ExistsCheck(tmpname);
    if (ret == NO_EXISTS) {
        //ɓt@Cw肵Ă̂
        if (arcpath != "") arcpath = "\\" +arcpath;
        arcpath = ExtractFileName(tmpname) +arcpath;
        tmpname = ExtractDirName(tmpname);
        if (tmpname.Length() <= 3) {
            //ႢH
            return SPI_FILE_READ_ERROR;
        }
    } else if (ret == IS_FILE) {
        //t@C݂
        //`FbNȂƖċAăX^bNI[o[t[
        if (arcpath == "") return SPI_NOT_SUPPORT;
        break;
    } else {
        //tH_͖낤...
        return SPI_FILE_READ_ERROR;
    }
} //end for (;;)
    //ċA
    //arcpath:ɓpX
    //tmpname:Ƀt@C
    ret = GetFileEx(tmpname, arcpath, NULL, dest);
    return ret;
}

if (src == NULL) {
    //t@C
    //ɂ͓ς
    //wt@C͏ɂɂ邩H
    pcspi = filecheck(tmpname.c_str(), NULL);
    if (pcspi->getType() != TYPE_00AM) {
        return SPI_NOT_SUPPORT;
    }
    memset(&finfo, 0, sizeof(finfo));
    ret = spi_fileinfo(pcspi, tmpname.c_str(), 0, arcpath.c_str(), SPI_FLAG_FILE, &finfo);
    if (ret == SPI_ALL_RIGHT) {
        ret = spi_getfile(pcspi, tmpname.c_str(), finfo.position, (char *)dest, SPI_FLAG_OUTMEM, NULL, 0);
        if (ret != SPI_ALL_RIGHT) {
            return ret;
        }
        return ret;
    }
for (;;) {
    //ɓɂ
    int ofset = arcpath.AnsiPos("\\");
    if (ofset == 0) {
        //...
        return SPI_FILE_READ_ERROR;
    }
    tmpname = arcpath.SubString(1, ofset -1);
    arcpath = arcpath.SubString(ofset +1, arcpath.Length() -ofset);
    memset(&finfo, 0, sizeof(finfo));
    ret = spi_fileinfo(pcspi, filename.c_str(), 0, tmpname.c_str(), SPI_FLAG_FILE, &finfo);
    if (ret == SPI_ALL_RIGHT) {
        ret = spi_getfile(pcspi, filename.c_str(), finfo.position, (char *)&htmp, SPI_FLAG_OUTMEM, NULL, 0);
        if (ret != SPI_ALL_RIGHT) {
            return ret;
        }
        //ɍċA
        ret = GetFileEx("", arcpath, &htmp, dest);
        LocalFree(htmp);
        return ret;
    }
} //end for (;;)
}

    //
    //ɂ͓ς
    //wt@C͏ɂɂ邩H
    char *pfimg = (char *)LocalLock(*src);
    pcspi = filecheck(tmpname.c_str(), pfimg);
    if (pcspi->getType() != TYPE_00AM) {
        LocalUnlock(*src);
        return SPI_NOT_SUPPORT;
    }
    memset(&finfo, 0, sizeof(finfo));
    ret = spi_fileinfo(pcspi, pfimg, LocalSize(*src), arcpath.c_str(), SPI_FLAG_MEM, &finfo);
    if (ret == SPI_ALL_RIGHT) {
        ret = spi_getfile(pcspi, pfimg +finfo.position, LocalSize(*src) -finfo.position, (char *)dest, SPI_FLAG_OUTMEM | SPI_FLAG_MEM, NULL, 0);
        LocalUnlock(*src);
        if (ret != SPI_ALL_RIGHT) {
            return ret;
        }
        return ret;
    }
for (;;) {
    //ɓɂ
    int ofset = arcpath.AnsiPos("\\");
    if (ofset == 0) {
        //...
        LocalUnlock(*src);
        return SPI_FILE_READ_ERROR;
    }
    tmpname = arcpath.SubString(0, ofset -1);
    arcpath = arcpath.SubString(ofset +1, arcpath.Length() -ofset -1);
    memset(&finfo, 0, sizeof(finfo));
    ret = spi_fileinfo(pcspi, pfimg, LocalSize(*src), arcpath.c_str(), SPI_FLAG_MEM, &finfo);
    if (ret == SPI_ALL_RIGHT) {
        ret = spi_getfile(pcspi, pfimg +finfo.position, LocalSize(*src) -finfo.position, (char *)&htmp, SPI_FLAG_OUTMEM | SPI_FLAG_MEM, NULL, 0);
        LocalUnlock(*src);
        if (ret != SPI_ALL_RIGHT) {
            return ret;
        }
        //ɍċA
        ret = GetFileEx("", arcpath, &htmp, dest);
        LocalFree(htmp);
        return ret;
    }
} //end for (;;)
}
//---------------------------------------------------------------------------

