//---------------------------------------------------------------------------
/** SusievOCNX
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef susie_plugin_h
#define susie_plugin_h

#include "plugin_dll.h"

#pragma pack(push)
#pragma pack(1) //\̂̃oE1oCgɂ pragma
typedef struct PictureInfo
{
    long left, top ;      /* 摜WJʒu */
    long width ;          /* 摜̕(pixel) */
    long height ;         /* 摜̍(pixel) */
    WORD x_density ;      /* f̐x */
    WORD y_density ;      /* f̐x */
    short colorDepth ;    /* fbit */
    HLOCAL hInfo ;        /* 摜̃eLXg */
} PictureInfo ;

typedef struct fileInfo
{
    unsigned char method[8] ;    /* k@̎ */
    unsigned long position ;     /* t@Cł̈ʒu */
    unsigned long compsize ;     /* kꂽTCY */
    unsigned long filesize ;     /* ̃t@CTCY */
    /*time_t*/ long timestamp ;  /* t@C̍XV */
    char path[200] ;             /* ΃pX */
    char filename[200] ;         /* t@Cl[ */
    unsigned long crc ;          /* CRC */
} fileInfo ;
#pragma pack(pop)

typedef int (CALLBACK *SPI_PROGRESS)(int, int, long) ;

/** G[R[h
 */
#define SPI_NO_FUNCTION       -1  /* ̋@\̓CvgĂȂ */
#define SPI_ALL_RIGHT          0  /* I */
#define SPI_ABORT              1  /* R[obN֐0Ԃ̂œWJ𒆎~ */
#define SPI_NOT_SUPPORT        2  /* m̃tH[}bg */
#define SPI_OUT_OF_ORDER       3  /* f[^Ă */
#define SPI_NO_MEMORY          4  /* [mۏoȂ */
#define SPI_MEMORY_ERROR       5  /* [G[ */
#define SPI_FILE_READ_ERROR    6  /* t@C[hG[ */
#define	SPI_WINDOW_ERROR       7  /* JȂ (J) */
#define SPI_OTHER_ERROR        8  /* G[ */
#define	SPI_FILE_WRITE_ERROR   9  /* ݃G[ (J) */
#define	SPI_END_OF_FILE       10  /* t@CI[ (J) */

//---------------------------------------------------------------------------
class APluginSusie : public APluginDLL
{
/** SusievOC̊֐`
 */
// 
typedef int (__stdcall *FGetPluginInfo)(int infono, LPSTR buf, int buflen) ;
typedef int (__stdcall *FIsSupported)(LPSTR filename, DWORD dw) ;
typedef int (__stdcall *FConfigurationDlg)(HWND parent, int fnc) ;
// 00IN
typedef int (__stdcall *FGetPictureInfo)(LPSTR buf, long len,
                           unsigned int flag, PictureInfo *lpInfo) ;
typedef int (__stdcall *FGetPicture)(LPSTR buf, long len, unsigned int flag,
                                     HANDLE *pHBInfo, HANDLE *pHBm,
                        SPI_PROGRESS lpPrgressCallback, long lData) ;
typedef int (__stdcall *FGetPreview)(LPSTR buf, long len, unsigned int flag,
                                     HANDLE *pHBInfo, HANDLE *pHBm,
                        SPI_PROGRESS lpPrgressCallback, long lData) ;
// 00AM
typedef int (__stdcall *FGetArchiveInfo)(LPSTR buf, long len,
                                         unsigned int flag, HLOCAL *lphInf) ;
typedef int (__stdcall *FGetFileInfo)(LPSTR buf, long len, LPSTR filename,
                                         unsigned int flag, fileInfo *lpInfo) ;
typedef int (__stdcall *FGetFile)(LPSTR src, long len, LPSTR dest,
                             unsigned int flag,
                        SPI_PROGRESS lpPrgressCallback, long lData) ;
                        
private:
#define TYPE_UNKNOWN    0
#define TYPE_00IN       1
#define TYPE_00AM       2
    int m_type ;

public:
    FGetPluginInfo GetPluginInfo ;
    FConfigurationDlg ConfigurationDlg ;
    FIsSupported IsSupported ;
    FGetPictureInfo GetPictureInfo ;
    FGetPicture GetPicture ;
    FGetPreview GetPreview ;
    FGetArchiveInfo GetArchiveInfo ;
    FGetFileInfo GetFileInfo ;
    FGetFile GetFile ;

    APluginSusie()
    {
        m_type = TYPE_UNKNOWN ;
    }

    ~APluginSusie()
    {
    }

    int __fastcall getType(void)
    {
        return m_type ;
    }
    
    bool __fastcall addressing(void)
    {
    	GET_FUNC( m_handle, GetPluginInfo ) ;
	    GET_FUNC( m_handle, IsSupported ) ;
    	GET_FUNC( m_handle, GetPictureInfo ) ;
	    GET_FUNC( m_handle, GetPicture ) ;
    	GET_FUNC( m_handle, GetPreview ) ;
	    GET_FUNC( m_handle, GetArchiveInfo ) ;
    	GET_FUNC( m_handle, GetFileInfo ) ;
	    GET_FUNC( m_handle, GetFile ) ;
    	GET_FUNC( m_handle, ConfigurationDlg ) ;

	    if ( (GetArchiveInfo != NULL) && (GetFile != NULL) )
    	{
	        // GetFileInfo͏dvȂ
	        m_type = TYPE_00AM ;
    	}
	    else if ( GetPicture != NULL )
    	{
	        // GetPictureInfo, GetPreview ͏dvȂ
	        m_type = TYPE_00IN ;
    	}
	    else
    	{
	        m_type = TYPE_UNKNOWN ;
	        return false ;
    	}

	    return (GetPluginInfo != NULL) & (IsSupported != NULL) ;
    }

};

#endif /* plugin_spi.h */
