//---------------------------------------------------------------------------
/** DLLvOCۃNX
 */
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef dll_plugin_h
#define dll_plugin_h

#include <vcl.h>

//---------------------------------------------------------------------------
/** GetProcAddress() helper
 * typedef void (__stdcall *FDllFunction)(void) ;
 * FDllFunction DllFunction ;
 * GET_FUNC( hdll, DllFunction ) ;
 */
#define GET_FUNC(hdll, api) ( ## api = (F ## api)GetProcAddress(hdll, #api) )

class APluginDLL
{
protected :
    HANDLE m_handle ;
    AnsiString m_dllname ;
    /** DLL̊֐̃AhXݒ肷֐
     */
    virtual bool __fastcall addressing(void) = 0;

public :
    APluginDLL()
    {
        m_handle = NULL ;
        m_dllname = "" ;
    }

    virtual ~APluginDLL()
    {
		unload() ;
    }

    AnsiString __fastcall getPluginFilename(void)
    {
        return m_dllname ;
    }

    bool __fastcall load(const char *dllpath)
    {
		bool ret = false ;
		unload() ;

		m_handle = ::LoadLibrary( dllpath ) ;

		if ( m_handle != NULL )
		{
			ret = addressing() ;
			if ( ret ) m_dllname = dllpath ;
		}

		return	ret ;
	}

    void unload(void)
    {
        if ( m_handle == NULL ) return ;

        ::FreeLibrary( m_handle ) ;
        m_handle = NULL ;
		m_dllname = "" ;
    }
};

#endif /* plugin_dll.h */
