//---------------------------------------------------------------------------
/** ABCo̓vOCNX
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef abc_plugin_h
#define abc_plugin_h

#include "plugin_dll.h"
#include "plugin_spi.h"

/** G[R[h
 */
#define XPI_NO_FUNCTION       -101  /* ̋@\̓CvgĂȂ */
#define XPI_ALL_RIGHT            0  /* I */
#define XPI_ABORT              101  /* R[obN֐0Ԃ̂œWJ𒆎~ */
#define XPI_NOT_SUPPORT        102  /* m̃tH[}bg */
#define XPI_OUT_OF_ORDER       103  /* f[^Ă */
#define XPI_NO_MEMORY          104  /* [mۏoȂ */
#define XPI_MEMORY_ERROR       105  /* [G[ */
#define XPI_FILE_READ_ERROR    106  /* t@C[hG[ */
#define	XPI_WINDOW_ERROR       107  /* JȂ */
#define XPI_OTHER_ERROR        108  /* G[ */
#define	XPI_FILE_WRITE_ERROR   109  /* ݃G[ */
#define	XPI_END_OF_FILE        110  /* t@CI[ */

//---------------------------------------------------------------------------
class APluginABC : public APluginDLL
{
typedef int (__stdcall *FGetPluginInfo)(int infono, LPSTR buf, int buflen);
typedef int (__stdcall *FConfigurationDlg)(HWND parent, int fnc);
typedef int (__stdcall *FIsSupported)(int colorDepth);
typedef int (__stdcall *FCreatePicture)(char *filepath, unsigned int flag,
                        HANDLE *pHBInfo,HANDLE *pHBm, PictureInfo *lpInfo,
                        SPI_PROGRESS lpPrgressCallback, long lData);

public:
    FGetPluginInfo GetPluginInfo ;
    FConfigurationDlg ConfigurationDlg ;
    FIsSupported IsSupported ;
    FCreatePicture CreatePicture ;

    APluginABC()
    {
    }

    ~APluginABC()
    {
    }

    bool __fastcall addressing(void)
    {
    	GET_FUNC( m_handle, GetPluginInfo ) ;
	    GET_FUNC( m_handle, IsSupported ) ;
    	GET_FUNC( m_handle, CreatePicture ) ;
	    GET_FUNC( m_handle, ConfigurationDlg ) ;

	    return (GetPluginInfo != NULL) & (IsSupported != NULL) & (CreatePicture != NULL) ;
    }

};

#endif /* plugin_abc.h */
