//---------------------------------------------------------------------------
/** CtH[
 */
//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <Registry.hpp>
#pragma hdrstop

#include "mainform.h"
#include "expform.h"
#include "aboutform.h"
#include "misc.h"
#include "spi_manage.h"
#include "xpi_manage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "DropEdit"
#pragma link "DropListBox"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
    AnsiString path;
    // SusievOC̏ꏊEXÊtH_
    path = ExtractDirName( ParamStr( 0 ) ) + "\\" ;
    g_spiManager.loadAll( path.c_str() ) ;
    // o̓vOC̏ꏊexp_plugtH_
    path += "exp_plug\\" ;
    g_xpiManager.loadAll( path.c_str() ) ;

    // R{{bNXɏo͌`
    int count = g_xpiManager.getXpiCount() ;
    for (int i=0; i < count; i++)
    {
        Bit8ComboBox->Items->Add( g_xpiManager.getXpiInfo( i, 2 ) ) ;
    }
    Bit16ComboBox->Items->AddStrings( Bit8ComboBox->Items ) ;
}
//---------------------------------------------------------------------------
/** t@Chbvt̓o^
 * @param flagAccept 󂯕tȂtrue
 */
void __fastcall TMainForm::setDropAccept(bool flagAccept)
{
    SrcListBox->DropAccept = flagAccept ;
    SrcEdit->DropAccept = flagAccept ;
    OutEdit->DropAccept = flagAccept ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    setDropAccept( true ) ;
    loadOptions() ;

    /* R}hC */
    int count = ParamCount() ;
    if ( count > 0 )
    {
        AnsiString param ;
        for (int i=0; i < count; )
        {
            i++ ;
            param = ParamStr( i ) ;
            DWORD at = GetFileAttributes( param.c_str() ) ;
            if ( at == 0xFFFFFFFF )
            {
                ; // 
            }
            else if ( at == FILE_ATTRIBUTE_DIRECTORY )
            {
                SrcListBox->Items->Add( param + "\\*.*" ) ;
            }
            else
            {
                SrcListBox->Items->Add( param ) ;
            }
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
    // Ô߉
    setDropAccept( false ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::startConvert(void)
{
    // XPIo^
    g_xpiManager.setXpi8bit( Bit8ComboBox->ItemIndex ) ;
    g_xpiManager.setXpi16bit( Bit16ComboBox->ItemIndex ) ;


    TDialogForm* form = new TDialogForm(this) ;
    Enabled = false ;
    form->Visible = true ;
    form->init() ;
    form->play() ; // Xbh肽Ȃ̂Ŏ蔲
    form->Visible = false ;
    Enabled = true ;
    delete form ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::StartButtonClick(TObject *Sender)
{
    if ( IsStartEnable() ) startConvert() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AboutButtonClick(TObject *Sender)
{
    TAboutForm* form = new TAboutForm(this) ;
    form->ShowModal() ;
    delete form ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FileAddButtonClick(TObject *Sender)
{
/** t@Cǉ
 */
    TOpenDialog *OpenDialog = new TOpenDialog(this) ;
    OpenDialog->Options << ofHideReadOnly << ofAllowMultiSelect	<< ofEnableSizing ;
    OpenDialog->Title = "ϊt@Cǉ" ;
    if ( OpenDialog->Execute() )
    {
        SrcListBox->Items->AddStrings( OpenDialog->Files ) ;
        // ǉt@C\
        SrcListBox->TopIndex = SrcListBox->Items->Count -1 ;
    }
    delete OpenDialog ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DeleteButtonClick(TObject *Sender)
{
/** Xg폜
 */
    // IĂ̂폜
    int count = SrcListBox->Items->Count -1 ;
    // 폜ƏԂ̂Ō납폜Ă
    for (int i = count; i >= 0; i--)
    {
        if ( SrcListBox->Selected[ i ] )
        {
            SrcListBox->Items->Delete( i ) ;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AddButtonClick(TObject *Sender)
{
/** SrcEdit̓eSrcListBoxɒǉ
 */
    // t@C݂̑mF
    if ( SrcEdit->Text.IsEmpty() ) return ;
    if ( ExistsCheck( SrcEdit->Text ) == NO_EXISTS )
    {
        ::Message( "̂悤ȃt@C݂͑܂B", MB_ICONEXCLAMATION ) ;
        return ;
    }

    SrcListBox->Items->Add( SrcEdit->Text ) ;
    SrcListBox->TopIndex = SrcListBox->Items->Count -1 ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::CloseButtonClick(TObject *Sender)
{
    Close() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DirAddButtonClick(TObject *Sender)
{
/** tH_ǉ
 */
    AnsiString dirPath ;
    if ( ::SelectDirectory( "ϊtH_I", "", dirPath ) )
    {
        SrcListBox->Items->Add( dirPath + "\\*.*" ) ;
        SrcListBox->TopIndex = SrcListBox->Items->Count -1 ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OutButtonClick(TObject *Sender)
{
    AnsiString dirPath ;
    if ( ::SelectDirectory( "ϊtH_I", "", dirPath ) )
    {
        OutEdit->Text = dirPath ;
    }
}
//---------------------------------------------------------------------------
bool __fastcall TMainForm::IsStartEnable(void)
{
/** ϊw̃`FbN
 */
    if ( SrcListBox->Items->Count <= 0 )
    {
        ::Message("ϊt@Cw肵ĂB", MB_ICONINFORMATION ) ;
        return false;
    }

    if ( (Bit8ComboBox->ItemIndex == -1) || (Bit16ComboBox->ItemIndex == -1) )
    {
        ::Message( "o͌`w肵ĂB", MB_ICONINFORMATION  ) ;
        return false ;
    }

    if ( OutEdit->Text.IsEmpty() )
    {
        ::Message( "ϊtH_w肵ĂB", MB_ICONEXCLAMATION ) ;
        return false ;
    }

    if ( ! ForceDirectories( OutEdit->Text) )
    {
        ::Message( "ϊtH_쐬ł܂B", MB_ICONEXCLAMATION ) ;
        return false ;
    }

    return true ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OpenButtonClick(TObject *Sender)
{
    TOpenDialog *OpenDialog = new TOpenDialog(this) ;
    OpenDialog->Options << ofHideReadOnly << ofEnableSizing ;
    OpenDialog->Title = "Q..." ;
    if ( OpenDialog->Execute() )
    {
        SrcEdit->Text = OpenDialog->FileName ;
    }
    delete OpenDialog ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveButtonClick(TObject *Sender)
{
    saveOptions() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::saveOptions(void)
{
/** ݒۑ
 */
    TRegistry *reg = new TRegistry ;
    //reg->RootKey = HKEY_CURRENT_USER ;
    reg->OpenKey( "\\Software\\shimitei\\abc", true ) ;

    reg->WriteString( "OutDir",  OutEdit->Text ) ;
    reg->WriteBool( "Overwrite", OverWriteCB->Checked ) ;
    reg->WriteBool( "ArcOut",    UnknownOutputCB->Checked ) ;
    reg->WriteString( "bit8",    Bit8ComboBox->Items->Strings[Bit8ComboBox->ItemIndex] ) ;
    reg->WriteString( "bit16",   Bit16ComboBox->Items->Strings[Bit16ComboBox->ItemIndex] ) ;

    reg->CloseKey() ;
    delete reg ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::loadOptions(void)
{
/** ݒǂݍ
 */
    TRegistry *reg = new TRegistry ;
    //reg->RootKey = HKEY_CURRENT_USER ;
    reg->OpenKey( "\\Software\\shimitei\\abc", true ) ;

    // ̃AvP[Vł͎gpȂXPItH_̏ꏊ
    reg->WriteString( "XPIPath", ExtractDirName( ParamStr( 0 ) ) + "\\exp_plug\\" ) ;

    // ϊtH_
    if ( reg->ValueExists( "OutDir" ) )
    {
        OutEdit->Text = reg->ReadString( "OutDir" ) ;
    }
    // ㏑mF
    if ( reg->ValueExists( "Overwrite" ) )
    {
        OverWriteCB->Checked = reg->ReadBool( "Overwrite" ) ;
    }
    // m̌`o
    if ( reg->ValueExists( "ArcOut" ) )
    {
        UnknownOutputCB->Checked = reg->ReadBool( "ArcOut" ) ;
    }
    // o͌`
    AnsiString format ;
    if ( reg->ValueExists( "bit8" ) )
    {
        format = reg->ReadString( "bit8" ) ;
        setFormat( Bit8ComboBox, format ) ;
    }
    if ( reg->ValueExists( "bit16" ) )
    {
        format = reg->ReadString( "bit16" ) ;
        setFormat( Bit16ComboBox, format ) ;
    }

    reg->CloseKey() ;
    delete reg ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::setFormat(TComboBox *comboBox, const AnsiString &format)
{
    int count = comboBox->Items->Count ;
    for (int i=0; i < count; i++)
    {
        if ( comboBox->Items->Strings[i] == format )
        {
            comboBox->ItemIndex = i ;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SrcListBoxDropFiles(TObject *Sender,
      TStringList *DropFileList)
{
/** t@C̃hbv󂯎
 */
    int count = DropFileList->Count ;
    AnsiString str ;
    for (int i=0; i < count; i++)
    {
        str = DropFileList->Strings[ i ] ;
        switch ( ExistsCheck( str ) )
        {
            case IS_DIR:
                SrcListBox->Items->Add( str + "\\*.*" ) ;
                break ;
            case IS_FILE:
                SrcListBox->Items->Add( str ) ;
                break ;
            default:
                ;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SrcEditDropFiles(TObject *Sender,
      char *DropFileName)
{
/** t@C̃hbv󂯎
 */
    ((TDropEdit *)Sender)->Text = DropFileName ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::abc8setButtonClick(TObject *Sender)
{
/** o̓vOC̐ݒ
 */
    if ( Bit8ComboBox->ItemIndex == -1 ) return ;
    if ( ! g_xpiManager.xpiConfig( Bit8ComboBox->ItemIndex, Handle, 1 ) )
    {
        ::Message( "̃vOCɂ͐ݒ肪܂B", MB_ICONINFORMATION ) ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::abc16setButtonClick(TObject *Sender)
{
/** o̓vOC̐ݒ
 */
    if ( Bit16ComboBox->ItemIndex == -1 ) return ;
    if ( ! g_xpiManager.xpiConfig( Bit16ComboBox->ItemIndex, Handle, 1 ) )
    {
        ::Message( "̃vOCɂ͐ݒ肪܂B", MB_ICONINFORMATION ) ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ImportListButtonClick(TObject *Sender)
{
/** Xg荞
 */
    TOpenDialog *OpenDialog = new TOpenDialog(this) ;
    OpenDialog->Options << ofHideReadOnly << ofEnableSizing ;
    OpenDialog->Title = "Xg荞" ;
    if ( OpenDialog->Execute() )
    {
        TStringList *list = new TStringList() ;
        list->LoadFromFile( OpenDialog->FileName ) ;
        SrcListBox->Items->AddStrings( list ) ;
        SrcListBox->TopIndex = SrcListBox->Items->Count -1 ;
        delete list ;
    }
    delete OpenDialog ;
}
//---------------------------------------------------------------------------

