#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include "exp_api.h"
#include "expng.h"
#include "lib/png.h"
#include "resource.h"

extern int RegTinyGet(HKEY tree, const char *key_name, const char *val_name,
				  LPVOID buffer);
extern int RegTinySet(HKEY tree, const char *key_name, const char *val_name,
				  DWORD type, LPVOID buffer, DWORD length);
void __fastcall SetDefaultOptions(void);
void __fastcall LoadOptions(void);

HINSTANCE ghDLLInst;
expng_opt opt; //IvV
//---------------------------------------------------------------------------
int WINAPI DllMain(HINSTANCE hinst, unsigned long reason, void*lpvReserved)
{
    switch (reason) {
        case DLL_PROCESS_ATTACH:
			ghDLLInst = hinst;
            SetDefaultOptions();
            LoadOptions();
            break;
    }

    return 1;
}
//---------------------------------------------------------------------------
void __fastcall SetDefaultOptions(void)
{
    opt.complevel = 8; //kx(0-9)
	opt.filter = PNG_ALL_FILTERS; //FILTER-all
	opt.inter = 0; //nonC^[X
	opt.alpha = 0; //32rbgȂ
    //opt.comment = 0; //Rg
    //strcpy(opt.lang, "ja"); //lang
}
//---------------------------------------------------------------------------
void __fastcall LoadOptions(void)
{
	//WXgǂݍ
    //kx
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"complevel", &opt.complevel);
    //tB^[
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"usefilter", &opt.filter);
    //C^[X
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"interlace", &opt.inter);
    //At@
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"withalpha", &opt.alpha);
#if 0
    //Rg
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"comment", &opt.comment);
    //lang
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
				"lang", &opt.lang);
	opt.lang[79] = '\0';
#endif
}
//---------------------------------------------------------------------------
//
BOOL CALLBACK
setting_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	char clstr[4];
	LRESULT tcomplv;
	switch ( msg ){
		case WM_INITDIALOG:
			wsprintf(clstr, "%d", opt.complevel);
			SetWindowText(GetDlgItem(hwnd, CL_STATIC), clstr);
			//SetRangeMin
			SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_SETRANGEMIN, FALSE, 0);
			//SetRangeMax
			SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_SETRANGEMAX, FALSE, 9);
			//SetTicFreq
			SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_SETTICFREQ, 1, 0L);
			//SetPos
			SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_SETPOS, TRUE, opt.complevel);
			//filter
			if (opt.filter & PNG_FILTER_NONE)
				CheckDlgButton(hwnd, FNONE_CHECK, BST_CHECKED);
			if (opt.filter & PNG_FILTER_SUB)
				CheckDlgButton(hwnd, FSUB_CHECK, BST_CHECKED);
			if (opt.filter & PNG_FILTER_UP)
				CheckDlgButton(hwnd, FUP_CHECK, BST_CHECKED);
			if (opt.filter & PNG_FILTER_AVG)
				CheckDlgButton(hwnd, FAVG_CHECK, BST_CHECKED);
			if (opt.filter & PNG_FILTER_PAETH)
				CheckDlgButton(hwnd, FPAETH_CHECK, BST_CHECKED);
			//C^[X
			if (opt.inter)
				CheckDlgButton(hwnd, PROG_CHECK, BST_CHECKED);
			//At@
			if (opt.alpha)
				CheckDlgButton(hwnd, ALPHA_CHECK, BST_CHECKED);
			//if (opt.comment) CheckDlgButton(hwnd, COM_CHECK, BST_CHECKED);
			break;
		case WM_DESTROY:
			break;
		case WM_NOTIFY:
			switch ( (int)(wParam) ) {
				case CL_SLIDER:
					//GetPos
					tcomplv = SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_GETPOS, 0, 0l);
					sprintf(clstr, "%d", tcomplv);
					SetWindowText(GetDlgItem(hwnd, CL_STATIC), clstr);
					break;
			}
			break;
		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					opt.complevel = SendMessage(GetDlgItem(hwnd, CL_SLIDER), TBM_GETPOS, 0, 0L);
					opt.filter = PNG_NO_FILTERS;
					if (IsDlgButtonChecked(hwnd, FNONE_CHECK))
						opt.filter |= PNG_FILTER_NONE; 
					if (IsDlgButtonChecked(hwnd, FSUB_CHECK))
						opt.filter |= PNG_FILTER_SUB; 
					if (IsDlgButtonChecked(hwnd, FUP_CHECK))
						opt.filter |= PNG_FILTER_UP; 
					if (IsDlgButtonChecked(hwnd, FAVG_CHECK))
						opt.filter |= PNG_FILTER_AVG; 
					if (IsDlgButtonChecked(hwnd, FPAETH_CHECK))
						opt.filter |= PNG_FILTER_PAETH; 
					opt.inter = IsDlgButtonChecked(hwnd, PROG_CHECK);
					opt.alpha = IsDlgButtonChecked(hwnd, ALPHA_CHECK);
					//opt.comment = IsDlgButtonChecked(hwnd, COM_CHECK);
                    EndDialog(hwnd, IDOK);
					return TRUE;
				case IDCANCEL:
					EndDialog(hwnd, IDCANCEL);
					return TRUE;
			}
			break;
		default:
			;
	}
	return FALSE;
}
//---------------------------------------------------------------------------
int __stdcall ConfigurationDlg(HWND parent, int fnc)
{
#define XPI_CFGDLG_ABOUT    0
#define	XPI_CFGDLG_SETTING  1
#define	XPI_CFGDLG_RESERVED 2

	int ret;
    switch (fnc) {
        case XPI_CFGDLG_SETTING:
			ret = DialogBox(ghDLLInst, MAKEINTRESOURCE(SET_DIALOG), parent, setting_proc);
			if (ret == IDOK) {
				//WXgɕۑ
			    //kx
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
							"complevel", REG_DWORD, &opt.complevel, sizeof(opt.complevel));
			    //tB^[
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
							"usefilter", REG_DWORD, &opt.filter, sizeof(opt.filter));
			    //C^[X
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
							"interlace", REG_DWORD, &opt.inter, sizeof(opt.inter));
			    //At@
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
							"withalpha", REG_DWORD, &opt.alpha, sizeof(opt.alpha));
#if 0
			    //Rg
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\expng", 
							"comment", REG_DWORD, &opt.comment, sizeof(opt.comment));
#endif
			}
			return XPI_ALL_RIGHT;
    }
    return XPI_NO_FUNCTION;
}
//---------------------------------------------------------------------------
