//---------------------------------------------------------------------------
/*
 * Copyright (c) 1999 - 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef Unit3H
#define Unit3H

#include "spi_manage.h"
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <FileCtrl.hpp>
#include <ExtCtrls.hpp> //MinimizeName
//---------------------------------------------------------------------------
/** ϊis */
typedef enum
{
    convertStateConverting,
    convertStateStop,
    convertStateAbort,
    convertStateSleep,
    convertStateEnd,
} ConvertState ;
class TDialogForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TPageControl *PageControl;
    TTabSheet *QueueTabSheet;
    TTabSheet *NoticeTabSheet;
    TPanel *NorthPanel;
    TLabel *srcHeaderLabel;
    TLabel *SrcLabel;
    TButton *PauseButton;
    TButton *StopButton;
    TButton *CloseButton;
    TMemo *NoticeMemo;
    TListBox *QueueListBox;
        void __fastcall CloseButtonClick(TObject *Sender);
        void __fastcall StopButtonClick(TObject *Sender);
        void __fastcall PauseButtonClick(TObject *Sender);
    void __fastcall QueueListBoxClick(TObject *Sender);
private:	// [U[錾
        void __fastcall FilesAddList(const AnsiString &path) ;
        void __fastcall AddErr(const int err, const AnsiString &filepath, const AnsiString &spiname) ;
        int __fastcall convert(AnsiString filepath, AnsiString desdir, char *pmem, long len) ;
        int __fastcall spi2xpi(char *src, char *des, char *mem, long len, APluginSusie *pspi) ;
        int __fastcall to8bit(HLOCAL *bmpinfo, HLOCAL *bmpdata, const int color) ;
        int __fastcall to24bit(HLOCAL *bmpinfo, HLOCAL *bmpdata, const int color) ;
        ConvertState m_state ;
        int m_overwrite ;
#define ABC_OVERWRITE_ALWAYS    0 //ɏ㏑
#define ABC_OVERWRITE_VERIFY    1 //₢킹
#define ABC_OVERWRITE_ALWAYS_NO 3 //ɏ㏑͂Ȃ

public:		// [U[錾
        __fastcall TDialogForm(TComponent* Owner);
        void __fastcall init(void) ;
        void __fastcall play(void) ;
};
//---------------------------------------------------------------------------
//extern PACKAGE TDialogForm *DialogForm;
//---------------------------------------------------------------------------
#endif
