#include <stdio.h>
#include <windows.h>
#include "exp_api.h"

//#pragma comment(lib, "ijl/ijl15l.lib")

#include "exjpeg.h"

extern jpeg_opt exp_opt;
extern JPEG_CORE_PROPERTIES jcprops;

//---------------------------------------------------------------------------
int __stdcall GetPluginInfo (int infono, char *buf, int buflen)
{
    char *infomation[] = {
      /* 0 */  "T0XN",
      /* 1 */  "JPEG export library v0.0.3.2",
      /* 2 */  "JPEG",
      /* 3 */  ".jpg",
      /* X */  ".jpeg", //̎dl͎sH
    };
    if (infono < 0 || infono >= 4) 
        return 0;

	if (exp_opt.extjpeg) infomation[3] = infomation[4];
    lstrcpyn(buf, infomation[infono], buflen);

    return lstrlen(buf);
}
//---------------------------------------------------------------------------
int __stdcall IsSupported (int colorDepth)
{
    /* F[xmF */
    if (colorDepth == 24)
        return 1;

    return 0;
}
//---------------------------------------------------------------------------
int write_JPEG_file (char *filepath, BITMAPINFOHEADER *bmih, char *pbmdat,
			PictureInfo *lpInfo, struct jpeg_opt *pexp_opt,
    int (CALLBACK *lpPrgressCallback)(int,int,long),
                long lData)
{
	JPEG_CORE_PROPERTIES jcprops;
    int ret = XPI_ALL_RIGHT;

    //if (lpPrgressCallback != NULL) lpPrgressCallback(0, 1, lData);

	// create an IJL compressor; initialize with default parameters
	ijlInit(&jcprops);

    // Setup DIB
	jcprops.DIBBytes = pbmdat;
	jcprops.DIBWidth = bmih->biWidth;
	jcprops.DIBHeight = -bmih->biHeight;  //{gAbv͕
	jcprops.DIBPadBytes = IJL_DIB_PAD_BYTES(jcprops.DIBWidth, jcprops.DIBChannels);
	//jcprops.DIBChannels = 3;  /* default = 3 */
	//jcprops.DIBColor = IJL_BGR;  /* default = IJL_BGR */

    // Setup JPEG
	jcprops.JPGFile = filepath;
	jcprops.JPGWidth = bmih->biWidth;
	jcprops.JPGHeight = bmih->biHeight;
	//jcprops.JPGChannels = 3;  /* default = 3 */
	//jcprops.JPGColor = IJL_YCBCR;  /* default = IJL_YCBCR */
	jcprops.JPGSubsampling = exp_opt.subsampl;
	//jcprops.JPGThumbHeight = 0;  /* default = 0 */
	//jcprops.JPGThumbWidth = 0;  /* default = 0 */
	jcprops.jquality = exp_opt.qual;

	//vObVu
    if (pexp_opt->prog)
		jcprops.jprops.progressive_found = 1;
	//Rg
    if (pexp_opt->comment && lpInfo->hInfo != NULL) {
		jcprops.jprops.jpeg_comment = (char *)LocalLock(lpInfo->hInfo);
		jcprops.jprops.jpeg_comment_size = LocalSize(lpInfo->hInfo);
    }

    if (ijlWrite(&jcprops, IJL_JFILE_WRITEWHOLEIMAGE) != IJL_OK) {
		ret = XPI_FILE_WRITE_ERROR;
    }

	// release the IJL
	ijlFree(&jcprops);

	//if (lpPrgressCallback != NULL) lpPrgressCallback(1, 1, lData);

    return ret;
}
//---------------------------------------------------------------------------
int __stdcall CreatePicture (
                char *filepath, unsigned int flag,
                HANDLE *pHBInfo, HANDLE *pHBm, PictureInfo *lpInfo,
    int (CALLBACK *lpPrgressCallback)(int,int,long),
                long lData)
{
    int ret;
	BITMAPINFOHEADER *bmih;
	char *pbmdat;

    if (exp_opt.qual < 1)   exp_opt.qual = 1;
    if (exp_opt.qual > 100) exp_opt.qual = 100;

    /* flag check */
	switch (flag) {
		case 0: //nh
		    bmih = (BITMAPINFOHEADER*)LocalLock(*pHBInfo);
			pbmdat = (char *)LocalLock(*pHBm);
			break;
		case 1: //̃AhX
		    bmih = (BITMAPINFOHEADER*)pHBInfo;
			pbmdat = (char *)pHBm;
			break;
		default:
    	return XPI_NO_FUNCTION;
	}

    ret = write_JPEG_file(filepath, bmih, pbmdat, lpInfo, &exp_opt, lpPrgressCallback, lData);

	if (flag == 0) {
		//nh
		LocalUnlock(*pHBInfo);
		LocalUnlock(*pHBm);
	}

    return ret;
}
//---------------------------------------------------------------------------
