#include <stdio.h>
#include <windows.h>
#include "exp_api.h"
#include "resource.h"
#include "Commctrl.h"
#include "exjpeg.h"

extern int RegTinyGet(HKEY tree, const char *key_name, const char *val_name,
				  LPVOID buffer);
extern int RegTinySet(HKEY tree, const char *key_name, const char *val_name,
				  DWORD type, LPVOID buffer, DWORD length);
void __fastcall SetDefaultOptions(void);
void __fastcall LoadOptions(void);

HINSTANCE ghDLLInst;
//IvV
jpeg_opt exp_opt;

//---------------------------------------------------------------------------
int WINAPI DllMain(HINSTANCE hinst, unsigned long reason, void*lpvReserved)
{
    switch (reason) {
        case DLL_PROCESS_ATTACH:
			ghDLLInst = hinst;
            SetDefaultOptions();
            LoadOptions();
            break;
    }

    return 1;
}
//---------------------------------------------------------------------------
void __fastcall SetDefaultOptions(void)
{
    //k
    exp_opt.qual = 75;
    //vObVu
    exp_opt.prog = 0; //nonvObVu
    //Rg𖄂߂
    exp_opt.comment = 0; //false
    //gq".jpeg"
    exp_opt.extjpeg = 0; //false
}
//---------------------------------------------------------------------------
void __fastcall LoadOptions(void)
{
	//WXgǂݍ
    //k
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
				"quality", &exp_opt.qual);
    //vObVu
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
				"progressive", &exp_opt.prog);
    //Rg
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
				"comment", &exp_opt.comment);
    //gq".jpeg"
	RegTinyGet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
				"extjpeg", &exp_opt.extjpeg);
}
//---------------------------------------------------------------------------
//
BOOL CALLBACK
setting_proc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	char qstr[4];
	LRESULT tqual;
	//NMHDR *pnmh;
	switch ( msg ){
		case WM_INITDIALOG:
			sprintf(qstr, "%d", exp_opt.qual);
			SetWindowText(GetDlgItem(hwnd, QUALITY), qstr);
			//SetRangeMin
			SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_SETRANGEMIN, FALSE, 1);
			//SetRangeMax
			SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_SETRANGEMAX, FALSE, 100);
			//SetTicFreq
			SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_SETTICFREQ, 10, 0L);
			//SetPos
			SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_SETPOS, TRUE, exp_opt.qual);
			if (exp_opt.prog)
				CheckDlgButton(hwnd, PROG_CHECK, BST_CHECKED);
			if (exp_opt.comment)
				CheckDlgButton(hwnd, COM_CHECK, BST_CHECKED);
			if (exp_opt.extjpeg)
				CheckDlgButton(hwnd, EXT_CHECK, BST_CHECKED);
			break;
		case WM_DESTROY:
			break;
		case WM_NOTIFY:
			switch ( (int)(wParam) ) {
				case QUAL_SLIDER:
					//pnmh = (LPNMHDR)lParam;
					//GetPos
					tqual = SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_GETPOS, 0, 0l);
					sprintf(qstr, "%d", tqual);
					SetWindowText(GetDlgItem(hwnd, QUALITY), qstr);
					break;
			}
		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					exp_opt.qual = SendMessage(GetDlgItem(hwnd, QUAL_SLIDER), TBM_GETPOS, 0, 0l);
					exp_opt.prog = IsDlgButtonChecked(hwnd, PROG_CHECK);
					exp_opt.comment = IsDlgButtonChecked(hwnd, COM_CHECK);
					exp_opt.extjpeg = IsDlgButtonChecked(hwnd, EXT_CHECK);
					EndDialog(hwnd, IDOK);
					return TRUE;
				case IDCANCEL:
					EndDialog(hwnd, IDCANCEL);
					return TRUE;
			}
			break;
		default:
			;
	}
	return FALSE;
}
//---------------------------------------------------------------------------
int __stdcall ConfigurationDlg(HWND parent, int fnc)
{
#define XPI_CFGDLG_ABOUT    0
#define	XPI_CFGDLG_SETTING  1
#define	XPI_CFGDLG_RESERVED 2

	int ret;
    switch (fnc) {
        case XPI_CFGDLG_SETTING:
			ret = DialogBox(ghDLLInst, MAKEINTRESOURCE(SET_DIALOG), parent, setting_proc);
			if (ret == IDOK) {
				//WXgɕۑ
				//k
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
							"quality", REG_DWORD, &exp_opt.qual, sizeof(exp_opt.qual));
			    //vObVu
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
							"progressive", REG_DWORD, &exp_opt.prog, sizeof(exp_opt.prog));
			    //Rg
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
							"comment", REG_DWORD, &exp_opt.comment, sizeof(exp_opt.comment));
			    //gq
				RegTinySet(HKEY_CURRENT_USER, "Software\\shimitei\\exjpeg", 
							"extjpeg", REG_DWORD, &exp_opt.extjpeg, sizeof(exp_opt.extjpeg));
			}
			return XPI_ALL_RIGHT;
    }
    return XPI_NO_FUNCTION;
}
//---------------------------------------------------------------------------
