/* daSEL.c */
#include <Pilot.h>
#include "res.h"

/* define */
#define IsSJIS1(n)		((((Byte)(n)>0x80) && ((Byte)(n)<0xa0)) || (((Byte)(n)>0xdf) && ((Byte)(n)<0xeb)))
#define IsSJIS2(n)		((((Byte)(n)>0x3f) && ((Byte)(n)<0xfd)) && (((Byte)(n)!=0x7f)))
#define IsASCII(n)		(((Byte)(n)>0x1f) && ((Byte)(n)<0x7f))
#define IsKANA(n)		(((Byte)(n)>0x9f) && ((Byte)(n)<0xe0))
#define IsCTRL(n)		(((Byte)(n)>0x00) && ((Byte)(n)<0x20))

/* struct */
typedef struct {
	Word		wCommand;
	FormPtr		thisForm;
	FormPtr		activeForm;
	FieldPtr	activeField;
	Word		wStart;
	Word		wEnd;
} t_Prefs;

/* prototype */
void start();
static void MainEventLoop( t_Prefs* pPrefs );
static Boolean MainHandleEvent( EventPtr event, t_Prefs* pPrefs );
static FieldPtr GetFocusObjectPtr( FormPtr activeForm );
static Word AdjustCursor( FieldPtr field, Word pos );
static void SelectionMoveLeft( t_Prefs* pPrefs );
static void SelectionMoveRight( t_Prefs* pPrefs );
static void SelectionMoveLeft2( t_Prefs* pPrefs );
static void SelectionMoveRight2( t_Prefs* pPrefs );

/* da main */
void start()
{
	t_Prefs tPrefs;
	Word pos;
	//	Word d1, d2, d3;
	//	Char szBuf[4];

	tPrefs.wCommand = 0;

	tPrefs.activeForm = FrmGetActiveForm();
	if( tPrefs.activeForm == NULL ){
		return;
	}

	tPrefs.activeField = GetFocusObjectPtr( tPrefs.activeForm );
	if( tPrefs.activeField == NULL ){
		return;
	}

	/*
		if( InsPtEnabled() == false ){
			return;
		}
	*/

	// XN[΍쒆
	//	FldSetScrollPosition( tPrefs.activeField, FldGetScrollPosition( tPrefs.activeField ) );
	//	FldRecalculateField( tPrefs.activeField, true );
	// FldDrawField( tPrefs.activeField );

//	tPrefs.wStart = FldGetInsPtPosition( tPrefs.activeField );
//	tPrefs.wEnd   = tPrefs.wStart;
	//	FldSetSelection( tPrefs.activeField, tPrefs.wStart, tPrefs.wEnd );

	//	d1 = FldGetInsPtPosition( tPrefs.activeField );

	FldGetSelection( tPrefs.activeField, &tPrefs.wStart, &tPrefs.wEnd );

	//	d2 = tPrefs.wStart;
	//	d3 = tPrefs.wEnd;

	if( tPrefs.wStart == tPrefs.wEnd ){
		pos = FldGetInsPtPosition( tPrefs.activeField );
		pos = AdjustCursor( tPrefs.activeField, pos );
		FldSetInsPtPosition( tPrefs.activeField, pos );
		tPrefs.wStart = FldGetInsPtPosition( tPrefs.activeField );
		tPrefs.wEnd   = tPrefs.wStart;
	} else {
		pos = AdjustCursor( tPrefs.activeField, tPrefs.wStart );
		if( tPrefs.wStart > pos ){
			pos += 2;
		}
		tPrefs.wStart = AdjustCursor( tPrefs.activeField, tPrefs.wEnd );
		tPrefs.wEnd = pos;
		if( tPrefs.wStart > tPrefs.wEnd ){
			pos = tPrefs.wEnd;
			tPrefs.wEnd = tPrefs.wStart;
			tPrefs.wStart = pos;
		}
		FldSetSelection( tPrefs.activeField, tPrefs.wStart, tPrefs.wEnd );
		if( tPrefs.wStart == tPrefs.wEnd ){
			FldSetInsPtPosition( tPrefs.activeField, tPrefs.wStart );
		}
	}

	tPrefs.thisForm = FrmInitForm( DA_FORM_ID );
	FrmSetActiveForm( tPrefs.thisForm );
	FrmDrawForm( tPrefs.thisForm );

	//	StrIToA( szBuf, d1 );
	//	WinDrawChars( szBuf, StrLen( szBuf ), 65, 2 );

	//	StrIToA( szBuf, d2 );
	//	WinDrawChars( szBuf, StrLen( szBuf ), 92, 2 );

	//	StrIToA( szBuf, d3 );
	//	WinDrawChars( szBuf, StrLen( szBuf ), 124, 2 );

	MainEventLoop( &tPrefs );

	FrmEraseForm( tPrefs.thisForm );
	FrmDeleteForm( tPrefs.thisForm );

	FrmSetActiveForm( tPrefs.activeForm );

	if( tPrefs.wStart == tPrefs.wEnd ){
		FldSetInsPtPosition( tPrefs.activeField, tPrefs.wStart );
	}

	switch( tPrefs.wCommand ){
	case CUT_BUTTON_ID:
		FldCut( tPrefs.activeField );
		break;
	case COPY_BUTTON_ID:
		FldCopy( tPrefs.activeField );
		break;
	case PASTE_BUTTON_ID:
		FldPaste( tPrefs.activeField );
		break;
	}
}

/* event loop */
static void MainEventLoop( t_Prefs* pPrefs )
{
	EventType event;
	Word error;
	Boolean done = false;

	do {
		EvtGetEvent( &event, evtWaitForever );
		if( SysHandleEvent( &event ) == false ){
			if( MenuHandleEvent( NULL, &event, &error ) == false ){
				if( FrmHandleEvent( FrmGetActiveForm(), &event ) == false ){
					done = MainHandleEvent( &event, pPrefs );
				}
			}
		}
	} while( done == false );
}

/* event handlers */
static Boolean MainHandleEvent( EventPtr event, t_Prefs* pPrefs )
{
	Boolean done = false;
	//	Char szBuf[16];
	//	CharPtr ptr;
	//	Word code;

	switch( event->eType ){
	case appStopEvent:
		EvtAddEventToQueue( event );
		done = true;
		break;
	case ctlSelectEvent:
		switch( event->data.ctlSelect.controlID ){
		case CUT_BUTTON_ID:
		case COPY_BUTTON_ID:
		case PASTE_BUTTON_ID:
			pPrefs->wCommand = event->data.ctlSelect.controlID;
			done = true;
			break;
//		case LEFT_BUTTON_ID:
//			SelectionMoveLeft( pPrefs );
			//	StrIToA( szBuf, pPrefs->wStart );
			//	FntSetFont( stdFont );
			//	WinDrawChars( szBuf, StrLen( szBuf ), 45, 2 );
//			break;
//		case RIGHT_BUTTON_ID:
//			SelectionMoveRight( pPrefs );
			//	StrIToA( szBuf, pPrefs->wStart );
			//	FntSetFont( stdFont );
			//	WinDrawChars( szBuf, StrLen( szBuf ), 45, 2 );
//			break;
		case LEFT1_BUTTON_ID:
			SelectionMoveLeft( pPrefs );
			break;
		case RIGHT1_BUTTON_ID:
			SelectionMoveRight( pPrefs );
			break;
		case LEFT2_BUTTON_ID:
			SelectionMoveLeft2( pPrefs );
			break;
		case RIGHT2_BUTTON_ID:
			SelectionMoveRight2( pPrefs );
			break;
		}
		break;
	case penDownEvent:
		if( event->screenY < 0 ){
			done = true;
		}
		break;
	case keyDownEvent:
		switch( event->data.keyDown.chr ){
		/*
			case '_':
				FntSetFont( stdFont );
				StrPrintF( szBuf, "%d ", pPrefs->wStart );
				WinDrawChars( szBuf, StrLen( szBuf ), 65, 2 );
				ptr = FldGetTextPtr( pPrefs->activeField );
				code = *(ptr+pPrefs->wStart);
				code <<= 8;
				code |= (Byte)( *(ptr+pPrefs->wStart+1) );
				StrPrintF( szBuf, "%x ", code );
				WinDrawChars( szBuf, StrLen( szBuf ), 92, 2 );
				break;
		*/
		case pageUpChr:
		case leftArrowChr:
			SelectionMoveLeft2( pPrefs );
			break;
		case pageDownChr:
		case rightArrowChr:
			SelectionMoveRight2( pPrefs );
			break;
		case 'x':
		case 'X':
			pPrefs->wCommand = CUT_BUTTON_ID;
			done = true;
			break;
		case 'c':
		case 'C':
			pPrefs->wCommand = COPY_BUTTON_ID;
			done = true;
			break;
		case 'p':
		case 'P':
		case 'v':
		case 'V':
			pPrefs->wCommand = PASTE_BUTTON_ID;
			done = true;
			break;
		case 'i':
		case 'I':
			//	FrmAlert( DA_HELP_ID );
			FrmHelp( DA_HELP_ID );
			break;
		}
		break;
	default:
		break;
	}

	return done;
}

/* get focus object ptr */
static FieldPtr GetFocusObjectPtr( FormPtr activeForm )
{
	Word focus;
	FormObjectKind objType;

	if( FrmGetActiveFormID() == 0 ){
		return( NULL );			// I Don't know why . but it's necesarry
	}

	if( activeForm == NULL ){
		return( NULL );
	}

	focus = FrmGetFocus( activeForm );
	if( focus == noFocus ){
		return( NULL );
	}

	objType = FrmGetObjectType( activeForm, focus );
	if( objType == frmFieldObj ){
		return( FrmGetObjectPtr( activeForm, focus ));
	} else if( objType == frmTableObj ){
		return( TblGetCurrentField( FrmGetObjectPtr( activeForm, focus )));
	}

	return( NULL );
}

/* */
Word AdjustCursor( FieldPtr field, Word pos )
{
	CharPtr ptr;
	Word length;
	Word count;
	Byte chr1, chr2;

	ptr = FldGetTextPtr( field );
	length = FldGetTextLength( field );

	count = 0;
	while( count < length ){
		chr1 = *( ptr + count );
		if( chr1 == 0 ){
			break;
		}
		chr2 = *( ptr + count + 1 );
		if( IsSJIS1( chr1 ) && IsSJIS2( chr2 )){
			if( ( count + 1 ) >= pos ){
				break;
			}
			count++;
		} else {	// if( IsASCII( chr1 ) || IsCTRL( chr1 ) || IsKANA( chr1 ) )
			if( count >= pos ){
				break;
			}
		}
		count++;
	}

	return( count );
}

/* */
static void SelectionMoveLeft( t_Prefs* pPrefs )
{
//	FrmEraseForm( pPrefs->thisForm );
	FrmSetActiveForm( pPrefs->activeForm );

	if( pPrefs->wStart > 0 ){
		pPrefs->wStart = AdjustCursor( pPrefs->activeField, pPrefs->wStart - 1 );
	}

	FldSetSelection( pPrefs->activeField, pPrefs->wStart, pPrefs->wEnd );
	//	FldDrawField( pPrefs->activeField );

	//	FldSetScrollPosition( pPrefs->activeField, pPrefs->wStart );

	FrmSetActiveForm( pPrefs->thisForm );
	FrmDrawForm( pPrefs->thisForm );
}

/* */
static void SelectionMoveRight( t_Prefs* pPrefs )
{
	CharPtr ptr;
	Byte chr;

//	FrmEraseForm( pPrefs->thisForm );
	FrmSetActiveForm( pPrefs->activeForm );

	ptr = FldGetTextPtr( pPrefs->activeField );
	chr = *( ptr + pPrefs->wStart );
	if( chr != 0 ){
		pPrefs->wStart++;
	//	if( chr == 0x0D || chr == 0x0A ){
	//		//	FldSetScrollPosition( pPrefs->activeField, pPrefs->wStart );
	//			FldScrollField( pPrefs->activeField, 1, down );
	//			FldRecalculateField( pPrefs->activeField, true );
	//	}
		if( IsSJIS1( chr ) ){
			chr = *( ptr + pPrefs->wStart );
			if( IsSJIS2( chr ) ){
				pPrefs->wStart++;
			}
		}
	}

	FldSetSelection( pPrefs->activeField, pPrefs->wStart, pPrefs->wEnd );
	//	FldDrawField( pPrefs->activeField );

	FrmSetActiveForm( pPrefs->thisForm );
	FrmDrawForm( pPrefs->thisForm );
}

/* */
static void SelectionMoveLeft2( t_Prefs* pPrefs )
{
//	FrmEraseForm( pPrefs->thisForm );
	FrmSetActiveForm( pPrefs->activeForm );

	if( pPrefs->wEnd > 0 ){
		pPrefs->wEnd = AdjustCursor( pPrefs->activeField, pPrefs->wEnd - 1 );
	}

	FldSetSelection( pPrefs->activeField, pPrefs->wStart, pPrefs->wEnd );
	//	FldDrawField( pPrefs->activeField );

	//	FldSetScrollPosition( pPrefs->activeField, pPrefs->wStart );

	FrmSetActiveForm( pPrefs->thisForm );
	FrmDrawForm( pPrefs->thisForm );
}

/* */
static void SelectionMoveRight2( t_Prefs* pPrefs )
{
	CharPtr ptr;
	Byte chr;

//	FrmEraseForm( pPrefs->thisForm );
	FrmSetActiveForm( pPrefs->activeForm );

	ptr = FldGetTextPtr( pPrefs->activeField );
	chr = *( ptr + pPrefs->wEnd );
	if( chr != 0 ){
		pPrefs->wEnd++;
	//	if( chr == 0x0D || chr == 0x0A ){
	//		//	FldSetScrollPosition( pPrefs->activeField, pPrefs->wStart );
	//			FldScrollField( pPrefs->activeField, 1, down );
	//			FldRecalculateField( pPrefs->activeField, true );
	//	}
		if( IsSJIS1( chr ) ){
			chr = *( ptr + pPrefs->wEnd );
			if( IsSJIS2( chr ) ){
				pPrefs->wEnd++;
			}
		}
	}

	FldSetSelection( pPrefs->activeField, pPrefs->wStart, pPrefs->wEnd );
	//	FldDrawField( pPrefs->activeField );

	FrmSetActiveForm( pPrefs->thisForm );
	FrmDrawForm( pPrefs->thisForm );
}

/* eof */
