/* daJIS.c */
#include <Pilot.h>
/* #include <System/MemoryMgr.h> */
/* #include "callback.h" */
#include "res.h"

/* define */
#define INTERVAL_TIMER		(30)
#define CREATER_ID			((DWord)'JCda')
#define CREATER_VER			103
#define LOBYTE(w)			((Byte)(w))
#define HIBYTE(w)			((Byte)(((Word)(w) >> 8) & 0xFF))
#define JIS_TOP				0x2121
#define JIS_BOTTOM			0x742F		/* 0x7424 */
#define IsSJIS1(n)			((((n)>0x80 ) && ( (n)<0xa0 )) || (((n)>0xdf) && ((n)<0xeb)) )
#define IsSJIS2(n)			((((n)>0x3f) && ((n)<0x7f)) || (((n)>0x7f) && ((n)<0xfd)) )
#define IsASCII(n)			(((n)>0x1f) && ((n)<0x7f))

/* struct */
typedef struct {
	Word		wBegin;
	Word		wCursor;
	SWord		nCurPx;
	SWord		nCurPy;
	Word		wJisCode;
} t_Prefs;

/* prototype */
void start();
static void MainEventLoop( t_Prefs* pPrefs );
static Boolean MainHandleEvent( EventPtr event, t_Prefs* pPrefs );
static FieldPtr GetFocusObjectPtr( FormPtr activeForm );
//	static void AdjustCursor( FieldPtr activeField );
static VoidPtr GetObjectPtr( Int objectID );
static void DrawButton( Word wButton );
static Word CalcJis( Word wCode, SWord nCount, Boolean fPlus );
static void TapToCursor( t_Prefs* pPrefs, short x, short y );
static void MoveChrJis( t_Prefs* pPrefs, Word wChrCode );
static void ScrollJis( t_Prefs* pPrefs, Boolean fPlus, SWord nValue );
static void DrawJis( t_Prefs* pPrefs );
static void DrawCursor( SWord px, SWord py );
static void MySetStrToField( int theFieldID, char* theDrawStr );
static void DrawState( Word wCursor, Word wBegin );
static void WordToHexString( Word wData, CharPtr ptrBuf );
static unsigned short JisToShiftjis( unsigned short wCode );

/* da main */
void start()
{
	FormPtr form;
	t_Prefs tPrefs;
	Char szBuf[4];
	FormPtr activeForm;
	FieldPtr activeField;

	activeForm = FrmGetActiveForm();
	activeField = GetFocusObjectPtr( activeForm );
	//	AdjustCursor( activeField );
	InsPtEnable( false );

	if( PrefGetAppPreferencesV10( CREATER_ID, CREATER_VER, &tPrefs, sizeof(t_Prefs) ) == false ){
		tPrefs.wBegin  = JIS_TOP;
		tPrefs.wCursor = JIS_TOP;
	}
	tPrefs.nCurPx = -1;
	tPrefs.nCurPy = -1;
	tPrefs.wJisCode = 0;

	form = FrmInitForm( DA_FORM_ID );
	FrmSetActiveForm( form );
	FrmDrawForm( form );

	DrawButton( activeField == NULL ? 0 : 1 );
	DrawJis( &tPrefs );

	MainEventLoop( &tPrefs );

	FrmEraseForm( form );
	FrmDeleteForm( form );

	PrefSetAppPreferencesV10( CREATER_ID, CREATER_VER, &tPrefs, sizeof(t_Prefs) );

	if( tPrefs.wJisCode != 0 ){
		szBuf[0] = HIBYTE(tPrefs.wJisCode);
		szBuf[1] = LOBYTE(tPrefs.wJisCode);
		szBuf[2] = '\0';
		if( activeField == NULL ){
			ClipboardAddItem( clipboardText, (VoidPtr)szBuf, 2 );
		} else {
			InsPtEnable( true );
			FrmSetActiveForm( activeForm );
			FldInsert( activeField, szBuf, 2 );
		}
	}
}

/* event loop */
static void MainEventLoop( t_Prefs* pPrefs )
{
	EventType event;
	Word error;
	Boolean done = false;

	do {
		EvtGetEvent( &event, evtWaitForever );
		if( SysHandleEvent( &event ) == false ){
			if( MenuHandleEvent( NULL, &event, &error ) == false ){
				if( FrmHandleEvent( FrmGetActiveForm(), &event ) == false ){
					done = MainHandleEvent( &event, pPrefs );
				}
			}
		}
	} while( done == false );
}

/* event handlers */
static Boolean MainHandleEvent( EventPtr event, t_Prefs* pPrefs )
{
	Boolean done = false;

	switch( event->eType ){
	case appStopEvent:
		EvtAddEventToQueue( event );
		done = true;
		break;
	case ctlSelectEvent:
		switch( event->data.ctlSelect.controlID ){
		case INSERT_BUTTON_ID:
		case COPY_BUTTON_ID:
			if( pPrefs->wCursor != 0 ){
				pPrefs->wJisCode = JisToShiftjis( pPrefs->wCursor );
			}
			done = true;
			break;
		case LUP_BUTTON_ID:
			ScrollJis( pPrefs, false, 8 );
			break;
		case LDOWN_BUTTON_ID:
			ScrollJis( pPrefs, true, 8 );
			break;
		}
		break;
	/*
	case ctlRepeatEvent:
		switch( event->data.ctlRepeat.controlID ){
		case LUP_BUTTON_ID:
			ScrollJis( pPrefs, false, 8 );
			break;
		case LDOWN_BUTTON_ID:
			ScrollJis( pPrefs, true, 8 );
			break;
	//	case PUP_BUTTON_ID:
	//		ScrollJis( pPrefs, false, 32 );
	//		break;
	//	case PDOWN_BUTTON_ID:
	//		ScrollJis( pPrefs, true, 32 );
	//		break;
		}
		break;
	*/
	case penDownEvent:
		if( event->screenY < 0 ){
			done = true;
		} else {
			TapToCursor( pPrefs, event->screenX, event->screenY );
		}
		break;
	case keyDownEvent:
		switch( event->data.keyDown.chr ){
		case pageUpChr:
			ScrollJis( pPrefs, false, 32 );
			break;
		case pageDownChr:
			ScrollJis( pPrefs, true, 32 );
			break;
		default:
			MoveChrJis( pPrefs, event->data.keyDown.chr );
			break;
		}
		break;
	default:
		break;
	}

	return done;
}

/* get focus object ptr */
static FieldPtr GetFocusObjectPtr( FormPtr activeForm )
{
	Word focus;
	FormObjectKind objType;

	if( FrmGetActiveFormID() == 0 ){
		return( NULL );			// I Don't know why . but it's necesarry
	}

	if( activeForm == NULL ){
		return( NULL );
	}

	focus = FrmGetFocus( activeForm );
	if( focus == noFocus ){
		return( NULL );
	}

	objType = FrmGetObjectType( activeForm, focus );
	if( objType == frmFieldObj ){
		return( FrmGetObjectPtr( activeForm, focus ));
	} else if( objType == frmTableObj ){
		return( TblGetCurrentField( FrmGetObjectPtr( activeForm, focus )));
	}

	return( NULL );
}

/* adjust cursor */
/*
static void AdjustCursor( FieldPtr activeField )
{
	CharPtr ptr;
	Word pos;
	//	Word len;
	Word count;
	Byte chr1, chr2;

	if( activeField == NULL ){
		return;
	}

	if( InsPtEnabled() == false ){
		return;
	}

	ptr = FldGetTextPtr( activeField );
	//	len = FldGetTextLength( activeField );
	pos = FldGetInsPtPosition( activeField );

	count = 0;
	while( true ){
		chr1 = *( ptr + count );
		if( chr1 == 0 ){
			break;
		}
		chr2 = *( ptr + count + 1 );
		if( IsSJIS1( chr1 ) && ( chr2 )){
			if( ( count + 1 ) >= pos ){
				break;
			}
			count++;
		//	} else if( IsASCII( chr1 ) ){
		} else {
			if( count >= pos ){
				break;
			}
		}
		count++;
	}

	if( pos != count ){
		FldSetInsPtPosition( activeField, count );
	}
}
*/

static VoidPtr GetObjectPtr( Int objectID )
{
	FormPtr frm = FrmGetActiveForm();
	return( FrmGetObjectPtr( frm, FrmGetObjectIndex( frm, objectID )));
}

/* draw insert/copy button */
static void DrawButton( Word wButton )
{
	/*
	Char szBuf[8];
	Word x;
	FontID font_temp;

	if( wButton == 0 ){
		StrCopy( szBuf, "Copy" );
		x = 127;
	} else {
		StrCopy( szBuf, "Insert" );
		x = 125;
	}

	font_temp = FntSetFont( stdFont );
	WinDrawChars( szBuf, StrLen( szBuf ), x, 15 );
	FntSetFont( font_temp );
	*/

	ControlPtr cpBtnCopy   = (ControlPtr)GetObjectPtr( COPY_BUTTON_ID );
	ControlPtr cpBtnInsert = (ControlPtr)GetObjectPtr( INSERT_BUTTON_ID );
	if( wButton == 0 ){
		CtlHideControl( cpBtnInsert );
		CtlShowControl( cpBtnCopy );
	} else {
		CtlHideControl( cpBtnCopy );
		CtlShowControl( cpBtnInsert );
	}
}

/* calc jis kanji code */
static Word CalcJis( Word wCode, SWord nCount, Boolean fPlus )
{
	short i;

	for( i = 0; i < nCount; i++ ){
		if( fPlus == true ){
			if( LOBYTE(wCode) == 0x7E ){
				wCode &= 0x7F00;
				wCode |= 0x0021;
				wCode += 0x0100;
			} else {
				wCode++;
			}
		} else {
			if( LOBYTE(wCode) == 0x21 ){
				wCode &= 0x7F00;
				wCode |= 0x007E;
				wCode -= 0x0100;
			} else {
				wCode--;
			}
		}
	}

	return( wCode );
}

/* tap to cursor */
static void TapToCursor( t_Prefs* pPrefs, short x, short y )
{
	DWord dwPos;
	Word wJis;

	if( 2 < x && x < (12*8+2) && 13 < y && y < (12*4+13) ){
		x -= 2;
		x /= 12;
		y -= 13;
		y /= 12;
		pPrefs->wCursor = CalcJis( pPrefs->wBegin, ( x + ( y * 8 )), true );
		DrawCursor( pPrefs->nCurPx, pPrefs->nCurPy );
		pPrefs->nCurPx = x;
		pPrefs->nCurPy = y;
		DrawCursor( pPrefs->nCurPx, pPrefs->nCurPy );
		DrawState( pPrefs->wCursor, pPrefs->wBegin );
	} else if( 100 <= x && x <= 104 && 15 <= y && y <= 60 ){
		dwPos = ( y - 15 ) * 100;
		dwPos /= ( 60 - 15 );
		dwPos *= (( JIS_BOTTOM & 0x7F00 ) - ( JIS_TOP & 0x7F00 ));
		dwPos /= 100;
		dwPos &= 0x7F00;
		dwPos += JIS_TOP;
		wJis = CalcJis( JIS_BOTTOM, (8*4)-1, false );
		if( dwPos >= wJis ){
			pPrefs->wBegin = wJis;
		} else {
			pPrefs->wBegin = dwPos;
		}
		DrawJis( pPrefs );
	}
}

/* move char jis kanji code */
static void MoveChrJis( t_Prefs* pPrefs, Word wChrCode )
{
	Word wMove;

	switch( wChrCode ){
		case ' ':	wMove = 0x2121;		break;
		case 'a':	wMove = 0x3021;		break;
		case 'k':	wMove = 0x323C;		break;
		case 's':	wMove = 0x3A33;		break;
		case 't':	wMove = 0x423E;		break;
		case 'n':	wMove = 0x4660;		break;
		case 'h':	wMove = 0x4743;		break;
		case 'm':	wMove = 0x4B60;		break;
		case 'y':	wMove = 0x4C69;		break;
		case 'r':	wMove = 0x4D65;		break;
		case 'w':	wMove = 0x4F41;		break;
	//	case '3':	wMove = 0x3021;		break;
	//	case '4':	wMove = 0x4021;		break;
	//	case '5':	wMove = 0x5021;		break;
	//	case '6':	wMove = 0x6021;		break;
	//	case '7':	wMove = 0x7021;		break;
		case '$':	wMove = 0x216E;		break;
		case '#':	wMove = 0x225C;		break;
	//	case '0':	wMove = 0x2330;		break;
		case 0xDF:	wMove = 0x2641;		break;		// char code 'beta'
		case '|':	wMove = 0x2821;		break;
	//	case '2':	wMove = 0x5021;		break;
		case '_':	wMove = 0x5021;		break;
		default:	wMove = 0;			break;
	}

	if( wMove != 0 ){
		pPrefs->wBegin = wMove;
	}

	DrawJis( pPrefs );
}

/* scroll jis kanji code */
static void ScrollJis( t_Prefs* pPrefs, Boolean fPlus, SWord nValue )
{
	Word wJis;
	Word wTmp;

	if( fPlus == false ){
		wJis = CalcJis( JIS_TOP, nValue, true );
		if( pPrefs->wBegin < wJis ){
			pPrefs->wBegin = JIS_TOP;
		} else {
			pPrefs->wBegin = CalcJis( pPrefs->wBegin, nValue, false );
		}
	} else {
		wJis = CalcJis( JIS_BOTTOM, (8*4)-1, false );
		wTmp = CalcJis( pPrefs->wBegin, nValue, true );
		if( wTmp >= wJis ){
			pPrefs->wBegin = wJis;
		} else {
			pPrefs->wBegin = wTmp;
		}
	}

	DrawJis( pPrefs );
}

/* draw jis kanji code */
static void DrawJis( t_Prefs* pPrefs )
{
	short i, j;
	Char szBuf[16];
	RectangleType rect;
	Word wCode;
	Word wSjis;
	FontID font_temp;

	DrawCursor( pPrefs->nCurPx, pPrefs->nCurPy );
	pPrefs->nCurPx = -1;
	pPrefs->nCurPy = -1;

	wCode = pPrefs->wBegin;

	DrawState( pPrefs->wCursor, pPrefs->wBegin );

	font_temp = FntSetFont( stdFont );

	for( j = 0; j < 4; j++ ){
		for( i = 0; i < 8; i++ ){
			wSjis = JisToShiftjis( wCode );
			szBuf[0] = HIBYTE(wSjis);
			szBuf[1] = LOBYTE(wSjis);
			szBuf[2] = 0;
			rect.topLeft.x = ( i * 12 ) +  2 + 1;
			rect.topLeft.y = ( j * 12 ) + 13 + 1;
			WinDrawChars( szBuf, 2, rect.topLeft.x, rect.topLeft.y );
			if( pPrefs->wCursor == wCode ){
				pPrefs->nCurPx = i;
				pPrefs->nCurPy = j;
				DrawCursor( i, j );
			}
			if( LOBYTE(wCode) == 0x7E ){
				wCode &= 0x7F00;
				wCode |= 0x0021;
				wCode += 0x0100;
			} else {
				wCode++;
			}
		}
	}

	FntSetFont( font_temp );
}

/* draw cursor */
static void DrawCursor( SWord px, SWord py )
{
	RectangleType rect;

	if( px < 0 || py < 0 ){
		return;
	}

	rect.topLeft.x = ( px * 12 ) + 2;
	rect.topLeft.y = ( py * 12 ) + 13 + 1;
	rect.extent.x  = 10;
	rect.extent.y  = 10;

	WinInvertRectangle( &rect, 0 );
}

//
static void MySetStrToField( int theFieldID, char* theDrawStr )
{
	Handle   myTextH;
	CharPtr  myTextP;
	FieldPtr myFldPtr;

	ULong myStrSize = StrLen( theDrawStr ) + 1;
	myTextH = (Handle)MemHandleNew( (ULong)myStrSize );
	if( myTextH ){
		myTextP = (CharPtr)MemHandleLock( (VoidHand)myTextH );
		MemMove( myTextP, theDrawStr, myStrSize );
		myFldPtr = (FieldPtr)GetObjectPtr( theFieldID );
		FldFreeMemory( myFldPtr );
		FldSetTextHandle( myFldPtr, myTextH );
		FldEraseField( myFldPtr );
		FldDrawField( myFldPtr );
		MemHandleUnlock( (VoidHand)myTextH );
	}
}

/* darw state */
static void DrawState( Word wCursor, Word wBegin )
{
	Char szBuf[16];
	RectangleType rect;
	DWord dwPos;
	CustomPatternType cpt;
	FontID font_temp;

	font_temp = FntSetFont( boldFont );

	if( wCursor != 0 ){
		//	StrPrintF( szBuf, "$%x ", wCursor );
		WordToHexString( wCursor, szBuf );
		// WinDrawChars( szBuf, StrLen(szBuf), 122, 30 );	// upper
		// WinDrawChars( szBuf, StrLen(szBuf), 122, 32 );		// lower
		MySetStrToField( CODE_FILED_ID, szBuf );
			FntSetFont( largeFont );
			szBuf[0] = HIBYTE( JisToShiftjis( wCursor ) );
			szBuf[1] = LOBYTE( JisToShiftjis( wCursor ) );
			szBuf[2] = 0;
			// WinDrawChars( szBuf, 2, 130, 44 );		// lower
				// WinDrawChars( szBuf, 2, 120, 15 );			// upper
			MySetStrToField( SAMPLE_FILED_ID, szBuf );
			//
			/*
			rect.topLeft.x = 120;
			rect.topLeft.y = 13;
			rect.extent.x  = 14;
			rect.extent.y  = 14;
			WinDrawGrayRectangleFrame( rectangleFrame, &rect );
			*/
	}

	FntSetFont( boldFont );

	cpt[0] = 0x55AA;
	cpt[1] = 0x55AA;
	cpt[2] = 0x55AA;
	cpt[3] = 0x55AA;
	WinSetPattern( cpt );

	rect.topLeft.x = 100;
	rect.topLeft.y = 14;
	rect.extent.x  = 3;
	rect.extent.y  = (12*4)-2;

	WinFillRectangle( &rect, 0 );

	dwPos = ( wBegin & 0x7F00 ) - ( JIS_TOP & 0x7F00 );
	dwPos *= ((12*4)-4);
	dwPos /= (( JIS_BOTTOM & 0x7F00 ) - ( JIS_TOP & 0x7F00 ));

	rect.topLeft.y += dwPos;
	rect.extent.x = 3;
	rect.extent.y = 3;
	WinDrawRectangle( &rect, 0 );

	FntSetFont( font_temp );
}

/* word to hex string */
static void WordToHexString( Word wData, CharPtr ptrBuf )
{
	Int i, j;
	Word w;

	*ptrBuf = '$';
	ptrBuf++;

	j = 12;
	for( i = 0; i < 4; i++ ){
		w = wData >> j;
		w &= 0x000F;
		if( w < 10 ){
			*ptrBuf = '0' + (Byte)w;
		} else {
			*ptrBuf = 'A' + (Byte)w - 10;
		}
		j -= 4;
		ptrBuf++;
	}

	*ptrBuf = ' ';
	ptrBuf++;

	*ptrBuf = ' ';
	ptrBuf++;

	*ptrBuf = '\0';
}

/* JIS CODE to SHIFT-JIS CODE */
static unsigned short JisToShiftjis( unsigned short wCode )
{
	unsigned char bHi = ( wCode >> 8 ) & 0x00FF;
	unsigned char bLo =   wCode        & 0x00FF;

	if( bHi & 1 ){
		bLo += 0x1F;
		if( bLo >= 0x7F ){
			bLo++;
		}
	} else {
		bLo += 0x7E;
	}

	bHi = ( bHi - 0x20 - 1 ) / 2 + 0x81;
	if( bHi >= 0xA0 ){
		bHi += 0x40;
	}

	return( bHi * 256 + bLo );
}

/* eof */
