﻿/* ************************************************************************** */
/* 美佳の英文タイプトレーナー テキスト練習編  C++ 版 ソースコード             */
/*                                           Ver2.02.01   2025/12/26          */
/*                                           Copy right 今村二朗              */
/*                                                                            */
/* このソースコードは 改変、転載、他ソフトの使用など自由にお使いください      */
/*                                                                            */
/* 注意事項                                                                   */
/*                                                                            */
/* グラフィック表示は640x400ドットの仮想画面に行い実座標に変換して表示してい  */
/* ます。                                                                     */
/*                                                                            */
/* C++では横軸がX座標、縦軸がY座標ですがこのソースコードでは横軸がY座標       */
/* 縦軸がX座標です。                                                          */
/*                                                                            */
/* ************************************************************************** */
// MIKATEXT.cpp : アプリケーションのエントリ ポイントを定義します。
//

#include "framework.h"
#include <string>
#include <time.h>
using namespace std;
#include "MIKATEXT.h"

#define MAX_LOADSTRING 100
#define MIKA_MAX_TEXT_LENGTH 3000 /* 練習テキスト最大行数 */
// グローバル変数:
HINSTANCE hInst;                                // 現在のインターフェイス
WCHAR szTitle[MAX_LOADSTRING];                  // タイトル バーのテキスト
WCHAR szWindowClass[MAX_LOADSTRING];            // メイン ウィンドウ クラス名
	string	MIKA_t_name[]={ /*練習テキストファイル名*/
		"MIKA001.MIT",
		"MIKA002.MIT",
		"MIKA003.MIT",
		"MIKA004.MIT",
		"MIKA005.MIT",
		"MIKA006.MIT"
	};
	string	MIKA_t_seiseki_name[]={ /*成績ファイル書き込み用 練習テキストフファイル名 */
		"mika001.mit",
		"mika002.mit",
		"mika003.mit",
		"mika004.mit",
		"mika005.mit",
		"mika006.mit"
	};
	string	MIKA_c_line[MIKA_MAX_TEXT_LENGTH]; /*練習テキスト読み込みエリア */
	int		MIKA_text_flag=1; /* 美佳のタイプトレーナー テキスト練習編フラグ */
	int		MIKA_max_c_line; /* 練習テキスト 行数 */
	int 	MIKA_start_text_line=86; /* 練習テキスト表示 開始 x 座標 */
	int		MIKA_double_text_hight=40; /* 練習テキスト表示の 行間隔 x座標 */
	int		MIKA_rensyu_text_hight=18; /* 文字入力エリアの行間隔 x座標 */
	int		MIKA_max_text_line=8; /* 練習テキスト表示 最大行数 */
	int		MIKA_kugiri_text_line=83; /* 練習テキストと練習記録表示の区切線の x座標 */
	int		MIKA_current_point_x=1; /* 練習テキストの入力行の位置*/
	int		MIKA_scroll_point=1; /* 画面スクロール表示の開始行位置 */
	int		MIKA_text_point_x=0; /* 文字入力カーソル縦行位置*/
	int		MIKA_text_point_y=0; /* 文字入力カーソル横文字位置 */
	int		MIKA_err_count=0; /* エラー文字表示文字数 */
	long	MIKA_text_time_interval=1000; /* 入力速度表示用のタイマーのミリ秒間隔 */
	wchar_t 	MIKA_err_c_table[256]; /* エラー文字保存エリア */ 
	int		MIKA_disp_cursor_flag=1; /* カーソル表示フラグ */
char MIKA_file_name_seiseki[] = "mikatext.sei"; /* 成績ファイル名 読み込み用 */
char MIKA_file_name_seiseki2[] = "mikatext.sei"; /* 成績ファイル名 書き込み用 */
char MIKA_file_name_kiroku[] = "mikatext.log"; /* 練習時間記録ファイル名 追記用 */
char MIKA_file_name_hayasa[] = "mikatext.spd"; /* 最高速度記録ファイル名 追記用 */
int MIKA_file_error_hayasa = 0; /* 最高速度記録ファイル書き込みエラー =0 正常 =1 異常 */
int MIKA_file_error_kiroku = 0; /* 練習時間記録ファイル書き込みエラー =0 正常 =1 異常 */
int MIKA_file_error_seiseki = 0; /* 成績ファイル書き込みエラー =0 正常 =1 異常 */
char MIKA_s_date[9]; /* 練習開始日付 プログラム起動時に取得 練習時間記録ファイルに書き込み時使用 */
char MIKA_s_time[9]; /* 練習開始時刻 プログラム起動時に取得 練習時間記録ファイルに書き込み時使用 */
char MIKA_type_date[9]; /* 最高速度達成日付  */
char MIKA_type_time[9]; /* 最高速度達成時刻  */
time_t	MIKA_st_t = 0; /*  練習時間記録ファイル用練習開始時間秒 */
time_t	MIKA_lt_t = 0; /*  練習時間記録ファイル用練習終了時間秒 */
time_t 	MIKA_rt_t = 0; /* 成績記録ファイル用合計練習時間  秒 */
string	MIKA_t_date[]= /* 最高速度達成日付 */
	{
		"        ",
		"        ",
		"        ",
		"        ",
		"        ",
		"        "
	};
	double	MIKA_t_speed[]= /* 最高速度記録 文字数／秒 */
	{
		0.0,0.0,0.0,0.0,0.0,0.0
	};
	double	MIKA_tw_speed[]= /* 最高速度記録 ワード／秒 */
	{
		0.0,0.0,0.0,0.0,0.0,0.0
	};
	long	MIKA_t_time[]= /* 累積練習時間 秒 */
	{
		0,0,0,0,0,0
	};
	long	MIKA_t_kaisu[]= /* 練習回数 */
	{
		0,0,0,0,0,0
	};
	long	MIKA_t_mojisu[]= /* 練習テキスト 文字数 */
	{
		0,0,0,0,0,0
	};

long* MIKA_p_count = NULL; /* 練習回数配列 アドレス */
string MIKA_type_kind_mes; /* 練習項目名 */
double* MIKA_type_speed_record = NULL; /* 最高速度記録配列アドレス */
double* MIKA_type_word_speed_record=NULL; /* 最高速度記録 ワード／分 配列アドレス */
string* MIKA_type_date_record = NULL; /* 最高速度達成日配列アドレス */
long* MIKA_type_time_record = NULL; /* 累積練習時間配列 アドレス */
string	MIKA_menu_kind_mes; /* 最高速度記録ファイル書き込み用メッセージ */
clock_t MIKA_type_start_time = 0; /* 練習開始時間 ミリ秒 */
clock_t MIKA_type_end_time = 0; /* 練習終了時間 ミリ秒 */
double MIKA_type_speed_time = 0.0; /* 前回 練習経過時間 秒 */
double MIKA_ttype_speed_time=0.0; /* 今回 練習経過時間 秒 */
double MIKA_type_speed=0.0; /* 練習テキストの入力速度  文字数／分 */
double MIKA_type_word_speed=0.0; /* 練習テキストの入力速度 最高速度記録 ワード／分 */
int MIKA_utikiri_flag=0; /* 練習テキスト打ち切りフラグ =1 全練習テキスト打ち切りによる終了 =0 入力練習中 */
int MIKA_utikiri_flag2=0; /*  前回速度表示時の打ち切りフラグの値 */
int MIKA_type_syuryou_flag = 0; /* 練習終了時の記録更新フラグ =0 更新せず =1 前回の入力速度が0.0の時の記録更新 =2 前回の記録が0.0より大きい時の記録更新 */
wchar_t MIKA_key_char = 0; /* 練習文字 */
int	MIKA_type_count = 0; /* 入力文字数カウンター */
int	MIKA_type_err_count = 0; /* エラー入力文字数カウンター */
int MIKA_time_start_flag=0; /* 時間計測開始フラグ =0 開始前 =1 測定中 */
int MIKA_max_x_flag = 0;/* 画面表示 縦行数モード =0 25行 =1 20行 */
int MIKA_max_y_flag = 0;/* 画面表示 横文半角カラム数モード =0 80カラム =1 64カラム */
int MIKA_width_x = 16; /* 全角文字 半角文字 縦方向ドット数 */
int MIKA_width_y = 8; /* 半角文字 横方向ドット数 */
int MIKA_practice_end_flag = 0; /* 練習実行中フラグ =0 練習中 =1 終了中 ESCによる終了も含む */
int MIKA_type_end_flag = 0; /* 練習終了フラグ =0 ESCによる終了 =1 60文字入力による終了 */
string	MIKA_mes0 = "●●  美佳の英文タイプトレーナ テキスト練習編  ●●";
string	MIKA_mest2="練習テキスト                    文字数   最高速度    達成日    累積練習時間 回数";
string	MIKA_mest3="                                       字(ワード)/分";
string	MIKA_mesta = "●● 美佳タイプ テキスト練習編 %s ●●";
string 	MIKA_mesi1 = "もう一度練習するときはリターンキーまたは、Enterキーを押してください";
string	MIKA_mesi2 = "メニューに戻るときはESCキーを押してください";
string	MIKA_mesi3 = "おめでとう、記録を更新しました";
string	MIKA_return_mes = "ESCキーを押すとメニューに戻ります";
string  MIKA_menu_mes_s[] = { /* 初期メニュー メニュー項目 */
		"練習テキスト１",
		"練習テキスト２",
		"練習テキスト３",
		"練習テキスト４",
		"練習テキスト５",
		"練習テキスト６",
		"成績",
		"終了",
};
string MIKA_ti_text[]={ /* 練習テキスト表題 格納エリア */
		"テキスト１",
		"テキスト２",
		"テキスト３",
		"テキスト４",
		"テキスト５",
		"テキスト６",
	};
int MIKA_menu_cord_s[8][2] = { /* 初期 メニュー項目表示位置 x座標 y座標 */
		{3*16,16*8},
		{5*16,16*8},
		{7*16,16*8},
		{9*16,16*8},
		{11*16,16*8},
		{13*16,16*8},
		{15*16,16*8},
		{17*16,16*8},
};
int MIKA_menu_s_sel_flag[] = { /* 初期メニュー メニュー項目選択フラグ */
    0,0,0,0,0,0,0,0 };
int MIKA_menu_s_function[] = { /* 初期メニュー 機能番号 */
    1101,1102,1103,1104,1105,1106,19,9999,0};
	int MIKA_exec_func_no = 0; /* メニューの機能番号 */
	int MIKA_type_kind_no = 0; /* 練習項目番号 */
	int* MIKA_menu_function_table; /* メニューの機能番号テーブルアドレス */
	int* MIKA_sel_flag; /* 前回選択メニュー項目選択フラグアドレス */
	RECT	MIKA_win_size; /* ウィンドーサイズ */
// このコード モジュールに含まれる関数の宣言を転送します:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);
int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: ここにコードを挿入してください。
 	procinit(); /* 練習成績ファイル読み込み 練習開始日時取得 乱数初期化 */
    // グローバル文字列を初期化する
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_MIKATEXT, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // アプリケーション初期化の実行:
    if (!InitInstance (hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_MIKATEXT));

    MSG msg;

    // メイン メッセージ ループ:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    return (int) msg.wParam;
}



//
//  関数: MyRegisterClass()
//
//  目的: ウィンドウ クラスを登録します。
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style          = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = WndProc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = 0;
    wcex.hInstance      = hInstance;
    wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MIKATEXT));
    wcex.hCursor        = LoadCursor(nullptr, IDC_ARROW);
    wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName   = MAKEINTRESOURCEW(IDC_MIKATEXT);
    wcex.lpszClassName  = szWindowClass;
    wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   関数: InitInstance(HINSTANCE, int)
//
//   目的: インスタンス ハンドルを保存して、メイン ウィンドウを作成します
//
//   コメント:
//
//        この関数で、グローバル変数でインスタンス ハンドルを保存し、
//        メイン プログラム ウィンドウを作成および表示します。
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // グローバル変数にインスタンス ハンドルを格納する

   HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

   if (!hWnd)
   {
      return FALSE;
   }
   SetMenu(hWnd, NULL); /* メニューバー非表示 */
	SetWindowText(hWnd,L"美佳TEXT"); /* タイトル設定 */
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  関数: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  目的: メイン ウィンドウのメッセージを処理します。
//
//  WM_COMMAND  - アプリケーション メニューの処理
//  WM_PAINT    - メイン ウィンドウを描画する
//  WM_DESTROY  - 中止メッセージを表示して戻る
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HDC hdc = BeginPaint(hWnd, &ps);
           // TODO: HDC を使用する描画コードをここに追加してください...
 			GetClientRect(hWnd,&MIKA_win_size);
            dispmen(hdc); /* メニュー及び練習画面表示 */
            EndPaint(hWnd, &ps);
         }
        break;
    case WM_CHAR:
      {
		wchar_t keyChar;
        HDC hdc = GetDC(hWnd);
        // TODO: HDC を使用する描画コードをここに追加してください...
	 	keyChar=(wchar_t) wParam;    
        exec_func(hWnd,hdc,keyChar); /* 入力文字に対応した処理を実行 */
        ReleaseDC(hWnd, hdc);
       }
        break;
	case WM_TIMER:
	{
            int wmId = LOWORD(wParam);
			switch (wmId)
			{
			case MIKA_Procttimer_ID:
			{
				if (MIKA_practice_end_flag == 0) /* 練習実行中の場合 */
				{
					HDC g = GetDC(hWnd);
					MIKA_type_end_time=getmillisecond(); /* 現在時刻をミリ秒で取得 */
					MIKA_ttype_speed_time=(MIKA_type_end_time-MIKA_type_start_time)/1000.0; /* 経過秒を実数で計算 */
					if(MIKA_type_speed_time!=MIKA_ttype_speed_time)
					{
						procdispspeed3(g); /* 英文テキスト練習の入力速度を表示 */
					}
					ReleaseDC(hWnd, g);
				}
				break;
			}
			}
			break;
	}
    case WM_DESTROY:
	{
		savekiroku(); /* 練習記録(累積練習時間 最高入力速度 達成日)を保存する */
		procexit(); /* 成績ファイル 練習時間記録ファイル書き込み */
    	PostQuitMessage(0);
        break;
    }
	default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}
int inttablelength(int table[]) /* 0で終わる整数テーブルの長さを求める */
{
	int i;
	for (i = 0;i < 10000;i++)
	{
		if (table[i]==0) /* 値が 0 の場合は終了 */
		{
			return(i);
		}
	}
	return(0);
}
void convdate(char r_date[],char rr_date[]) /* 日付の表示順を mm/dd/yy から yy/mm/dd に変換 */
{
	r_date[0]=rr_date[6]; /* 年の一文字目 */
	r_date[1]=rr_date[7]; /* 年の二文字目 */
	r_date[2]='/'; /* 区切りマーク */
	r_date[3]=rr_date[0]; /* 月の一文字目 */
	r_date[4]=rr_date[1]; /* 月の二文字目 */
	r_date[5]='/'; /* 区切りマーク */
	r_date[6]=rr_date[3]; /* 日の一文字目 */
	r_date[7]=rr_date[4]; /* 日の二文字目 */
	r_date[8]=0; /* 文字列の終わり */
}
    void read_file_title() /* 練習テキストファイル 表題読み込み */
	{
		int i=0;
		char a[80];
		for(i=0;i<6;i++)
		{
			readtextfiles(MIKA_t_name[i],MIKA_ti_text,i,1); /* 各練習テキストの最初の一行を読み込み */
		}
		for(i=0;i<6;i++)
		{
			snprintf(a,80,"%s  %s",MIKA_menu_mes_s[i].c_str(),MIKA_ti_text[i].c_str()); /* 練習テキストファイルの表題をメニュー表示項目に追加 */
			MIKA_menu_mes_s[i]=a;
		}
	}
int rseiseki(FILE *fp) /* 練習成績ファイル読み込み =0 正常終了 =1 読み込みエラー */
{
	int	i,ttime[3],ret;
	char format1[]="%*s %5d%*1c%*c%*c%*c%2d%*c%*c%2d%*c%*c\n"; /* 累積練習時間読み込みフォーマット */
	char format2[]="%*s %8ld%7lf%*c%5lf%*c%*c%8c"; /* 文字数 最高速度 達成日読み込みフォーマット */
	char format3[]="%4d%*1c%*c%*c%*c%2d%*c%*c%2d%*c%*c"; /* 累積練習時間読み込みフォーマット */
	char format4[]="%4ld\n"; /* 練習回数読み込みフォーマット */
	ret=fscanf_s(fp,format1,&ttime[0],&ttime[1],&ttime[2]); /* 総合の累積練習時間読み込み */
	if(ret==EOF) return(1);
	MIKA_rt_t=ttconv(ttime); /* 累積練習時間を文字列から長精度整数に変換 */
	for(i=0;i<6;i++) /* 英文テキスト練習 成績読み込み */
	{
		ret=fscanf_s(fp,format2,&MIKA_t_mojisu[i],&MIKA_t_speed[i],&MIKA_tw_speed[i], &MIKA_t_date[i][0], 8); /* 文字数 最高速度 達成日読み込み */
		if(ret==EOF) return(1);
		ret=fscanf_s(fp,format3,&ttime[0],&ttime[1],&ttime[2]);	/* 累積練習時間読み込み */		
		if(ret==EOF) return(1);
		MIKA_t_time[i]=ttconv(ttime);  /* 累積練習時間を文字列から長精度整数に変換 */
		ret=fscanf_s(fp,format4,&MIKA_t_kaisu[i]);	/* 練習回数読み込み */		
		if(ret==EOF) return(1);
	}
	return(0);
}
void	procinit(void) /* 練習成績ファイル読み込み 練習日時取得 */
{
	int err;
	FILE *fp;
    read_file_title(); /* 練習テキストファイル 表題読み込み */
	err=fopen_s(&fp,MIKA_file_name_seiseki,"rt"); /* 練習成績ファイルを読み込み専用のテキストファイルでオープン */
   	if(err==0) /* 正常にオープンできた場合は成績ファイルを読み込み */
	{
		rseiseki(fp); /* 練習成績ファイル読み込み */
		fclose(fp); /* 練習成績ファイルクローズ */
	}
	_strdate_s(MIKA_s_date,9); /* 練習開始日付取得 */
	_strtime_s(MIKA_s_time,9); /* 練習開始時刻取得 */
	time(&MIKA_st_t); /* 現在時刻を秒で取得 */
}
	string tconv(long time) /* 練習時間秒を文字列に変換 */
	{
		string a;
		a=t0conv(time,0); /* 練習時間秒を "%5d時間%2d分%2d秒"のフォーマットで文字列に変換 */
		return a;
	}
	string t0conv(long time,int flag) /* 練習時間秒をフォーマットを指定して文字列に変換 */
	{
		char a[18];
		long t1,t2,t3;
		t3=time%60; /* 秒を計算 */
		time=time/60;
		t2=time%60; /* 分を計算 */
		t1=time/60; /* 時間を計算 */
		if(flag==0)	snprintf(a,18,"%5d時間%2d分%2d秒",t1,t2,t3); /* 時分秒を文字列に変換 */
		else if(flag==1) snprintf(a,18,"%3d時間%2d分%2d秒",t1,t2,t3);
		else  snprintf(a,18,"%4d時間%2d分%2d秒",t1,t2,t3);
		return a;
	}
long	ttconv	(int ttime[3]) /* 時分秒の配列を秒に変換 */
{
	long	time;
	time=ttime[0]; /* 時間 を取り出し */
	time=time*60; /* 時間を分に変換 */
	time=time+ttime[1]; /* 分を取り出して 時間に加算 */
	time=time*60; /* 分を秒に変換 */
	time=time+ttime[2]; /* 秒を取り出して分に加算 */
	return(time);
}
int charlength(wchar_t a) /* 文字が半角文字か全角文字かの判定を行う リターン値 半角=1 全角 =2 */
	{
		int i;
//		System.out.printf("a=%1c code=%d\n",a,(int)a);
		if(a<255) i=1; /* 半角英数の場合 */
		else if(0xff61<=a&&a<=0xff9f) i=1; /* 半角カナ文字の場合 */
		else i=2; /* 半角英数 半角カナ文字以外の場合 */
		return i;
	}
void cslclr(HDC g) /* 画面クリア */
{
        HBRUSH brush1;
        brush1 = CreateSolidBrush(MIKA_bk_color); /* 背景色でソリッドブラシを生成 */
        FillRect(g, &MIKA_win_size, brush1); /* ウィンドーを背景色で塗りつぶし */
		DeleteObject(brush1); /* ブラシを破棄 */
}
void cslcolor(HDC g, COLORREF color) /* 表示色を設定 */
{
    SetTextColor(g,color);
}
void cslbkcolor(HDC g, COLORREF color) /* 背景表示色を設定 */
{
    SetBkColor(g,color);
}
void cslputscale(HDC g, int x, int y, string mes, double scale) /* string文字列をワイド文字列に変換して指定倍率で仮想座標で表示 */
{
    int mes_length;
    wchar_t mes0[256];
    mes_length = MultiByteToWideChar(CP_ACP, 0, mes.c_str(), -1, (wchar_t*)NULL, 0); /* 変換後のワイド文字列の長さを求める */
    if (mes_length <= 1 || mes_length > 256) return; /*長さが１以下か256以上の時は表示せずにリターン */
    MultiByteToWideChar(CP_ACP, 0, mes.c_str(), -1, mes0, mes_length); /* 文字コードをシフトJISからUTF16に変換する */
    cslputwscale(g, x, y, mes0, scale); /* ワイド文字列を表示 */
}
void cslputzscale(HDC g,int x1,int y1,wchar_t a,double scale) /* 半角英数を全角文字に変換して指定の倍率で表示 */
	{
		wchar_t aa,bb[2];
		if('0'<=a&&a<='9') { /* 数字を半角から全角に変換 */
			aa=(wchar_t)(a-'0'+L'０');
		}
		else if('A'<=a&&a<='Z')
		{ /* 英大文字を半角から全角に変換 */
			aa=(wchar_t)(a-'A'+L'Ａ');
		}
		else if('a'<=a&&a<='z') { /* 英小文字を半角から全角に変換 */
			aa=(wchar_t)(a-'a'+L'ａ');
		}
		else if(a==',') /* カンマを半角から全角に変換 */
		{
			aa=L'，';
		}
		else if(a=='.') /* ピリオドを半角から全角に変換 */
		{
			aa=L'．';
		}
		else if(a==' ') /* スペースを半角から全角に変換 */
		{
			aa=L'　';
		}
		else if(a==';') /* セミコロンを半角から全角に変換 */
		{
			aa=L'；';
		}
		else {
			aa=a;
		}
		bb[0]=aa;
		bb[1]=0;
		cslputwscale(g,x1,y1,bb,scale); /* ワイド文字列を指定で倍率で仮想座標で表示 */
	}
void cslput(HDC g, int x, int y, string mes) /* ストリング文字列を仮想座標で表示 */
{
    cslputscale(g, x, y, mes, 1.0); /* ストリング文字列を等倍の倍率で仮想座標で表示 */
}
void cslputw(HDC g, int x ,int y, wchar_t nChar) /* ワイド文字を一文字仮想座標で表示 */
{
    wchar_t mes[2];
	mes[0]=nChar; /* ワイド文字一文字をワイド文字列に変換 */
	mes[1]=0;
	cslputwscale(g, x, y, mes, 1.0); /* ワイド文字列を等倍の倍率で仮想座標で表示 */
}
void cslputwscale(HDC g, int x, int y, wchar_t mes[], double scale)/* 仮想座標から実座標に変換してワイド文字列を指定の倍率で表示 */
{
    int i, ii;
	wchar_t	c;
    wchar_t b[2];
    int	font_size, font_width, font_height;
    int xx, yy;
    HFONT oldfont; /* 旧フォント */
    HFONT font; /* 新フォント */
    font_size = cslfontsize(scale); /* 文字フォントサイズ取得 */
	font_height=cslfonthight(1.0); /* 文字表示エリア幅取得 */
	font_width=cslfontwidth(1.0); /* 文字表示エリア高さ取得 */
    font=CreateFont(font_size,0,0,0,FW_DONTCARE,FALSE,FALSE,FALSE,SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,
        CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,DEFAULT_PITCH,_T("ＭＳ ゴシック")); /* フォント生成 */
    oldfont=(HFONT)SelectObject(g, font);	/* フォントを設定 */
	ii = 0;
    xx = xcord(x); /* 表示位置x座標を仮想座標から実座標に変換 */
    for (i = 0;i < 256;i++)
    {
        c = mes[i]; /* ワイド文字のi番目の文字を取り出し */
		if(c==0) break;
        b[0] = c;
        b[1] = 0;
        yy = ycord(y + ii * 8); /* 表示位置 y座標を仮想座標から実座標に変換 */
        TextOut(g, yy+ (font_width - font_size)/2,xx+ (font_height - font_size)/2, b, 1); /* 表示位置の中央に文字を表示 */
		ii=ii+charlength(c); /* 表示文字位置更新 半角文字は y座標を 1 加算 全角文字は 2加算 */
	}
    SelectObject(g,oldfont); /* フォントを元に戻す */
    DeleteObject(font); /* フォントを削除 */
}
	void cslputu(HDC g,int x,int y,string mes,int yy,COLORREF color1) /* 文字列の下に下線を表示 */
// x 文字列表示左上仮想x座標
// y 文字列表示左上仮想y座標 
// mes アンダーラインを引く文字列
// yy 文字列下端から下線までのドット数間隔の補正値
// color1 表示色 
	{
		int char_length;
		int x1,x2,xx,y1,y2;
		int font_size;
		int font_hight;
		HPEN oldpen; /* 旧ペン */
		HPEN pen1; /* 新ペン */
		char_length=(int)mes.length(); /* string 文字列長を取得 */
		font_size=cslfontsize(1.0); /* 等倍のフォントサイズ取得 */
		font_hight=cslfonthight(1.0); /* 表示エリア高さを取得 */
		x1=xcord(x+MIKA_width_x)+yy+(font_size-font_hight)/2+2; /* アンダーラインのx座標設定 */
		x2=xcord(1)-xcord(0); /* アンダーラインの太さを設定 */
		y1=ycord(y); /* アンダーラインの開始y座標設定 */
		y2=ycord(y+char_length*8); /* アンダーラインの終了y座標設定 */
		pen1=CreatePen(PS_SOLID,1,color1); /* 指定色でソリッドペン生成 */
        oldpen=(HPEN)SelectObject(g,pen1); /* ペンを設定 */
		for(xx=x1;xx<=x1+x2;xx++) /* 指定の太さのアンダーラインを描画 */
		{
//			g.drawLine(y1,xx,y2,xx); /* 直線描画 */
			MoveToEx(g,y1,xx,NULL); /* ペンの位置を移動 */
			LineTo(g,y2,xx); /* 直線描画 */
		}
		SelectObject(g,oldpen); /* ペンを元に戻す */
		DeleteObject(pen1); /* ペンを削除 */
	}
void cslmencenter(HDC g, int x, string mes) /* 中央にメッセージ文字列を表示 */
// x 文字列表示仮想座標
{
    int y;
    int k;
    int kk;
    if (MIKA_max_y_flag == 0) kk = 80; /* 横幅半角80文字モード */
    else kk = 64; /* 横幅半角64文字モード */
    k =(int)mes.length(); /* 文字列長取得  半角文字は長さ=1 全角文字は長さ=2で計算*/
    //		System.out.printf("mes=%s lentgh=%s",mes,k);
    y = ((kk - k) * MIKA_width_y) / 2; /* 表示開始位置計算 */
    cslput(g, x, y, mes); /* 文字列表示 */
}
void cslrectt (HDC g,int x1,int y1,int x2,int y2,COLORREF color) /* 四角を表示 */
	{
		cslrecttt(g,x1,y1,x2,y2,color,0); /* 境界なしで四角を表示 */
	}
void cslrecttt (HDC g,int x1,int y1,int x2,int y2,COLORREF color,int b) /* 四角の内側を境界幅bで塗りつぶす */
	{
		int	xx1,xx2,yy1,yy2;
		int bx,by,bb;
        HBRUSH brush1;
        RECT rect1;
        if (b != 0) /* 境界幅が0で無い場合 */
		{
			bx=xcord(b)-xcord(0); /* 縦方向の境界幅を仮想座標から実座標に変換 */
			by=ycord(b)-ycord(0); /* 横方向の境界幅を仮想座標から実座標に変換 */
			bb=min(bx,by); /* 縦方向の境界幅と横方向の境界幅の小さい方の値を設定 */
			if(bb<=0) bb=1; /* 境界幅がゼロ以下の場合は境界幅を一に設定 */
		}
		else bb=0;
		xx1=xcord(x1)+bb;	/* 左上 x 座標を 仮想座標から実座標に変換 */ 
		xx2=xcord(x2)-bb;	/* 右下 x 座標を 仮想座標から実座標に変換 */
		yy1=ycord(y1)+bb;	/* 左上 y 座標を 仮想座標から実座標に変換 */
		yy2=ycord(y2)-bb;	 /* 右下 y 座標を 仮想座標から実座標に変換 */
		cslcolor(g,color);  /* 表示色を設定 */
		if(xx1<=xx2&&yy1<=yy2)
		{
            brush1 = CreateSolidBrush(color); /* 指定色でブラシを生成 */
            rect1.top = xx1; /* 四角の上端位置指定 */
            rect1.bottom = xx2; /* 四角の下端位置指定 */
            rect1.right = yy1; /* 四角の右端位置指定 */
            rect1.left = yy2; /* 四角の左端位置指定 */
            FillRect(g, &rect1, brush1);
		//	g.fillRect(yy1,xx1,yy2-yy1,xx2-xx1);	/*四角を描画 */
			DeleteObject(brush1); /* ブラシを削除 */
		}
}
	int cslfonthight(double scale) /* 指定倍率で全角文字の表示エリア高さを取得 */
	{
			int font_hight;
			int font_size;
			font_size=(int)(MIKA_width_x*scale); /* 表示エリア高さを仮想座標で計算 */
			font_hight=xcord(font_size)-xcord(0);  /* 表示エリア高さを実座標に変換 */
			return font_hight;
	}
	int cslfontwidth(double scale) /* 指定倍率で全角文字の表示エリア幅を取得 */
	{
			int font_width;
			int font_size;
			font_size=(int)(MIKA_width_y*2*scale); /* 表示エリア幅を仮想座標で計算 */
			font_width=ycord(font_size)-ycord(0); /* 表示エリア幅を実座標に変換 */
			return font_width;
	}
	int cslfontsize(double scale) /* 指定倍率でフォントサイズを取得 */
	{
		int font_hight;
		int font_width;
		int font_size;
		font_hight=cslfonthight(scale); /* 指定倍率で表示エリア高さを取得 */
		font_width=cslfontwidth(scale); /* 指定倍率で表示エリア幅を取得 */
		font_size=min(font_hight,font_width); /* 表示エリア高さと表示エリア幅の小さい方の値をフォントサイズに指定 */
		return font_size;
	}
int xcord(int x1) /* 仮想x座標を 実x座標に変換 */
{
	int max_x_cord1;
	int x,xx;
	if(MIKA_max_x_flag==0) /* 縦25行モードの設定 */
	{
		max_x_cord1=25*16;
	}
	else /* 縦20行モードの設定 */
	{
		max_x_cord1=20*16;
	}
	x=MIKA_win_size.bottom; /* 仮想座標を実座標に変換 */
	xx=(x*x1)/max_x_cord1;
	return(xx);
}	
int ycord(int y1) /* 仮想y座標を 実y座標に変換 */
{
    int max_y_cord1;
    int y, yy;
 	if(MIKA_max_y_flag==0) /* 一行横 80カラムモードの設定 */
	{
		max_y_cord1=80*8;
	}
	else /* 一行横 64カラムモードの設定 */
	{
		max_y_cord1=64*8;
	}
    y = MIKA_win_size.right;
    yy = (y * y1) / max_y_cord1; /* 仮想座標を実座標に変換 */
    return(yy);
}
	void disperrorcount(HDC g,int flag,int i,int j) /* エラー入力回数表示 */
// flag=0 表示 flag=1 数値のみ消去 flag=2 メッセージと共に数値を消去
// i 表示位置縦行番号
// j 表示位置横列番号
	{
		char type_mes[18];
		int offset;
		if(flag==0) /* フラグが=0の時は表示色を赤色に設定 */
		{
 			cslcolor(g,MIKA_red);
			snprintf(type_mes,18,"ミスタッチ%5d回",MIKA_type_err_count); /* エラーカウントメッセージ作成 */
			offset=0;
		}
		else if(flag==1)
		{
			cslcolor(g,MIKA_bk_color); /* フラグが=1の時は数値表示を消去 */
			snprintf(type_mes,18,"%5d",MIKA_type_err_count); /* エラーカウントメッセージ作成 */
			offset=10;
		}
		else
		{
			cslcolor(g,MIKA_bk_color); /* フラグが=2の時はメッセージを含めて表示を消去 */
			snprintf(type_mes,18,"ミスタッチ%5d回",MIKA_type_err_count); /* エラーカウントメッセージ作成 */
			offset=0;
		}
		//		System.out.printf("i=%d j=%d",i,j);
		cslput(g,i*16,(j+offset)*8,type_mes); /* 指定位置にエラーカウント表示 */
	}
	void disperror3(HDC g,int flag) /* 英文テキスト練習エラー回数表示 */
// flag=0 表示 flag=1 数値のみ消去  flag=2 メッセージと共に数値を消去
	{
		disperrorcount(g,flag,3,57); /* 表示位置を指定してエラー回数表示 */
	}
void disptitle(HDC g,string mes,string submes) /* 練習項目を画面上部に表示 */
// mes 練習種別メッセージ
// submes 練習項目メッセージ
	{
		char mes0[80];
		snprintf(mes0,80,mes.c_str(), submes.c_str()); /* 表示メッセージを作成 */
		cslcolor(g,MIKA_magenta); /* 表示色をマゼンタに設定 */
		cslmencenter(g,1,mes0); /* 画面上部中央にメッセージを表示 */
//		System.out.printf(mes0);
	}
	void displtitle1(HDC g) /* テキスト練習画面 上部表示 */
	{
		char a[60];			
		if(MIKA_p_count[MIKA_type_kind_no]!=0)  /* 練習回数がゼロでない場合 */
		{
			dispkaisu3(g,0); /* 練習回数を表示 */
		}
		if(MIKA_type_speed!=0.0) /* 入力速度がゼロでない場合 */
		{
			cslcolor(g,MIKA_blue);
			snprintf(a,60,"入力速度%6.1f文字(%5.1fワード)/分",MIKA_type_speed,MIKA_type_word_speed); /* 入力速度を文字列に変換 */
			cslput(g,3*16,21*8,a); /* 入力速度を表示 */
		}
		if (MIKA_type_speed_time!=0.0) /* 経過秒がゼロでない場合 */
		{
				disptime2(g,0); /* 経過秒表示 */
		}
		if(MIKA_type_err_count!=0) /* エラー回数がゼロで無い場合 */
		{
			disperror3(g,0); /* エラー回数表示 */
		}
		if(MIKA_type_speed_record[MIKA_type_kind_no]!=0.0) /* 最高入力速度がゼロでない場合 */
		{
			cslcolor(g,MIKA_green);
			snprintf(a,60,"最高入力速度%6.1f文字(%5.1fワード)/分",MIKA_type_speed_record[MIKA_type_kind_no],MIKA_type_word_speed_record[MIKA_type_kind_no]); /*最高入力速度を文字列に変換 */
			cslput(g,2*16,17*8,a); /* 最高速度 表示 */
			snprintf(a,60,"達成日   %s",MIKA_type_date_record[MIKA_type_kind_no].c_str());
			cslput(g,2*16,57*8,a); /* 達成日表示 */
		}
	}
	void displtitle2(HDC g) /* テキスト練習画面 メッセージと区切り線を表示 */
	{
		int	x1,x2,y1,y2;
		int i;
		HPEN oldpen; /* 旧ペン */
		HPEN pen1; /* 新ペン */
		cslcolor(g,MIKA_cyan); /* 表示色をシアンに設定 */
 		cslput(g,4*16,1,"修正はBSを押して下さい、行末ではスペースかEnterを押して下さい、ESCで中断します"); 
		cslcolor(g,MIKA_key_black); /* 表示色を黒色に設定 */
		x1=xcord(MIKA_kugiri_text_line); /* 区切り線 x 座標 開始位置取得 */
		x2=xcord(MIKA_kugiri_text_line+1); /* 区切り線 x 座標 終了位置取得 */
		y1=ycord(0); /* 区切り線 y 座標 開始位置取得 */
		y2=ycord(639); /* 区切り線 y 座標 終了位置取得 */
		pen1=CreatePen(PS_SOLID,1,MIKA_key_black); /* 指定色でソリッドペン生成 */
        oldpen=(HPEN)SelectObject(g,pen1); /* ペンを設定 */
		for(i=x1;i<x2;i++)
		{
			MoveToEx(g,y1,i,NULL); /* ペンを描画開始位置に移動 */
			LineTo(g,y2,i); /* 直線描画 */
		}
		SelectObject(g,oldpen); /* ペンを元に戻す */
		DeleteObject(pen1); /* ペンを削除 */
	}
	void dispkaisu3(HDC g,int flag) /* 英文テキス練習 練習回数表示 */
// flag=0 表示 flag=1 消去 
	{
		char type_mes[18];
		long count;
		if(MIKA_p_count==NULL) return; /* 練習回数配列アドレスが空の時はリターン */
		count=MIKA_p_count[MIKA_type_kind_no]; /* 練習項目に対応する練習回数取り出し */
//		System.out.printf("count=%d  MIKA_type_kind_no=%d\n",count,MIKA_type_kind_no);
		if(count==0) return; /* 練習回数がゼロの時はリターン */
		if(flag==0) cslcolor(g,MIKA_green); /* フラグが=0の時は表示色を緑色に設定 */
		else cslcolor(g,MIKA_bk_color); /* フラグが=1の時は表示を消去 */
		snprintf(type_mes,18,"練習回数%7ld回",count); /* 練習回数メッセージ作成 */
		cslput(g,16,57*8,type_mes); /* 練習回数メッセージ表示 */
	}
	string timemessage(int flag,double t1,double t2) /* 経過時間の表示メッセージを作成 */
	{
		char a[80];
		if(flag==0) /* 打ち切りでない場合 */
		{
			if(t1<=0.0) /* 一分以下の時は 秒のみ表示 */
			{
				snprintf(a,80,"経過時間%3.0f秒",t2); /* 秒のみの経過時間表示メッセージ作成 */
			}
			else
			{
				snprintf(a,80,"経過時間%3.0f分%2.0f秒",t1,t2); /* 分と秒の経過時間表示メッセージ作成 */
			}
		}
		else /* 打ち切りの時は小数点以下二桁まで表示 */
		{
			if(t1<=0.0) /* 一分以下の時は 秒のみ表示 */
			{
				snprintf(a,80,"経過時間%6.2f秒",t2); /*  小数点二桁まで秒のみの経過時間表示メッセージ作成 */
			}
			else
			{
				snprintf(a,80,"経過時間%3.0f分%5.2f秒",t1,t2); /* 小数点二桁まで分と秒の経過時間表示メッセージ作成 */
			}
		}
		return a;
	}
	void disptime2(HDC g,int flag) /* 経過時間分秒を表示 */
	// flag=0 表示 flag=1 消去 
	{
		string	type_mes;
		char a[80],b[80];
		double t1;
		double t2;
		t1=roundtime(MIKA_type_speed_time/60.0); /* 経過分を算出 */
		t2=MIKA_type_speed_time-t1*60; /* 経過秒を算出 */
		int	offset;
		if(flag==0) /* 経過時間 表示の場合 */
		{
 			cslcolor(g,MIKA_blue);  /* フラグが=0の時は表示色を青に設定 */
			type_mes=timemessage(MIKA_utikiri_flag,t1,t2); /* 練習時間分秒のメッセージを作成 */
			cslput(g,3*16,1,type_mes); /* 経過時間秒のメッセージを表示 */
		}
		else if(flag==1&&MIKA_utikiri_flag==0)/* 表示消去の場合 */
		{
			cslcolor(g,MIKA_bk_color); /* フラグが=1の時は表示を消去 */
			if(t1<=0.0)  /* 表示消去が秒のみの場合 */
			{
				snprintf(a,80,"%3.0f",t2); /* 経過時間秒の表示メッセージ作成 */
				offset=8;
				cslput(g,3*16,1+offset*8,a); /* 経過時間秒のメッセージを消去 */
			}
			else /* 表示消去が分と秒の場合 */
			{
				snprintf(a,80,"%3.0f",t1); /* 経過時間分の表示メッセージ作成 */
				offset=8;
				cslput(g,3*16,1+offset*8,a); /* 経過時間分の表示を消去 */
				snprintf(b,80,"%2.0f",t2); /* 経過時間秒の表示メッセージ作成 */
				offset=8+5;
				cslput(g,3*16,1+offset*8,b); /* 経過時間秒の表示を消去 */
			}
		}
		else /* 表示メッセージを含んで経過時間を消去する場合 */
		{
			cslcolor(g,MIKA_bk_color); /* フラグが=2の時はメッセージを含んで表示を消去 */
			type_mes=timemessage(MIKA_utikiri_flag2,t1,t2); /* 経過時間分秒のメッセージを作成 */
			cslput(g,3*16,1,type_mes); /* 経過時間分秒のメッセージを消去 */
		}
	}
	void displinetrain(HDC g,string mest) /* 練習実行画面を表示 */
	{
		int i,j,k,l;
		cslclr(g); /* 画面クリア */
		disptitle(g,mest,MIKA_type_kind_mes); /* 練習テキスト表題を表示 */
		displtitle1(g); /* テキスト練習画面 上部表示 */
		displtitle2(g); /* テキスト練習画面 メッセージと区切り線を表示 */
		cslcolor(g,MIKA_key_black); /* 表示色を黒色に設定 */
		for(i=0;i<MIKA_max_text_line;i++)
		{
			j=i+MIKA_scroll_point; /* 練習テキスト表示開始行位置取得 */
			if(j<MIKA_max_c_line) /* 最大行まで練習テキストを表示 */
			{
				cslput(g,MIKA_start_text_line+MIKA_double_text_hight*i,0,MIKA_c_line[j]); /*練習テキストを一行表示 */
			}
			else
			{
				break;
			}
		}
		for(i=0;i<MIKA_text_point_x;i++) /* 入力済テキストを表示 */
		{
			j=i+MIKA_scroll_point; /* 入力済テキスト表示開始行取得 */
			if(j<MIKA_max_c_line) /* 一行分入力済のテキストを表示 */
			{
				k=MIKA_start_text_line+MIKA_double_text_hight*i+MIKA_rensyu_text_hight; /* 入力テキスト表示x座標設定 */
				cslcolor(g,MIKA_key_blue); /* 表示色を青色に設定 */
				cslput(g,k,0,MIKA_c_line[j]); /* 入力済テキスト表示 */
				l=(int)MIKA_c_line[j].length(); /* 入力済みテキスト文字数取得 */
				cslputu(g,k,0,MIKA_c_line[j],1,MIKA_color_text_under_line); /* 入力済テキストに青色アンダーライン描画 */
				cslputu(g,k,l*8," ",1,MIKA_color_text_under_line); /* 入力済テキスト行末にアンダーラインを一文字分描画 */
			}
			else
			{
				break;
			}
		}
		k=MIKA_start_text_line+MIKA_double_text_hight*MIKA_text_point_x+MIKA_rensyu_text_hight; /* 入力中の行の表示 x座標取得 */
		j=MIKA_text_point_x+MIKA_scroll_point; /* 入力済テキスト行位置取得 */
		for(i=0;i<MIKA_text_point_y;i++) /* 入力済の文字を一文字づつ表示 */
		{
				cslcolor(g,MIKA_key_blue); /* 表示色を青色に設定 */
				cslputw(g,k,i*8,MIKA_c_line[j][i]); /* 入力済の文字を表示 */
				cslputu(g,k,i*8,"a",1,MIKA_color_text_under_line); /* 入力済文字にアンダーラインを描画 */
		}
		if(MIKA_err_count>0) /* エラー入力文字がある場合 */ 
		{
			cslbkcolor(g, MIKA_color_text_err);
			for(i=0;i<MIKA_err_count;i++)
			{
				l=(MIKA_text_point_y+i)*8; /*エラー文字表示y座標取得 */
				dispbkcharline(g,k,l,MIKA_color_text_err); /* エラー文字の背景を赤色で表示 */
				cslcolor(g,MIKA_key_black); /* 表示色を黒に設定 */
				cslputw(g,k,l,MIKA_err_c_table[i]); /*エラー文字を表示 */
			}
			cslbkcolor(g, MIKA_bk_color);
		}			
		if(MIKA_disp_cursor_flag==1) /* カーソル表示フラグがオンの場合はカーソルを表示 */
		{
			if(MIKA_text_point_y+MIKA_err_count<79) /* カーソル位置が行末でない場合 */
			{
				dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_color_cursor); /* カーソル表示 */
			}
			else /* カーソル位置が行末の場合 */
			{
				dispcur(g,scroll_cord_x(),scroll_cord_y()-8,1,MIKA_color_cursor); /* カーソル表示 */
			}
		}
		if(MIKA_practice_end_flag==1) /* 練習終了時 */
		{
			cslrectt (g,21*16+8,0,24*16+8,80*8,MIKA_bk_color); /* 表示メッセージの背景を消去 */
			if(MIKA_type_syuryou_flag==2) /* 記録更新時 */
			{
				dispupmes(g,0); /* 記録を更新しましたの表示を行う */
			}
			dispretrymessage(g,0); /* リトライメッセージ表示 */
		}
	}
	void ppseiseki(HDC g,int i,int j,string menu_mes[],long r_mojisu[], double r_speed[],double w_speed[], string r_date[], long r_time[],long t_kaisu[]) /* 英文テキスト練習の成績を表示 */
/* i 表示位置 j 表示個数 menu_mes 練習項目 r_speed 最高速度 r_date 達成日 r_time 累積練習時間 */
	{
		int ii;
		char a[14],c[5];
		string b;
		for(ii=0;ii<j;ii++)
		{
			snprintf(a,14,"%1d:",ii+1);
			cslput(g,(i+ii)*16,1,a); /* 練習テキストの番号を表示 */
			cslput(g,(i+ii)*16,2*8,menu_mes[ii]); /* テキスト名を表示 */
			if(r_mojisu[ii]!=0) /* 練習テキスト文字数が 0 でない場合 */
			{
				snprintf(a,14,"%6ld",r_mojisu[ii]); /* 練習テキスト文字数を文字列に変換 */
				cslput(g,(i+ii)*16,32*8,a); /* 練習テキスト文字数を表示 */
				
			}
			
			if(r_speed[ii]!=0.0) /*最高入力速度が 0.0 でない場合 */
			{
				snprintf(a,14,"%6.1f(%5.1f)",r_speed[ii],w_speed[ii]); /* 最高入力速度を文字列に変換 */
				cslput(g,(i+ii)*16,38*8,a); /* 最高入力速度を表示 */
			}
			cslput(g,(i+ii)*16,52*8,r_date[ii]); /* 達成日を表示 */
			b=t0conv(r_time[ii],2); /* 累積練習時間を文字列に変換 */
			cslput(g,(i+ii)*16,60*8,b); /* 累積練習時間を表示 */
			snprintf(c,5,"%4d",t_kaisu[ii]); /* 練習回数を文字列に変換 */
			cslput(g,(i+ii)*16,76*8,c); /* 練習回数を表示 */
		}
}
	void dispseiseki(HDC g) /* 成績表示 */
	{
		long time_i;
		char aa[38];
		string a,b;
		cslclr(g); /* 画面クリア */
		a=tconv((long)MIKA_rt_t); /* 前回までの合計練習時間を文字列に変換 */
		snprintf(aa,38,"前回までの練習時間　%s",a.c_str()); /* 前回までの合計練習時間のメッセージ作成 */
		cslcolor(g,MIKA_green); /* 表示色を緑色に設定 */
		cslput(g,1,1,aa); /* 前回までの合計練習時間を表示 */
		cslcolor(g,MIKA_blue); /* 表示色を青色に設定 */
		cslput(g,1,43*8,MIKA_return_mes); /* エスケープキーを押すとメニューに戻りますのメッセージを表示 */
		time(&MIKA_lt_t); /* 現在時刻をミリ秒で取得 */
		time_i=(long)(MIKA_lt_t-MIKA_st_t); /* 今回練習時間を秒で計算 */
		a=tconv(time_i); /* 今回練習時間を文字列に変換 */
		snprintf(aa,38,"今回の練習時間　　　%s",a.c_str()); /* 前回までの合計練習時間のメッセージ作成 */
		cslcolor(g,MIKA_green); /* 表示色を緑色に設定 */
		cslput(g,16,1,aa); /* 今回練習時間を表示 */
		cslcolor(g,MIKA_blue); /* 表示色を青色に設定 */
		cslput(g,3*16,1,MIKA_mest2); /* 成績メッセージ表示 */
		cslput(g,4*16,1,MIKA_mest3); /* 成績メッセージ下一行を表示 */
		cslcolor(g,MIKA_orange); /* 表示色をオレンジに設定 */
		ppseiseki(g,6,6,MIKA_ti_text,MIKA_t_mojisu,MIKA_t_speed,MIKA_tw_speed,MIKA_t_date,MIKA_t_time,MIKA_t_kaisu); /* 英文テキスト練習の成績を表示 */
	}
void dispstart(HDC g) /* 著作権表示 */
{
    int i;
    MIKA_max_x_flag = 1; /* 縦 20行モードに設定 */
    MIKA_max_y_flag = 1;/* 横 64カラムモードに設定 */
    string title_bar = "●●●●●●●●●●●●●●●●●●●●●●●●●";
 //   cslclr(g); /* 画面クリア */
    cslcolor(g, MIKA_magenta); /* 表示色をマゼンタに設定 */
    cslput(g, 3 * 16, 7 * 8, title_bar); /* 表示枠 上端を表示 */
    for (i = 4;i < 15;i++)
    {
        cslput(g, i * 16, 7 * 8, "●"); /* 表示枠 左端を表示 */
        cslput(g, i * 16, 55 * 8, "●"); /* 表示枠 右端を表示 */
    }
    cslput(g, 15 * 16, 7 * 8, title_bar); /* 表示枠 下端を表示 */
    cslcolor(g, MIKA_blue); /* 表示色を青に設定 */
	cslmencenter(g,5*16+8,"美佳の英文タイプトレーナー テキスト練習編");
	cslcolor(g,MIKA_cyan); /* 表示色をシアンに設定 */
	cslmencenter(g,7*16+8,"ＭＩＫＡＴＥＸＴ Ｖer２.０２.０１");
	cslcolor(g,MIKA_orange); /* 表示色をオレンジに設定 */
	cslmencenter(g,9*16+6,"＜＜英文タイプ練習のために＞＞");
	cslcolor(g,MIKA_cyan); /* 表示色をシアンに設定 */
	cslmencenter(g,13*16+8,"Copy right 1992/8/24  今村 二朗");
	cslput(g,17*16,24*8,"キーをどれか押すとメニューを表示します");
    MIKA_max_x_flag = 0; /* 縦 25行モードに戻す */
    MIKA_max_y_flag = 0; /* 横 80カラムモードに戻す */
}
void dispmen(HDC g) /* メニュー及び練習画面、成績画面表示 */
{
	if(MIKA_exec_func_no==0) dispstart(g); /* 著作権表示 */
	else if (MIKA_exec_func_no==1) menexe(g,MIKA_menu_mes_s,MIKA_menu_cord_s,MIKA_menu_s_function,MIKA_menu_s_sel_flag,MIKA_mes0); /* 初期メニュー表示 */
	else if (MIKA_exec_func_no==19) dispseiseki(g); /* 成績表示 */
	else if(MIKA_exec_func_no>1100&&MIKA_exec_func_no<1200) displinetrain(g,MIKA_mesta); /* 英文テキスト練習の各項目の実行画面表示 */
}
void menexe(HDC g,string menu_mes[], int menu_cord[6][2], int menu_function[], int sel_flag[], string menut) /* メニュー画面表示 */
{
		int i,j;
		int x;
		int y;
		string	mesi5="番号キーを押して下さい";
		MIKA_max_x_flag=0; /* 縦 25行モードに設定 */
		MIKA_max_y_flag=0; /* 横 80カラムモードに設定 */
		cslclr(g); /* 画面クリア */
		cslcolor(g,MIKA_magenta); /* 表示色をマゼンタに設定 */
		cslmencenter(g,1,menut); /* メニュータイトルを上端の中央に表示 */
		MIKA_max_x_flag=1; /* 縦 20行モードに設定 */
		MIKA_max_y_flag=1; /* 横 64カラムモードに設定 */
		cslcolor(g,MIKA_cyan);
		cslput(g,18*16,29*8,mesi5); /* 番号キーを押して下さいのメッセージを表示 */
		j=inttablelength(menu_function);
		for(i=0;i<j;i++)
		{
			x=menu_cord[i][0]; /* メニュー表示位置 x座標取得 */
			y=menu_cord[i][1]; /* メニュー表示位置 y座標取得 */
			if(sel_flag[i]==1)	cslcolor(g,MIKA_green); /*前回選択メニュー項目は緑色で表示 */
			else 	cslcolor(g,MIKA_blue); /* その他のメニューは青色で表示 */
			cslput(g,x,y,menu_mes[i]); /* メニュー項目表示 */
			if(sel_flag[i]==1) cslputu(g,x,y,menu_mes[i],1,MIKA_green); /* 前回選択メニュー項目に下線を表示 */
			cslputzscale(g,x,y-4*MIKA_width_y,(wchar_t)(i+'1'),1.0); /* メニュー番号を表示 */
		}
		MIKA_menu_function_table=menu_function; /* 機能番号テーブル設定 */
		MIKA_sel_flag=sel_flag; /* 前回選択メニュー項目選択フラグアドレス設定 */
		MIKA_max_x_flag=0; /* 縦 25行モードに戻す */
		MIKA_max_y_flag=0; /* 横 80カラムモードに戻す */
}
	int mencom(int* menu_function_table,int* sel_flag,wchar_t nChar) /* 選択されたメニューの項目に対応する機能番号を取得 */
	{
		int func_no=0;
		int i,ii,iii;
		int sel_flag1=0;
		if(menu_function_table==NULL) return(0);
		ii = inttablelength(menu_function_table);
		if(nChar==0x1b){ /* 入力文字がエスケープの場合 */
			for(i=0;i<ii;i++) /* メニューに戻りますのメニュー項目をサーチ */
			{
				if (menu_function_table[i] > 9000 && menu_function_table[i] < 9999) /* メニューに戻りますのメニュー項目があった場合 */
				{
					func_no=menu_function_table[i];
				}
			}
			return(func_no);
		}
		else if(nChar<=0x30||nChar>0x39) return(0); /* 入力文字が1～9の数字以外は処理をしないでリターン */
		else
		{
			iii=nChar-0x31; /* 文字を数字に変換 */
			if(iii<ii) /* 入力された数字に対応するメニューがある場合 */
			{
				func_no=menu_function_table[iii]; /* 対応する機能番号を取り出す */
				for(i=0;i<ii;i++)
				{
						if(sel_flag[i]!=0) sel_flag1=i+1; /* 前回選択メニュー項目番号をサーチ */
				}
				if(0<func_no&&func_no<9000) /* 今回選択メニューがメニューに戻るで無い場合 */
				{
					if(sel_flag1!=0) sel_flag[sel_flag1-1]=0; /*前回選択メニュー番号をクリア */
					sel_flag[iii]=1; /* 今回の選択メニュー番号を前回選択メニュー番号に設定 */
				}
				return(func_no);
			}
			else
			return(0);
		}	
	}
	int exec_func(HWND hWnd,HDC g,wchar_t nChar) /* 一文字入力に対応した処理を行う */
	{
		int func_no;
		if(MIKA_exec_func_no==0) /* 最初の初期画面を表示中にキーが押された場合 */
		{
			MIKA_exec_func_no=1; /* 初期画面の表示番号を設定 */
			dispmen(g); /* メニュー表示 */
			return(1);
		}
		func_no=mencom(MIKA_menu_function_table,MIKA_sel_flag,nChar); /* 選択されたメニューの項目に対応する機能番号を取得 */
		if(func_no!=0) /* メニュー表示中に数字キーが押されて対応する機能番号がゼロでない場合 */
		{
			MIKA_menu_function_table=NULL;
			MIKA_exec_func_no=func_no;
			if(MIKA_exec_func_no==9999)
			{
				procexit(); /* 機能番号が 9999の時は終了 */
		    	PostQuitMessage(0);
				return(0);
			}
			if (MIKA_exec_func_no>9000) MIKA_exec_func_no=MIKA_exec_func_no-9000; /* 機能番号がメニューに戻るの時は、メニュー番号を取得 */
			if(MIKA_exec_func_no>1100&&MIKA_exec_func_no<1200) /* 機能番号が英文テキスト練習の場合は各練習の項目ごとに前処理を行う */
			{
				preplinetrain(MIKA_exec_func_no); /* 英文テキスト練習の各項目ごとの前処理 */
			}
			dispmen(g); /* メニュー、練習画面表示 */
		}
		else /* 練習の実行中にキーが押された場合 */
		{
			if(nChar==0x1b&&MIKA_exec_func_no==19) /* 成績表示中にエスケープキーが押された場合 */
			{
				MIKA_exec_func_no=1; /* 初期メニューのメニュー番号設定 */
				dispmen(g); /* メニュー表示 */
				return(1);
			}
			if(MIKA_exec_func_no>1100&&MIKA_exec_func_no<1200) /* 英文テキスト 練習 */
			{
				proclinetrain(hWnd,g,nChar); /* 英文テキスト練習  文字入力処理 */
				return(1);
			}
		}
		return(0);
	}
	long timeinterval(long time_start,long time_end) /* ミリ秒で指定された時間間隔の経過時間を秒に変換 */
	{
			long time_interval;
			time_interval=(time_end-time_start)/1000; /* 開始時間ミリ秒と終了時間ミリ秒の差を秒に変換 */
			if(time_interval<=0) time_interval=1; /* 経過時間がゼロ秒以下の場合は1秒を設定 */
			return time_interval;
	}
int wwseiseki(FILE *fp) /* 成績書き込み  =0 書き込みエラー =0 以外は書き込み成功 */
{
	int i;
	int err;
	string a,b;
	char format1[]=" %s\n";/* 累積練習時間書き込みフォーマット */
	char format2[]="%-34s%7.1lf %s"; /* 練習項目名 最高速度 達成日 書き込みフォーマット */
	time(&MIKA_lt_t);
	a=tconv((long)(MIKA_lt_t-MIKA_st_t+MIKA_rt_t)); /* 前回の練習時間に今回の練習時間を加算して文字列に変換 */
	err=fprintf(fp,"練習時間　%s\n",a.c_str()); /* 練習時間を書き込み */
	if(err==0) return(err);
	for(i=0;i<6;i++) /* 英文テキスト練習 練習成績書き込み */
	{
		err=fprintf(fp,"mika%03d.mit %8ld %7.1lf(%5.1lf) %s",i+1,MIKA_t_mojisu[i],MIKA_t_speed[i],MIKA_tw_speed[i],MIKA_t_date[i].c_str()); /* 文字数 最高入力速度 達成日書き込み */
		if(err==0) return(err);
		b=t0conv(MIKA_t_time[i],2); /* 累積練習時間を文字列に変換 */
		err=fprintf(fp,"%s",b.c_str()); /* 累積練習時間書き込み */
		if(err==0) return(err);
		err=fprintf(fp,"%4ld\n",MIKA_t_kaisu[i]); /* 練習回数書き込み */
		if(err==0) return(err);

	}
	return(err);
}
int wseiseki(void) /* 成績ファイル書き込み エラーコード =0 書き込み成功 =1 書き込み失敗 */
{
	FILE *fp;
	int err;
	err=fopen_s(&fp,MIKA_file_name_seiseki2,"wt"); /* 成績ファイルを書き込みテキストモードでオープン */
	if(err==0)
	{
		err=wwseiseki(fp); /* 成績書き込み */
		fclose(fp);
		if(err==0) return(1); /* 書き込みエラー時はリターンコード=1でリターン */
		else return(0); /* 正常終了時はリターンコード=0でリターン */
	}
	else
	return(1); /* 成績ファイルのオープンに失敗したときはエラーコード=1でリターン */
}
int wwkiroku(FILE *fp) /* 練習開始時刻と練習時間を成績記録ファイルに書き込む */
{
	int	err;
	char	ss_date[9];
	string a;
	convdate(&ss_date[0],MIKA_s_date); /* 日付の表示順序を mm/dd/yyから yy/mm/dd に変換 */
	a=t0conv((long)(MIKA_lt_t-MIKA_st_t),1); /* 練習時間を文字列に変換 */
	err=fprintf(fp,"%s %s",ss_date,MIKA_s_time); /* 練習開始日付と時刻を書き込み */
	if(err==0) return(err);
	err=fprintf(fp," 練習時間%s\n",a.c_str()); /* 練習時間を書き込み */
	return(err);
}
int wkiroku() /* 練習終了時に練習開始時刻と練習時間を成績記録ファイルに書き込む */
{
	FILE *fp;
	int err;
	err=fopen_s(&fp,MIKA_file_name_kiroku,"at"); /* テキスト追記モードで練習時間記録ファイルをオープン */
	if(err==0)
	{
		err=wwkiroku(fp); /* 練習開始時刻と練習時間を練習時間記録ファイルに書き込み */
		fclose(fp);
		if(err==0) return(1); /* 書き込みエラー時はリターンコード =1でリターン */
		else
		return(0); /* 正常終了時はリターンコード=0でリターン */
	}
	else
		return(1); /* 練習時間記録ファイルのオープンに失敗したときはエラーコード=1でリターン */
}
int wwhayasa(FILE *fp) /* 最高入力速度を最高速度記録ファイルに書き込む */
{
	int err;
	string a;
	a=t0conv(MIKA_type_time_record[MIKA_type_kind_no],2); /* 累積練習時間を字列に変換 */
	err=fprintf(fp,"%s %s %s%5ld字%6.1f字(%5.1fﾜｰﾄﾞ)/分%s%3d回\n",MIKA_type_date, MIKA_type_time, MIKA_menu_kind_mes.c_str(), MIKA_type_count, MIKA_type_speed, MIKA_type_word_speed, a.c_str(), MIKA_p_count[MIKA_type_kind_no]); /* 達成日付時刻と練習項目 文字数 最高入力速度 達成日 練習回数 書き込み */
	return(err);
}
int whayasa() /* 最高入力速度を最高速度記録ファイル書き込む */
{
	FILE *fp;
	int err;
	err=fopen_s(&fp,MIKA_file_name_hayasa,"at");/* テキスト追記モードで最高速度記録ファイルをオープン */
	if(err==0)
	{	
		err=wwhayasa(fp);  /* 最高入力速度を最高速度記録ファイル書き込む */
		fclose(fp);
		if(err==0) return(1); /* 書き込みエラー時はリターンコード =1でリターン */
		else return(0);/* 正常終了時はリターンコード=0でリターン */
	}
	return(1); /* 最高速度記録ファイルのオープンに失敗したときはエラーコード=1でリターン */
}
	void savekiroku() /* プログラムがウィンドーの閉じるボタンにより終了した場合、練習記録を保存する */
	{
		if(1100<MIKA_exec_func_no&&MIKA_exec_func_no<1200) /* 英文テキスト 練習の場合 */
		{
//			System.out.printf("random word romaji practice\n");
			if(MIKA_practice_end_flag==0&&MIKA_time_start_flag!=0) /* 練習中で練習時間の計測を開始した場合 */
			{
//				System.out.printf("random word romaji  practic time save\n");
				MIKA_type_end_time=getmillisecond(); /* 練習終了時間をミリ秒で取得 */
				MIKA_type_time_record[MIKA_type_kind_no]=MIKA_type_time_record[MIKA_type_kind_no]+timeinterval(MIKA_type_start_time,MIKA_type_end_time); /* 練習終了時間をミリ秒で取得 */
			}
			if(MIKA_type_syuryou_flag==1||MIKA_type_syuryou_flag==2) /* 最高記録を更新して練習を終了した場合 */
			{
				MIKA_type_speed_record[MIKA_type_kind_no]=MIKA_type_speed; /* 最高入力速度を保存 */
				MIKA_type_word_speed_record[MIKA_type_kind_no]=MIKA_type_word_speed; /* 練習記録 最高入力速度 ワード／分を更新 */
				MIKA_type_date_record[MIKA_type_kind_no]=MIKA_type_date; /* 達成日を保存 */
			}
		}
	}
	void procexit() /* プログラム終了時の処理 */
	{
//		String a;
//		Container c;
		time(&MIKA_lt_t); /* 練習時間記録ファイル用練習終了時間をミリ秒で取得 */
		MIKA_file_error_seiseki=wseiseki(); /* 成績ファイル書き込み */
		MIKA_file_error_kiroku=wkiroku(); /* 練習時間記録ファイル書き込み */
//		MIKA_file_error_seiseki=1;
//		MIKA_file_error_kiroku=1;
//		MIKA_file_error_hayasa=1;
//		if(MIKA_file_error_seiseki==1||MIKA_file_error_kiroku==1||MIKA_file_error_hayasa==1) /* 成績ファイル書き込みエラーの場合 */
//		{
//			a=mesfileerr(); /* 成績ファイル書き込みエラーメッセジ作成 */
//			c = getContentPane();
//			JOptionPane.showMessageDialog(c.getParent(),a,"成績ファイル書き込みエラー",JOptionPane.WARNING_MESSAGE);
//			/* 成績ファイル書き込みエラーダイアログ表示 */
//		}
//		System.exit(0); /* プログラム終了 */
	}		
	double ftypespeed(int count,long start_time,long end_time) /* 一分間あたりのタイプ速度を計算 */
// count 文字数
// start_time 開始時間 ミリ秒
// end_time 終了時間 ミリ秒
	{
		double speed_rate;
		double r_count;
		r_count=count;
		if(end_time==start_time) speed_rate=0.0; /* 開始時間と終了時間が一致する場合はタイプ速度をゼロに指定 */
		else
		{
			speed_rate=1000.0*60.0*r_count/(end_time-start_time); /* 一分間あたりのタイプ速度を計算 */
		}
		return speed_rate;
	}
	void dispspeedrate3(HDC g,int flag) /* 英文テキスト練習 入力速度表示 */
// flag=0 表示 flag=1 消去
	{
		char a[80],b[80];
		int offset_a,offset_b;
		if(flag==0)
		{
			cslcolor(g,MIKA_blue); /* flagが=ゼロの時は青色で表示 */
			snprintf(a,80,"入力速度%6.1f文字(%5.1fワード)/分",MIKA_type_speed,MIKA_type_word_speed); /* 入力速度を文字列に変換 */
			cslput(g,3*16,21*8,a); /* 入力速度を表示 */
		}
		else
		{
			cslcolor(g,MIKA_bk_color); /* flagが=1の場合は表示消去 */
			snprintf(a,80,"%6.1f",MIKA_type_speed); /* 入力速度 文字数／分を文字列に変換 */
			offset_a=8;
			cslput(g,3*16,(21+offset_a)*8,a); /* 入力速度 文字数／分を消去 */
			snprintf(b,80,"%5.1f",MIKA_type_word_speed); /* 入力速度 ワード／分を文字列に変換 */
			offset_b=19;
			cslput(g,3*16,(21+offset_b)*8,b); /* 入力速度 ワード／分を消去 */
		}
	}
	void procdispspeed3(HDC g)  /* 英文テキスト練習 入力速度を計算して再表示 */
	{
			if(MIKA_type_speed_time<60.0&&MIKA_ttype_speed_time>=60.0) disptime2(g,2); /* 前回練習経過時間表示を消去 */
			else disptime2(g,1);
			dispspeedrate3(g,1); /* 前回 入力速度表示を消去 */
			MIKA_type_speed_time=MIKA_ttype_speed_time; /* 練習経過時間を更新 */
 			MIKA_type_speed=ftypespeed(MIKA_type_count,MIKA_type_start_time,MIKA_type_end_time); /* 入力速度  文字数／分を取得 */
	 		MIKA_type_word_speed=MIKA_type_speed/5.0; /* 入力速度 ワード／分を取得 */
			disptime2(g,0); /* 今回練習経過時間を表示 */
			dispspeedrate3(g,0); /* 今回 入力速度を表示 */
	}
void preplinetrain(int func_no) /* 練習の前処理 */
	{
			if(MIKA_exec_func_no>1100&&MIKA_exec_func_no<1200) /* 英文テキスト練習の前処理 */
			{
					MIKA_type_kind_no=func_no-1101; /* 練習項目番号を取得 */
					MIKA_menu_kind_mes=MIKA_t_seiseki_name[MIKA_type_kind_no]; /* 最高速度記録ファイル書き込み用メッセージ設定 */
					MIKA_type_speed_record=MIKA_t_speed; /* 最高速度記録配列 文字数／分アドレスに 英文テキスト練習 最高速度記録 文字数／分 を設定 */
					MIKA_type_word_speed_record=MIKA_tw_speed; /* 最高速度記録配列 ワード／分アドレスに 英文テキスト練習 最高速度記録 ワード／分 を設定 */
					MIKA_type_date_record=MIKA_t_date; /* 最高速度達成日配列アドレスに 英文テキスト練習 最高速度達成日付 を設定 */
					MIKA_type_time_record=MIKA_t_time; /* 累積練習時間配列アドレスに 英文テキスト練習 累積練習時間 を設定 */
					MIKA_p_count=MIKA_t_kaisu; /* 練習回数配列アドレスに英文テキスト練習 練習回数 を設定 */
					MIKA_type_kind_mes=MIKA_ti_text[MIKA_type_kind_no]; /* 練習テキスト表題を設定 */ 
					prepflagsline(); /* 英文テキスト練習開始時のフラグクリア */
					MIKA_max_c_line=readtextfiles(MIKA_t_name[MIKA_type_kind_no],MIKA_c_line,0,MIKA_MAX_TEXT_LENGTH); /* 練習テキスト読み込み */
			}
	}
	void prepflagsline() /* 英文テキスト練習開始時のフラグクリア処理 */
	{
		MIKA_practice_end_flag=0; /* 練習実行中フラグ クリア */
		MIKA_time_start_flag=0; /* 時間計測開始フラグ クリア */
		MIKA_current_point_x=1; /* 練習テキストの入力行の位置を1に設定 */
		MIKA_scroll_point=1; /* 画面スクロール表示の開始行の位置を1に設定 */
		MIKA_text_point_x=0; /* 文字入力カーソル縦行位置クリア */
		MIKA_text_point_y=0; /* 文字入力カーソル横文字位置クリア */
		MIKA_err_count=0; /* エラー文字表示文字数クリア */
		MIKA_type_count=0; /* 入力文字数カウンター クリア */
		MIKA_type_speed=0.0; /* 練習テキストの入力速度 文字数／分クリア */
		MIKA_type_word_speed=0.0; /* 練習テキストの入力速度 ワード／分クリア */
		MIKA_type_speed_time=0.0; /* 前回 練習経過時間 クリア */
		MIKA_ttype_speed_time=0.0; /* 今回 練習経過時間 クリア */
		MIKA_type_err_count=0; /* エラー入力文字数カウンター クリア */
		MIKA_utikiri_flag=0; /* 速度表示時の練習テキスト打ち切りフラグ クリア */
		MIKA_utikiri_flag2=0; /* 前回速度表示時の練習テキスト打ち切りフラグ クリア */
		MIKA_type_syuryou_flag=0; /* 練習終了時の記録更新フラグ クリア */
		MIKA_disp_cursor_flag=1; /* カーソル表示フラグを1に設定 */
	}
	int	rtextfile(FILE *fp,string c_line[],int offset_i,int file_length) /* 英文練習テキストファイル読み込み */
	{
			int i,ii,iii;
			char* err;
			int f_length;
			char a[128];
			char b[129];
			f_length=0;
			err=0;
			for(i=0;i<file_length;i++)/* 英文練習テキストファイルを指定行数読み込み */
			{
				err=fgets(a, 128, fp);
				if(err==NULL)
				{
					break;
				}
				iii = 0;
				b[iii] = 0;
				for (ii = 0;ii < 128;ii++)
				{
					if (a[ii] != 0x0d && a[ii] != 0x0a) /* 復帰0x0dコードと改行0x0aコードを削除 */
					{
						b[iii] = a[ii];
						iii++;
					}
					if (a[ii] = 0) break;
					else b[iii] = 0;
				}
				c_line[i+offset_i]=b;
   			}
 			f_length=i;
			return(f_length); /* 読み込みファイル行数をリターン */
	}
	int readtextfiles(string text_file_name,string c_line[],int offset_i,int file_length) /* 英文練習テキストファイルをオープンして指定行読み込みクローズする */
	{
     	int err;
		int f_length;
		f_length=0;
		FILE *fp;
 		err=fopen_s(&fp,text_file_name.c_str(), "rt"); /* 英文練習テキストファイルを読み込み専用のテキストファイルでオープン */
  		if(err==0) /* 正常にオープンできた場合は英文練習テキストファイルを読み込み */
		{
			f_length=rtextfile(fp,c_line,offset_i,file_length); /* 英文練習テキストファイル読み込み */
			fclose(fp); /* 英文練習テキストファイルクローズ */
		}
		return(f_length);
	};
	void dispretrymessage(HDC g,int flag) /* リトライメッセージ表示 flag=0 表示を行う flag=1 表示を消去 */
	{
		if(flag==0) cslcolor(g,MIKA_cyan); /* 表示色をシアンに設定 */
		else cslcolor(g,MIKA_bk_color); /* 表示色を背景色に設定 */
		cslput(g,22*16,10*8,MIKA_mesi1); /* 「もう一度練習するときはリターンキーまたは、Enterキーを押してください」のメッセージを表示 */
		cslput(g,23*16,10*8,MIKA_mesi2); /* 「メニューに戻るときはESCキーを押してください」のメッセージを表示 */
	}
	int funcbackmenu(int func_no) /* メニューの階層を一段上に戻る */
	{
		int ffun_no;
		ffun_no=1; /* 初期メニューに戻る */
		return ffun_no;
	}
	void proclinetrain(HWND hWnd, HDC g,wchar_t nChar) /* 英文テキスト練習の文字入力処理 */
	{
//			System.out.printf("char %x pressed\n",(int) nChar);
		if(nChar==0x1b){ /* エスケープキー入力の場合 */
			if(MIKA_practice_end_flag==0) /* 入力練習実行中の場合 */
			{
				MIKA_practice_end_flag=1; /* 練習実行中フラグを終了にセット */
				if(MIKA_time_start_flag!=0) /* 最初の正解を入力済の場合 */
				{
//					MIKA_Procttimer.cancel();		/* 入力速度表示の一秒間隔タイマーをキャンセル */				
					KillTimer(hWnd,MIKA_Procttimer_ID); /* ガイドキー文字位置表示用タイマーをキャンセル */
					MIKA_type_end_time= getmillisecond(); /* 練習終了時間をミリ秒で取得 */
					MIKA_type_speed_time=roundtime((MIKA_type_end_time-MIKA_type_start_time)/1000.0); /* 練習経過時間 秒を計算 */
					MIKA_type_time_record[MIKA_type_kind_no]=MIKA_type_time_record[MIKA_type_kind_no]+(long)MIKA_type_speed_time; /* 累積練習時間の記録を加算 */
				}
				cslrectt (g,21*16+8,0,24*16+8,80*8,MIKA_bk_color); /* リトライメッセージ背景クリア */
				dispretrymessage(g,0); /* リトライメッセージ表示 */
			}
			else if(MIKA_practice_end_flag==1) /* 練習終了の場合 */
			{
				if(MIKA_type_syuryou_flag==1||MIKA_type_syuryou_flag==2)	 /* 練習記録を更新した場合 */
				{
					MIKA_type_speed_record[MIKA_type_kind_no]=MIKA_type_speed; /* 練習記録 最高入力速度 文字数／分 を更新 */
					MIKA_type_word_speed_record[MIKA_type_kind_no]=MIKA_type_word_speed; /* 練習記録 最高入力速度 ワード／分 を更新 */
					MIKA_type_date_record[MIKA_type_kind_no]=MIKA_type_date; /* 練習記録 達成日を更新 */
					MIKA_type_syuryou_flag=0; /* 練習終了時の記録更新フラグ クリア */
				}
				MIKA_exec_func_no=funcbackmenu(MIKA_exec_func_no); /* メニューを一階層戻る */
				dispmen(g); /* メニュー表示 */
			}
		}
		else if((nChar==0x0d||nChar==0x0a)&&MIKA_practice_end_flag==1)	 /* 練習の終了時に改行が入力された場合 */
		{
			MIKA_practice_end_flag=0; /* 練習実行中フラグをクリア */
			if(MIKA_type_syuryou_flag==1||MIKA_type_syuryou_flag==2)	 /* 練習記録を更新した場合 */
			{
				MIKA_type_speed_record[MIKA_type_kind_no]=MIKA_type_speed; /* 練習記録 最高入力速度 文字数／分 を更新 */
				MIKA_type_word_speed_record[MIKA_type_kind_no]=MIKA_type_word_speed; /* 練習記録 最高入力速度ワード／分を更新 */
				MIKA_type_date_record[MIKA_type_kind_no]=MIKA_type_date; /* 練習記録 達成日を更新 */
			}
			MIKA_type_syuryou_flag=0; /* 練習終了時の記録更新フラグ クリア */
			prepflagsline(); /* 英文テキスト練習開始時のフラグクリア */
			dispmen(g); /* 英文テキスト練習画面 再表示 */
		}
		else if(MIKA_practice_end_flag==0) /* 練習実行中の場合 */
		{
//			System.out.printf("TYPE char %1c %1c\n",MIKA_key_char,nChar);a.charAt(i)
			if(MIKA_err_count>0&&nChar==0x08) /* エラー文字表示中にバックスペースにより訂正する場合 */
			{
				dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_bk_color); /* 現在位置カーソル消去 */
				MIKA_err_count--; /* エラー文字表示文字数 デクリメント */
				dispbkcharline(g,scroll_cord_x(),scroll_cord_y(),MIKA_bk_color); /* エラー文字の一番右の端の文字の背景をクリア */
				cslcolor(g,MIKA_bk_color); /* 表示色に背景色を設定 */
				cslputw(g,scroll_cord_x(),scroll_cord_y(),MIKA_err_c_table[MIKA_err_count]); /* エラー文字の一番右端の文字をクリア */
				dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_color_cursor); /* カーソルを一文字左に戻して表示 */
			}
			else if(MIKA_text_point_y>=MIKA_c_line[MIKA_current_point_x].length()) /* 行末に文字が入力された場合 */
			{
				if((nChar==0x20||nChar==0x0a||nChar==0x0d)&&MIKA_err_count==0) /* 入力された文字がスペースか改行の場合 */
				{
					dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_bk_color); /* 現在位置カーソル消去 */
					if(MIKA_text_point_y>0)
					{
						cslcolor(g,MIKA_key_blue); /* 表示色を青色に設定 */
						cslputw(g,scroll_cord_x(),scroll_cord_y()-8,MIKA_c_line[MIKA_current_point_x][MIKA_text_point_y-1]); /* 正解入力文字の一つ手前の文字を再表示 */
					}
					cslputu(g,scroll_cord_x(),scroll_cord_y(),"a",1,MIKA_color_text_under_line); /* 行末にアンンダーラインを表示 */
					MIKA_current_point_x++; /* 練習テキストの入力行の位置をインクリメント */
					if(MIKA_current_point_x>=MIKA_max_c_line) /* すべての練習テキストを入力し終わった場合 */
					{
							MIKA_practice_end_flag=1; /* 練習実行中フラグを終了にセット */
//							MIKA_Procttimer.cancel();		/* 入力速度表示の一秒間隔タイマーをキャンセル */
							KillTimer(hWnd,MIKA_Procttimer_ID); /* ガイドキー文字位置表示用タイマーをキャンセル */
							MIKA_disp_cursor_flag=0; /* カーソル表示フラグをクリア */
							MIKA_text_point_x++; /* 文字入力カーソル縦位置インクリメント */
							MIKA_text_point_y=0; /* 文字入力カーソル横位置をゼロに設定 */
							MIKA_utikiri_flag=1; /* 練習打ち切りフラグをセット */
							MIKA_utikiri_flag2=0; /* 前回練習速度消去用にフラグをクリア */
							MIKA_type_end_time= getmillisecond(); /* 現在時刻をミリ秒で取得 */
							MIKA_ttype_speed_time=(MIKA_type_end_time-MIKA_type_start_time)/1000.0; /* 経過秒を実数で計算 */
							procdispspeed3(g); /* 入力速度を表示 */
							MIKA_type_time_record[MIKA_type_kind_no]=MIKA_type_time_record[MIKA_type_kind_no]+(long)MIKA_ttype_speed_time; /* 累積練習時間の記録を加算 */
							dispkaisu3(g,1); /* 前回練習回数表示クリア */
							MIKA_p_count[MIKA_type_kind_no]++; /* 練習回数インクリメント */
							dispkaisu3(g,0); /* 今回練習回数表示 */
							prockiroku(g); /* 記録を更新時の処理 */
							cslrectt (g,21*16+8,0,24*16+8,80*8,MIKA_bk_color); /* リトライメッセージ背景クリア */
							dispretrymessage(g,0); /* リトライメッセージ表示 */
					}
					else
					{
						if(MIKA_text_point_x==5) /* 五行目の入力で改行したときは練習テキストを二行分上にスクロールする */
						{
							cslscroll(hWnd,MIKA_start_text_line,MIKA_double_text_hight,MIKA_rensyu_text_hight); /* 画面を二行分上方にコピー */
							if(MIKA_current_point_x+2<MIKA_max_c_line) /* 最下行に追加の練習テキスト表示がある場合 */
							{
								cslcolor(g,MIKA_key_black); /* 表示色を黒色に設定 */
								cslput(g,MIKA_start_text_line+MIKA_double_text_hight*7,0,MIKA_c_line[MIKA_current_point_x+2]); /* 最下行に練習テキスト表示 */
							}
							MIKA_scroll_point++; /* 画面スクロール表示の開始行位置をインクリメント */
						}
						else /* 行末の改行でスクロールしない場合 */
						{					
							MIKA_text_point_x++; /* 文字入力カーソル縦位置インクリメント */
						}
						MIKA_text_point_y=0; /* 文字入力カーソル横位置をゼロに設定 */
						dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_color_cursor); /* 文字入力カーソルを表示 */
					}
				}
				else /* 行末の入力文字がエラーの場合 */
				{
					procerrchar(g,nChar); /* エラー入力文字の処理 */
				}
			}
			else
			{	
				MIKA_key_char=MIKA_c_line[MIKA_current_point_x][MIKA_text_point_y]; /* 練習文字を取り出し */
				if	(MIKA_err_count==0&&MIKA_key_char==nChar) /* エラー文字表示がなくて入力が正解の場合  */
				{
				/* 正解の場合 */
					if(MIKA_time_start_flag==0) /* 最初の正解文字入力の場合 */
					{
						MIKA_type_start_time= getmillisecond();  /* 練習開始時間をミリ秒で取得取得 */
						MIKA_time_start_flag=1; /* 練習時間計測フラグセット */
//						MIKA_Procttimer = new Procttimer();/* タイマー取得 */
//						MIKA_timer.scheduleAtFixedRate(MIKA_Procttimer,MIKA_text_time_interval,MIKA_text_time_interval); /* タイマーを一秒間隔にセット */
						SetTimer(hWnd,MIKA_Procttimer_ID,MIKA_text_time_interval,NULL);  /* 一秒タイマー設定 */
					}
					dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_bk_color); /* 現在位置のカーソルを消去 */
					cslcolor(g,MIKA_key_blue); /* 表示色を青色に設定 */
					if(MIKA_text_point_y>0)
					{
						cslputw(g,scroll_cord_x(),scroll_cord_y()-8,MIKA_c_line[MIKA_current_point_x][MIKA_text_point_y-1]); /* 正解入力文字の一つ手前の文字を再表示 */
					}
					cslputw(g,scroll_cord_x(),scroll_cord_y(),nChar); /* 正解入力文字を表示 */
					cslputu(g,scroll_cord_x(),scroll_cord_y(),"a",1,MIKA_color_text_under_line); /* 正解文字入力にアンダーラインを描画 */
					MIKA_type_count++; /* 正解数を加算 */
					MIKA_text_point_y++; /* 文字入力カーソル横位置をインクリメント */
					dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_color_cursor); /* カーソルを新位置に表示 */
				}
				else /* 入力文字がエラーの場合 */
				{
						procerrchar(g,nChar); /* エラー入力文字の処理 */
				}
			}
		}
	}
	int scroll_cord_x() /* カーソル位置 縦 x 座標算出 */
	{	
		return(MIKA_double_text_hight*MIKA_text_point_x+MIKA_start_text_line+MIKA_rensyu_text_hight);
	}
	int scroll_cord_y() /* カーソル位置 横 y 座標算出 */
	{
		return((MIKA_text_point_y+MIKA_err_count)*8);
	}
	void procerrchar(HDC g,wchar_t nChar) /* エラー入力文字処理 */
	{
		if(0x20<=nChar&&nChar<=0x7E)/* エラー入力文字が表示可能文字の場合 */
		{
			disperror3(g,1); /* 前回エラー入力文数表示を消去 */
			MIKA_type_err_count++; /* エラー入力文字数カウンターをインクリメント */
			disperror3(g,0); /* 今回エラー入力文字数を表示 */		
			if(MIKA_text_point_y+MIKA_err_count<79) /* エラー文字入力位置が 行末でない場合 */
			{
				MIKA_err_c_table[MIKA_err_count]=nChar; /* エラー文字保存エリアにエラー文字を保存 */
				dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_bk_color); /* 現在カーソルを消去 */
				dispbkcharline(g,scroll_cord_x(),scroll_cord_y(),MIKA_color_text_err); /* エラー文字表示位置の背景を赤色表示 */
				cslcolor(g,MIKA_key_black); /* 表示色を黒色に指定 */
				cslbkcolor(g, MIKA_color_text_err); /* 背景色を赤色に設定 */
				if(MIKA_err_count>0)
				{
					cslputw(g,scroll_cord_x(),scroll_cord_y()-8,MIKA_err_c_table[MIKA_err_count-1]); /* 一つ手前のエラー文字を黒色で再表示 */
				}
				cslputw(g,scroll_cord_x(),scroll_cord_y(),nChar); /* エラー文字を黒色で表示 */
				MIKA_err_count++; /* エラー文字表示文字数をインクリメント */
				if(MIKA_text_point_y+MIKA_err_count<79) /* 次回表示カーソル位置が行末でない場合 */
				{
					dispcur(g,scroll_cord_x(),scroll_cord_y(),1,MIKA_color_cursor); /* カーソルを一つ進めて表示 */
				}
				else
				{
					dispcur(g,scroll_cord_x(),scroll_cord_y()-8,1,MIKA_color_cursor); /* カーソルを進めずに同じ位置に表示 */
				}
				cslbkcolor(g, MIKA_bk_color); /* 背景色を白色に戻す */
			}
			else /* エラー文字入力位置が行末の場合 */
			{
				cslcolor(g,MIKA_bk_color); /* 表示色に背景色を設定 */
//				cslput(g,scroll_cord_x(),scroll_cord_y()-8,String.valueOf(MIKA_err_c_table[MIKA_err_count])); /* 行末のエラー文字表示をクリア */
				MIKA_err_c_table[MIKA_err_count-1]=nChar; /* 行末の位置にエラー文字を保存 */
				dispcur(g,scroll_cord_x(),scroll_cord_y()-8,1,MIKA_bk_color); /* 行末のカーソルを消去 */
				cslcolor(g,MIKA_bk_color); /* 表示色に背景色を設定 */
				dispbkcharline(g,scroll_cord_x(),scroll_cord_y()-8,MIKA_color_text_err); /* エラー文字表示位置の背景を赤色で表示 */
				cslcolor(g,MIKA_key_black); /* 表示色を黒色に指定 */
				cslbkcolor(g, MIKA_color_text_err); /* 背景色を赤色に設定 */
				cslputw(g,scroll_cord_x(),scroll_cord_y()-8,nChar); /* エラー文字を黒色で表示 */
				cslbkcolor(g, MIKA_bk_color); /* 背景色を白色に戻す */
				dispcur(g,scroll_cord_x(),scroll_cord_y()-8,1,MIKA_color_cursor); /* カーソルを進めずに同じ位置に表示 */
			}
		}
	}
	void dispbkcharline(HDC g,int x,int y,COLORREF color) /* 入力文字の背景を指定色で塗りつぶす */
	{
		int x1,x2,y1,y2;
		RECT	rect1;
	    HBRUSH brush1;
   		y1=ycord(y); /* 開始 y座標 */
		x1=xcord(x); /* 開始 x座標 */
		y2=ycord(y+8); /* 終了 y座標 */
		x2=xcord(x+16); /* 終了 x座標 */
		rect1.left=y1;
		rect1.right=y2;
		rect1.top=x1;
		rect1.bottom=x2;
     	brush1 = CreateSolidBrush(color); /* 背景色でソリッドブラシを生成 */
        FillRect(g, &rect1, brush1); /* 入力文字の背景を指定色で塗りつぶし */
		DeleteObject(brush1); /* ブラシを破棄 */
	}
	void cslscroll(HWND g,int start_text_line,int double_text_hight,int rensyu_text_hight) /* 英文テキスト練習画面を上方に二行分スクロールする */
	{
	int x0;
	RECT rect_scroll, rect_scroll2, rect_scroll3;
	rect_scroll.top=xcord(start_text_line+double_text_hight); /* スクロール元 四角形 上端座標 */
	rect_scroll.bottom=MIKA_win_size.bottom; /* スクロール元 四角形 下端座標 */
	rect_scroll.left=MIKA_win_size.left;/* スクロール元 四角形 左端座標 */
	rect_scroll.right=MIKA_win_size.right;/* スクロール元 四角形 右端座標 */
	rect_scroll2.top=xcord(start_text_line); /* スクロール先 四角形 上端座標 */
	rect_scroll2.bottom=MIKA_win_size.bottom; /* スクロール先 四角形 下端座標 */
	rect_scroll2.left=MIKA_win_size.left; /* スクロール先 四角形 左端座標 */
	rect_scroll2.right=MIKA_win_size.right; /* スクロール先 四角形 右端座標 */
	x0=xcord(start_text_line+double_text_hight)-xcord(start_text_line); /* 縦スクロールドット数 */
	ScrollWindowEx(g,0,-x0,&rect_scroll,&rect_scroll2,NULL,&rect_scroll3,SW_ERASE|SW_INVALIDATE); /* スクロールを実行 */
	}
	void dispcur(HDC g,int x,int y,int width,COLORREF color) /* 文字入力カーソルを表示、または消去 */
	{ 
		int x1,x2,y1,y2;
		int xx1,yy1;
		int i;
		HPEN oldpen; /* 旧ペン */
		HPEN pen1; /* 新ペン */
		y1=ycord(y); /* カーソル 左上 y 座標取得 */
		yy1=ycord(width)-ycord(0); /* カーソルのy方向太さを取得 */
		x1=xcord(x); /* カーソル 左上 x 座標取得 */
		xx1=xcord(width)-xcord(0); /* カーソルのx方向の太さを取得 */ 
		y2=ycord(y+8); /* カーソル 右下 y 座標取得 */
		x2=xcord(x+16); /* カーソル 右下 x 座標取得 */
		pen1=CreatePen(PS_SOLID,1,color); /* 指定色でソリッドペン生成 */
        oldpen=(HPEN)SelectObject(g,pen1); /* ペンを設定 */
		for(i=0;i<xx1;i++) /* カーソルの横方向の上下の線を描画 */
		{
			MoveToEx(g,y1,x1+i,NULL);  /* ペンの位置をカーソルの左上に移動 */ 
			LineTo(g,y2,x1+i); /* 横方向にカーソルの上辺を描画 */
			MoveToEx(g,y1,x2-i,NULL);  /* ペンの位置をカーソルの左下に移動 */ 
			LineTo(g,y2,x2-i); /* 横方向にカーソルの下辺を描画 */
		}
		for(i=0;i<yy1;i++) /* カーソルの縦方向の左右の線を描画 */
		{
			MoveToEx(g,y1+i,x1,NULL);  /* ペンの位置をカーソルの左上に移動 */
			LineTo(g,y1+i,x2); /* 縦方向にカーソルの左辺を描画 */
			MoveToEx(g,y2-i,x1,NULL); /* ペンの位置をカーソルの右上に移動 */
			LineTo(g,y2-i,x2); /* 縦方向にカーソルの右辺を描画 */
		}
		SelectObject(g,oldpen); /* ペンを元に戻す */
		DeleteObject(pen1); /* ペンを削除 */
	}
	void dispupmes(HDC g,int flag) /* タイプ速度を更新したときのメッセージを表示 */
	{
		if(flag==0) cslcolor(g,MIKA_green); /* 表示色を緑色に設定 */
		else cslcolor(g,MIKA_bk_color); /* 表示色を背景色に設定 */
		cslput(g,20*16+8,20*8,MIKA_mesi3); /* 指定位置に「おめでとう、記録を更新しました」のメッセージを表示 */
	}
	void prockiroku(HDC g) /* 英文テキスト練習にてタイプ入力速度が前回までの最高速度を更新したかの比較を行う */
	{
		char type_date[9];
		if((MIKA_type_speed_record[MIKA_type_kind_no]==0.0)||(MIKA_type_speed>MIKA_type_speed_record[MIKA_type_kind_no])) /* 前回までの最高入力速度を更新した場合 */
		{
			if(MIKA_type_speed_record[MIKA_type_kind_no]>0.0) /* 前回の最高入力速度がゼロより大きい場合 */
			{
				dispupmes(g,0); /* 練習記録を更新しましたのメッセージを表示 */
				MIKA_type_syuryou_flag=2; /* 練習記録更新フラグを2にセット */
			}
			else /* 前回の最高入力速度がゼロの場合 */
			{
				MIKA_type_syuryou_flag=1; /* 練習記録更新フラグを1にセット */
			}
			_strdate_s(type_date,9); /* 現在日付取得 */
			convdate(MIKA_type_date,type_date); /* 日付の表示順序を mm/dd/yyから yy/mm/dd に変換 */
			_strtime_s(MIKA_type_time, 9); /* 現在時刻取得 */
			MIKA_t_mojisu[MIKA_type_kind_no]=MIKA_type_count; /* 英文練習テキスト文字数保存 */
			MIKA_file_error_hayasa=whayasa(); /* 最高速度記録ファイル書き込み */
		}
	}
double roundtime(double time) /* 小数点以下 切り捨て */
	{
		long time0;
		time0=(long)time; /* 浮動小数点を整数に変換 */
		time=time0; /* 整数を浮動小数点に変換 */
		return time;
	}
clock_t getmillisecond() /* プログラム開始からの経過時間をミリセコンドで取得 */
{
	clock_t millisecond;
	millisecond=clock(); /* プログラム開始からのミリセコンドを取得 */
	return(millisecond);
}
