//opol_math.js Copyright (c) 2018, Bachagi.h  <kitabaya@nifty.com>
//Licensed under the MIT license.
{
	////////////////////////////////////////////////////////////////////////
	//math.jsの５つのクラスをオーバーロード設定.
	//まずはmath.jsの便利関数をまるっと登録。
	////////////////////////////////////////////////////////////////////////
	//設定するクラスの一覧
	let mathlibs = [
		math.type.BigNumber,//Decimal
		math.type.Fraction,
		math.type.Complex,
		math.type.Matrix,
		math.type.Unit
	];
	for(let i=0; i<mathlibs.length; i++) {
		let __class = mathlibs[i];
		opol.operator(__class,"-@",  math.unaryMinus );//単項マイナス
		opol.operator(__class,"+"   ,math.add )
		opol.operator(__class,"-"   ,math.subtract );
		opol.operator(__class,"*"   ,math.multiply);
		opol.operator(__class,"/"   ,math.divide);
		opol.operator(__class,"%"   ,math.mod);
		opol.operator(__class,"**"  ,math.pow);
		opol.operator(__class,"=="  ,math.equal);
		opol.operator(__class,"!="  ,math.unequal);
		opol.operator(__class,">"   ,math.larger);
		opol.operator(__class,"<"   ,math.smaller);
		opol.operator(__class,">="  ,math.largerEq);
		opol.operator(__class,"<="  ,math.smallerEq);
		opol.operator(__class,"===" ,math.equal);
		opol.operator(__class,"!==" ,math.unequal);
		//opol.operator(__class,"&&"  ,math.and);
		//opol.operator(__class,"||"  ,math.or);
		opol.operator(__class,"&&"  ,function(L,fR){return L&&fR();});//fR()は右項評価クロージャ。短絡評価のため。
		opol.operator(__class,"||"  ,function(L,fR){return L||fR();});//fR()は右項評価クロージャ。短絡評価のため。
		opol.operator(__class,"!"   ,math.not);
		opol.operator(__class,"&"   ,math.bitAnd);
		opol.operator(__class,"|"   ,math.bitOr);
		opol.operator(__class,"^"   ,math.bitXor);
		opol.operator(__class,"~"   ,math.bitNot);
		opol.operator(__class,"<<"  ,math.leftShift);
		opol.operator(__class,">>"  ,math.rightArithShift);//算術右シフト
		opol.operator(__class,">>>" ,math.rightLogShift);//論理右シフト 符号ビットが0になる
		opol.operator(__class,"++"  ,function(L){ return L.add(1);} );
		opol.operator(__class,"--"  ,function(L){ return L.sub(1);} );
		//opol.operator(__class,"@++" ,function(L){ return L.add(1);} );
		//opol.operator(__class,"@--" ,function(L){ return L.sub(1);} );
		opol.operator(__class,"="   ,function(L,R){ return R;} );
		//代入系演算子の自動反映。 *= は * と同じ設定でよいため。個別が面倒な場合。
		opol.compound(__class);
	}

	////////////////////////////////////////////////////////////////////////
	//math.jsの便利関数は遅いので個別に設定。速度わりと違う。
	//複素数が実数の上位互換的に使えるように、mathjsで対応しない演算パタンは実部で計算する。
	//論理演算では左項がオブジェクトだと常に左項trueでつまらないので。数値としてみるように。
	let boolCpx = function(a){return !(a.isZero() || a.isNaN());};
	opol.operator(math.type.Complex,"-@"    ,function(L      ){return L.neg(L);});
	opol.operator(math.type.Complex,"+"     ,function(L,R    ){if( !L.add ) return R.add(L);return L.add(R);});
	opol.operator(math.type.Complex,"-"     ,function(L,R    ){if( !L.sub ) L = math.complex(L);return L.sub(R);});
	opol.operator(math.type.Complex,"*"     ,function(L,R    ){if( !L.mul ) return R.mul(L);return L.mul(R);});
	opol.operator(math.type.Complex,"/"     ,function(L,R    ){if( !L.div ) L = math.complex(L);return L.div(R);});
	opol.operator(math.type.Complex,"%"     ,function(L,R    ){return math.re(L) % math.re(R);});
	opol.operator(math.type.Complex,"**"    ,function(L,R    ){if( !L.pow ) L = math.complex(L); return L.pow(R);});
	opol.operator(math.type.Complex,"++"    ,function(L      ){return L.add(1);});
	opol.operator(math.type.Complex,"--"    ,function(L      ){return L.sub(1);});
	opol.operator(math.type.Complex,"=="    ,function(L,R    ){return (L.equals)? L.equals(R): R.equals(L);});
	opol.operator(math.type.Complex,"!="    ,function(L,R    ){return !((L.equals)? L.equals(R): R.equals(L));});
	opol.operator(math.type.Complex,">"     ,function(L,R    ){return math.re(L) >  math.re(R);});
	opol.operator(math.type.Complex,"<"     ,function(L,R    ){return math.re(L) <  math.re(R);});
	opol.operator(math.type.Complex,">="    ,function(L,R    ){return math.re(L) >= math.re(R);});
	opol.operator(math.type.Complex,"<="    ,function(L,R    ){return math.re(L) <= math.re(R);});
	opol.operator(math.type.Complex,"==="   ,function(L,R    ){return   (L.equals)? L.equals(R) :  R.equals(L) ;});
	opol.operator(math.type.Complex,"!=="   ,function(L,R    ){return !((L.equals)? L.equals(R) :  R.equals(L));});
	opol.operator(math.type.Complex,"&&"    ,function(L,fR   ){return boolCpx(L)? fR() : L;});
	opol.operator(math.type.Complex,"||"    ,function(L,fR   ){return boolCpx(L)? L : fR();});
	opol.operator(math.type.Complex,"!"     ,function(L      ){return !boolCpx(L);});
	opol.operator(math.type.Complex,"&"     ,function(L,R    ){return  math.re(L) &   math.re(R);});
	opol.operator(math.type.Complex,"|"     ,function(L,R    ){return  math.re(L) |   math.re(R);});
	opol.operator(math.type.Complex,"^"     ,function(L,R    ){return  math.re(L) ^   math.re(R);});
	opol.operator(math.type.Complex,"~"     ,function(L      ){return ~math.re(L)               ;});
	opol.operator(math.type.Complex,"<<"    ,function(L,R    ){return  math.re(L) <<  math.re(R);});
	opol.operator(math.type.Complex,">>"    ,function(L,R    ){return  math.re(L) >>  math.re(R);});
	opol.operator(math.type.Complex,">>>"   ,function(L,R    ){return  math.re(L) >>> math.re(R);});
	opol.operator(math.type.Complex,"?"     ,function(C,fL,fR){return boolCpx(C)? fL() : fR();});
	opol.operator(math.type.Complex,"||~"   ,function(L,R    ){
		if( !(L instanceof math.type.Complex)) L=math.complex(L);
		if( L.equals(0) && R.equals(0) ) return math.complex(0);
		return L.mul(R).div(L.add(R));
	}); //||~ (z1*z2)/(z1+z2)
	opol.compound(math.type.Complex);//複合代入系演算子を一括設定
}

