//opol.js relese 1.0 Copyright (c) 2018, Bachagi.h <kitabaya@nifty.com>
//Licensed under the MIT license.
{
	const global = Function("return this")();//window
	const src2ast = function(src) { return Chiffon.parse(src); };	//使用するパーサーを指定
	const ast2src = function(node) { return astring.generate(node); }; //使用するジェネレータを指定
	const clone = function(node){ return JSON.parse(JSON.stringify(node)); };
	//const debugPrint = console.log;
	const debugPrint = function(){};
	//////////////////////////////////////////////////////////////////////////
	//プログラムのトランスパイル
	global.opol = function(src){ return opol.transpile(src.toString() ); };
	////////////////////////////////////////////////////////////////////////////
	//演算子ごとの定義
	const optbl = {
		//     : { func:通常演算処理          ,ptn:オーバーロード雛形}
		"-@"   : { func:(L,R)  => -L          ,ptn:'opol.opu("-@"  ,L  ) '},
		"+"    : { func:(L,R)  => L +   R     ,ptn:'opol.opb("+"   ,L,R) '},
		"-"    : { func:(L,R)  => L -   R     ,ptn:'opol.opb("-"   ,L,R) '},
		"*"    : { func:(L,R)  => L *   R     ,ptn:'opol.opb("*"   ,L,R) '},
		"/"    : { func:(L,R)  => L /   R     ,ptn:'opol.opb("/"   ,L,R) '},
		"%"    : { func:(L,R)  => L %   R     ,ptn:'opol.opb("%"   ,L,R) '},
		"**"   : { func:(L,R)  => L **  R     ,ptn:'opol.opb("**"  ,L,R) '},
		"=="   : { func:(L,R)  => L ==  R     ,ptn:'opol.opb("=="  ,L,R) '},
		"!="   : { func:(L,R)  => L !=  R     ,ptn:'opol.opb("!="  ,L,R) '},
		">"    : { func:(L,R)  => L >   R     ,ptn:'opol.opb(">"   ,L,R) '},
		"<"    : { func:(L,R)  => L <   R     ,ptn:'opol.opb("<"   ,L,R) '},
		">="   : { func:(L,R)  => L >=  R     ,ptn:'opol.opb(">="  ,L,R) '},
		"<="   : { func:(L,R)  => L <=  R     ,ptn:'opol.opb("<="  ,L,R) '},
		"==="  : { func:(L,R)  => L === R     ,ptn:'opol.opb("===" ,L,R) '},
		"!=="  : { func:(L,R)  => L !== R     ,ptn:'opol.opb("!==" ,L,R) '},
		"&&"   : { func:(L,fR) => L &&  fR()  ,ptn:'opol.opl("&&"  ,L,()=>R) '},
		"||"   : { func:(L,fR) => L ||  fR()  ,ptn:'opol.opl("||"  ,L,()=>R) '},
		"!"    : { func:(L)    => !L          ,ptn:'opol.opu("!"   ,L  ) '},
		"&"    : { func:(L,R)  => L &   R     ,ptn:'opol.opb("&"   ,L,R) '},
		"|"    : { func:(L,R)  => L |   R     ,ptn:'opol.opb("|"   ,L,R) '},
		"^"    : { func:(L,R)  => L ^   R     ,ptn:'opol.opb("^"   ,L,R) '},
		"~"    : { func:(L)    => ~L          ,ptn:'opol.opu("~"   ,L  ) '},
		"<<"   : { func:(L,R)  => L <<  R     ,ptn:'opol.opb("<<"  ,L,R) '},
		">>"   : { func:(L,R)  => L >>  R     ,ptn:'opol.opb(">>"  ,L,R) '},
		">>>"  : { func:(L,R)  => L >>> R     ,ptn:'opol.opb(">>>" ,L,R) '},
		"="    : { func:(L,R)  => R           ,ptn:'opol.asb("="   ,(v)=>L=v,L,R) '},
		"+="   : { func:(L,R)  => L +   R     ,ptn:'opol.asb("+="  ,(v)=>L=v,L,R) '},
		"-="   : { func:(L,R)  => L -   R     ,ptn:'opol.asb("-="  ,(v)=>L=v,L,R) '},
		"*="   : { func:(L,R)  => L *   R     ,ptn:'opol.asb("*="  ,(v)=>L=v,L,R) '},
		"/="   : { func:(L,R)  => L /   R     ,ptn:'opol.asb("/="  ,(v)=>L=v,L,R) '},
		"%="   : { func:(L,R)  => L %   R     ,ptn:'opol.asb("%="  ,(v)=>L=v,L,R) '},
		"**="  : { func:(L,R)  => L **  R     ,ptn:'opol.asb("**=" ,(v)=>L=v,L,R) '},
		"&="   : { func:(L,R)  => L &   R     ,ptn:'opol.asb("&="  ,(v)=>L=v,L,R) '},
		"|="   : { func:(L,R)  => L |   R     ,ptn:'opol.asb("|="  ,(v)=>L=v,L,R) '},
		"^="   : { func:(L,R)  => L ^   R     ,ptn:'opol.asb("^="  ,(v)=>L=v,L,R) '},
		"<<="  : { func:(L,R)  => L <<  R     ,ptn:'opol.asb("<<=" ,(v)=>L=v,L,R) '},
		">>="  : { func:(L,R)  => L >>  R     ,ptn:'opol.asb(">>=" ,(v)=>L=v,L,R) '},
		">>>=" : { func:(L,R)  => L >>> R     ,ptn:'opol.asb(">>>=",(v)=>L=v,L,R) '},
		"++"   : { func:(L)    => L+1         ,ptn:'opol.asu("++"  ,(v)=>L=v,L)   '},
		"--"   : { func:(L)    => L-1         ,ptn:'opol.asu("--"  ,(v)=>L=v,L)   '},
		"@++"  : { func:(L)    => L+1         ,ptn:'opol.asp("@++" ,(v)=>L=v,L)   '},
		"@--"  : { func:(L)    => L-1         ,ptn:'opol.asp("@--" ,(v)=>L=v,L)   '},
		"||~"  : { func:(L,R)  => (L===0&&R===0)?0 : (L*R)/(L+R) ,ptn:'opol.opb("||~" ,L,R) '},
		"?"    : { func:(C,fL,fR) => (C)? fL() : fR() ,ptn:'opol.opc("?"  ,C,()=>L,()=>R) '},
		//typeof delete void instanceof等の演算子は非対応
	};
	const D={};
	//演算子処理テーブルの前処理
	for( let ops in optbl ) {
		optbl[ops].ast = src2ast(optbl[ops].ptn).body[0].expression;//オーバーロード雛形をASTに変換しておく。
		D[ops] = optbl[ops].func;//通常の演算子処理
	}
	////////////////////////////////////////////////////////////////////////////
	//トランスパイル
	opol.transpile = function(src){
		const node = src2ast(src); //元ソースを構文解析しast木を取得
		debugPrint("src2ast=" , node);
		nodeConv(node,"",null); //演算子を関数呼び出しに置換
		let dst = ast2src(node); //ソースを生成
		if( node.body[0].type === "FunctionDeclaration" ) dst = "("+ dst + ")";//関数は式に
		dst = dst.replace( /;\n$/,"");//式の場合、末尾の;を削除。
		debugPrint("変換結果:" + dst );
		return dst;
	};
	//nodeを指定して演算子部分を関数に置換
	const nodeConv = function(node,name,parent_node){
		if( node && typeof node === "object" ) {
			for( let key in node) {
				nodeConv( node[key], key, node);
			}
			switch(node.type){
			case 'BinaryExpression'://2項演算子
			case 'LogicalExpression'://&&論理演算
			case 'AssignmentExpression'://代入演算子
				opConv(node,name,parent_node, node.left,node.right);
				break;
			case 'UnaryExpression'://単項演算子
			case 'UpdateExpression'://++,--演算子
				opConv(node,name,parent_node, node.argument);
				break;
			case 'ConditionalExpression'://条件演算子
				opConv(node,name,parent_node, node.consequent,node.alternate,node.test);
				break;
			}
		}
	};
	//演算子1箇所指定してを関数呼び出しに置換する
	const opConv = function(node, name, parent_node, nodeL, nodeR, nodeC){
		let ops = node.operator;
		if( node.type === 'UnaryExpression' && ops === '-' ) ops = "-@";//2項マイナスと別名に
		if( node.prefix===false && (ops==="++" || ops==="--") ) ops = "@" + ops;//a++,a--//前置と別名に
		if( node.type === 'ConditionalExpression' ) ops = '?';//条件演算子
		if( ops in optbl ) {
			let ast = clone( optbl[ops].ast );//置換雛形取得
			convLR(ast,"expression",null,nodeL, nodeR, nodeC);//雛形のL,Rを本物に置換
			debugPrint( "convLR結果=", ast )
			parent_node[name] = ast;//本体を関数呼び出し形式に置換
		}//無い場合は置換しない。
	};
	//演算子関数呼出し雛形ASTを、実際の左項、右項目のnodeに差し替える
	const convLR = function(ast, name, parent_ast, nodeL, nodeR, nodeC){
		if( ast && typeof ast === "object" ) {
			for( let key in ast) {
				convLR( ast[key],key, ast, nodeL, nodeR, nodeC);
			}
			if( ast.type === "Identifier" ){
				if( nodeL && ast.name === "L" ) parent_ast[name] = nodeL;
				if( nodeR && ast.name === "R" ) parent_ast[name] = nodeR;
				if( nodeC && ast.name === "C" ) parent_ast[name] = nodeC;
			}
		}
	};
	////////////////////////////////////////////////////////////////////////
	//クラスに演算子処理関数を登録する。
	opol.operator = function(__class,ops,func) {
		const className = __class.name || "className";
		let err = false;
		if( typeof __class !== "object" && typeof __class !== "function" ) {
			console.warn( "opol.operator([" + className + "],'" + ops + "', function) is not class." );
			err = true;//引数__classの型が不正。
		}
		if( typeof optbl[ops] !== "object" ) {
			console.warn( "opol.operator(" + className + ",['" + ops + "'], function) unsupported operator." );
			err = true;//引数opsが不正。不明な演算子。
		}
		if( typeof func !== "function" ) {
			console.warn( "opol.operator(" + className + ",'" + ops + "', [function]) is not functiond." );
			err = true;//引数funcが関数ではない
		}
		__class.prototype[ops] = func;//登録
		if( ops === "++" || ops === "--" ) {
			__class.prototype["@" + ops] = func;//++,--の場合後置の場合の設定も行う。
		}
		return err;
	};
	//複合代入演算子を一括適用。*= に * の関数を適用する。
	opol.compound = function(__class){
		if( "+"   in __class.prototype ) opol.operator(__class,"+="  ,__class.prototype["+"] );
		if( "-"   in __class.prototype ) opol.operator(__class,"-="  ,__class.prototype["-"] );
		if( "*"   in __class.prototype ) opol.operator(__class,"*="  ,__class.prototype["*"] );
		if( "/"   in __class.prototype ) opol.operator(__class,"/="  ,__class.prototype["/"] );
		if( "%"   in __class.prototype ) opol.operator(__class,"%="  ,__class.prototype["%"] );
		if( "**"  in __class.prototype ) opol.operator(__class,"**=" ,__class.prototype["**"] );
		if( "&"   in __class.prototype ) opol.operator(__class,"&="  ,__class.prototype["&"] );
		if( "|"   in __class.prototype ) opol.operator(__class,"|="  ,__class.prototype["|"] );
		if( "^"   in __class.prototype ) opol.operator(__class,"^="  ,__class.prototype["^"] );
		if( "<<"  in __class.prototype ) opol.operator(__class,"<<=" ,__class.prototype["<<"] );
		if( ">>"  in __class.prototype ) opol.operator(__class,">>=" ,__class.prototype[">>"] );
		if( ">>>" in __class.prototype ) opol.operator(__class,">>>=",__class.prototype[">>>"] );
	};
	////////////////////////////////////////////////////////////////////////
	//実行時演算子処理実体
	opol.opb = (ops,L,R) => ((L&&L[ops]) || (R&&R[ops]) || D[ops])(L,R); //2項演算
	opol.opu = (ops,L) => ( (L&&L[ops]) || D[ops])(L); //単項演算
	opol.asb = (ops,setter,L,R) => setter( ((L&&L[ops]) || (R&&R[ops]) || D[ops])(L,R) ); //2項代入演算
	opol.asu = (ops,setter,L) => setter((L[ops] || D[ops])(L)); //前置単項更新(++a.--a)
	opol.asp = (ops,setter,L) => (setter((L[ops] || D[ops])(L) ), L); //後置単項更新(a++.a--)
	opol.opl = (ops,L,fR) => ((L&&L[ops]) || D[ops])(L,fR); //2項論理演算。右辺をクロージャ渡し。
	opol.opc = (ops,C,fL,fR) => ((C&&C[ops]) || D[ops])(C,fL,fR); //3項条件演算
}
