//ooCons.js Copyright (c) 2018, Bachagi.h <kitabaya@nifty.com>
//Licensed under the MIT license.
////////////////////////////////////////////////////////////////////////////////
//コンソール
function ooCons(_topId){
	const self = this;
	//const topId = _topId;
	const elemTop = document.getElementById(_topId);
	const oo_cons_input = elemTop.getElementsByClassName("oo_cons_input")[0];
	const oo_cons_table = elemTop.getElementsByClassName("oo_cons_table")[0];

	//入力部のリサイズ
	const textareaResize = function(ta){
		let lineHeight = parseInt(window.getComputedStyle(ta).lineHeight)||1; //実際の行間
	    ta.style.height = (lineHeight*2) + "px";//一旦小さく
		if( ta.scrollHeight > ta.offsetHeight ){
		    ta.style.height = ta.scrollHeight+'px';
		}
		scrollEnd();
	};
	//全体を最後にスクロールする
	const scrollEnd = function(){
		elemTop.scrollTop = elemTop.scrollHeight;
	};

	////////////////////////////////////////////////////////////////////////////////
	//ログ出力処理

	//ログ部分をクリア
	const logclear = function(){
		let e = oo_cons_table;
		while( e.rows.length >= 2 ){
			e.deleteRow(0);
		}
	};
	//ログを出力。htmlで指定
	const tr_insert_html = function(prompt_html,text_html){
		let th = document.createElement("th");
		th.insertAdjacentHTML('beforeend', prompt_html);
		let td = document.createElement("td");
		if( typeof text_html === "string" ) {
			td.insertAdjacentHTML('beforeend', text_html);//html文字列の場合
		} else {
			td.appendChild(text_html);//オブジェクトの場合
		}
		td.classList.add( "oo_cons_log_td" );
		let rows = oo_cons_table.rows.length;
		let tr = oo_cons_table.insertRow(rows-1);
		tr.appendChild(th);
		tr.appendChild(td);
		return tr;
	};
	//シンプルなログ出力。色指定可
	const log = function(prompt,text,color){
		let tr = tr_insert_html(esc(prompt), esc(text) );
		if(color) tr.style.color = color;
	};
	//結果出力、折り畳たたみ式
	self.log_folding = function(prompt,log_html,detail_html,style,className){
		let __class = (className)? `class="${className}"` : "";
		let __style = style || "";
		let html = `
			<a href="javascript:void(0)" onclick="ooCons.nextObjonoff(this)" ${__class} style="${__style}">
				${this.esc(log_html)}
			</a>
			<div style="display:none;opacity:0.6;${__style}" ${__class}>
				${detail_html}
			<div>
			`;
		tr_insert_html(esc(prompt),html);
	};
	//結果出力、例外表示。catchしたeを渡して折りたたみ出力
	self.log_exception = function(e){
		self.log_folding("!",e.message,decodeURIComponent(e.stack),"color:red");
	};

	////////////////////////////////////////////////////////////////////////////////////////
	//オブジェクトダンプログ出力
	const obj2elem = function(name,obj,level,opacity){
		let oocons={data:obj, level:level, created:false,opacity:opacity  };
		let div = document.createElement("div");

		div.appendChild(document.createTextNode(name+" : "));
		div.style.opacity = opacity;

		if( Array.isArray(obj) ) {
			div.appendChild(document.createTextNode("["));
			let a = html2elem('<a href="javascript:void(0)" onclick="ooCons.nextObjonoff(this)">▼</a>');
			a.oocons = oocons;
			div.appendChild(a);
			div.appendChild(document.createTextNode("]"));
			div.appendChild(document.createElement("br"));
		} else if( obj!=null && typeof obj === "object" || typeof obj === "function" ) {
			if(  typeof obj === "function" ) div.appendChild(document.createTextNode("f()"));
			if(  Object.keys(obj).length > 0 ) {
				div.appendChild(document.createTextNode("{"));
				let a = html2elem('<a href="javascript:void(0)" onclick="ooCons.nextObjonoff(this)">▼</a>');
				a.oocons = oocons;
				div.appendChild(a);
				div.appendChild(document.createTextNode("}"));
			}
			div.appendChild(document.createElement("br"));
		} else {
			div.appendChild(document.createTextNode(obj));
			div.appendChild(document.createElement("br"));
		}


		return div;
	};

	//aタグ▼部分クリックでオブジェクトの中身を展開した要素を生成。aタグの子として生成する。
	const genChild = function (elem,opacity){
		let obj = elem.oocons.data;
		let level = elem.oocons.level+1;
		let indent = 4 *level;
		let div = document.createElement("div");
		let objdiv = html2elem(`<div style='display:block;padding-left:${indent}px;'>`);
		if( Array.isArray(obj) ) {
			for(let i=0;i<obj.length; i++){
				let c = obj2elem("["+i+"]",obj[i],level,opacity);
				objdiv.appendChild( c );
			}
		} else if( typeof obj === "object" ||  typeof obj === "function" ) {
			//重要な順に表示
			let ownProp=[], ownFunc=[], noOwnProp=[], noOwnFunc=[];
			for(const key in obj){
				const c = obj2elem(key,obj[key],level,opacity);
				const isOwnProp = obj.hasOwnProperty(key);
				const isObject = typeof obj[key] !== "function";
				if( isOwnProp  &&  isObject ) { ownProp.push(c); }
				if( isOwnProp  && !isObject ) { ownFunc.push(c); }
				if( !isOwnProp &&  isObject ) { noOwnProp.push(c); c.style.opacity = opacity*0.7;}
				if( !isOwnProp && !isObject ) { noOwnFunc.push(c); c.style.opacity = opacity*0.7;}
			}
			for(let c of ownProp) objdiv.appendChild( c );
			for(let c of ownFunc) objdiv.appendChild( c );
			for(let c of noOwnProp) objdiv.appendChild( c );
			for(let c of noOwnFunc) objdiv.appendChild( c );
		}
		div.appendChild(objdiv);
		elem.oocons.created = true;
		return div;
	};
	//▼部分クリック時呼び出し関数
	ooCons.nextObjonoff = function(elem){
		if( elem.oocons && elem.oocons.created === false ) {
			//次の要素が無い場合生成する。
			//elem.oocons.created = true;
			let child = genChild(elem, elem.oocons.opacity);
			elem.parentNode.insertBefore(child, elem.nextSibling);
		}
		const style = elem.nextElementSibling.style;//<a>の次の要素
		style.display = ( style.display !== "block" ) ? "block" : "none";
		switch(elem.innerText){
		case "▼": elem.innerText="▲"; break;
		case "▲": elem.innerText="▼"; break;
		}

	};
	//htmlを指定してその要素を生成
	const html2elem = function(html) {
		const dummy = document.createElement('div');
		dummy.innerHTML = html;
		return dummy.firstElementChild;
	}

	////////////////////////////////////////////////////////////////////////////////////////
	//htmlエスケープ
	const esc = self.esc = function(string) {
		if(typeof string !== 'string') {
			return string;
		}
		return string.replace(/[&'`"<>]/g, function(match) {
			return {
				'&': '&amp;',
				"'": '&#x27;',
				'`': '&#x60;',
				'"': '&quot;',
				'<': '&lt;',
				'>': '&gt;',
			}[match]
		});
	};

	////////////////////////////////////////////////////////////////////////////////
	//キー入力ヒストリー
	function Hist(){
		let self = this;
		self.load = () => JSON.parse( localStorage.getItem("hist") || "[]");
		self.save = function(){
			if( self.list.length > 100 ) self.list.shift();
			if( self.no > self.list.length ) self.no = self.list.length;
			localStorage.setItem("hist", JSON.stringify(self.list));
		};
		self.list = self.load() || [];
		self.no = self.list.length;
		self.backward = function(){
			if( --self.no < 0 ) self.no = 0;
			self.save();
			return self.list[self.no];
		};
		self.foward = function(){
			if( ++self.no >= self.list.length ) self.no = self.list.length-1;
			self.save();
			return self.list[self.no];
		};
		self.push = function(str){
			if( str === "" ) return; //空欄は何もしない。
			self.no = self.list.length;
			self.list.push(str);
			self.no = self.list.length;
			self.save();
		};
	};
	let hist = new Hist();

	////////////////////////////////////////////////////////////////////////////////
	//キーイベント処理
	//履歴機能　上キー
	const ArrowUp = function(e){
		e.target.value = hist.backward();
	};
	//履歴機能　下キー
	const ArrowDown = function(e){
		e.target.value = hist.foward();
	};
	//エンター入力
	const keyEnter = function(e){
		let inputtext = e.target.value;
		if( inputtext === "" ) return; //空欄は何もしない。
		hist.push(inputtext);

		//実際処理の呼び出し
		if( self.onInput ) self.onInput.call(self,inputtext);
		e.target.value = "";
	};
	//タブ入力
	const onKeyTab = function(e){
		let pos = e.target.selectionStart;
		e.target.value = e.target.value.substr(0, pos) + "\t" + e.target.value.substr(pos);
		e.target.setSelectionRange(pos+1, pos+1);
		e.preventDefault();
	};
	//キーダウン
	const onKeyDown = function(e){
		//console.log(e);
		let flag=false;
		switch( e.key ) {
		case "Enter"    : keyEnter(e);  flag = true; break;
		case "ArrowUp"  : ArrowUp(e);   flag = true; break;
		case "ArrowDown": ArrowDown(e); flag = true; break;
		case 'Tab' : onKeyTab(e); return;
		default: break;
		}
		if( flag ) {
			e.target.selectionStart = e.target.selectionEnd = e.target.value.length;
			e.preventDefault();
		}
		textareaResize(this);
	};
	//キーイベントの設定
	oo_cons_input.addEventListener('keydown', onKeyDown);
	oo_cons_input.addEventListener('keyup', function(e){textareaResize(this);} );


	////////////////////////////////////////////////////////////////////////////////
	//コンソール入力のコールバック
	self.onInput = function(text){
		text = text.trim();
		if( text.match( /^clear\b/ ) ) {
			logclear();
			return;
		}
		//コンソール入力はブロックスコープが終わってしまうので外部変数に。
		//text = text.replace( /^((let[\s]*)|(const[\s]*))/, "var " );
		//text = text.replace( /^function[\s]+?(.+?)\(/, "var $1 = function(" );
		text = input_support(text);//入力サポート
		let code=undefined;
		let ret=undefined;
		try{
			code = opol(text);
			ret = (0,eval)(code);//evalを別名にしてグローバルスコープで実行
			self.log_folding(">",text, "transpile code : " + code, "color:block");//入力ログ＆変換ログ
		}catch(e){
			self.log_folding(">",text, "transpile code : " + code, "color:gray");//入力ログ＆変換ログ
			self.log_exception(e);//例外の表示
			console.error(e);
			return;
		}
		//結果のログ出力
		if( typeof ret === "object" ){ //オブジェクトの場合展開できる形で出力
			tr_insert_html(esc("<"),obj2elem(ret,ret,1,1));
		} else if( ret === undefined ) {//地味に表示
			log( "<", "undefined", "#a0a0a0");
		} else { //オブジェクトではない場合、普通に出力
			log( "<", ret+"", "black");
		}
	};
	////////////////////////////////////////////////////////////////////////////////
	const input_support = function(text){
		//コンソール入力はブロックスコープが終わってしまうので外部変数に。
		let ptn = /^((let[\s]*)|(const[\s]*)|(set[\s]*))/;
		if( text.match(ptn)){
			log("<" , "message : let,const,set converted to var", "#888" );
			text = text.replace(ptn, "var " );
		}
		ptn = /^function[\s]+?(.+?)\(/;
		if( text.match(ptn)){
			log("<" , "message : function converted to variable", "#888" );
			text = text.replace( ptn, "var $1 = function(" );
		}
		return text;
	};
};

