Program TrainPositionDisplay;
(* Display Train Positions
  TRNMN03     first release
  TRNMN04     micro PS -> cache PS.
              change in efferent train display.
              saving memory.
  TRNMN05     OOP,
              Dialogs,
              Long Timetable data available,
              Train data sub fields,
              Train position update thread (UpdateTrnPos)
                is once killed at WS_SIZE
              Simple algorithm for over-24hour train
  TRNMN07B    for SP/2 1.5
  TRNMN07C    Dual window
  TRNMN07D    Encapsulation willing..
  TRNMN08     Diagram
  TRNMN09     Trains and rails are displayed with BMP.
  TRNMN09a    Redisplay of trains is done in the 2nd thread.
              Display selected / focused train.
  TRNMN09b    Search train, File I/O done in their threads.
  TRNMN09c    micro PS -> cache PS, experimental
              SetViewParam cannot affect GpiBitBlt, so this expm.
              not successfully.  only 50k bytes saved.
  TRNMN09d    Some Dialog Boxed Added
  TRNMN09e    RailMagn can be changed by user
  TRNMN09f    English Version of TRNMN09e
*)
uses DOS, OS2DEF, CMDEF, PmWin, PmGpi, PmStdDlg, BSEDOS, BSEERR, PmBitMap;
{$R+,I-,S+}
{$R TRNMN09f}
const
  maxstn        = 80;
  maxstn2       = 160; (* maxstn * 2 *)
  maxtrn        = 500;
  RailWidth     = 6;
  StdRailMagn   = 4;
  MinXscrn      = 400;
  MinYscrn      = 300;
  StdDelayTime  = 300;
  StnNameSize   = 20;
  TrnIDsize     = 10;
  TrnNameSize   = 30;
  RailBMPWidth  = 128;
  RailBMPHeight = 3;
  IndicatorHeight = 8;
  AnHour        = 240;
  TrainWndClass = 'Train';
  AppTitle      = 'TRNMN';
  DiaWndClass   = 'Dia';
  DiaTitle      = 'DIAGRAMME';
  DiaLineClass  = 'DiaLine';
  DiaStnClass   = 'DiaStn';
  DefaultPref   = 'DEFAULT.CFG';
  vers          = 'beta 0.9';
  DefaultFont   = 0;
  TrainFont     = 1;
  DiagrammeFont = 2;
  WM_USER0      = WM_USER;
  WM_USER1      = WM_USER + 1;
  WM_USER2      = WM_USER + 2;
  WM_USER4      = WM_USER + 4;
  TimerID       = 1;
  MP_TrainSelected = 1;
  MP_TrainFocused  = 2;
  ID_TRAIN      = 200;
  ID_DIA        = 201;
  IDM_FILE      = 300;
  IDM_LOAD      = 301;
  IDM_QUIT      = 302;
  IDM_ABOUT     = 310;
  IDM_SETPREF   = 320;
  IDM_SETTIME   = 321;
  IDM_SETFONT   = 322;
  IDM_LOADPREF  = 323;
  IDM_SAVEPREF  = 324;
  IDM_SETTRAINDISP   = 325;
  IDM_DIAGRAMME = 330;
  IDM_OPENDIAGRAMME  = 331;
  IDM_CLOSEDIAGRAMME = 332;
  IDM_SETDIAPREF= 340;
  IDM_SETDIAFONT= 341;
  IDM_SETDIASIZE= 342;
  IDM_REVERSE   = 351;
  IDM_STOPRUN   = 352;
  IDM_FORWARD   = 353;
  IDD_ABOUT     = 410;
  IDD_SETPREF   = 420;
  IDD_SETDELAY  = 421;
  IDD_HOUR1     = 422;
  IDD_HOUR2     = 423;
  IDD_MIN1      = 424;
  IDD_MIN2      = 425;
  IDD_SIGN      = 426;
  IDD_SELECTEDTRAINTIME = 427;
  IDD_TRAINDISPPREF  = 431;
  IDD_DISPTRAINID    = 432;
  IDD_DISPSELECTEDTRAINBMP = 433;
  IDD_DISPTRAINBMP   = 434;
  IDD_DISTANCE  = 435;
  IDD_SETDIASIZE= 440;
  IDD_SETDIAMULX= 441;
  IDD_SETDIAMULY= 442;

type
  stationnum    = 1..maxstn;
  stationnum0   = 0..maxstn;
  trainnum      = 1..maxtrn;
  trainnum0     = 0..maxtrn;
  passingstatus = (afferentatform, nopassing,
                   gointo, passing, atform);
  stndata       = record
    name        : string[StnNameSize];
    distance    : integer;
    position    : POINTL;
    stoptrn     : trainnum0;
    passingstat : passingstatus;
    doubletrack : boolean
  end;
  direction     = (efferent, afferent);
  timing        = record
    arrival,
    departure   : integer
  end;
  dialineary    = array[1..maxstn2] of POINTL;
  pdialineary   = ^dialineary;
  dialine       = record
    plineary    : pdialineary;
    size,
    count       : integer;
    trnid       : string[TrnIDsize];
    trndr       : direction;
    minT, maxT,
    minD, maxD  : word
  end;

(* abstruct train class *)
  runside       = (runupper, runlower);
  timedata      = array[stationnum] of timing;
  train         = object
    id          : string[TrnIDsize];
    name        : string[TrnNameSize];
    starttime,
    endtime     : integer;
    startstn,
    endstn      : stationnum;
    currentstn  : stationnum0;
    time        : timedata;
    position,
    oldposition : POINTL;
    trainWidth,
    trainHeight : integer;
{    ddx         : integer;}
    ddx         : LONG;
    index       : trainnum;
    selected,
    focused,
    exists,
    displayed   : boolean;
    side        : runside;
    drct        : direction;
    constructor init(initid,  initname : string;
                     initdirect  : direction;
                     initstartstn,
                     initendstn  : stationnum;
                     initstarttime,
                     initendtime : integer;
                     initindex   : trainnum;
                     var initTimeTbl : timedata);
    function  getstarttime : integer;
    function  getendtime   : integer;
    function  getstartstn  : stationnum;
    function  getendstn    : stationnum;
    function  getid        : string;
    function  getname      : string;
    function  getdirection : direction;
    function  getfocused   : boolean;
    function  getdisplayed : boolean;
    function  atHere(checkpos : POINTS) : boolean;
    procedure setdisplayed(initDisplayed : boolean);
    procedure setfocused(initFocused : boolean);
    procedure calcposition(currenttime : integer);
    procedure setTrainWidth(initTW : integer); virtual;
    procedure setTrainHeight(initTH : integer); virtual;
    procedure adjustX(incX : integer);
{    procedure adjustY(incY : integer);}
    procedure adjustY(incY : LONG); virtual;
    procedure show(initHP : HPS); virtual;
    procedure hide(initHP : HPS); virtual;
    procedure hideold(initHP : HPS); virtual;
    procedure move(initHP : HPS);
    procedure makedialine(var dline : dialine);
    destructor done; virtual;
  end;
  ptrain        = ^train;

(* train drawed with charactors *)

  chrtrain      = object(train)
    procedure adjustY(incY : LONG); virtual;
    procedure show(initHP : HPS); virtual;
    procedure hide(initHP : HPS); virtual;
    procedure hideold(initHP : HPS); virtual;
    destructor done; virtual;
  end;
  pchrtrain     = ^chrtrain;

(* train drawed with bitmap *)

  POINTL4       = array[1..4] of POINTL;

  bmptrain      = object(chrtrain)
    aptl        : POINTL4;
    procedure setLowerLeftpos(initPos : POINTL);
    procedure setTrainWidth(initTW : integer); virtual;
    procedure setTrainHeight(initTH : integer); virtual;
    procedure adjustY(incY : LONG); virtual;
    procedure show(initHP : HPS); virtual;
    procedure hide(initHP : HPS); virtual;
    procedure hideold(initHP : HPS); virtual;
    destructor done; virtual;
  end;
  pbmptrain     = ^bmptrain;

  cstr3         = cstring[3];
  pcstr3        = ^cstr3;
  cstr9         = cstring[9];
  pcstr9        = ^cstr9;
  pstring       = ^string;


  trnwindowstat = record
    cb          : word;
    hwndHScroll,
    hwndVScroll : HWND;
    AveChar,
    CharHeight  : word;
    Xscrn,
    Yscrn,                              (* Logical screen size *)
    Xmove,
    Ymove       : integer;            (* size of hidden area *)
    dx, dy      : integer;            (* display offset *)
    font        : FATTRS;
    fontSelected: boolean
  end;
  ptrnwindowstat   = ^trnwindowstat;

  indicatorshape= POINTL4;
  diawindowstat = record
    cb          : word;
    hwndHScroll,
    hwndVScroll : HWND;
    hwndDiaStn  : HWND;
    AveChar,
    CharHeight  : word;
    xMul,
    yMul        : real;               (* Multiply factor *)
    Xscrn,
    Yscrn,                            (* Logical screen size *)
    cxClient,
    cyClient    : word;               (* Phisical screen size *)
    xOfst,
    DiaWidth,
    StnNameWidth,
    IDTop,
    StnTop,
    DiaTop      : integer;
    Xmove,
    Ymove       : integer;            (* size of hidden area *)
    dx, dy      : integer;            (* display offset *)
    indicator   : indicatorshape;     (* indicator triangle *)
    font        : FATTRS;
    fontSelected: boolean
  end;
  pdiawindowstat= ^diawindowstat;

  fontattr      = record
    facename    : string;               (* null string - default *)
    codepage    : integer;
    MaxBaselineExt : integer;
    AveCharWidth: integer;
    sType       : integer
  end;

  bmpbuffer     = array[1..100000] of byte;
  bmpinforec    = record
    usType   : USHORT;
    cbSize   : ULONG;
    xHotspot : SHORT;
    yHotspot : SHORT;
    offBits  : ULONG;
    info2    : BITMAPINFO2
  end;
  BitMapOmni    = record
    case integer of
      0 : (asFile   : BITMAPFILEHEADER2);
      1 : (asInfo   : bmpinforec);
      2 : (asBuffer : bmpbuffer)
  end;
  pBitMapOmni   = ^BitMapOmni;

  bitmapdata    = record
    handle      : HBITMAP;
    data        : pBitMapOmni;
    fsize       : longint;
    cx, cy      : word
  end;

  traindispmodes = (IDonly, BMPSelected, BMPonly);
  disptrnpref   = record
    cb          : word;
    pref        : traindispmodes;
    rmgn        : integer
  end;
  pdisptrnpref  = ^disptrnpref;

  dispdiapref   = record
    cb          : word;
    mx, my      : real
  end;
  pdispdiapref  = ^dispdiapref;

  preference    = record
    mainx0, mainy0,
    mainx1, mainy1,
    diax0,  diay0,
    diax1,  diay1  : integer;           (* zero - dia not shown *)
    dummy1         : integer;           (* to avoid bug in SP/2 1.5b4 *)
    mainfont,
    diafont        : fontattr;
    diaxMul,diayMul: real;
    dummy2         : real;              (* to avoid bug in SP/2 1.5b4 *)
    disppref       : traindispmodes;
    assigned       : boolean            (* preference read from file *)
  end;

  timedirection = (stoprun, goReverse, goForward);

var
(* line and setting *)
  linename,
  linecomment   : string[40];
  cfgfilename   : string;

(* stations *)
  station       : array[stationnum] of stndata;
  stnnum        : stationnum0;

(* trains *)
  trains        : array[trainnum] of ptrain;
  trnnum        : trainnum0;

(* time *)
  time,
  firsttime,
  lasttime      : integer;
  DelayTime     : integer;

(* Diagramme *)
  diadata       : array[trainnum] of dialine;

(* PM manipulation *)
  myhab         : HAB;
  myhmq         : HMQ;                (* Message Queue Handle *)
  myhps         : HPS;
  hwndFrame,                          (* Frame Window Handle *)
  hwndTitle,
  hwndTrainArea,
  hwndDiaFrame,
  hwndDiaArea,
  hwndDiaLine   : HWND;
  ctlData,
  ctlData2      : ULONG;              (* Control Flag *)

(* Thread *)
  idThread,
  idSearchTrn,
  idReLoad      : TID;
  TrnThreadRunning,
  SearchThreadRunning : boolean;

(* Bitmaps *)
  railbmp,
  trainbmp      : bitmapdata;

(* Screen *)
  RailDistance,
  xMargin,
  StationArea,
  PrefRailMagn,
  RailMagn,
  MaxTrnWidth,
  MaxTrnHeight,
  MaxStnHeight,
  DispWidth,
  cxClient,
  cyClient      : word;               (* Phisical screen size of Trn *)

(* window *)
  TrnWndStat    : ptrnwindowstat;
  DiaWndStat    : pdiawindowstat;

(* spin button control *)
  timech        : array [0..9] of pcstr3;
  signch        : array [0..2] of pcstr9;

(* interaction from user *)
  MousePos      : POINTS;             (* Where mouse cliked.
                                         (-1, -1) means empty *)
  focusedtrn    : trainnum0;

(* preference *)
  prefname      : string;
  prefdata      : preference;

(* flags *)
  Resized,                            (* Trn window resized *)
  DiaDisplayed  : boolean;            (* Dia window created *)
  TrainDispMode : traindispmodes;
  timedir       : timedirection;


procedure DistToPos(var p : POINTL; len : LONG);
begin
  len := (len - station[1].distance) * RailMagn;
  with TrnWndStat^, p do begin
    x   := len mod DispWidth;
    y   := len div DispWidth;
    inc(x, xMargin);
    y   := cyClient - succ(y) * RailDistance
  end
end;

function interpolate(t, t1, t2 : integer;
                     dstp, dstn : integer) : integer;
var d : integer;
    r : real;
begin
  r  := (t - t1)/(t2 - t1);
  d  := dstn - dstp;
  interpolate := round(d * r) + dstp
end;

(* train class *)

constructor train.init(initid,  initname : string;
                       initdirect  : direction;
                       initstartstn,
                       initendstn  : stationnum;
                       initstarttime,
                       initendtime : integer;
                       initindex   : trainnum;
                       var initTimeTbl : timedata);
begin
  id          := initid;
  name        := initname;
  startstn    := initstartstn;
  endstn      := initendstn;
  starttime   := initstarttime;
  endtime     := initendtime;
  currentstn  := 0;
  time        := initTimeTbl;
  fillchar(position, sizeof(position), 0);
  oldposition := position;
  exists      := false;
  displayed   := false;
  focused     := false;
  selected    := false;
  drct        := initdirect;
  index       := initindex;
  trainWidth  := 0;
  trainHeight := 0;
  ddx         := 0
end;

procedure train.setdisplayed(initDisplayed : boolean);
begin
  displayed := initDisplayed
end;

procedure train.setfocused(initFocused : boolean);
begin
  focused   := InitFocused
end;

function  train.getstarttime : integer;
begin
  getstarttime := starttime
end;

function  train.getendtime   : integer;
begin
  getendtime   := endtime
end;

function  train.getstartstn  : stationnum;
begin
  getstartstn  := startstn
end;

function  train.getendstn    : stationnum;
begin
  getendstn    := endstn
end;

function  train.getid        : string;
begin
  getid        := id
end;

function  train.getname      : string;
begin
  getname      := name
end;

function  train.getdirection : direction;
begin
  getdirection := drct
end;

function  train.getfocused   : boolean;
begin
  getfocused   := focused
end;

function  train.getdisplayed   : boolean;
begin
  getdisplayed := displayed
end;

function  train.atHere(checkpos : POINTS) : boolean;
var p0, p1 : POINTL;
begin
  if exists then begin
    if drct = efferent then begin
      p0.x := position.x - trainWidth;
      p0.y := position.y
    end else
      p0   := position;
    p1.x := p0.x + trainWidth;
    p1.y := p0.y + trainHeight;
    with checkpos do
      atHere := (x >= p0.x) and (x <= p1.x) and
                (y >= p0.y) and (y <= p1.y)
  end else
    atHere := false
end;

procedure train.calcposition(currenttime : integer);
var prevstn,
    nextstn    : stationnum;
    t0, t1,
    t2, t3     : integer;
    prevdist,
    nextdist,
    dst        : integer;
    doubled,
    staying    : boolean;
    passstat   : passingstatus;

  function neighbour(i1, i2 : integer) : boolean;
  (* must be signed type *)
  begin
    neighbour := (abs(i1 - i2) = 1)
  end;

  procedure findpos(var prv, nxt : stationnum;
                    t : integer);
  var p, n : stationnum;
      tt   : integer;
  begin
    n := startstn;
    repeat
      inc(n);
      tt := time[n].arrival
    until t < tt;
    p := n;
    repeat
      dec(p)
    until time[p].arrival<>-maxint;
    nxt := n;
    prv := p
  end;

  function checkpass(dst : integer; stn : stationnum) : stationnum0;
  begin
    station[succ(stnnum)].distance := dst; (* sentinel *)
    while abs(station[stn].distance - dst) > StationArea do
      inc(stn);
    if stn<=stnnum then checkpass := stn
                   else checkpass := 0
  end;

{
  procedure calcYadd;
  var yadd : integer;
  begin
    if (doubled or (currentstn<>0)) and
       (drct = afferent) then
      yadd := -CharHeight - 4
    else
      yadd := CharHeight + 3;
    adjustY(yadd)
  end;
}

  procedure calcYadd;
  var yadd : integer;
  begin
    yadd := succ(trainHeight);
    if          doubled then begin
      if drct = afferent then yadd := -trainHeight - 6
    end else if currentstn<>0 then
      with station[currentstn] do
        if passstat <= passingstat then
          yadd := -trainHeight - 6
        else begin
          if passingstat > nopassing then
            trains[stoptrn]^.adjustY(-trainHeight * 2 - 10);
          passingstat := passstat;
          stoptrn := index
        end;
    adjustY(yadd)
  end;

  function InStationArea(d, s : integer) : boolean;
  begin
    InStationArea := abs(d - s) < StationArea
  end;

begin
  currentstn:= 0;
  exists := (currenttime >= starttime) and
            (currenttime <= endtime);
  if exists then begin
    findpos(prevstn, nextstn, currenttime);
    t0 := time[prevstn].arrival;
    t1 := time[prevstn].departure;
    t2 := time[nextstn].arrival;
    t3 := time[nextstn].departure;
    if drct = efferent then
      doubled := station[prevstn].doubletrack
    else begin;
      prevstn := succ(stnnum - prevstn);
      nextstn := succ(stnnum - nextstn);
      doubled := station[nextstn].doubletrack
    end;
    prevdist  := station[prevstn].distance;
    nextdist  := station[nextstn].distance;
    passstat  := nopassing;
    if currenttime <= t1 then begin
        dst := prevdist;
        currentstn := prevstn;
        staying := t1 - t0 > 2
    end else
      if neighbour(prevstn, nextstn) then begin
        dst := interpolate(currenttime, t1, t2,
                           prevdist, nextdist);
        if          InStationArea(dst, prevdist) then begin
          currentstn := prevstn;
          staying := t1 - t0 > 2
        end else if InStationArea(dst, nextdist) then begin
          currentstn := nextstn;
          staying := t3 - t2 > 2
        end
      end else begin
        dst := interpolate(currenttime, t1, t2,
                           prevdist, nextdist);
        currentstn := checkpass(dst, startstn);
        passstat   := passing
      end;
    if (currentstn<>0) and (passstat <> passing) then
      if staying then
        if drct = efferent then passstat := atform
                           else passstat := afferentatform
      else
        passstat := gointo;
    DistToPos(position, dst);
    calcyadd;
    if drct = efferent then adjustX(-trainWidth)
                       else adjustX(0)
  end { if exists }
end;

procedure train.setTrainWidth(initTW : integer);
begin
  trainWidth := initTW
end;

procedure train.setTrainHeight(initTH : integer);
begin
  trainHeight := initTH
end;

procedure train.adjustX(incX : integer);
begin
  ddx := incX
end;

procedure train.adjustY(incY : LONG);
begin
  inc(position.y, incY)
end;

procedure train.show(initHP : HPS);
var p : POINTL;
begin
  if (TrainDispMode = BMPselected) < focused then begin
    GpiSetColor(initHP, CLR_BLACK);
    GpiMove(initHP, position);
    if drct = efferent then p.x := position.x - trainWidth
                       else p.x := position.x + trainWidth;
    p.y := position.y + pred(trainHeight);
    GpiBox(initHP, DRO_OUTLINE, p, 0, 0)
  end;
  displayed := true;
  oldposition := position
end;

procedure train.hideold(initHP : HPS);
var p : POINTL;
begin
  if (TrainDispMode = BMPselected) < focused then begin
    GpiMove(initHP, oldposition);
    GpiSetColor(initHP, CLR_WHITE);
    if drct = efferent then p.x := oldposition.x - trainWidth
                       else p.x := oldposition.x + trainWidth;
    p.y := oldposition.y + pred(trainHeight);
    GpiBox(initHP, DRO_OUTLINE, p, 0, 0)
  end
end;

procedure train.hide(initHP : HPS);
var p : POINTL;
begin
  if (TrainDispMode = BMPselected) < focused then begin
    GpiMove(initHP, position);
    GpiSetColor(initHP, CLR_WHITE);
    if drct = efferent then p.x := position.x - trainWidth
                       else p.x := position.x + trainWidth;
    p.y := position.y + pred(trainHeight);
    GpiBox(initHP, DRO_OUTLINE, p, 0, 0)
  end;
  displayed := false
end;

procedure train.makedialine(var dline : dialine);
var i : stationnum;
    ii: integer;
    s, ss : integer;
begin
  with dline do begin
    size := succ(endstn - startstn) * 2 * sizeof(POINTL);
    getmem(plineary, size);
    ii := 0;
    ss := station[1].distance;
    if drct = efferent then
      for i := startstn to endstn do begin
        s := ss - station[i].distance;
        with time[i] do
          if arrival >= 0 then begin
            inc(ii, 2);
            with plineary^[pred(ii)] do begin
              x := arrival - firsttime;
{              x := arrival;  }
              y := s
            end;
            with plineary^[ii] do begin
              x := departure - firsttime;
{              x := departure;  }
              y := s
            end
          end
      end
    else
{      for i := endstn downto startstn do begin}
      for i := startstn to endstn do begin
        s := ss - station[succ(stnnum - i)].distance;
        with time[i] do
          if arrival >= 0 then begin
            inc(ii, 2);
            with plineary^[pred(ii)] do begin
              x := arrival - firsttime;
{              x := arrival;  }
              y := s
            end;
            with plineary^[ii] do begin
              x := departure - firsttime;
{              x := departure;  }
              y := s
            end
          end
      end;
    count := ii;
    trnid := id;
    trndr := drct;
    minT := time[startstn].arrival;
    maxT := time[endstn].departure;
    if drct = efferent then begin
      minD := ss - station[startstn].distance;
      maxD := ss - station[endstn].distance
    end else begin
      minD := ss - station[succ(stnnum - endstn)].distance;
      maxD := ss - station[succ(stnnum - startstn)].distance
    end
  end
end;

procedure train.move(initHP : HPS);
var ii     : stationnum0;
begin
  if exists and ((oldposition.x<>position.x) or
                 (oldposition.y<>position.y)) then begin
    if displayed then hideold(initHP);
    show(initHP)
  end else if exists < displayed then hide(initHP)
end;

destructor train.done;
begin
end;

(* chrtrain class *)

procedure chrtrain.adjustY(incY : LONG);
begin
  inc(position.y, incY + 2)
end;

procedure chrtrain.show(initHP : HPS);
var p : POINTL;
begin
  GpiSetBackMix(initHP, BM_OVERPAINT);
  if drct = efferent then GpiSetColor(inithp, CLR_RED)
                     else GpiSetColor(inithp, CLR_BLUE);
  p := position;
  inc(p.x, ddx);
  GpiCharStringAt(initHP, p, length(id), id[1]);
  GpiSetBackMix(initHP, BM_DEFAULT);
  inherited.show(initHP)
end;

procedure chrtrain.hideold(initHP : HPS);
var p : POINTL;
begin
  GpiSetColor(initHP, CLR_WHITE);
  p := oldposition;
  inc(p.x, ddx);
  GpiCharStringAt(initHP, p, length(id), id[1]);
  inherited.hideold(initHP)
end;

procedure chrtrain.hide(initHP : HPS);
var p : POINTL;
begin
  GpiSetColor(initHP, CLR_WHITE);
  p := position;
  inc(p.x, ddx);
  GpiCharStringAt(initHP, p, length(id), id[1]);
  inherited.hide(initHP)
end;

destructor chrtrain.done;
begin
end;

(* bmptrain class *)

procedure bmptrain.adjustY(incY : LONG);
begin
  inc(position.y, incY - 3)
end;

procedure bmptrain.setLowerLeftpos(initPos : POINTL);
begin
  inc(initPos.x, ddx);
  aptl[1] := initPos;
  with aptl[2] do begin
    x := initPos.x + TrainWidth;
    y := initPos.y + TrainHeight
  end
end;

procedure bmptrain.setTrainWidth(initTW : integer);
begin
  train.setTrainWidth(initTW);
  aptl[3].x := 0;
  aptl[4].x := initTW
end;

procedure bmptrain.setTrainHeight(initTH : integer);
begin
  train.setTrainHeight(initTH);
  aptl[3].y := 0;
  aptl[4].y := initTH
end;

procedure bmptrain.show(initHP : HPS);
begin
  if ord(TrainDispMode) <= ord(not focused) then
    inherited.show(initHP)
  else begin
    setLowerLeftPos(position);
    GpiWCBitBlt(initHP, trainbmp.handle, 3,
                aptl[1], ROP_SRCCOPY, BBO_IGNORE);
    train.show(initHP)
  end
end;

procedure bmptrain.hideold(initHP : HPS);
begin
  if ord(TrainDispMode) <= ord(not focused) then
    inherited.hideold(initHP)
  else begin
    GpiSetColor(initHP, CLR_WHITE);
    setLowerLeftPos(oldposition);
    GpiMove(initHP, aptl[1]);
    GpiBox(initHP, DRO_FILL, aptl[2], 0, 0);
    train.hideold(initHP)
  end
end;

procedure bmptrain.hide(initHP : HPS);
var p : POINTL;
begin
  if ord(TrainDispMode) <= ord(not focused) then
    inherited.hide(initHP)
  else begin
    GpiSetColor(initHP, CLR_WHITE);
    setLowerLeftPos(position);
    GpiMove(initHP, aptl[1]);
    GpiBox(initHP, DRO_FILL, aptl[2], 0, 0);
    train.hide(initHP)
  end
end;

destructor bmptrain.done;
begin
end;

(* string handling routines *)

function sjis1st(c : char) : boolean;
begin
  sjis1st:=(ord(c) in [$81..$9F, $E0..$FC])
end;

function delspace(s : string) : string;
begin
  while (s<>'') and (pos(' ', s) <> 0) do
    delete(s, pos(' ', s), 1);
  delspace := s
end;

procedure DelHeadSpc(var s : string);
begin
  while (s<>'') and ((s[1] <= ' ') or (pos('@', s) = 1)) do
    if pos('@', s) = 1 then delete(s, 1, 2)  (* DBCS *)
                        else delete(s, 1, 1)
end;

function getitem(var s : string; c : char) : string;
(* gets first token deliminated by <c> with a side effect
  of deleting the token and <c> drom  <s> *)
var i : integer;
    ss: string;
begin
  i := pos(c, s);
  if i<>0 then begin
    if i > 0 then getitem := delspace(copy(s, 1, pred(i)))
             else getitem := '';
    delete(s, 1, i)
  end else begin
    getitem := delspace(s);
    s := ''
  end
end;  { getitem }

function getnum(var s : string) : integer;
(* gets a first integer from string <s>. The integers must be separated
  by comma from each other. If first integer is not found successibly,
  retures zero *)
var ss: string;
    i : integer;
    ii: integer;
begin
  ii := 0;
  ss := getitem(s, ',');
  if ss > ' ' then begin
   val(ss, ii, i);
   if IOResult = 0 then getnum := ii
  end;
  getnum := ii
end;  { getnum }

procedure NumTo15Sec(var i : integer);
var i1, i2, i3 : integer;
begin
  i1 := i div 1000;
  i  := i mod 1000;
  i2 := i div 10;
  i3 := i mod 10;
  i  := i1 * AnHour + i2 * 4 + i3
end;

procedure ReadData(InputFilename : string);
const
    ADay = 24 * AnHour;
var t : text;
    s : string;
    direct : direction;
    deftrack : boolean;

  procedure addtrn;
  var
    i, ii : integer;
    ss,
    sid,
    sarriv, sdeprt,
    did, sname    : string;
    startstn,
    endstn : stationnum;
    starttime,
    endtime,
    arriv,
    deprt : integer;
    ttbl  : timedata;
    linecontinued,
    InYard: boolean;
  begin
    inc(trnnum);
    sid   := getitem(s, ',');
    sname := getitem(s, ',');
    readln(t, s);
    InYard := true;
    ii:= 0;
    while s<>'' do begin
      linecontinued := s[length(s)] = ',';
      inc(ii);
      ss := getitem(s, ',');
      if ss <> '-' then
        if ss = '=' then
          arriv := -maxint         (* passing *)
        else begin
          if pos('|', ss)<>0 then begin
            sarriv := getitem(ss, '|') + '0';
            sdeprt := ss + '0';
            val(sarriv, arriv, i);
            val(sdeprt, deprt, i);
            NumTo15Sec(arriv);
            NumTo15Sec(deprt)
          end else begin
            val(ss + '0', deprt, i);
            NumTo15Sec(deprt);
            arriv := deprt - 2  (* 30sec stop *)
          end; {if pos }
          if InYard then begin
            InYard   := false;
            startstn := ii;
            starttime:= arriv
          end else begin
            if arriv < starttime then inc(arriv, ADay);
            if deprt < starttime then inc(deprt, ADay);
                   (* for mid-night trains *)
            endstn   := ii;
            endtime  := deprt
          end;
          ttbl[succ(ii)].arrival := maxint
        end; { else }
      with ttbl[ii] do begin
        arrival := arriv;
        departure := deprt
      end;
      if (s = '') and linecontinued then readln(t, s)
    end;     { while }
    if trainbmp.fsize = 0 then
      trains[trnnum] := new(pchrtrain, init(sid, sname, direct,
                                         startstn, endstn,
                                         starttime, endtime,
                                         trnnum, ttbl))
    else
      trains[trnnum] := new(pbmptrain, init(sid, sname, direct,
                                            startstn, endstn,
                                            starttime, endtime,
                                            trnnum, ttbl));
    readln(t, s)
  end;  { ReadData .addtrn }

  function GetParamTitle : string;
  var s : string;
  begin
    repeat
      readln(t, s)
    until pos('[', s) = 1;
    GetParamTitle := s
  end;  { ReadData .GetParamTitle }

begin  { ReadData }
  assign(t, InputFileName);
  reset(t);
  trnnum := 0;
  PrefRailMagn := StdRailMagn;
  prefname     := DefaultPref;
  s := GetParamTitle;
  while (s <> '[I]') and (s <>'[END]') do begin
    if          (s = '[]') or (s = '[LINE]') then begin
      readln(t, s);
      linename    := getitem(s, ',');
      linecomment := getitem(s, ',');
      deftrack    := (s = '') or (s = 'DOUBLE');
      readln(t, cfgfilename)
    end else if (s = '[wԔ{]') or (s = '[MAGNIFICATION]') then
      readln(t, PrefRailMagn)
    else     if (s = '[w]') or (s = '[STATIONS]') then begin
      readln(t, s);
      deftrack := false;
      stnnum := 0;
      while s<>'' do begin
        inc(stnnum);
        with station[stnnum] do begin
          name := getitem(s, ',');
          distance := getnum(s);
          s := delspace(s);
          if      s = '-' then doubletrack := false
          else if s = '=' then doubletrack := true
          else                 doubletrack := deftrack;
          passingstat := nopassing
        end;
        readln(t, s)
      end
    end else if (s = '[]') or (s = '[DOWNLINE]') then begin
      direct := efferent;
      readln(t, s);
      while s<>'' do addtrn
    end else if (s = '[ナ]') or (s = '[UPLINE]') then begin
      direct := afferent;
      readln(t, s);
      while s<>'' do addtrn
    end;
    s := GetParamTitle
  end;
  close(t)
end;  { ReadData  }

procedure SetUpTrainData(InputFn : string);
var i : trainnum;

  procedure DelTrains;
  var i : trainnum;
  begin
    for i := 1 to maxtrn do begin
      if trains[i]<>nil then begin
        dispose(trains[i], done);
        trains[i] := nil
      end;
      with diadata[i] do
        if size<>0 then begin
          freemem(plineary, size);
          size := 0
        end
    end
  end;  { SetUpTrainData.DelTrains }

  function findfirsttime : integer;
  var ii, iii : integer;
      i  : trainnum;
  begin
    ii := trains[1]^.getstarttime;
    for i := 2 to trnnum do begin
      iii := trains[i]^.getstarttime;
        if ii > iii then ii := iii
    end;
    findfirsttime := ii
  end;  { SetUpTrainData.findfirsttime }

  function findlasttime : integer;
  var ii, iii : integer;
      i  : trainnum;
  begin
    ii := trains[trnnum]^.getendtime;
    for i := pred(trnnum) downto 1 do begin
      iii := trains[i]^.getendtime;
      if ii < iii then ii := iii
    end;
    findlasttime := ii
  end;  { SetUpTrainData.findlasttime }

begin  { SetUpTrainData }
  DelTrains;
  ReadData(InputFn);
  firsttime := findfirsttime;
  lasttime  := findlasttime;
  time      := firsttime;
  for i := 1 to trnnum do
    trains[i]^.makedialine(diadata[i])
end;  { SetUpTrainData }

procedure SetViewParam(hp : HPS; mulx, muly : real; ofsx, ofsy : integer);
var mat : MATRIXLF;
    x1, x2,
    y1, y2 : word;
begin
  fillchar(mat, sizeof(mat), 0);
  with mat do begin
    fxM11  := trunc($10000 * mulx);
    fxM22  := trunc($10000 * muly);
    lM31   := ofsx;
    lM32   := ofsy;
    lM33   := 1
  end;
  GpiSetDefaultViewMatrix(hp, 9, mat, TRANSFORM_REPLACE)
end;  { SetViewParam }

procedure DispSingleRail(hp : HPS; len : integer);
var ptl0, ptl1 : POINTL;
begin
  GpiSetColor(hp, CLR_BLACK);
  len := len * RailMagn;
  ptl0.y := cyClient + RailWidth;
  while len > 0 do begin
    ptl0.x := xMargin;
    dec(ptl0.y, RailDistance);
    GpiMove(hp, ptl0);
    if len > DispWidth then ptl1.x := DispWidth + xMargin
                       else ptl1.x := len + xMargin;
    ptl1.y := ptl0.y;
    GpiLine(hp, ptl1);
    dec(len, DispWidth)
  end
end;  { DispSingleRail }

procedure DispRailBMP(hp : HPS; len : integer; var ptl : POINTL4);
var i : integer;
begin
  for i := 1 to len div RailBMPWidth do begin
    ptl[2].x := ptl[1].x + RailBMPWidth;
    GpiWCBitBlt(hp, railbmp.handle, 4, ptl[1], ROP_SRCCOPY, BBO_IGNORE);
    inc(ptl[1].x, RailBMPWidth)
  end;
  len := len mod RailBMPWidth;
  if len <> 0 then begin
    ptl[4].x := len;
    ptl[2].x := ptl[1].x + len;
    GpiWCBitBlt(hp, railbmp.handle, 4, ptl[1], ROP_SRCCOPY, BBO_IGNORE);
    ptl[4].x := RailBMPWidth
  end
end;  { DiapRailBMP }

procedure DispSingleRailBMP(hp : HPS; len : integer);
var ptl : POINTL4;
    l   : integer;
begin
  len := len * RailMagn;
  ptl[3].x := 0;
  ptl[3].y := 0;
  ptl[4].x := RailBMPWidth;
  ptl[4].y := RailBMPHeight;
  ptl[1].y := pred(cyClient + RailWidth);
  while len > 0 do begin
    ptl[1].x := xMargin;
    dec(ptl[1].y, RailDistance);
    ptl[2].y := ptl[1].y + RailBMPHeight;
    if len > DispWidth then l := DispWidth
                       else l := len;
    DispRailBMP(hp, l, ptl);
    dec(len, DispWidth)
  end
end;  { DispSingleRailBMP }

procedure DispDoubleRail(hp : HPS);
var ptl0, ptl1 : POINTL;
    i   : integer;
begin
  GpiSetColor(hp, CLR_BLACK);
  for i := 1 to stnnum do
    with station[i] do
      if doubletrack then begin
        ptl0 := position;
        inc(ptl0.y, RailWidth * 2);
        GpiMove(hp, ptl0);
        ptl1 := station[succ(i)].position;
        inc(ptl1.y, RailWidth * 2);
        if ptl0.y<>ptl1.y then begin
          ptl0.x := DispWidth + xMargin;
          GpiLine(hp, ptl0);
          ptl0.x := xMargin;
          ptl0.y := ptl1.y;
          GpiMove(hp, ptl0)
        end;
        GpiLine(hp, ptl1)
      end
end;  { DispDoubleRail }

procedure DispDoubleRailBMP(hp : HPS);
var ptl : POINTL4;
    temp: LONG;
    i   : integer;
begin
  ptl[3].x := 0;
  ptl[3].y := 0;
  ptl[4].x := RailBMPWidth;
  ptl[4].y := RailBMPHeight;
  for i := 1 to stnnum do
    with station[i] do
      if doubletrack then begin
        ptl[1] := position;
        inc(ptl[1].y, pred(RailWidth * 2));
        ptl[2] := station[succ(i)].position;
        inc(ptl[2].y, pred(RailWidth * 2));
        if ptl[1].y<>ptl[2].y then begin
          temp := ptl[2].y;
          ptl[2].y := ptl[1].y + RailBMPHeight;
          DispRailBMP(hp, DispWidth + xMargin - ptl[1].x, ptl);
          ptl[1].x := xMargin;
          ptl[1].y := temp;
          ptl[2].y := temp
        end;
        inc(ptl[2].y, RailBMPHeight);
        DispRailBMP(hp, ptl[2].x - ptl[1].x, ptl)
      end
end;  { DispDoubleRailBMP }

procedure CalcStationPos;
var i    : integer;
begin
  for i := 1 to stnnum do
    with station[i] do DistToPos(position, distance)
end;

procedure DispStations(hp : HPS);
var i   : integer;
    ptl : POINTL;
    w   : integer;
    abnd: AREABUNDLE;
begin
  GpiSetColor(hp, CLR_BLACK);
  if railbmp.fsize = 0 then DispDoubleRail(hp)
                       else DispDoubleRailBMP(hp);
  GpiSetBackMix(hp, BM_OVERPAINT);
  abnd.lcolor := CLR_YELLOW;
  GpiSetAttrs(hp, PRIM_AREA, ABB_COLOR, 0, abnd);
  with TrnWndStat^ do begin
    for i := 1 to stnnum do
      with station[i] do begin
        w   := AveChar * length(name) div 2;
        ptl := position;
        dec(ptl.x, w + 4);
        dec(ptl.y, 4);
        GpiMove(hp, ptl);
        inc(ptl.x, w * 2 + 8);
        inc(ptl.y, MaxStnHeight + 4);
        GpiBox(hp, DRO_OUTLINEFILL, ptl, 10, 10)
      end;
    GpiSetBackMix(hp, BM_DEFAULT);
    for i := 1 to stnnum do
      with station[i] do begin
        w   := AveChar * length(name) div 2;
        ptl := position;
        dec(ptl.x, w);
        GpiCharStringAt(hp, ptl, length(name), name[1])
      end
  end
end; { DispStations }

procedure CalcTrainPos(t : integer);
var i : trainnum;
begin
  for i := 1 to trnnum do trains[i]^.calcposition(t)
end;

procedure FifteenSecToNum(var h1, h2, m1, m2 : integer;
                         i : integer);
var h, m: integer;
begin
  h  := i div AnHour;
  h1 := h div 10;
  h2 := h mod 10;
  m  := (i mod AnHour) div 4;
  m1 := m div 10;
  m2 := m mod 10
end;

function FifteenSecToStr(i : integer) : string;
var i1, i2, i3 : integer;
    s1, s2, s3 : string[2];
begin
  i1 := i div AnHour;
  str(i1, s1);
  if length(s1)=1 then s1 := '0' + s1;
  i  := i mod AnHour;
  i2 := i div 4;
  str(i2, s2);
  if length(s2)=1 then s2 := '0' + s2;
  i3 := i mod 4;
  str(i3, s3);
  FifteenSecToStr := s1 + ':' + s2 + ':' + s3
end;

procedure ReadBMPFile(fn : string; var bmpd : bitmapdata);
var f       : file;
begin
  with bmpd do begin
    fillchar(bmpd, sizeof(bmpd), 0);
    assign(f, fn);
{$I-}
    reset(f, 1);
    if IORESULT = 0 then begin
      fsize := filesize(f);
      getmem(data, fsize);
      blockread(f, data^, fsize);
      close(f)
    end
  end
{$I+}
end;  { ReadBMPFile }

procedure SetBMPtoPS(hp : HPS; var bmpd : bitmapdata);
var l, ll  : longint;
begin
  with bmpd do begin
    with data^ do begin
      handle := GpiCreateBitMap(hp, asFile.bmp2, CBM_INIT,
                                    asBuffer[succ(asFile.offBits)],
                                    asInfo.info2);
      ll     := (fsize - asFile.offBits) * 8;
      cx     := asInfo.info2.cx;
      cy     := ll div bmpd.cx div 4
    end;
    freemem(data, fsize);
    data     := nil
  end
end;

procedure InitVars;
(* initialising variables *)
var i : trainnum;
    ii: integer;
begin
  for i := 1 to maxtrn do begin
    trains[i] := nil;
    diadata[i].size := 0
  end;
  stnnum := 0;
  trnnum := 0;
  DelayTime := StdDelayTime;
  for ii := 0 to 9 do begin
    new(timech[ii]);
    timech[ii]^ := ToStr(ii)
  end;
  new(signch[0]);
  signch[0]^ := 'RealTime +';
  new(signch[1]);
  signch[1]^ := 'Warp to';
  new(signch[2]);
  signch[2]^ := 'RealTime -';
  Resized := false;
  TrnThreadRunning    := false;
  SearchThreadRunning := false;
  DiaDisplayed := false;
  TrainDispMode := BMPonly;
  focusedtrn := 0;
  MousePos.x := -1;
  MousePos.y := -1;
  timedir    := goForward;
  ctlData := FCF_TITLEBAR or FCF_SYSMENU or
             FCF_SIZEBORDER or FCF_MINMAX or
             FCF_TASKLIST or FCF_SHELLPOSITION or
             FCF_MENU or
             FCF_HORZSCROLL or FCF_VERTSCROLL;
  ctlData2 := FCF_TITLEBAR + FCF_SYSMENU +
             FCF_SIZEBORDER + FCF_MINMAX +
             FCF_SHELLPOSITION + FCF_MENU +
             FCF_HORZSCROLL + FCF_VERTSCROLL
end;  { InitVar }


procedure ReadPrefData(fn : string; var pd : preference);
var t  : text;
    s  : string;
    dx, dy : integer;
    dummy : integer;

  procedure readfont(var f : fontattr);
  begin
    with f do begin
      readln(t, facename);
      readln(t, codepage, MaxBaselineExt, AveCharWidth, sType)
    end
  end;

begin
  fillchar(pd, sizeof(pd), 0);
{$I-}
  assign(t, fn);
  reset(t);
  if IORESULT = 0 then
    with pd do begin
      while not eof(t) do begin
        readln(t, s);
        if      s = '[呋ʒu]' then readln(t, mainx0, mainy0,
                                                mainx1, mainy1)
        else if s = '[呋]' then readfont(mainfont)
        else if s = '[ʒu]' then readln(t, diax0, diay0,
                                                diax1, diay1)
        else if s = '[]' then readfont(diafont)
        else if s = '[{]' then { readln(t, diaxMul, diayMul) }
          begin
            readln(t, dx, dy); { bug bug in SP/2 }
            diaxMul := dx / 10;
            diayMul := dy / 10
          end
      end;
      close(t);
      assigned := true
    end
{$I+}
end;

procedure ReadFiles;
begin
  ReadBMPFile('train.bmp', trainbmp);
  ReadBMPFile('rail.bmp', railbmp);
  if paramstr(1) <> '' then SetUpTrainData(paramstr(1));
  ReadPrefData(DefaultPref, prefdata)
end;

procedure WritePrefData(fn : string;
                        pf : preference);
var t  : text;

  procedure writefont(var t : text; s : string; f : fontattr);
  begin
    writeln(t, '[', s, ']');
    with f do begin
      writeln(t, facename);
      writeln(t, codepage, ' ', MaxBaselineExt, ' ',
                 AveCharWidth, ' ', sType)
    end
  end;

begin { WritePrefData }
  with pf do begin
    assign(t, fn);
    rewrite(t);
    writeln(t, '[呋ʒu]');
    writeln(t, mainx0, ' ', mainy0, ' ', mainx1, ' ', mainy1);
    writefont(t, '呋', mainfont);
    if DiaDisplayed then begin
      writeln(t, '[ʒu]');
      writeln(t, diax0, ' ', diay0, ' ', diax1, ' ', diay1);
      writefont(t, '', diafont);
      writeln(t, '[{]');
{      writeln(t, diaxMul, ' ', diayMul)}
      writeln(t, round(diaxMul * 10), ' ', round(diayMul * 10))
                        { bug bug in SP/2 beta }
    end;
    close(t)
  end
end; { WritePrefData }

(* Values setup for display *)

procedure SetDisplayConstants;
var i, w : integer;
begin
  with TrnWndStat^ do begin
    xMargin       := AveChar * 4;
    StationArea   := AveChar;
    RailMagn      := round(AveChar * PrefRailMagn / 8);
    MaxTrnWidth   := 0;
    for i := 1 to trnnum do
      with trains[i]^ do begin
        if trainbmp.handle = 0 then begin
          w := length(getid) * AveChar;
          setTrainWidth(w);
          if w > MaxTrnWidth then MaxTrnWidth := w;
          setTrainHeight(CharHeight)
        end else begin
          setTrainWidth(trainbmp.cx);
          setTrainHeight(trainbmp.cy)
        end
      end;
    if trainbmp.handle = 0 then
      MaxTrnHeight  := CharHeight
    else begin
      MaxTrnWidth   := trainbmp.cx;
      MaxTrnHeight  := trainbmp.cy + 2
    end;
    MaxStnHeight  := CharHeight;
    RailDistance  := (MaxTrnHeight + MaxStnHeight) * 2
  end
end;  { SetDisplayConstants }

procedure GetFontData(h : HPS;
                      var AveChar, CharHeight : word);
var fm : FontMetrics;
begin
  GpiQueryFontMetrics(h, sizeof(fm), fm);
  with fm do begin
    AveChar    := lAveCharWidth;
    CharHeight := lEmHeight
  end
end;  { GetFontData }

procedure setfont(var fatr : FATTRS;
                  var b : boolean;
                      f : fontattr);
begin
  fillchar(fatr, sizeof(fatr), 0);
  with f do
    if facename  > '' then begin
      b := true;
      with fatr do begin
        usRecordLength := sizeof(fatr);
        szFacename     := facename;
        usCodePage     := codepage;
        lMaxBaseLineExt:= MaxBaselineExt;
        lAveCharWidth  := AveCharWidth;
        fsType         := sType
      end
    end
end;  { setfont }

(* Multithreads *)

procedure UpDateTrainPos; CDECL;
var i : integer;
begin
  TrnThreadRunning := true;
  repeat
    DosSleep(DelayTime);
    if stnnum<>0 then begin
      case timedir of
        stoprun   :;
        goReverse :
           if time < firsttime then time := lasttime  else dec(time);
        goForward :
           if time > lasttime  then time := firsttime else inc(time)
      end;
      for i:=1 to stnnum do station[i].passingstat := nopassing;
      Resized := false;
      CalcTrainPos(time);
      if not Resized then begin
        for i := 1 to trnnum do trains[i]^.move(myhps);
        WinPostMsg(hwndTrainArea, WM_USER0, 0, 0)
      end;
      if DiaDisplayed and (timedir > stoprun) then
        WinPostMsg(hwndDiaLine, WM_USER0, 0, 0)
    end
  until false
end;  { UpDateTrainPos }

procedure SearchSelectedTrn(l : longint); CDECL;
var i : integer;
    b : boolean;
begin
  SearchThreadRunning := true;
  with TrnWndStat^ do begin
    inc(MousePos.x, dx);
    inc(MousePos.y, dy-Ymove)
  end;
  b := false;
  i := 0;
  while not b and (i < trnnum) do begin
    inc(i);
    b := trains[i]^.atHere(MousePos)
  end;
  MousePos.x := -1;
  MousePos.y := -1;
  if not b then i := 0;
  WinPostMsg(hwndTrainArea, WM_USER1, l, i);
  SearchThreadRunning := false;
  DosExit(EXIT_THREAD, 0)
end;  { SearchSelectedTrn }

procedure ReLoadData(ps : pstring); CDECL;
begin
  SetUpTrainData(ps^);
  SetDisplayConstants;
  CalcStationPos;
  dispose(ps);
  WinPostMsg(hwndTrainArea, WM_USER2, 0, 0);
  DosExit(EXIT_THREAD, 0)
end;

procedure KillTrnThread;
begin
  if TrnThreadRunning then begin
    ResumeThread(idThread);
    KillThread(idThread)
  end;
  TrnThreadRunning := false
end;

procedure KillSearchThread;
begin
  if SearchThreadRunning then KillThread(idSearchTrn);
  SearchThreadRunning := false
end;

(* Dialogs *)

function GetFileName(h : HWND;
                     title, defname : string;
                     save : boolean) : string;
var fdlg  : FILEDLG;
    szTitle : cstring[10];
    szFullFile0 : cstring[cchmaxpath];
    i     : integer;
    s     : cstring;
begin
  szTitle := title + 'File';
  szFullFile0 := defname;
  fillchar(fdlg, sizeof(fdlg), 0);
  with fdlg do begin
    cbsize:= sizeof(fdlg);
    fl    := FDS_HELPBUTTON + FDS_CENTER;
    if save then inc(fl, FDS_SAVEAS_DIALOG)
            else inc(fl, FDS_OPEN_DIALOG);
    pszTitle := @szTitle;
    szFullFile := szFullFile0;
    s       := '';
    i := WinFileDlg(HWND_DESKTOP, h, fdlg);
    if (i<>0) and (lReturn = DID_OK) then begin
      if papszFQFilename<>nil then begin
        s := papszFQFilename^[0]^;
        WinFreeFileDlgList(papszFQFilename)
      end else
        s := szFullFile;
    end
  end;
  GetFileName := s
end;  { GetFileName }

procedure SelectFont(var font: FATTRS;
                     var sel : boolean;
                         h : HWND);
var fnt : fontdlg;
    s   : string;
    cs  : cstring[FACESIZE];
    ps  : cstring[13];
    t   : text;
begin
  fillchar(fnt, sizeof(fnt), 0);
  cs := '';
  ps := 'Railway as No.1!';
  with fnt do begin
    cbsize := sizeof(fnt);
    pszPreview := @ps;
    pszFamilyname := @cs;
    usFamilyBufLen := FACESIZE;
    fl := FNTS_CENTER + FNTS_FIXEDWIDTHONLY + FNTS_BITMAPONLY;
    clrFore := CLR_BLACK;
    clrBack := CLR_WHITE
  end;
  WinFontDlg(HWND_DESKTOP, h, fnt);
  sel := fnt.lReturn = DID_OK;
  if sel then font := fnt.fAttrs
end;  { SelectFont }

function hwndParent(h : HWND) : HWND;
begin
  hwndParent := WinQueryWindow(h, QW_PARENT)
end;

(* Diagramme Display *)

function DiaPrefDlgBoxProc   (h : HWND;
                              w : ULONG;
                              m1: MPARAM;
                              m2: MPARAM) : MRESULT; CDECL;
(* ask train display preference
   This dialog box should be called
*)
var dpref : pdispdiapref;

  procedure SetEntryBoxVal(id : ULONG; r : real);
  var s : string;
  begin
    str(r:4:1, s);
    WinSetDlgItemText(h, id, s)
  end;

  function GetEntryBoxVal(id : ULONG): real;
  var s : cstring;
      ss: string;
      i : integer;
      r : real;
  begin
    WinQueryDlgItemText(h, id, 255, s);
    ss[0] := chr(WinQueryDlgItemTextLength(h, id));
    move(s, ss[1], ord(ss[0]));
    val(ss, r, i);
    GetEntryBoxVal := r
  end;

begin
  case w of
    WM_INITDLG : begin
        dpref := pdispdiapref(m2);
        WinSetWindowPtr(h, QWL_USER, dpref);
        SetEntryBoxVal(IDD_SETDIAMULX, dpref^.mx);
        SetEntryBoxVal(IDD_SETDIAMULY, dpref^.my);
        DiaPrefDlgBoxProc := 0
      end;
    WM_COMMAND : begin
        dpref := pdispdiapref(WinQueryWindowPtr(h, QWL_USER));
        dpref^.mx := GetEntryBoxVal(IDD_SETDIAMULX);
        dpref^.my := GetEntryBoxVal(IDD_SETDIAMULY);
        case COMMANDMSG(@w)^.cmd - CM_FIRST of
          CM_OK     : WinDismissDlg(h, 1);
          CM_CANCEL : WinDismissDlg(h, 0)
        else
        end;
        DiaPrefDlgBoxProc := 0
      end
  else
    DiaPrefDlgBoxProc := WinDefDlgProc(h, w, m1, m2)
  end
end;  { DiaPrefDlgBoxProc }

function DiaLineProc( h : HWND;
                      w : ULONG;
                      m1: MPARAM;
                      m2: MPARAM) : MRESULT; CDECL;
var r : RECTL;
    myhps : HPS;

  procedure DispDiagramme(hp : HPS; x1, x2 : integer);
  var t1, t2 : integer;
      ws  : pdiawindowstat;

    procedure DrawTrnIDs;
    var i, tt1, tt2 : integer;
        p   : POINTL;
        g   : GRADIENTL;
        s   : string[5];
    begin
      GpiSetCharMode(hp, CM_MODE3);
      g.x := 0;
      g.y := 1;
      GpiSetCharAngle(hp, g);
{      GpiSetCharDirection(hp, CHDIRN_TOPBOTTOM);}
      with ws^ do begin
        SetViewParam(hp, xMul, 1, -xOfst, IDTop + dy);
        p.y := -AveChar * 6;
        tt1 := t1 - round(AveChar / xMul);
        tt2 := t2 + round(AveChar / xMul);
        for i := 1 to trnnum do
          with trains[i]^ do begin
{            if getdirection = efferent then p.x := getstarttime
                                       else p.x := getendtime;}
            p.x := getstarttime;
            if (p.x >= tt1) and (p.x <= tt2) then begin
              dec(p.x, firsttime);
              s := getid;
              GpiCharStringAt(hp, p, length(s), s[1])
            end
          end
      end;
{      GpiSetCharDirection(hp, CHDIRN_DEFAULT);}
      g.y := 0;
      GpiSetCharAngle(hp, g);
      GpiSetCharMode(hp, CM_DEFAULT)
    end;  { DiaLineProc.DispDiagramme.DrawTimeLines }

    procedure DrawTimeLines;
    var i   : integer;
        p   : POINTL;
        s   : string[2];
    begin
      GpiSetColor(hp, CLR_BLUE);
      with ws^ do begin
        SetViewParam(hp, xMul, 1, -xOfst, 0);
        for i := t1 div AnHour to t2 div AnHour do begin
          p.x := i * AnHour - firsttime;
          p.y := 0;
          GpiMove(hp, p);
          p.y := StnTop;
          GpiLine(hp, p);
          str(i, s);
          GpiCharString(hp, length(s), s[1])
        end
      end;
      GpiSetColor(hp, CLR_DEFAULT)
    end;  { DiaLineProc.DispDiagramme.DrawTimeLines }

    procedure DrawStationLines;
    var i   : integer;
        p   : POINTL;
    begin
      GpiSetColor(hp, CLR_BLUE);
      with ws^ do begin
        SetViewParam(hp, 1, yMul, 0, DiaTop + dy);
        for i := 1 to stnnum do
          with station[i] do begin
            p.y := station[1].distance-distance;
            p.x := 0;
            GpiMove(hp, p);
            p.x := cxClient;
            GpiLine(hp, p)
          end
      end;
      GpiSetColor(hp, CLR_DEFAULT)
    end;  { DiaLineProc.DispDiagramme.DrawStationLines }

    procedure DrawDia;
    var i   : integer;
        p   : POINTL;
    begin
      with ws^ do SetViewParam(hp, xMul, yMul, -xOfst, DiaTop + dy);
      p.y := round(ws^.CharHeight * 2 / ws^.yMul);
      for i := 1 to trnnum do
        with diadata[i] do
          if (maxT >= t1) and (minT <= t2) then begin
            p.x := plineary^[1].x;
            GpiMove(hp, p);
            GpiSetLineType(hp, LINETYPE_DOT);
            if trains[i]^.getfocused then begin
              GpiSetColor(hp, CLR_RED);
              GpiLine(hp, plineary^[1]);
              GpiSetLineWidth(hp, LINEWIDTH_THICK * 16);
              GpiSetLineType(hp, LINETYPE_DEFAULT);
              GpiPolyLine(hp, pred(count), plineary^[2]);
              GpiSetLineWidth(hp, LINEWIDTH_DEFAULT);
              GpiSetColor(hp, CLR_DEFAULT)
            end else begin
              GpiSetColor(hp, CLR_PALEGRAY);
              GpiLine(hp, plineary^[1]);
              GpiSetLineType(hp, LINETYPE_DEFAULT);
              GpiSetColor(hp, CLR_DEFAULT);
              GpiPolyLine(hp, pred(count), plineary^[2])
            end
          end
    end;  { DiaLineProc.DispDiagramme.DrawDia }

  begin  { DiaLineProc.DispDiagramme }
    ws := pdiawindowstat(WinQueryWindowPtr(hwndDiaArea, QWL_USER));
    with ws^ do begin
      GpiErase(hp);
      t1 := firsttime + trunc((xOfst + x1)/ xMul);
      t2 := t1 + round((x2 - x1) / xMul);
      DrawTrnIDs;
      if fontSelected then begin
        GpiCreateLogFont(hp, nil, Diagrammefont, font);
        GpiSetCharSet(hp, Diagrammefont)
      end;
      DrawTimeLines;
      DrawStationLines;
      DrawDia
    end
  end; { DiaLineProc.DispDiagramme }

  procedure ScrollDiagramme;
  var dx1, dt : integer;
      ws  : pdiawindowstat;
  begin
    ws := pdiawindowstat(WinQueryWindowPtr(hwndDiaArea, QWL_USER));
    with ws^ do begin
      dx1 := dx;
      dx  := round((time - firsttime) * xMul);
      dt  := dx - dx1;
      xOfst    := dx - DiaWidth div 2;
      if      dt < 0 then WinInvalidateRect(h, nil, false)
      else if dt > 0 then WinScrollWindow(h, -dt, 0, nil, nil,
                              NULLHANDLE, nil, SW_INVALIDATERGN)

    end
  end; { DiaLineProc.ScrollDiagramme }

begin  { DiaLineProc }
  case w of
    WM_PAINT : begin
        myhps := WinBeginPaint(h, NULLHANDLE, r);
        DispDiagramme(myhps, r.xLeft, r.xRight);
        WinEndPaint(myhps);
        DiaLineProc := 0
      end;
    WM_USER0 : begin
        ScrollDiagramme;
        DiaLineProc := 0
      end
  else
     DiaLineProc := WinDefWindowProc(h, w, m1, m2)
  end
end;   { DiaLineProc }

function DiaStnProc(  h : HWND;
                      w : ULONG;
                      m1: MPARAM;
                      m2: MPARAM) : MRESULT; CDECL;
var r : RECTL;
    myhps : HPS;

  procedure DispStn(hp : HPS);
  var i, ii : integer;
      p : POINTL;
      s : string[2];
      ws : pdiawindowstat;
  begin
    ws := pdiawindowstat(WinQueryWindowPtr(hwndDiaArea, QWL_USER));
    with ws^ do begin
      if fontSelected then begin
        GpiCreateLogFont(myhps, nil, Diagrammefont, font);
        GpiSetCharSet(myhps, Diagrammefont)
      end;
      SetViewParam(hp, 1, yMul, 0, StnTop - CharHeight + dy);
      p.x := 0;
      for i := 1 to stnnum do
        with station[i] do begin
          p.y := station[1].distance-distance;
          GpiCharStringAt(hp, p, length(name), name[1])
        end
    end
  end;

begin  { DiaStnProc }
  case w of
    WM_PAINT : begin
        myhps := WinBeginPaint(h, NULLHANDLE, r);
        GpiErase(myhps);
        DispStn(myhps);
        WinEndPaint(myhps);
        DiaStnProc := 0
      end
  else
     DiaStnProc := WinDefWindowProc(h, w, m1, m2)
  end
end;   { DiaStnProc }

function DiaWndProc(  h : HWND;
                      w : ULONG;
                      m1: MPARAM;
                      m2: MPARAM) : MRESULT; CDECL;
var r : RECTL;
    myhps : HPS;
    ws      : pdiawindowstat;

  procedure InitWin;
  var ws : pdiawindowstat;
  begin
    new(ws);
    WinSetWindowPtr(h, QWL_USER, ws);
    with ws^ do begin
      cb := sizeof(diawindowstat);
      xMul := 0.6;
      yMul := 0.6;
      dx := 0;
      dy := 0;
      myhps := WinGetPS(h);
      GetFontData(myhps, AveChar, CharHeight);
      fontSelected := false;
      WinReleasePS(myhps);
      fillchar(indicator, sizeof(indicator), 0);
      with indicator[2] do begin
        x := -3;
        y := 7
      end;
      indicator[3]   := indicator[2];
      inc(indicator[3].x, 7);
      hwndHscroll := WinWindowFromID(hwndParent(h), FID_HORZSCROLL);
      hwndVscroll := WinWindowFromID(hwndParent(h), FID_VERTSCROLL);
      WinSendMsg(hwndHscroll,  SBM_SETPOS, dx, 0);
      WinSendMsg(hwndVscroll,  SBM_SETPOS, Ymove - dy, 0);
      WinRegisterClass(myhab, DiaLineClass, @DiaLineProc,
                       CS_SIZEREDRAW, 0);
      hwndDiaLine := WinCreateWindow(h, DiaLineClass, '', WS_VISIBLE,
                                     0, 0, 0, 0,
                                     h, HWND_TOP, 1, nil, nil);
      WinRegisterClass(myhab, DiaStnClass, @DiaStnProc,
                       CS_SIZEREDRAW, 0);
      hwndDiaStn  := WinCreateWindow(h, DiaStnClass, '', WS_VISIBLE,
                                     0, 0, 0, 0,
                                     h, HWND_TOP, 2, nil, nil)
    end
  end;
{
  procedure HScrollProc(cmd : word);
  var olddx : integer;
      ws : pdiawindowstat;
  begin
    ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      olddx := dx;
      case cmd of
        SB_LINELEFT : dec(dx);
        SB_LINERIGHT: inc(dx);
        SB_PAGELEFT : dec(dx, cxClient div 2);
        SB_PAGERIGHT: inc(dx, cxClient div 2);
        SB_SLIDERPOSITION : dx := lo(m2)
      else
      end;
      if      dx < 0     then dx := 0
      else if dx > Xmove then dx := Xmove;
      WinSendMsg(hwndHscroll, SBM_SETPOS, dx, 0);
      WinScrollWindow(h, olddx - dx, 0,
                      nil, nil, NULLHANDLE, nil, SW_INVALIDATERGN)
    end
  end;
}
  procedure VScrollProc(cmd : word);
  var olddy : integer;
      ws : pdiawindowstat;
  begin
    ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      olddy := dy;
      case cmd of
        SB_LINEUP  :dec(dy);
        SB_LINEDOWN: inc(dy);
        SB_PAGEUP  : dec(dy, cyClient div 2);
        SB_PAGEDOWN: inc(dy, cyClient div 2);
        SB_SLIDERPOSITION : dy :=lo(m2)
      else
      end;
      if      dy < 0     then dy := 0
      else if dy > Ymove then dy := Ymove;
      WinSendMsg(hwndVscroll, SBM_SETPOS, dy, 0);
      WinScrollWindow(hwndDiaStn, 0, dy - olddy,
                      nil, nil, NULLHANDLE, nil, SW_INVALIDATERGN);
      WinScrollWindow(hwndDiaLine, 0, dy - olddy,
                      nil, nil, NULLHANDLE, nil, SW_INVALIDATERGN)
    end
  end;

  procedure SetScrollParam(cx, cy : word);
  var MinXscrn, MinYscrn : integer;
      ws : pdiawindowstat;
  begin
    ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      cxClient := cx;
      cyClient := cy;
      StnNameWidth := AveChar * StnNameSize;
      IDTop    := cyClient - IndicatorHeight;
      StnTop   := IDTop - CharHeight * 4;
      DiaTop   := StnTop - CharHeight;
      DiaWidth := cxClient - StnNameWidth;
      xOfst    := dx - DiaWidth div 2;
      MinXscrn := StnNameWidth + round((lasttime - firsttime) * xMul);
      if cxClient < MinXscrn then Xscrn := MinXscrn
                             else Xscrn := cxClient;
      Xmove    := Xscrn - cxClient;
      if Xmove < 0 then Xmove := 0;
      MinYscrn := DiaTop + round((station[stnnum].distance -
                                  station[1].distance) * yMul);
      if cyClient < MinYscrn then Yscrn := MinYscrn
                             else Yscrn := cyClient;
      Ymove := Yscrn - cyClient;
      if Ymove < 0 then Ymove := 0;
      WinSendMsg(hwndHscroll, SBM_SETSCROLLBAR, 0, MAKELONG(0, Xmove));
      WinSendMsg(hwndHscroll, SBM_SETPOS, dx, 0);
      WinSendMsg(hwndVscroll, SBM_SETSCROLLBAR, 0, MAKELONG(0, Ymove));
      WinSendMsg(hwndVscroll, SBM_SETPOS, dy, 0)
    end
  end;  { DiaWndProc.SetScrollParam }

  procedure CommandProcs(cmd : word);
  (* Treats WM_COMMAND messages *)
  var ws      : pdiawindowstat;
      dpref   : pdispdiapref;
      changed : boolean;
  begin { DiaWndProc.CommandProcs }
    case cmd of
      IDM_SETDIAFONT : begin
          ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
          with ws^ do begin
            SelectFont(font, changed, h);
            if changed then begin
              fontSelected := true;
              myhps := WinGetPS(h);
              GpiCreateLogFont(myhps, nil, Diagrammefont, font);
              GpiSetCharSet(myhps, Diagrammefont);
              GetFontData(myhps, AveChar, CharHeight);
              WinReleasePS(myhps);
              SetScrollParam(cxClient, cyClient);
              WinSetWindowPos(hwndDiaLine, HWND_TOP, StnNameWidth, 0,
                              cxClient - StnNameWidth,
                              cyClient - IndicatorHeight,
                              SWP_SIZE + SWP_MOVE);
              WinSetWindowPos(hwndDiaStn, HWND_TOP, 0, 0,
                              StnNameWidth, StnTop, SWP_SIZE + SWP_MOVE);
              WinInvalidateRect(h, nil, true)
            end
          end
        end;
      IDM_SETDIASIZE : begin
          new(dpref);
          ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
          with ws^ do begin
            dpref^.cb := sizeof(dispdiapref);
            dpref^.mx := xMul;
            dpref^.my := yMul;
            changed :=
              WinDlgBox(HWND_DESKTOP, h, @DiaPrefDlgBoxProc,
                        NULLHANDLE, IDD_SETDIASIZE, dpref) = 1;
            if changed then begin
              xMul := dpref^.mx;
              yMul := dpref^.my;
              SetScrollParam(cxClient, cyClient);
              WinInvalidateRect(h, nil, true)
            end
          end;
          dispose(dpref)
        end
    else
    end
  end;  { DiaWndProc.CommandProc }

  procedure ChangeFont(ds : pdiawindowstat);
  var hp : HPS;
  begin
    with ds^ do begin
      hp := WinGetPS(h);
      GpiCreateLogFont(hp, nil, DiagrammeFont, font);
      GpiSetCharSet(hp, DiagrammeFont);
      GetFontData(hp, AveChar, CharHeight);
      WinReleasePS(hp)
    end;
    WinInvalidateRect(h, nil, true)
  end;

  procedure SetAccordPreference;
  var ds : pdiawindowstat;
      hp : HPS;
  begin
    with prefdata do begin
      WinSetWindowPos(hwndDiaFrame, HWND_TOP,
                      diax0, diay0, diax1, diay1, SWP_SIZE + SWP_MOVE);
      ds := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
      with ds^ do begin
        setfont(font, fontselected, diafont);
        if diaxMul > 0 then xMul := diaxMul;
        if diayMul > 0 then yMul := diayMul
      end;
      ChangeFont(ds)
    end
  end; { DiaWndProc.SetAccordPreference }

begin  { DiaWndProc }
  DiaWndProc := 0;
  case w of
    WM_CREATE : begin
        InitWin;
        DiaDisplayed := true
      end;
    WM_PAINT : begin
        myhps := WinBeginPaint(h, NULLHANDLE, r);
        ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
        with ws^ do begin
          if fontSelected then begin
            GpiCreateLogFont(myhps, nil, Diagrammefont, font);
            GpiSetCharSet(myhps, Diagrammefont)
          end;
          GpiErase(myhps);
          SetViewParam(myhps, 1, 1,
                       StnNameWidth + DiaWidth div 2,
                       cyClient - IndicatorHeight);
          GpiMove(myhps, indicator[1]);
          GpiPolyLine(myhps, 3, indicator[2])
        end;
{        WinInvalidateRect(hwndDiaLine, nil, false);}
        WinEndPaint(myhps)
      end;
    WM_USER4 :
        SetAccordPreference;
    WM_SIZE  : begin
        ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
        with ws^ do begin
          SetScrollParam(lo(m2), hi(m2));
          WinSetWindowPos(hwndDiaLine, HWND_TOP, StnNameWidth, 0,
                          cxClient - StnNameWidth,
                          cyClient - IndicatorHeight,
                          SWP_SIZE + SWP_MOVE);
          WinSetWindowPos(hwndDiaStn, HWND_TOP, 0, 0,
                          StnNameWidth, StnTop, SWP_SIZE + SWP_MOVE)
        end
      end;
    WM_COMMAND :
        CommandProcs(COMMANDMSG(@w)^.cmd - CM_FIRST);
    WM_VSCROLL :
        VScrollProc(hi(m2));
    WM_DESTROY : begin
        ws := pdiawindowstat(WinQueryWindowPtr(h, QWL_USER));
        dispose(ws);
        DiaDisplayed := false;
        DiaWndProc := WinDefWindowProc(h, w, m1, m2)
      end;
    WM_CLOSE   :
        WinDestroyWindow(hwndDiaFrame)
  else
    DiaWndProc := WinDefWindowProc(h, w, m1, m2)
  end
end;

(* Dialog window procedures *)

function AboutDlgBoxProc (h : HWND;
                          w : ULONG;
                          m1: MPARAM;
                          m2: MPARAM) : MRESULT; CDECL;
begin
  AboutDlgBoxProc := WinDefDlgProc(h, w, m1, m2)
end;

function PrefDlgBoxProc  (h : HWND;
                          w : ULONG;
                          m1: MPARAM;
                          m2: MPARAM) : MRESULT; CDECL;
(* ask preference *)
const
    delayskip = 50;
var di : integer;
    t,
    h1,
    h2,
    min1,
    min2 : integer;

  procedure settimech(id : ULONG; n, v : integer);
  begin
    WinSendDlgItemMsg(h, CM_FIRST + id,
                      SPBM_SETARRAY, ULONG(@timech), n);
    WinSendDlgItemMsg(h, CM_FIRST + id,
                      SPBM_SETCURRENTVALUE, v, 0)
  end;

  function getspinitem(id : ULONG) : integer;
  var l : LONG;
  begin
    WinSendDlgItemMsg(h, CM_FIRST + id,
                      SPBM_QUERYVALUE, ULONG(@l),
                      MAKELONG(0, SPBQ_UPDATEIFVALID));
    getspinitem := l
  end;

begin  {  PrefDlgBoxProc }
  case w of
    WM_INITDLG : begin
        di := (DelayTime - delayskip) div delayskip;
        WinSendDlgItemMsg(h, CM_FIRST + IDD_SETDELAY,
                          SLM_SETSLIDERINFO,
                          MAKELONG(SMA_SLIDERARMPOSITION,
                                   SMA_INCREMENTVALUE), di);
        FifteenSecToNum(h1, h2, min1, min2, time);
        WinSendDlgItemMsg(h, CM_FIRST + IDD_SIGN,
                          SPBM_SETARRAY, ULONG(@signch), 3);
        WinSendDlgItemMsg(h, CM_FIRST + IDD_SIGN,
                          SPBM_SETCURRENTVALUE, 1, 0);
        settimech(IDD_HOUR1, 3, h1);
        settimech(IDD_HOUR2, 10, h2);
        settimech(IDD_MIN1,  6, min1);
        settimech(IDD_MIN2,  10, min2);
        PrefDlgBoxProc := 0
      end;
    WM_COMMAND : begin
        case COMMANDMSG(@w)^.cmd - CM_FIRST of
          CM_OK     : begin
              di := WinSendDlgItemMsg(h,
                          CM_FIRST + IDD_SETDELAY,
                          SLM_QUERYSLIDERINFO,
                          MAKELONG(SMA_SLIDERARMPOSITION,
                                   SMA_INCREMENTVALUE), 0);
              DelayTime := di * delayskip + delayskip;
              h1   := getspinitem(IDD_HOUR1);
              h2   := getspinitem(IDD_HOUR2);
              min1 := getspinitem(IDD_MIN1);
              min2 := getspinitem(IDD_MIN2);
              t := (h1 * 10 + h2) * AnHour +
                   (min1 * 10 + min2) * 4;
              if (t >= firsttime) and (t <= lasttime) then
                time := t;
              WinDismissDlg(h, 1)
            end;
          CM_CANCEL : WinDismissDlg(h, 0)
        else
        end;
        PrefDlgBoxProc := 0
      end
  else
    PrefDlgBoxProc := WinDefDlgProc(h, w, m1, m2)
  end
end;  {  PrefDlgBoxProc }

function DispPrefDlgBoxProc  (h : HWND;
                              w : ULONG;
                              m1: MPARAM;
                              m2: MPARAM) : MRESULT; CDECL;
(* ask train display preference
   This dialog box should be called
*)
var dpref : pdisptrnpref;
    i : word;
begin
  case w of
    WM_INITDLG : begin
        dpref := pdisptrnpref(m2);
        WinSetWindowPtr(h, QWL_USER, dpref);
        WinSendDlgItemMsg(h, CM_FIRST + IDD_DISPTRAINID + ord(dpref^.pref),
                          BM_SETCHECK, 1, 0);
        if trainbmp.fsize = 0 then begin
          WinEnableControl(h, CM_FIRST + IDD_DISPTRAINBMP, false);
          WinEnableControl(h, CM_FIRST + IDD_DISPSELECTEDTRAINBMP, false)
        end;
        WinSendDlgItemMsg(h, CM_FIRST + IDD_DISTANCE,
                          SLM_SETSLIDERINFO,
                          MAKELONG(SMA_SLIDERARMPOSITION,
                                   SMA_INCREMENTVALUE), dpref^.rmgn);
        DispPrefDlgBoxProc := 0
      end;
    WM_CONTROL : begin
        if hi(m1) = BN_CLICKED then begin
          dpref := pdisptrnpref(WinQueryWindowPtr(h, QWL_USER));
          i     := lo(m1) - CM_FIRST - IDD_DISPTRAINID;
          if i in [0..2] then
            with dpref^ do begin
              pref := IDonly;
              inc(pref, i)
            end
        end;
        DispPrefDlgBoxProc := 0
      end;
    WM_COMMAND : begin
       dpref := pdisptrnpref(WinQueryWindowPtr(h, QWL_USER));
       dpref^.rmgn := WinSendDlgItemMsg(h,
                          CM_FIRST + IDD_DISTANCE,
                          SLM_QUERYSLIDERINFO,
                          MAKELONG(SMA_SLIDERARMPOSITION,
                                   SMA_INCREMENTVALUE), 0);
        case COMMANDMSG(@w)^.cmd - CM_FIRST of
          CM_OK     : WinDismissDlg(h, 1);
          CM_CANCEL : WinDismissDlg(h, 0)
        else
        end;
        DispPrefDlgBoxProc := 0
      end
  else
    DispPrefDlgBoxProc := WinDefDlgProc(h, w, m1, m2)
  end
end;  { DispPrefDlgBoxProc }

(* Main Window procedure *)

function TrainWndProc(  h : HWND;
                        w : ULONG;
                        m1: MPARAM;
                        m2: MPARAM) : MRESULT; CDECL;
var r : RECTL;
    s : string;

  procedure EnableMenuItem(h : HWND; id : word; enable : boolean);
  begin
    WinSendMsg(h, MM_SETITEMATTR,
                 MAKELONG(id, 1),
                 MAKELONG(MIA_DISABLED,
                          MIA_DISABLED * ord(not enable)))
  end; { TrainWndProc.EnableMenuItem }

  procedure InitWin;
  var sz : SIZEL;
  begin
    new(TrnWndStat);
    WinSetWindowPtr(h, QWL_USER, TrnWndStat);
    with TrnWndStat^ do begin
      cb := sizeof(trnwindowstat);
      dx := 0;
      dy := 0;
      fillchar(sz, sizeof(sz), 0);
      myhps := GpiCreatePS(myhab, WinOpenWindowDC(h), sz,
                           PU_PELS + GPIF_DEFAULT +
                           GPIT_MICRO + GPIA_ASSOC);
      GetFontData(myhps, AveChar, CharHeight);
      fontSelected := false;
      SetViewParam(myhps, 1, 1, 0, 0);
      if trainbmp.data<>nil then SetBMPtoPS(myhps, trainbmp);
      if railbmp.data<>nil then SetBMPtoPS(myhps, railbmp);
      SetDisplayConstants;
      hwndHscroll := WinWindowFromID(hwndParent(h), FID_HORZSCROLL);
      hwndVscroll := WinWindowFromID(hwndParent(h), FID_VERTSCROLL);
      hwndTitle   := WinWindowFromID(hwndParent(h), FID_TITLEBAR);
      WinSendMsg(hwndHscroll,  SBM_SETPOS, dx, 0);
      WinSendMsg(hwndVscroll,  SBM_SETPOS, Ymove - dy, 0)
    end;
    StartThread(@UpDateTrainPos, 8192, nil, idThread);
    SuspendThread(idThread)
  end; { TrainWndProc.InitWin }

  procedure SetScrollParam;
  var MinYscrn : integer;
      ws : ptrnwindowstat;
  begin
    ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      Xscrn := cxClient;
      if cxClient < MinXscrn then Xscrn := MinXscrn
                             else Xscrn := cxClient;
      Xmove := Xscrn - cxClient;
      DispWidth := Xscrn - xMargin * 2;
      if Xmove < 0 then Xmove := 0;
      CalcStationPos;
      MinYscrn :=  station[1].position.y
                 - station[stnnum].position.y
                 + RailDistance * 2;
      if cyClient < MinYscrn then Yscrn := MinYscrn
                             else Yscrn := cyClient;
      Ymove := Yscrn - cyClient;
      if Ymove < 0 then Ymove := 0;
      dy := Ymove;
      WinSendMsg(hwndHscroll, SBM_SETSCROLLBAR, 0, MAKELONG(0, Xmove));
      WinSendMsg(hwndHscroll, SBM_SETPOS, dx, 0);
      WinSendMsg(hwndVscroll, SBM_SETSCROLLBAR, 0, MAKELONG(0, Ymove));
      WinSendMsg(hwndVscroll, SBM_SETPOS, Ymove - dy, 0);
      SetViewParam(myhps, 1, 1, -dx, Ymove-dy)
    end
  end; { TrainWndProc.SetScrollParam}

  procedure ChangeFont(ws : ptrnwindowstat);
  begin
    KillTrnThread;
    with ws^ do begin
      GpiCreateLogFont(myhps, nil, TrainFont, font);
      GpiSetCharSet(myhps, TrainFont);
      GetFontData(myhps, AveChar, CharHeight)
    end;
    SetDisplayConstants;
    SetScrollParam;
    CalcTrainPos(time);
    StartThread(@UpDateTrainPos, 8192, nil, idThread);
    WinInvalidateRect(h, nil, false)
  end;

  procedure SetAccordPreference;
  var ws : ptrnwindowstat;
  begin
    with prefdata do begin
      if (mainx1 > 0) and (mainy1 > 0) then
        WinSetWindowPos(hwndFrame, HWND_TOP,
                        mainx0, mainy0, mainx1, mainy1,
                        SWP_SIZE + SWP_MOVE);
      ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
      with ws^ do setfont(font, fontselected, mainfont);
      ChangeFont(ws);
      if (diax1 > 0) and (diay1 > 0) then begin
        if not DiaDisplayed then
          WinSendMsg(h, WM_COMMAND, IDM_OPENDIAGRAMME + CM_FIRST, 0);
        WinPostMsg(hwndDiaFrame, WM_USER4, 0, 0)
      end
    end
  end; { TrainWndProc.SetAccordPreference }


  procedure LoadPreference(fn : string);
  begin
    ReadPrefData(fn, prefdata);
    if prefdata.assigned then SetAccordPreference
  end; { TrainWndProc.LoadPreference }

  procedure SavePreference(fn : string);
  var ws : ptrnwindowstat;
      ds : pdiawindowstat;
      sw : SWP;
  begin { TrainWndProc.SavePreferences }
    with prefdata do begin
      WinQueryWindowPos(hwndFrame, sw);
      with sw do begin
        mainx0 := x;
        mainy0 := y;
        mainx1 := cx;
        mainy1 := cy
      end;
      ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
      with ws^ do
        if fontselected then with font do begin
          mainfont.facename := szFacename;
          mainfont.codepage := usCodePage;
          mainfont.MaxBaselineExt := lMaxBaselineExt;
          mainfont.AveCharWidth := lAveCharWidth;
          mainfont.sType    := fsType
        end;
      if DiaDisplayed then begin
        WinQueryWindowPos(hwndDiaFrame, sw);
        with sw do begin
          diax0 := x;
          diay0 := y;
          diax1 := cx;
          diay1 := cy
        end;
        ds := pdiawindowstat(WinQueryWindowPtr(hwndDiaArea, QWL_USER));
        with ds^ do begin
          if fontselected then with font do begin
            diafont.facename := szFacename;
            diafont.codepage := usCodePage;
            diafont.MaxBaselineExt := lMaxBaselineExt;
            diafont.AveCharWidth := lAveCharWidth;
            diafont.sType    := fsType
          end;
          diaxMul := xMul;
          diayMul := yMul
        end
      end
    end;
    WritePrefData(fn, prefdata)
  end; { TrainWndProc.SavePreferences }

  procedure CommandProcs(cmd : word);
  (* Treats WM_COMMAND messages *)
  var s : string;
      ws : ptrnwindowstat;
      ps : pstring;
      currentpointer,
      waitpointer : HPOINTER;
      pdtrn   : pdisptrnpref;
      changed : boolean;
  begin { TrainWndProc.CommandProcs }
    case cmd of
      IDM_LOAD: begin
          s := GetFileName(h, 'Train data', '*.cpn', false);
          if s<>'' then begin
            currentpointer := WinQueryPointer(HWND_DESKTOP);
            waitpointer    := WinQuerySysPointer(HWND_DESKTOP,
                                                 SPTR_WAIT, false);
            WinSetPointer(HWND_DESKTOP, waitpointer);
            KillTrnThread;
            new(ps);
            ps^ := s;
            StartThread(@ReLoadData, 65536, ps, idReLoad);
            WinSetPointer(HWND_DESKTOP, currentpointer)
          end
        end;
      IDM_SETTIME :
          WinDlgBox(HWND_DESKTOP, h, @PrefDlgBoxProc,
                    NULLHANDLE, IDD_SETPREF, nil);
      IDM_SETFONT : begin
          ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
          with ws^ do begin
            SelectFont(font, changed, h);
            if changed then begin
              fontSelected := true;
              ChangeFont(ws)
            end
          end
        end;
      IDM_LOADPREF : begin
          s := GetFileName(h, 'Preference', prefname, false);
          if s<>'' then begin
            currentpointer := WinQueryPointer(HWND_DESKTOP);
            waitpointer    := WinQuerySysPointer(HWND_DESKTOP,
                                                 SPTR_WAIT, false);
            LoadPreference(s);
            WinSetPointer(HWND_DESKTOP, currentpointer)
          end
        end;
      IDM_SAVEPREF : begin
          s := GetFileName(h, 'Preference', prefname, true);
          if s<>'' then begin
            currentpointer := WinQueryPointer(HWND_DESKTOP);
            waitpointer    := WinQuerySysPointer(HWND_DESKTOP,
                                                 SPTR_WAIT, false);
            SavePreference(s);
            WinSetPointer(HWND_DESKTOP, currentpointer)
          end
        end;
      IDM_SETTRAINDISP : begin
          new(pdtrn);
          with pdtrn^ do begin
            cb := sizeof(disptrnpref);
            pref := TrainDispMode;
            rmgn := RailMagn
          end;
          changed := (WinDlgBox(HWND_DESKTOP, h, @DispPrefDlgBoxProc,
                               NULLHANDLE, IDD_TRAINDISPPREF, pdtrn) = 1);
          if changed then begin
            if pdtrn^.pref<>TrainDispMode then begin
              TrainDispMode := pdtrn^.pref;
              WinInvalidateRect(h, nil, false)
            end;
            if pdtrn^.rmgn<>RailMagn then begin
              RailMagn := pdtrn^.rmgn;
              Resized := true;
              SetScrollParam;
              WinInvalidateRect(h, nil, false)
            end
          end;
          dispose(pdtrn)
        end;
      IDM_OPENDIAGRAMME :
          if not DiaDisplayed then begin
            WinRegisterClass(myhab, DiaWndClass, @DiaWndProc,
                             CS_SIZEREDRAW, sizeof(diawindowstat) + 32);
            hwndDiaFrame:= WinCreateStdWindow(HWND_DESKTOP,
                             WS_VISIBLE,
                             ctlData2, DiaWndClass, DiaTitle,
                             0, NULLHANDLE, ID_DIA,
                             hwndDiaArea);
            DiaWndStat := pdiawindowstat(
                             WinQueryWindowPtr(hwndDiaArea, QWL_USER))
          end;
      IDM_CLOSEDIAGRAMME :
          if DiaDisplayed then WinPostMsg(hwndDiaFrame, WM_CLOSE, 0, 0);
      IDM_REVERSE : timedir := goReverse;
      IDM_STOPRUN : timedir := stoprun;
      IDM_FORWARD : timedir := goForward;
      IDM_ABOUT   :  WinDlgBox(HWND_DESKTOP, h, @AboutDlgBoxProc,
                               NULLHANDLE, IDD_ABOUT, nil)
    else
    end
  end;  { TrainWndProc.CommandProc }

  procedure HScrollProc(cmd : word);
  var olddx : integer;
      ws : ptrnwindowstat;
  begin
    ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      olddx := dx;
      case cmd of
        SB_LINELEFT : dec(dx);
        SB_LINERIGHT: inc(dx);
        SB_PAGELEFT : dec(dx, cxClient div 2);
        SB_PAGERIGHT: inc(dx, cxClient div 2);
        SB_SLIDERPOSITION : dx := lo(m2)
      else
      end;
      if      dx < 0     then dx := 0
      else if dx > Xmove then dx := Xmove;
      WinSendMsg(hwndHscroll, SBM_SETPOS, dx, 0);
      WinScrollWindow(h, olddx - dx, 0,
                      nil, nil, NULLHANDLE, nil, SW_INVALIDATERGN);
      SetViewParam(myhps, 1, 1, -dx, Ymove-dy)
    end
  end; { TrainWndProc.HScrollProc }

  procedure VScrollProc(cmd : word);
  var olddy : integer;
      ws : ptrnwindowstat;
  begin
    ws := ptrnwindowstat(WinQueryWindowPtr(h, QWL_USER));
    with ws^ do begin
      olddy := dy;
      case cmd of
        SB_LINEUP  : inc(dy);
        SB_LINEDOWN: dec(dy);
        SB_PAGEUP  : inc(dy, cyClient div 2);
        SB_PAGEDOWN: dec(dy, cyClient div 2);
        SB_SLIDERPOSITION : dy := Ymove - lo(m2)
      else
      end;
      if      dy < 0     then dy := 0
      else if dy > Ymove then dy := Ymove;
      WinSendMsg(hwndVscroll, SBM_SETPOS, Ymove - dy, 0);
      WinScrollWindow(h, 0, olddy - dy,
                      nil, nil, NULLHANDLE, nil, SW_INVALIDATERGN);
      SetViewParam(myhps, 1, 1, -dx, Ymove-dy)
    end
  end; { TrainWndProc.VScrollProc }

  procedure ChangeTitle;
  var s : string;
  begin
    s  := AppTitle + ' ' + linename + ' ' + FifteenSecToStr(time);
    if focusedtrn > 0 then
      with trains[focusedtrn]^ do s := s + ' >> ' + getid + ' ' + getname;
    WinSetWindowText(hwndTitle, s)
  end;  { TrainWndProc.ChangeTitle }

  procedure DispSelectedTrn(i : integer);
  var s : string;
  begin
    with trains[i]^ do
      s := 'No.' + getid + ' ' + getname + chr($0D) +
           station[getstartstn].name + ' from ' +
           copy(FifteenSecToStr(getstarttime), 1, 5) + ',' +
           station[getendstn].name + ' for ' +
           copy(FifteenSecToStr(getendtime), 1, 5);
    WinMessageBox(HWND_DESKTOP, h, s, 'This Train is', 0, MB_OK + MB_NOICON)
  end;  { TrainWndProc.DispSelectedTrn }

  procedure TrainSelection;
  begin
    case m1 of
      MP_TrainSelected :
          if m2<>0 then DispSelectedTrn(m2);
      MP_TrainFocused : begin
          if m2<>0 then begin
            if focusedtrn<>0 then
              with trains[focusedtrn]^ do begin
                SuspendThread(idThread);
                if getdisplayed then hide(myhps);
                setfocused(false);
                ResumeThread(idThread)
              end;
              focusedtrn := m2;
              trains[focusedtrn]^.setfocused(true);
            end else begin
              if focusedtrn<>0 then
                with trains[focusedtrn]^ do begin
                  SuspendThread(idThread);
                  if getdisplayed then hide(myhps);
                  setfocused(false);
                  ResumeThread(idThread)
                end;
              focusedtrn := 0
            end;
          if DiaDisplayed then WinInvalidateRect(hwndDiaArea, nil, true)
      end
    end
  end;  { TrainWndProc.TrainSelection }

  procedure ResetTrainDispFlag;
  var i : trainnum;
  begin
    for i:=1 to trnnum do trains[i]^.setdisplayed(false)
  end;

begin { TrainWndProc }
  TrainWndProc := 0;
  case w of
    WM_CREATE : begin
        InitWin;
        if prefdata.assigned then WinPostMsg(h, WM_USER4, 0, 0)
      end;
    WM_PAINT : begin
        WinBeginPaint(h, myhps, r);
        GpiErase(myhps);
        if stnnum<>0 then begin
          SuspendThread(idThread);
          if railbmp.handle = 0 then
            DispSingleRail(myhps, station[stnnum].distance)
          else
            DispSingleRailBMP(myhps, station[stnnum].distance);
          DispStations(myhps);
{          ResetTrainDispFlag;}
          ResumeThread(idThread);
          ChangeTitle
        end else begin
          WinQueryWindowRect(h, r);
          SetViewParam(myhps, 1, 1, 0, 0);
          s := 'No train data are read.';
          WinDrawText(myhps, length(s), s[1], r,
                      CLR_BLACK, 0, DT_CENTER + DT_VCENTER)
        end;
        WinEndPaint(myhps)
      end;
    WM_USER0 :
        ChangeTitle;
    WM_USER1 :
        TrainSelection;
    WM_USER2 : begin
        SetScrollParam;
        StartThread(@UpDateTrainPos, 8192, nil, idThread);
        WinInvalidateRect(h, nil, false);
        if DiaDisplayed then WinInvalidateRect(hwndDiaArea, nil, false)
       end;
    WM_USER4 :
        SetAccordPreference;
    WM_SIZE  : begin
        Resized := true;
        cxClient := lo(m2);
        cyClient := hi(m2);
        SetScrollParam
      end;
    WM_HSCROLL :
        HScrollProc(hi(m2));
    WM_VSCROLL :
        VScrollProc(hi(m2));
    WM_COMMAND :
        CommandProcs(COMMANDMSG(@w)^.cmd - CM_FIRST);
    WM_BUTTON1CLICK : begin
        WinStartTimer(myhab, h, TimerID, 200);
        MousePos := POINTS(m1);
        TrainWndProc := WinDefWindowProc(h, w, m1, m2)
      end;
    WM_TIMER, WM_BUTTON1DBLCLK : begin
        WinStopTimer(myhab, h, TimerID);
        if not SearchThreadRunning then
          if w = WM_TIMER then
            StartThread(@SearchSelectedTrn, 8192,
                          pointer(MP_TrainSelected), idSearchTrn)
          else begin
            MousePos := POINTS(m1);
            StartThread(@SearchSelectedTrn, 8192,
                          pointer(MP_TrainFocused), idSearchTrn)
          end;
        TrainWndProc := WinDefWindowProc(h, w, m1, m2)
      end;
    WM_CLOSE   :begin
        WinStopTimer(myhab, h, TimerID);
        KillTrnThread;
{        DosWaitThread(idThread, DCWW_WAIT);}
        if DiaDisplayed then WinDestroyWindow(hwndDiaFrame);
        KillSearchThread;
        GpiDestroyPS(myhps);
        TrainWndProc := WinDefWindowProc(h, w, m1, m2)
      end
  else
    TrainWndProc := WinDefWindowProc(h, w, m1, m2)
  end
end;

begin
  InitVars;
  ReadFiles;

  myhab := WinInitialize(0);
  myhmq := WinCreateMsgQueue(myhab, 0);

  WinRegisterClass(myhab, TrainWndClass, @TrainWndProc,
                   CS_SIZEREDRAW, sizeof(trnwindowstat) + 32);

  hwndFrame := WinCreateStdWindow(HWND_DESKTOP,
                                  WS_VISIBLE,
                                  ctlData, TrainWndClass, AppTitle,
                                  0, NULLHANDLE, ID_TRAIN,
                                  hwndTrainArea);


  MainDispatchLoop;

  WinDestroyMsgQueue(myhmq);
  dispose(TrnWndStat);
  WinTerminate(myhab)
end.



