;--------------------------------------------------------------------------------
;	v[e[V^C}[ Programmed by GRANADA
;
;	Ver 0.5		2010/11/26 `				16F88A3F\n_Se^C}[ρA8MHzATMR0 
;	Ver 1.0		2010/11/30 `				16F88ANbN 4MHz, TMR0  TMR1 + RyAɎdlύX
;	Ver 2.0		2010/12/02 `				16F690 ɈڐAAONbN֕ύX
;	Ver 2.1		2010/12/03 `				NbN OSCTUNE ŃLu[V\
;	Ver 2.2		2010/12/06 `				SNbN CCPR1H/L ŃLu[V\
;	Ver 2.3		2010/12/07 ` 2010/12/09	bZ[W\tAJ
;	Ver 2.4		2010/12/15 ` 2010/12/	LED J\[hRAAm[hRΉ
;	Ver 2.5		2011/03/02 					
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Presentation_Timer.htm
;--------------------------------------------------------------------------------

	LIST		P=16F690
	INCLUDE		P16F690.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

;	NbN 4MHz ̏ꍇ
;	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_ON & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF

;	ONbN 4MHz ̏ꍇ
	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_ON & _HS_OSC & _IESO_OFF & _WDT_OFF

;--------------------------------------------------------------------------------
;	AZuݒ
;--------------------------------------------------------------------------------

LED_TYPE = 1		; 7ZO LED J\[hRȂ 1AAm[hRȂ 0

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	USER_FLAG			; etO

	BCD_H				; BCD ϊliʁjp
	BCD_M				; BCD ϊliʁjp
	BCD_L				; BCD ϊliʁjp

	PATTERN_H			; 1rbgp^[
	PATTERN_M			; 2rbgp^[
	PATTERN_L			; 3rbgp^[

	SEGMENT				; \rbgp^[

	UP_SW				; XLp[N
	DW_SW
	ST_SW

	KEY_FLAG			; L[XLptO

	MIN_H				; [N
	MIN_TMP				; [N

	SEC_H_TMP			; [N
	SEC_L_TMP			; [N

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	MES_CNT				; bZ[W\pJE^

	BEEP_CNT_H			; r[vpJE^
	BEEP_CNT_L

	KEY_SCAN_C			; L[XLo

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	MINUTE				; c莞ԁij

	SEC_COUNTER			; bvpJE^[

	SEC_H				; cbi 8bitj
	SEC_L				; cbi 8bitj

	CALIB_DATA			; Lu[VliOSCTUNE WX^ݒlj
	CALIB_DISP			; Lu[VliLED \lj

	EEPROM_DATA			; EEPROM ݒlASoNʃAhXK{

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------

;RA0	DW_SP	DIGITAL IN		ݒ莞 UP XCb`
;RA1	UP_SW	DIGITAL IN		ݒ莞 DW XCb`
;RA2	ST_SW	DIGITAL IN		X^[gXCb`

;RA3			DIGITAL IN		MCLR
;RA4(OSC2)		DIGITAL IN		ONbNp
;RA5(OSC1)		DIGITAL IN		ONbNp

;RB4	C1		DIGITAL OUT		1ڐ
;RB5	C2		DIGITAL OUT		2ڐ
;RB6	C3		DIGITAL OUT		3ڐ
;RB7	BUZZER	DIGITAL OUT		duU[

;RC0	LED a	DIGITAL OUT
;RC1	LED b	DIGITAL OUT
;RC2	LED c	DIGITAL OUT
;RC3	LED d	DIGITAL OUT
;RC4	LED e	DIGITAL OUT
;RC5	LED f	DIGITAL OUT
;RC6	LED g	DIGITAL OUT
;RC7	LED dp	DIGITAL OUT

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		KEY_SCAN1		D'15'		; L[XLiZ߁j񐔁Aʏ̃L[XLɎgp
										; ő 10080us x 15 = 151.2ms ԉƃXCb`Ɣ肳
#DEFINE		KEY_SCAN2		D'50'		; L[XLi߁j񐔁AJEgfAĊJ̃L[XLɎgp
										; ő 10080us x 50 = 504.0ms ԉƃXCb`Ɣ肳
#DEFINE		CALIB_FACTOR	D'8'		; CCPR1H/L ␳WA62500JEg x 0.002(%) / 16(STEP)  8
										; }2%  }16Xebvŕ␳\

#DEFINE		E_PATTERN	B'01111001'		; E \̃rbgp^[
#DEFINE		r_PATTERN	B'01010000'		; r \̃rbgp^[

#DEFINE		MI_PATTERN	B'01000000'		; - \̃rbgp^[

#DEFINE		C_PATTERN	B'00111001'		; C \̃rbgp^[
#DEFINE		A_PATTERN	B'01110111'		; A \̃rbgp^[
#DEFINE		L_PATTERN	B'00111000'		; L \̃rbgp^[

#DEFINE		S_PATTERN	B'01101101'		; S \̃rbgp^[
#DEFINE		e_PATTERN	B'01111011'		; e \̃rbgp^[
#DEFINE		t_PATTERN	B'01111000'		; t \̃rbgp^[

#DEFINE		g_PATTERN	B'01101111'		; g \̃rbgp^[
#DEFINE		o_PATTERN	B'01011100'		; o \̃rbgp^[
#DEFINE		ex_PATTERN	B'10000010'		; ! \̃rbgp^[

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		TIME_OVER_FLAG	USER_FLAG,0	; 1 = ݒ莞Ԃ߂Ă̂ŃJEgAbv
#DEFINE		ZERO_SUP1		USER_FLAG,1	; 1 = 1ڃ[TvX
#DEFINE		ZERO_SUP2		USER_FLAG,2	; 1 = 2ڃ[TvX
#DEFINE		SETTING_MODE	USER_FLAG,3	; 1 = ԃZbg[h
#DEFINE		STOP_FLAG		USER_FLAG,4	; 1 = JEg~
#DEFINE		MINUS_FLAG		USER_FLAG,5	; 1 = \l}CiX
#DEFINE		FLASH_FLAG		USER_FLAG,6	; 1 = LED _A0 = BLED _ŐpgO
#DEFINE		CALIB_MODE		USER_FLAG,7	; 1 = Lu[V[h

#DEFINE		UP_SW_FLAG		KEY_FLAG,0	; 1 = UP SW 莞ԉꑱ
#DEFINE		DW_SW_FLAG		KEY_FLAG,1	; 1 = DW SW 莞ԉꑱ
#DEFINE		ST_SW_FLAG		KEY_FLAG,2	; 1 = ST SW 莞ԉꑱ

#DEFINE		C1_PORT			PORTB,4		; 1ڐ|[g
#DEFINE		C2_PORT			PORTB,5		; 2ڐ|[g
#DEFINE		C3_PORT			PORTB,6		; 3ڐ|[g
#DEFINE		BZ_PORT			PORTB,7		; duU[|[g

#DEFINE		DW_SW_PORT		PORTA,0		; ݒ莞 DW XCb`|[g
#DEFINE		UP_SW_PORT		PORTA,1		; ݒ莞 UP XCb`|[g
#DEFINE		ST_SW_PORT		PORTA,2		; X^[gXCb`|[g

#DEFINE		A_SEG	PORTC,0				; LED a ZOg̃|[gԍ
#DEFINE		B_SEG	PORTC,1				; LED b ZOg̃|[gԍ
#DEFINE		C_SEG	PORTC,2				; LED c ZOg̃|[gԍ
#DEFINE		D_SEG	PORTC,3				; LED d ZOg̃|[gԍ
#DEFINE		E_SEG	PORTC,4				; LED e ZOg̃|[gԍ
#DEFINE		F_SEG	PORTC,5				; LED f ZOg̃|[gԍ
#DEFINE		G_SEG	PORTC,6				; LED g ZOg̃|[gԍ
#DEFINE		DP_SEG	PORTC,7				; LED dp ZOg̃|[gԍ

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ (500ms ɔłj
;--------------------------------------------------------------------------------

	ORG		H'4'				; 荞ݏ擪AhX

	MOVWF	W_WORK				; WX^Ҕ
	SWAPF	STATUS,W			; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK

;
;	݌`FbN
;

	BTFSS	PIR1,CCP1IF			; Bank 0, TMR1 compare special event triger  ?
	GOTO	POP_REG				; Ⴄ̂ŊݏI

;
;	TMR1 RyAݏ
;

	BCF		PIR1,CCP1IF			; Bank 0, Special event triger ݃tONA

;
;	JEgf ?
;

	BTFSC	STOP_FLAG
	GOTO	POP_REG				; fȂ̂ŉȂŖ߂

;
;	500ms ̏i_ŕ\tOj
;

	BTFSS	FLASH_FLAG			; LED tO`FbN
	GOTO	ST_LED_ON

	BCF		FLASH_FLAG			; tO𔽓] LED OFF
	GOTO	CHK_SEC

ST_LED_ON:

	BSF		FLASH_FLAG			; tO𔽓] LED ON

;
;	1bo߃`FbN
;

CHK_SEC:

	DECFSZ	SEC_COUNTER,F		; JE^`FbN
	GOTO	POP_REG				; 1b̏ꍇ͊ݏI

;
;	ȍ~ 1b̏
;

	CALL	RESET_SEC_CNTR		; bJE^̃Zbg

;
;	JEg[h up  down 
;

	BTFSC	TIME_OVER_FLAG		; 0 = count down
	GOTO	COUNT_UP			; 1 = count up

;
;	JEg_E[h
;

COUNT_DOWN:
								; 16bit fNg
	DECF	SEC_L,F				;  - 1
	DECF	SEC_H,F				;  - 1
	INCFSZ	SEC_L,W				;  + 1  0  ?i؂ꂪj
	INCF	SEC_H,F				; ؂ꂪȂ̂ŏ + 1 ŏC

	MOVF	SEC_H,W
	BTFSS	STATUS,Z
	GOTO	POP_REG				; ʂ 0 ł͂Ȃ
	MOVF	SEC_L,W
	BTFSS	STATUS,Z
	GOTO	POP_REG				; ʂ 0 ł͂Ȃ

;
;	Ԃg؂i b 0A^CI[o[ j
;

	BSF		TIME_OVER_FLAG		; Ԑ؂AȌ̓JEgAbv̂ŃtO𗧂Ă

	GOTO	POP_REG

;
;	JEgAbv[hiݒ莞Ԍoߌj
;

COUNT_UP:

	INCFSZ	SEC_L,F				; b 8bit JEgAbvČJオ肪`FbN
	GOTO	POP_REG				; Jオ肪Ȃ̂ŏI

	INCF	SEC_H,F				; Jオi255->0j 8bit JEgAbv

;
;	ݏI
;

POP_REG:						; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:

	ADDWF	PCL,F
;			   gfedcba
	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC			; LED SZOg OFF

	BANK2

	CLRF	ANSEL			; Bank 2, S|[gfW^ݒ
	CLRF	ANSELH			; Bank 2

	BANK1

	CLRF	PIE1			; Bank 1, 荞݂͂ЂƂ܂Sĕs

;	MOVLW	B'00001111'		; ̓|[gݒiNbNj
	MOVLW	B'00111111'		; ̓|[gݒiONbNj
	MOVWF	TRISA			; Bank 1
	CLRF	TRISB			; Bank 1
	CLRF	TRISC			; Bank 1

	MOVLW	B'00000101'		; Weak pull up enable, TMR0 interanal clock, PSA = TMR0, PS = 1:64
	MOVWF	OPTION_REG		; Bank 1

	MOVLW	B'00001111'		; L[̓|[g RA0-2  Weak pull up enableAMCLR (RA3) ͎I enable
	MOVWF	WPUA			; Bank 1

	BANK2

	CLRF	WPUB			; Bank 2, LED |[g Weak pull up disable

	BANK0

;--------------------------------------------------------------------------------
;	TMR1 ݒ, RyA@\g 500ms 荞݂ɐݒ
;--------------------------------------------------------------------------------

	CLRF	INTCON			; Bank 0A܂荞݂͋Ȃ

	CLRF	TMR1H			; Bank 0, TMR1 NA
	CLRF	TMR1L			; Bank 0

	MOVLW	B'00001011'		; Campare mode with Special event triger enable
	MOVWF	CCP1CON			; Bank 0

	MOVLW	D'1'			; EEPROM AhXw
	CALL	READ_EEPROM		; Lu[Vl W WX^Ɏ擾
	MOVWF	CALIB_DATA		; Lu[Vlɓ]
	CALL	SET_CCPR1_REG	; CCPR1H/L ␳

	MOVLW	B'00110100'		; vXP[ 1:8 ɐݒB62.5ms x 8 = 500ms Ɋ݂
	MOVWF	T1CON			; Bank 0

	BANK1

	BCF		PIE1,TMR1IE		; Bank 1, TMR1 I[o[t[荞݂͎gpȂ̂ŕs
	NOP
	BSF		PIE1,CCP1IE		; Bank 1, RyA݋

	BANK0

	BSF		INTCON,GIE		; Bank 0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank 0, ӊ荞݋

;	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	^C}[Ԑݒ
;--------------------------------------------------------------------------------

RESTART:

	CLRF	USER_FLAG		; etO

	CALL	SET_TIMER		; Ԑݒ

;--------------------------------------------------------------------------------
;	C[vJn
;	JEg 3 DP _
;--------------------------------------------------------------------------------

MAIN_LOOP:

	CALL	SET_LED_DATA	; \p^[ݒ

	CALL	EXEC_DISPLAY	; LED _Ci~bN\
;
;							; JEgfEĊJ
;
	CALL	SCAN_SW			; XCb`͊Ď

	BTFSS	ST_SW_FLAG		; 1 = ST XCb`ꂽ
	GOTO	CHK_RESET		; ĂȂ΃Zbg`FbN

	BTFSS	STOP_FLAG		; ݃JEgf ?
	GOTO	STOP_CNT		; No

	BCF		STOP_FLAG		; JEgĊJ
	NOP
	BSF		FLASH_FLAG		; LED _ŗptO𗧂Ă

	GOTO	SUPRESS_KEY

;							; JEg 1 DP _

STOP_CNT:

	BSF		STOP_FLAG		; ftO𗧂Ă
	NOP
	BCF		FLASH_FLAG		; LED _ŗptONA

SUPRESS_KEY:

	CALL	BEEP			; fEĊJ͊mF炷

	GOTO	MAIN_LOOP

;
;							; JEgf UP/DW L[͎ԍĐݒ
;

CHK_RESET:

	BTFSS	STOP_FLAG		; ݃JEgf ?
	GOTO	MAIN_LOOP		; JEg_EȂ炻̑̃L[͖

	BTFSS	UP_SW_FLAG		; 1 = UP XCb`ꂽ
	GOTO	MAIN_LOOP		; ĂȂΕA

	BTFSS	DW_SW_FLAG		; 1 = DW XCb`ꂽ
	GOTO	MAIN_LOOP		; ĂȂΕA

	CALL	WAIT_100ms		; L[Ah~A4MHz Ȃ̂ 200ms
	CALL	WAIT_100ms		; L[Ah~A4MHz Ȃ̂ 200ms

	GOTO	RESTART			; JEg_EIă^C}Ԑݒɖ߂

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	LED \p^[̌
;	 PATTERN_H, PATTERN_M, PATTERN_L Ƀrbgp^[ZbgĖ߂
;--------------------------------------------------------------------------------

SET_LED_DATA:

	MOVF	SEC_H,W			; Ɋ荞݂Ă悢悤ɑbޔĂ
	MOVWF	SEC_H_TMP
	MOVF	SEC_L,W
	MOVWF	SEC_L_TMP

;
;	b -> ϊ
;

	CLRF	A1
	MOVF	SEC_H_TMP,W
	MOVWF	A2
	MOVF	SEC_L_TMP,W
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'60'
	MOVWF	B3

	CALL	DIV24			; in Math24-v2.lib

	MOVF	A2,W
	MOVWF	MIN_H			;  8bit
	MOVF	A3,W			;  8bit m
	MOVWF	MIN_TMP			; c蕪

	BTFSC	SETTING_MODE	; ԃZbg[h ?
	GOTO	MIN2BCD			; ԃZbg[hȂ番\

	BTFSC	TIME_OVER_FLAG	; Ԓ ?
	GOTO	MIN2BCD			; Ԓ߂Ȃ番\

	MOVF	MIN_TMP,W
	BTFSS	STATUS,Z		; c 0?
	GOTO	MIN2BCD			; c 1ȏ゠̂ŕ\

;
;	b\[hi0-999܂ł\łȂƂɒӁj
;

SEC2BCD:

	MOVF	SEC_H_TMP,W		; bǂݏo
	MOVWF	prm1b			; ʂ̓NA
	MOVF	SEC_L_TMP,W		; bǂݏo
	MOVWF	prm1a			; ʃZbg

	GOTO	EXEC_BCD_CONV

;
;	\[h
;

MIN2BCD:

	MOVF	MIN_H,W			; ̏ 8bit  0  ?
	BTFSS	STATUS,Z
	GOTO	DISP_ERROR		; 255ȏ̓G[

	CLRF	prm1b			; ʂ̓NA
	MOVF	MIN_TMP,W
	MOVWF	prm1a			; ʃZbg

;
;	5 BCD ϊ
;	Ԑݒ莞͂Gg[
;

EXEC_BCD_CONV:

	CALL	HEX2DEC16		; in Math24-v2.lib, 510ilɕϊ

;
;	3\
;

DIGIT3:

	BCF		ZERO_SUP1		; 1ڃ[TvXtONA
	NOP
	BCF		ZERO_SUP2		; 2ڃ[TvXtONA

	MOVF	prm3c,W			; 1
	BTFSC	STATUS,Z		; 1 = 0 ȂɃ[TvX
	GOTO	COL2_CHK		; ̌

	MOVWF	BCD_H			; 1ڒʏ\

COL2:

	MOVF	prm3b,W			; 2
	MOVWF	BCD_M			; 0 łʏ\

	GOTO	COL3

COL2_CHK:					; 1ڂ̓[TvX

	BSF		ZERO_SUP1		; 1ڃ[TvXtO𗧂Ă
	CLRF	BCD_H

	MOVF	prm3b,W	
	BTFSS	STATUS,Z
	GOTO	COL2			; 0 ȊOȂ̂Ő\

	BSF		ZERO_SUP2		; 2ڂ[TvXtO𗧂Ă
	CLRF	BCD_M

COL3:

	MOVF	prm3a,W			; 3
	MOVWF	BCD_L			; 3ڂ͏ɕ\

;--------------------------------------------------------------------------------
;	BCD lɊÂ LED \p^[ɃZbg
;--------------------------------------------------------------------------------

GET_LED_PATTERN:

	CLRF	PATTERN_H			; [TvX
	CLRF	PATTERN_M
	CLRF	PATTERN_L

COLUMN1:

	BTFSC	ZERO_SUP1
	GOTO	COLUMN2				; [TvXԂ2ڂ

	MOVF	BCD_H,W				; 1
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_H			; p^[ۑ

COLUMN2:

	BTFSC	ZERO_SUP2
	GOTO	COLUMN3				; [TvXԂ2ڂ

	MOVF	BCD_M,W				; 2
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_M			; p^[ۑ

COLUMN3:

	MOVF	BCD_L,W				; 3
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_L			; p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	255ȏ̓G[\_łŌŒ
;	{͕bǗ SEC_H, SEC_L CNgȂ΂̂
;	65536b = 1092 = 18ԂŁAdrɐ؂邩Ă
;	i邢̓X[vŎEĂ܂?j
;--------------------------------------------------------------------------------

DISP_ERROR:

	MOVLW	E_PATTERN			; E
	MOVWF	PATTERN_H
	MOVLW	r_PATTERN
	MOVWF	PATTERN_M			; r
	MOVWF	PATTERN_L			; r

	RETURN

;								; X[vŎEĂ܂Ȃ炱
;
;	CLRF	PORTA				; S|[g L 
;	CLRF	PORTB
;	CLRF	PORTC
;	CALL	ALL_LED_OFF
;
;DISP_ERROR2:
;
;	SLEEP
;	NOP
;	GOTO	DISP_ERROR2			; Ô

;--------------------------------------------------------------------------------
;	LED _`FbNi_ŁAdp Ȃǁj
;--------------------------------------------------------------------------------

EXEC_DISPLAY:

	CALL	ALL_LED_OFF			; S

	BTFSS	SETTING_MODE
	GOTO	EXEC_DISPLAY2

	BSF		PATTERN_H,7			; Ԑݒ胂[hȂ dp  3 Ƃ_
	BSF		PATTERN_M,7
	BSF		PATTERN_L,7

	GOTO	H_COLUMN			; Ԑݒ胂[h͔_ŕ\

EXEC_DISPLAY2:

	BTFSS	CALIB_MODE			; Lu[V[hȂ 2ڂ dp _
	GOTO	EXEC_DISPLAY3

	BSF		PATTERN_M,7

	GOTO	H_COLUMN

EXEC_DISPLAY3:

	BTFSS	STOP_FLAG			; ~
	GOTO	EXEC_DISPLAY4		; ʏ\

	BSF		PATTERN_H,7			; ~ 1ڂ dp _

	GOTO	H_COLUMN			; ~Ȃ^CI[o[ł\

EXEC_DISPLAY4:

	BTFSS	TIME_OVER_FLAG		; ݒ莞Ԃ߂
	GOTO	H_COLUMN			; ܂߂ĂȂ̂Œʏ폈
								; ݒ莞Ԃ߂̂œ_ŕ\ɂ

	BTFSS	FLASH_FLAG			; LED tO`FbN
	RETURN						; LED ^C~OȂ̂ŉȂŖ߂

;--------------------------------------------------------------------------------
;	H \
;--------------------------------------------------------------------------------

H_COLUMN:

	BTFSS	MINUS_FLAG			; }CiXl ?
	GOTO	H_COLUMN2			; Ⴄ

	MOVLW	MI_PATTERN			; '-' p^[
	MOVWF	PATTERN_H

EXEC_DISP_CHAR:					; 𒼐ڕ\Ȃ炱Gg[

H_COLUMN2:

	if LED_TYPE == 1
		BCF		C1_PORT
	else
		BSF		C1_PORT
	endif

	MOVF	PATTERN_H,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	M \
;--------------------------------------------------------------------------------

M_COLUMN:

	if LED_TYPE == 1
		BCF		C2_PORT
	else
		BSF		C2_PORT
	endif

	MOVF	PATTERN_M,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	L \
;--------------------------------------------------------------------------------

L_COLUMN:

	BTFSC	TIME_OVER_FLAG		; ^CI[o[Ԃ
	GOTO	L_COLUMN2			; ^CI[o[͐_ŏԂȂ̂ dp \͕sv

	BTFSC	FLASH_FLAG			; ݒ莞ԓŃtOĂ
	BSF		PATTERN_L,7			; dp \

L_COLUMN2:

	if LED_TYPE == 1
		BCF		C3_PORT
	else
		BSF		C3_PORT
	endif

	MOVF	PATTERN_L,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

	RETURN

;--------------------------------------------------------------------------------
;	ZOgiԂ͓_ZOgɖ֌WňA210us x 24 = 5040us
;	IN:		W = rbgp^[
;--------------------------------------------------------------------------------

DISP_SEGMENT:

	MOVWF	SEGMENT				; rbgp^[ۑ

SEG_A:

	if LED_TYPE == 1
		BTFSC	SEGMENT,0		; a ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		A_SEG			; a ZOg_

		CALL	HOLD_LED
		BCF		A_SEG			; a ZOg
	else
		BTFSC	SEGMENT,0		; a ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		A_SEG			; a ZOg_

		CALL	HOLD_LED
		BSF		A_SEG			; a ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_B:

	if LED_TYPE == 1
		BTFSC	SEGMENT,1		; b ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		B_SEG			; b ZOg_

		CALL	HOLD_LED
		BCF		B_SEG			; b ZOg
	else
		BTFSC	SEGMENT,1		; b ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		B_SEG			; b ZOg_

		CALL	HOLD_LED
		BSF		B_SEG			; b ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_C:

	if LED_TYPE == 1
		BTFSC	SEGMENT,2		; c ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		C_SEG			; c ZOg_

		CALL	HOLD_LED
		BCF		C_SEG			; c ZOg
	else
		BTFSC	SEGMENT,2		; c ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		C_SEG			; c ZOg_

		CALL	HOLD_LED
		BSF		C_SEG			; c ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_D:

	if LED_TYPE == 1
		BTFSC	SEGMENT,3		; d ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		D_SEG			; d ZOg_

		CALL	HOLD_LED
		BCF		D_SEG			; d ZOg
	else
		BTFSC	SEGMENT,3		; d ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		D_SEG			; d ZOg_

		CALL	HOLD_LED
		BSF		D_SEG			; d ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_E:

	if LED_TYPE == 1
		BTFSC	SEGMENT,4		; e ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		E_SEG			; e ZOg_

		CALL	HOLD_LED
		BCF		E_SEG			; e ZOg
	else
		BTFSC	SEGMENT,4		; e ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		E_SEG			; e ZOg_

		CALL	HOLD_LED
		BSF		E_SEG			; e ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_F:

	if LED_TYPE == 1
		BTFSC	SEGMENT,5		; f ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		F_SEG			; f ZOg_

		CALL	HOLD_LED
		BCF		F_SEG			; f ZOg
	else
		BTFSC	SEGMENT,5		; f ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		F_SEG			; f ZOg_

		CALL	HOLD_LED
		BSF		F_SEG			; f ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_G:

	if LED_TYPE == 1
		BTFSC	SEGMENT,6		; g ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		G_SEG			; g ZOg_

		CALL	HOLD_LED
		BCF		G_SEG			; g ZOg
	else
		BTFSC	SEGMENT,6		; g ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		G_SEG			; g ZOg_

		CALL	HOLD_LED
		BSF		G_SEG			; g ZOg
	endif

	CALL	HOLD_LED_SHORT

SEG_DP:

	if LED_TYPE == 1
		BTFSC	SEGMENT,7		; dp ZOgrbg 0 Ȃ玟̖߂XLbv
		BSF		DP_SEG			; dp ZOg_

		CALL	HOLD_LED
		BCF		DP_SEG			; dp ZOg
	else
		BTFSC	SEGMENT,7		; dp ZOgrbg 0 Ȃ玟̖߂XLbv
		BCF		DP_SEG			; dp ZOg_

		CALL	HOLD_LED
		BSF		DP_SEG			; dp ZOg
	endif

	CALL	HOLD_LED_SHORT

	RETURN

;--------------------------------------------------------------------------------
;	LED SAJ\[hR LED Ȃ̂ŃZOg L = OFFA H = OFF
;	Xe[^X LED _ŏ
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	if LED_TYPE == 1				; J\[hR LED ̏ꍇ

		CLRF	PORTC				; LED SZOg

		BSF		C1_PORT				; 1 OFF
		NOP
		BSF		C2_PORT				; 2 OFF
		NOP
		BSF		C3_PORT				; 3 OFF

	else							; Am[hR LED ̏ꍇ

		MOVLW	B'11111111'			; LED SZOg
		MOVWF	PORTC

		BCF		C1_PORT				; 1 OFF
		NOP
		BCF		C2_PORT				; 2 OFF
		NOP
		BCF		C3_PORT				; 3 OFF

	endif

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێi߁j
;--------------------------------------------------------------------------------

HOLD_LED:

	CALL	WAIT_100us			; NbN 4MHz Ȃ̂ 200us

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێiZ߁j
;--------------------------------------------------------------------------------

HOLD_LED_SHORT:

	CALL	WAIT_5us			; NbN 4MHz Ȃ̂ 10us

	RETURN

;--------------------------------------------------------------------------------
;	^C}[Ԑݒ
;	̃[h͑S DP _
;--------------------------------------------------------------------------------

SET_TIMER:

	BCF		T1CON, TMR1ON	; Bank 0, TMR1 ~
;
;							; ^C}[[hڍsbZ[W\
;

	MOVLW	S_PATTERN		; S
	MOVWF	PATTERN_H

	MOVLW	e_PATTERN		; e
	MOVWF	PATTERN_M

	MOVLW	t_PATTERN		; t
	MOVWF	PATTERN_L

	CALL	DISP_MESSAGE	; \

;
;							; {
;

	CLRF	MIN_H			;  8bit NA

	CLRW					; EEPROM AhX擪
	CALL	READ_EEPROM		; W = ߂l
	MOVWF	MINUTE			; ǂݏolۑ

	BSF		SETTING_MODE	; Ԑݒ胂[htO𗧂Ă

	MOVLW	KEY_SCAN1		; XLԒZ
	MOVWF	KEY_SCAN_C		; XLԒlݒ

	CALL	INIT_KEY_CNT	; L[̓`FbNpJE^ƃtONA

SET_TIMER_LOOP:

	CLRF	prm1b			; ʂ̓NA
	MOVF	MINUTE,W
	MOVWF	prm1a			; ʃZbg

	CALL	EXEC_BCD_CONV	;  -> BCD ϊ
	CALL	EXEC_DISPLAY	; LED _Ci~bN\

	CALL	SCAN_SW			; L[XL

;
;	Lu[V[h`FbN
;

	BTFSC	UP_SW_PORT		; UP XCb`ꂽi|[g𒼐ڃXLj
	GOTO	SCAN1			; ĂȂ̂Ŏ̃L[XL͂

	BTFSC	DW_SW_PORT		; DW XCb`ꂽi|[g𒼐ڃXLj
	GOTO	SCAN1

	CALL	WAIT_100ms		; 4MHz Ȃ̂ 200ms
							; ^C}[[hڍs߂ł̂܂܃Lu[V[hڍsh~

	BTFSC	UP_SW_PORT		; ܂ UP XCb`Ă邩i|[g𒼐ڃXLj
	GOTO	SCAN1			; ĂȂ̂Ŏ̃L[XL͂

	BTFSS	DW_SW_PORT		; ܂ DW XCb`Ă邩i|[g𒼐ڃXLj
	GOTO	SET_CALIB		; ȂgLu[V

SCAN1:

	BTFSS	UP_SW_FLAG		; UP XCb`ꂽ
	GOTO	SCAN2			; ĂȂ̂Ŏ̃L[XL͂

	BCF		UP_SW_FLAG		; tONA

	INCFSZ	MINUTE,F
	GOTO	SET_TIMER_LOOP	; 0 ȊOȂ\ɔf

	INCF	MINUTE,F		; 0 ɂȂ狭I 1 ɐݒ
	GOTO	SET_TIMER_LOOP	; \

SCAN2:

	BTFSS	DW_SW_FLAG		; DW XCb`ꂽ
	GOTO	SCAN3			; ĂȂ̂Ŏ̃L[XL͂

	BCF		DW_SW_FLAG		; tONA

	DECFSZ	MINUTE,F
	GOTO	SET_TIMER_LOOP	; 0 ȊOȂ\ɔf

	MOVLW	D'255'			; 0 Ȃ 255 ɋݒ
	MOVWF	MINUTE

	GOTO	SET_TIMER_LOOP	; \

SCAN3:

	BTFSS	ST_SW_FLAG		; ST XCb`ꂽ
	GOTO	SET_TIMER_LOOP	; ĂȂȂ烋[vp

;
;	^C}[X^[g
;

	MOVF	MINUTE,W
	MOVWF	EEPROM_DATA		; ރf[^
	CLRW					; EEPROM AhX擪
	CALL	SAVE_EEPROM		; ݒ莞Ԃ EEPROM ɕۑ

;
;	bvZ
;

	CLRF	A1
	CLRF	A2
	MOVF	MINUTE,W		; i 1 ` 255 j
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'60'			; x 60 = b
	MOVWF	B3

	CALL	MUL24			; in Math24-v2.libA 16bit ȓm

	MOVF	B2,W
	MOVWF	SEC_H			; b H XgA
	MOVF	B3,W
	MOVWF	SEC_L			; b L XgA

;
;	̑̏ݒ
;

	BCF		SETTING_MODE	; Ԑݒ胂[htONA
	NOP
	BSF		FLASH_FLAG		; LED _ŗptOZbgĕ\
	NOP
	BCF		MINUS_FLAG		; Ô߃}CiXtOZbg

	MOVLW	KEY_SCAN2		; fL[̂߂ɃXLԒ߂ɍĐݒ
	MOVWF	KEY_SCAN_C		; XLԒlݒ

	CALL	INIT_KEY_CNT	; L[͊֘AϐƃtOď

	CALL	RESET_SEC_CNTR	; TMR1 ݊֘Aϐ

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;
;	X^[g\
;

;	CALL	BEEP			; ^C}X^[gmF炷

	MOVLW	g_PATTERN		; g
	MOVWF	PATTERN_H

	MOVLW	o_PATTERN		; o
	MOVWF	PATTERN_M

	MOVLW	ex_PATTERN		; !
	MOVWF	PATTERN_L

	CALL	DISP_MESSAGE	; \

	RETURN

;--------------------------------------------------------------------------------
;	덷Lu[V[h
;	̃[h 2 DP _
;--------------------------------------------------------------------------------

SET_CALIB:

	CALL	BEEP
;
;							; Lu[V[hڍs\
;
	MOVLW	C_PATTERN		; C
	MOVWF	PATTERN_H

	MOVLW	A_PATTERN		; A
	MOVWF	PATTERN_M

	MOVLW	L_PATTERN		; L
	MOVWF	PATTERN_L

	MOVLW	D'200'			; 5.04ms x 200 =  1b
	MOVWF	MIN_TMP			; iϐpj

	CALL	DISP_MESSAGE	; \
;
;							; ݒ{
;

	BCF		SETTING_MODE
	BSF		CALIB_MODE

	MOVLW	KEY_SCAN1		; XLԒZ
	MOVWF	KEY_SCAN_C		; XLԒlݒ

	CALL	INIT_KEY_CNT	; L[̓`FbNpJE^ƃtONA

	MOVLW	D'1'			; EEPROM AhX
	CALL	READ_EEPROM
	MOVWF	CALIB_DATA		; f[^Zbg

SET_CALIB_LOOP:				; 0-15 -> +, 16-31 -> -

	CALL	CONV_DISP_DATA

	CLRF	prm1b			; ʂ̓NA
	MOVF	CALIB_DISP,W	; Lu[Vli\lj
	MOVWF	prm1a			; ʃZbg

	CALL	EXEC_BCD_CONV	; \l BCD ϊ
	CALL	EXEC_DISPLAY	; LED _Ci~bN\
	CALL	SCAN_SW			; L[XL

;
;	JEgAbv
;

CALIB_SCAN1:

	BTFSS	UP_SW_FLAG		; UP XCb`ꂽ
	GOTO	CALIB_SCAN2		; ĂȂ̂Ŏ̃L[XL͂

	BCF		UP_SW_FLAG		; tONA

	MOVLW	D'15'
	SUBWF	CALIB_DATA,W	; CALIB_DATA - 15 -> W
	BTFSC	STATUS,Z		; CALIB_DATA = 15 ?
	GOTO	SET_CALIB_LOOP	; NO, JEgAbvɃ[vp

	MOVLW	D'31'
	SUBWF	CALIB_DATA,W	; CALIB_DATA - 31 -> W
	BTFSS	STATUS,Z		; CALIB_DATA = 31 ?
	GOTO	CALIB_PLUS2

	CLRF	CALIB_DATA		; 32 ̎ 0 ɕ␳
	GOTO	SET_CALIB_LOOP

CALIB_PLUS2:

	INCF	CALIB_DATA,F	; JEgAbv
	GOTO	SET_CALIB_LOOP

;
;	JEg_E
;

CALIB_SCAN2:

	BTFSS	DW_SW_FLAG		; DW XCb`ꂽ
	GOTO	CALIB_SCAN3		; ĂȂ̂Ŏ̃L[XL͂

	BCF		DW_SW_FLAG		; tONA

	MOVF	CALIB_DATA,W	; CALIB_DATA = 0 ?
	BTFSS	STATUS,Z
	GOTO	CALIB_MINUS2	; No

	MOVLW	D'31'
	MOVWF	CALIB_DATA		; 0 ̎ 31 ɕ␳

	GOTO	SET_CALIB_LOOP	; \

CALIB_MINUS2:

	MOVLW	D'16'
	SUBWF	CALIB_DATA,W	; CALIB_DATA - 16 -> W
	BTFSC	STATUS,Z		; CALIB_DATA = 16 ?
	GOTO	SET_CALIB_LOOP	; Yes, [vp

	DECF	CALIB_DATA,F	; JEg_E

	GOTO	SET_CALIB_LOOP

CALIB_SCAN3:

	BTFSS	ST_SW_FLAG		; ST XCb`ꂽ
	GOTO	SET_CALIB_LOOP	; ĂȂȂ烋[vp

;
;	Lu[VI
;

	MOVF	CALIB_DATA,W
	MOVWF	EEPROM_DATA		; EEPROM_DATA ͑SoNʗ̈
	MOVLW	D'1'			; EEPROM AhX
	CALL	SAVE_EEPROM		; Lu[Vlۑ

	CALL	SET_CCPR1_REG	; CCPR1H/L WX^␳

	BSF		FLASH_FLAG		; LED _ŗptOZbgĕ\
	NOP
	BCF		MINUS_FLAG		; }CiXltONA

	CALL	INIT_KEY_CNT	; L[͊֘AϐƃtOď

	CALL	BEEP
	CALL	BEEP

	BCF		CALIB_MODE
	BSF		SETTING_MODE

	GOTO	SET_TIMER		; Ԑݒɖ߂

;--------------------------------------------------------------------------------
;	l\pf[^ɕϊ
;	IN:			CALIB_DATA
;	RETURN:		CALIB_DISPi\lAΒlj
;				MINUS_FLAGi1=}CiXlj
;--------------------------------------------------------------------------------

CONV_DISP_DATA:

	MOVF	CALIB_DATA,W
	MOVWF	CALIB_DISP
	BCF		MINUS_FLAG		; ɃtONAĂ

	BTFSS	CALIB_DATA,4	; tO`FbNil 16`31 Ȃ 4bit=1j
	RETURN					; ̒lȂ炻̂܂ܖ߂
;
;							; ̒lȂ␳
;
	MOVLW	B'11110000'		; rbg͕KĂ
	IORWF	CALIB_DISP,F
	COMF	CALIB_DISP,F	; Srbg] -> W
	INCF	CALIB_DISP,F	; + 1 ƕ␔ɂȂ

	BSF		MINUS_FLAG		; }CiXl

	RETURN

;--------------------------------------------------------------------------------
;	Lu[Vf[^ CCPR1H/L WX^ɏ
;	IN:		CALIB_DATA
;--------------------------------------------------------------------------------

SET_CCPR1_REG:

	CALL	CONV_DISP_DATA	; l  \lϊ

	CLRF	A1
	CLRF	A2
	MOVF	CALIB_DISP,W	; \liΒl 0`16j
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	CALIB_FACTOR	; ␳W
	MOVWF	B3

	CALL	MUL24			; in Math24-v2.lib,  16bit ȓ B2,B3 ɂ

	CLRF	A1
	MOVLW	H'F4'			; &HF423 = 62500 - 1
	MOVWF	A2
	MOVLW	H'23'
	MOVWF	A3

	CLRF	B1				; Ô

	BTFSS	MINUS_FLAG		; \l̓}CiX ?
	GOTO	SLOW_CALIB		; ƒxȂ悤␳Al 1-16

FAST_CALIB:					; ƑȂ悤CAl 0-15

	CALL	SUB24			; in Math24-v2.libA 16bit  A2,A3
	GOTO	CALIB2

SLOW_CALIB:					; 

	CALL	ADD24			; in Math24-v2.libA 16bit  A2,A3

;
;							; CCPR1H/L WX^ɔf
;

CALIB2:

	MOVF	A2,W
	MOVWF	CCPR1H			; Bank 0

	MOVF	A3,W
	MOVWF	CCPR1L			; Bank 0

	RETURN

;--------------------------------------------------------------------------------
;	XCb`XL
;	w񐔘AăL[ĂtO𗧂ĂiΉj
;	RETURN:		UP_SW_FLAG, DW_SW_FLAG, ST_SW_FLAG (1 = ꂽ)
;--------------------------------------------------------------------------------

SCAN_SW:

CHK_UP_SW:

	BTFSS	UP_SW_PORT			; UP XCb`Ă邩
	GOTO	PUSH_UP_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	UP_SW				; JE^
	BCF		UP_SW_FLAG			; tONA
	GOTO	CHK_DW_SW			; ̃L[͂

PUSH_UP_SW:

	DECFSZ	UP_SW,F
	GOTO	CHK_DW_SW			; 񐔖Ȃ玟̃L[͏

	BSF		UP_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	UP_SW				; JE^

CHK_DW_SW:

	BTFSS	DW_SW_PORT			; DW XCb`Ă邩
	GOTO	PUSH_DW_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	DW_SW				; JE^
	BCF		DW_SW_FLAG			; tONA
	GOTO	CHK_ST_SW			; ̃L[͂

PUSH_DW_SW:

	DECFSZ	DW_SW,F
	GOTO	CHK_ST_SW			; 񐔖Ȃ玟̃L[͏

	BSF		DW_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	DW_SW				; JE^

CHK_ST_SW:

	BTFSS	ST_SW_PORT			; ST XCb`Ă邩
	GOTO	PUSH_ST_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	ST_SW				; JE^
	BCF		ST_SW_FLAG			; tONA
	RETURN						; ߂

PUSH_ST_SW:

	DECFSZ	ST_SW,F
	RETURN						; 񐔖Ȃ߂

	BSF		ST_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	ST_SW				; JE^

	RETURN

;--------------------------------------------------------------------------------
; L[̓`FbNpJE^ƃtÕNA
;--------------------------------------------------------------------------------

INIT_KEY_CNT:

	MOVF	KEY_SCAN_C,W	; lǂݏo
	MOVWF	UP_SW
	MOVWF	DW_SW
	MOVWF	ST_SW

	CLRF	KEY_FLAG		; L[̓tO

	RETURN

;--------------------------------------------------------------------------------
;	ԃJE^̏
;--------------------------------------------------------------------------------

RESET_SEC_CNTR:

	MOVLW	D'2'				; 500ms ̊荞ݏ 1bɂȂ邩
	MOVWF	SEC_COUNTER

	RETURN

;--------------------------------------------------------------------------------
;	f[^ EEPROM ǂݏo
;	IN		: W = EEPROM AhX
;	RETURN	: W = ǂݏol
;--------------------------------------------------------------------------------

READ_EEPROM:

	BANK2

	MOVWF		EEADR			; ǂݏo EEPROM AhXw

	BANK3

	BCF			EECON1,EEPGD	; Bank 3, Point to data memory
	BSF			EECON1,RD		; Bank 3, EE READ

	BANK2

	MOVF		EEDATA,W		; Bank2, W = EEDATAi߂lj

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	EEPROM փf[^
;	IN		: W = EEPROM AhX
;	IN		: EEPROM_DATA = ޒl
;--------------------------------------------------------------------------------

SAVE_EEPROM:

	BANK3

	BTFSC		EECON1,WR		; Bank 3, ÔߊɏݏԂłȂ`FbN
	GOTO		$-1				; ݒȂ`FbNp

	BANK2

	MOVWF		EEADR			; Bank 2,  EEPROM AhXw
	MOVF		EEPROM_DATA,W	; ޒlAEEPROM_DATA ͑SoNʗ̈
	MOVWF		EEDATA			; Bank 2

	BANK3

	BCF			EECON1,EEPGD	; Bank 3, Point to DATA memory
	BSF			EECON1,WREN		; Bank 3, Enable write

	MOVLW		H'55'
	MOVWF		EECON2			; Bank 3, Write 55h
	MOVLW		H'AA'
	MOVWF		EECON2			; Bank 3, Write AAh
	BSF			EECON1, WR		; WR bit Zbgď݊Jn

	BCF			EECON1, WREN	; Bank 3, ݒ~ԂցBݎ̂͏IĂȂB
								; ݏIoKvȂ
								; WR rbg = 0  EEIF rbg = 1 Ōo

	BTFSC		EECON1,WR		; Bank 3, ݏI܂ő҂
	GOTO		$-1

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	4.1KHz duty 50%  0.1bԈduU[炷
;--------------------------------------------------------------------------------

BEEP:

	MOVLW	D'2'				; 61.25ms x 2 = 122.5ms
	MOVWF	BEEP_CNT_H

BEEP2:

	MOVLW	D'255'				; 240us x 255 = 61.25ms
	MOVWF	BEEP_CNT_L

BEEP3:

	CALL	EXEC_BEEP

	DECFSZ	BEEP_CNT_L,F
	GOTO	BEEP3

	DECFSZ	BEEP_CNT_H,F
	GOTO	BEEP2
								; L[Ah~
	CALL	WAIT_100ms			; 4MHz Ȃ̂ 200ms
	CALL	WAIT_100ms			; 4MHz Ȃ̂ 200ms

	RETURN
;
; duU[ɃpX𑗂B 4.1KHz duty 50% = ON 120us, OFF 120us
;

EXEC_BEEP:

	BSF		BZ_PORT				; ON
	CALL	WAIT_50us			; 4MHz Ȃ̂ 100us
	CALL	WAIT_10us			; 4MHz Ȃ̂  20us

	BCF		BZ_PORT				; OFF
	CALL	WAIT_50us			; 4MHz Ȃ̂ 100us
	CALL	WAIT_10us			; 4MHz Ȃ̂  20us

	RETURN

;--------------------------------------------------------------------------------
;	bZ[W\
;	IN:		PATTERN_H,M,L
;--------------------------------------------------------------------------------

DISP_MESSAGE:

	MOVLW	D'200'			; 5.04ms x 255 =  1.28b
	MOVWF	MES_CNT

DISP_MES2:

	CALL	EXEC_DISP_CHAR	; 񒼐ڕ\, 5ms cycle

	DECFSZ	MES_CNT,F
	GOTO	DISP_MES2		; 莞ԕ\

	CALL	WAIT_100ms		; 4MHz Ȃ̂ 200msA\NA˂

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu
								; ̓NbN 4MHz Ȃ̂ŎԂ͕\L̔{ɂȂ
	INCLUDE		Math24-v2.lib	; 24bit ZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	ORG		H'2100'				; EEPROM JnԒnw

	DE		D'30'				; ݒ莞ԕۑ̈Fl 30
								; ȍ~͎gpԂIɕۑ
	DE		D'0'				; NbNLu[V CCPR1H/L ␳li0=WA+ Ȃx - Ȃ瑬j
								; ȍ~͎gpLu[VlIɕۑ

	END
