;********************************************************************************
;	ԍڃobe[j^[ & `[W[
;	For PIC16F785, for 8MHz clock
;
;	v1.00	2010/06/14`	LCD x[^[tI[fBIZN^[ v1.10 𗬗p
;	v1.20	2010/06/21`	dőlAŏlL`\Ή
;	v1.21	2010/06/22`	LCD \CuOo^Ήg
;	v1.30	2010/06/29`	dőlAŏlL`\Ή
;	v2.00	2010/07/16`	10bit A/D ϊŐx
;	v3.00	2010/12/21`	ڃOt\[hǉ
;
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Car_Battery_Monitor.htm
;********************************************************************************

	LIST		P=16F785
	INCLUDE		P16F785.INC
	INCLUDE		Original_Macro.lib

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF 

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK			 H'20'	; ϐGA擪AhX

V_DATA					; 1Ԃ̓df[^
C_DATA					; 1Ԃ̓df[^

AVG_V					; ϓdliǒl x 10j
AVG_C					; ϓdliǒlj

ACCUM_V_H				; ώZdl H
ACCUM_V_L				; ώZdl L
ACCUM_C_H				; ώZdl H
ACCUM_C_L				; ώZdl L

V_MAX					; dől
V_MIN					; dŏl
C_MAX					; dől
C_MIN					; dŏl

V_LEVEL					; dx
C_LEVEL					; dx

SIG_LEVEL				; \
PEAK_LEVEL				; s[Nl

V_PEAK					; d̃s[Nx
C_PEAK					; d̃s[Nx

V_PEAK_COUNT			; ds[N\pJE^
C_PEAK_COUNT			; ds[N\pJE^

LEVEL_COUNT				; x\ʒumFp
BAR_COUNTER				; x[^[\p[N

COOLING_COUNTER			; [d~JE^

MESURE_CNT				; f[^JE^

USER_FLAG				; etO

COUNTER1				; ԑ҂[N
COUNTER2
COUNTER3

TMP						; Gp[N

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------
;
;	RA0		A  IN	AN0, drdlv
;	RA1		A  IN	Vref+
;	RA2		D  OUT	gp
;	RA3		D  IN	s[Nz[hIWp
;	RA4		D  OUT	LCD E
;	RA5		D  OUT	LCD RS

;	RB4		*  IN   OP2-
;	RB5		*  IN   OP2+
;	RB6		D  IN	ߋf[^\/NAXCb`
;	RB7		D  OUT	[d
;
;	RC0		D  OUT	 LED
;	RC1		D  OUT	 LED
;	RC2		A  IN	AN6, IyAvdlv
;	RC3		D  OUT	LCD DB5
;	RC4		D  OUT	LCD DB4
;	RC5		D  IN	s[Nz[hIWp
;	RC6		D  OUT	LCD DB6
;	RC7		D  OUT	LCD DB7
;
;	LCD ʃC[W (16~2sj
;
;POS0   4 6         15
;   |   | |
;   12.5V ----------iۂ͊O\j
;   100mA ----------iۂ͊O\j
;
;---------------------------------------------------------------------------
; |[g`
;---------------------------------------------------------------------------

#DEFINE		LCD_CMD_PORT	PORTA		; LCD |[g
#DEFINE		LCD_DATA_PORT	PORTC		; LCD f[^o|[g

#DEFINE		RS			5			; RS Mq|[gԍ
#DEFINE		E			4			; E  Mq|[gԍ
#DEFINE		DB4			4			; DB4 ̃|[gԍ
#DEFINE		DB5			3			; DB5 ̃|[gԍ
#DEFINE		DB6			6			; DB6 ̃|[gԍ
#DEFINE		DB7			7			; DB7 ̃|[gԍ

LCD_CHR_LEN		EQU		D'32'	; gp LCD ̕\BLCD ύX͂C
								;  DEFINE ł̒`si /2 vZŕso邩j

#DEFINE		V_IN		0				; RA0
#DEFINE		PEAK_MODE	3				; RA3

#DEFINE		GREEN_LED	0				; RC0
#DEFINE		RED_LED		1				; RC1
#DEFINE		GRAPH_MODE	5				; RC5

#DEFINE		SWITCH		6				; RB6
#DEFINE		CHG_CTRL	7				; RB7

#DEFINE		V_SENS_P	0				; RA0Ado|[gԍ
#DEFINE		C_SENS_P	2				; RC2Ado|[gԍ
#DEFINE		V_SENSE		0				; AN0AdoAiO|[gԍ
#DEFINE		C_SENSE		6				; AN6AdoAiO|[gԍ

#DEFINE		MODE_PORT		PORTA, PEAK_MODE
#DEFINE		GRAPH_PORT		PORTC, GRAPH_MODE
#DEFINE		CHG_CTRL_PORT	PORTB, CHG_CTRL
#DEFINE		SW_PORT			PORTB, SWITCH
#DEFINE		RED_LED_PORT	PORTC, RED_LED
#DEFINE		GREEN_LED_PORT	PORTC, GREEN_LED

#DEFINE		V_HIGH_FLAG		USER_FLAG,0	; 0 = d, 1 = ߏ[dd
#DEFINE		CHARGE_FLAG		USER_FLAG,1	; 0 = [d~, 1 = [d
#DEFINE		CUR100_Z_FLAG	USER_FLAG,2	; 0 = dl100̈ʂ 0 ł͂ȂA1 = dl100̈ʂ 0 
#DEFINE		KEY_STATUS		USER_FLAG,3	; őlEŏl\L[͂̏ԁB1=ꂽA0=ĂȂ
#DEFINE		DISP_MODE		USER_FLAG,4	; 0 = ڃOt\A1 = x[^[\

;---------------------------------------------------------------------------
; 萔`
;---------------------------------------------------------------------------

;			 < VZONE1 <  < VZONE2 < 
;			ilj= 1/5.12, Vref+ = 5.0V, Vref- = GND Ńobed𑪒肵ꍇA
#DEFINE		V_LOW			D'95'		;  9.5V  8bit A/D ϊl = 9.5/5.12 * 255/5	o[\Q^p

#DEFINE		VZONE1			D'114'		; 11.5V  8bit A/D ϊl = 11.5/5.12 * 255/5	ȉ͐ԕ\
#DEFINE		VZONE2			D'123'		; 12.4V  8bit A/D ϊl = 12.4/5.12 * 255/5	ȉ͞\
#DEFINE		V_HIGH			D'147'		; 14.8V  8bit A/D ϊl = 14.8/5.12 * 255/5	[d~d

;	Vref+ = 5.0V, drd 1/5.12 ͂ 10bit A/D ϊ 4 Ŋƒǒlx10B
;	10`15V  50 JEgƂȂA10ڐŕ

#DEFINE		V_FACTOR		D'5'	; dx[^[1ڐԂ A/D ϊl

;	Vref+ = 5.0V 
;	dZT[ 100mA  100mV óB
;	39.06 { 10bit A/D ϊ 8 Ŋ 100mA  100 JEg
;	10ڐŕ邩

#DEFINE		C_FACTOR		D'5'	; dx[^[1ڐԂ A/D ϊl

#DEFINE		PEAK_INTERVAL	D'20'	; ő剽Ńs[Nz[hXV邩

#DEFINE		CHARGE_WAIT		D'50'	; [vԂ[d~邩B100ms x 50 = 5sec

#DEFINE		AVG_CONST		D'5'	; 񑪒肵ĕϒlvZ邩

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

	ORG		H'0'			; vOJnԒn̎w
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏigpj
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX
	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	BANK0

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC

	BANK1

	CLRF	TRISA			; Bank 1, S|[go͂ɐݒ
	CLRF	TRISB			; Bank 1, S|[go͂ɐݒ
	CLRF	TRISC			; Bank 1, S|[go͂ɐݒ

	CLRF	ANSEL0			; S|[gfW^ɐݒ
	CLRF	ANSEL1			; ANSEL ݒ TRIS ݒOłȂƃ_ƂET

	MOVLW	B'01110101'		; NbN 8MHz
	MOVWF	OSCCON			; Bank 1

	CLRF	OSCTUNE			; Bank 1, NbN
	CLRF	PIE1			; Bank 1, 荞݂͑Sĕs

	BSF		TRISA,1			; Vref+ |[g͂ɐݒ
	NOP
	BSF		TRISA,V_SENS_P	; Bank 1, do|[g͂ɍĐݒ
	BSF		TRISB,SWITCH	; Bank 1, XCb`|[g͂ɍĐݒ
	BSF		TRISC,C_SENS_P	; Bank 1, do|[g (OP2=AN6) ͂ɍĐݒ
	NOP
	BSF		TRISC,GRAPH_MODE; Bank 1, Ot[hݒ|[g͂ɍĐݒ

	BSF		TRISB,PEAK_MODE	; Bank 1, s[N[hݒ|[g͂ɍĐݒ
	NOP
	BSF		TRISB,4			; OP2+ ͂ɐݒiAiOݒ܂ł͕svj
	NOP
	BSF		TRISB,5			; OP2- ͂ɐݒiAiOݒ܂ł͕svj

	BSF		ANSEL0,1		; Bank 1, Vref+ (AN1) AiO|[gɐݒ
	NOP
	BSF		ANSEL0,V_SENSE	; Bank 1, do|[g (AN0) AiOɐݒ
	NOP
	BSF		ANSEL0,C_SENSE	; Bank 1, do|[g (AN6) AiOɐݒ

;--------------------------------------------------------------------------------
;	A/D Ro[^[ݒ (10bit)
;--------------------------------------------------------------------------------

	MOVLW	B'00100000'		; Bank 1, 32 Tosc
	MOVWF	ADCON1

	BANK0

	MOVLW	B'11000001'		; El(10bit A/Dϊ), O Vref gp, AN0 (bit 5-2) gp, AD Ro[^d ON
	MOVWF	ADCON0

	BANK2

	CLRF	OPA1CON			; Bank 2, OPAMP1 OFF
	BSF		OPA2CON,OPAON	; Bank 2, OPAMP2 ON

	BANK0

;--------------------------------------------------------------------------------
;	ϐAʏ
;--------------------------------------------------------------------------------

	CALL	LCD_INI			; LCD 

	MOVLW	H'40'
	MOVWF	EEPROM_ADRS		; `Of[^̐擪AhX

	MOVLW	D'8'			; `O
	MOVWF	FONTS
	CLRF	FONT_NUM		; `̐擪ԍ
	CALL	SET_USER_FONT	; Oo^

	CALL	LCD_CLR			; LCD NA
	CALL	STARTUP			; Nʕ\
	CALL	LCD_CLR			; LCD NA

	CLRF	V_PEAK			; ds[NxZbg
	CLRF	C_PEAK			; ds[NxZbg

	MOVLW	PEAK_INTERVAL	; s[Nz[hōXV邩
	MOVWF	V_PEAK_COUNT	; s[N\pJE^
	MOVWF	C_PEAK_COUNT	; s[N\pJE^

	CALL	RESET_COOLING	; ߏ[d֌WNA

	CLRF	USER_FLAG		; etO

	CALL	RESET_DATA		; őlEŏl

RESTART:

	CALL	BUFFER_CLEAR	; ڃOtNAiBank 1 LCD obt@]pj

;--------------------------------------------------------------------------------
;	C[`
;--------------------------------------------------------------------------------

MAIN_LOOP:

	CALL	RESET_MES_CNT	; JE^Zbg
	CALL	RESET_ACC_DATA	; ώZlNA

	CALL	KEY_CHECK		; L[̓`FbN
	BTFSC	KEY_STATUS
	GOTO	DISP_MAX_MIN	; L[Ă΍őlEŏl\

MEASURE_LOOP:

	CALL	READ_DATA		; dAdǂݍŃx
	CALL	WAIT_10ms		; ҂
	CALL	WAIT_10ms		; ҂

;
;	l񐔉ZĐώZl𓾂
;

	CLRF	A1
	MOVF	V_DATA,W	; 1񕪂̓dl
	MOVWF	A2
	MOVF	ACCUM_V_H,W
	MOVWF	B1
	MOVF	ACCUM_V_L,W
	MOVWF	B2

	CALL	ADD16			; in Math16.libA A1A2

	MOVF	A1,W
	MOVWF	ACCUM_V_H
	MOVF	A2,W
	MOVWF	ACCUM_V_L

	CLRF	A1
	MOVF	C_DATA,W	; 1񕪂̓dl
	MOVWF	A2
	MOVF	ACCUM_C_H,W
	MOVWF	B1
	MOVF	ACCUM_C_L,W
	MOVWF	B2

	CALL	ADD16			; in Math16.libA A1A2

	MOVF	A1,W
	MOVWF	ACCUM_C_H
	MOVF	A2,W
	MOVWF	ACCUM_C_L

	DECFSZ	MESURE_CNT,F	; ̉񐔑
	GOTO	MEASURE_LOOP

;
;	ϒlvZ
;

	MOVF	ACCUM_V_H,W
	MOVWF	A1
	MOVF	ACCUM_V_L,W
	MOVWF	A2

	CLRF	B1
	MOVLW	AVG_CONST
	MOVWF	B2

	CALL	DIV16			; in Math16.lib,  A2

	MOVF	A2,W
	MOVWF	AVG_V			; ϓdl

	MOVF	ACCUM_C_H,W
	MOVWF	A1
	MOVF	ACCUM_C_L,W
	MOVWF	A2

	CLRF	B1
	MOVLW	AVG_CONST
	MOVWF	B2

	CALL	DIV16			; in Math16.lib,  A2

	MOVF	A2,W
	MOVWF	AVG_C			; ϓdl

;
;	dĎA[d
;

	CALL	DISP_LED		; LED \

	CALL	CHARGE_CTRL		; [d

;
;	\[h`FbN
;

	BTFSC	GRAPH_PORT
	GOTO	TRANSITION_GRAPH	; H = ڃOt\

;--------------------------------------------------------------------------------
;	x[^[\
;--------------------------------------------------------------------------------

	BTFSC	DISP_MODE
	GOTO	LEVEL_METER_START	; \[hύX

	BSF		DISP_MODE		; tOύX
	CALL	LCD_CLR			; ʂNA

LEVEL_METER_START:

	CLRF	V_LEVEL			; ЂƂ܂d́̐ 0 ɂĂ

	MOVF	AVG_V,W
	MOVWF	TMP

	MOVLW	V_LOW			; 10V Ԃ
	SUBWF	TMP,F			; Ô߃NbsOBTMP(AVG_V) - V_LOW -> TMP
	BTFSS	STATUS,C		; VOLTAGE >= V_LOW Ȃ؂ꂪȂ̂ C=1 ƂȂ莟̍sXLbv
	GOTO	SET_C_LEVEL		; V_LEVEL = 0 ̂܂ܓdl

	MOVLW	V_FACTOR
	CALL	CALC_LEVEL		; ߂l W = ̐
	MOVWF	V_LEVEL			; d́

SET_C_LEVEL:

	MOVF	AVG_C,W
	MOVWF	TMP
	MOVLW	C_FACTOR
	CALL	CALC_LEVEL		; ߂l W = ̐
	MOVWF	C_LEVEL			; d́

	BTFSS	MODE_PORT		; s[Nz[hݒ|[g`FbNiL = s[Nz[hj
	GOTO	PEAK_HOLD		; s[Nz[h\

							; o[\
	CLRF	V_PEAK			; d̃s[NxZbg
	CLRF	C_PEAK			; d̃s[NxZbg
	GOTO	DISP_LEVEL

PEAK_HOLD:

	CALL	SET_PEAK		; s[NlvZAs[Nz[hsv̏ꍇ̓RgAEg

DISP_LEVEL:

	CALL	LEVEL_METER		; x[^[\

	CALL	WAIT_100ms		; x[^[\̓f[^XVx߂

	GOTO	MAIN_LOOP		; ĊJ

;---------------------------------------------------------------------------
; ڃOt\
;	IN:		AVG_V, AVG_C
;---------------------------------------------------------------------------

TRANSITION_GRAPH:

	BTFSS	DISP_MODE
	GOTO	TRANS_GRAPH_START	; \[hύX

	BCF		DISP_MODE		; tOύX
	CALL	LCD_CLR			; ʂNA
	CALL	BUFFER_CLEAR	; ڃOtNAiBank 1 LCD obt@]pj

;
;	f[^]ăAbvf[g
;

TRANS_GRAPH_START:

	MOVLW	POS7			; ]AhX
	MOVWF	FSR

	MOVLW	D'9'			; 9oCg]
	MOVWF	TMP

	CALL	DATA_TRANSFER	; df[^]

	MOVLW	POS23			; ]AhX
	MOVWF	FSR

	MOVLW	D'9'			; 9oCg]
	MOVWF	TMP

	CALL	DATA_TRANSFER	; df[^]

;
;	obt@ŏIʒuŐṼf[^ɍXV
;
;
;	ϓdl  Oԍɕϊ  obt@ɏ
;	12V (=120) ` 14.4V (=144)  8  0.3V P
;

	MOVLW	D'120'			; 12V
	SUBWF	AVG_V,W			; V_AVG - 120 -> W
	BTFSC	STATUS,C		; if V_AVG < 120, C=0
	GOTO	SET_V_FONT		; l͈͐

	MOVLW	' '
	MOVWF	A1				; Xy[Xɒu
	GOTO	SET_V_FONT2

SET_V_FONT

	MOVWF	A1				; q
	MOVLW	D'3'			; 8ꍇ 0.3V Xebv
	MOVWF	B1				; 

	CALL	DIV8			; im Math16.libA A1

	MOVLW	D'8'
	SUBWF	A1,W			; A1 - W -> W
	BTFSS	STATUS,C		; if A1 >= W1, C=1, skip next line
	GOTO	SET_V_FONT2		; f[^␳KvȂ

	MOVLW	D'7'
	MOVWF	A1				; l␳

SET_V_FONT2:

	MOVLW	POS15
	MOVWF	FSR				; obt@ Bank 1 Ȃ̂ŗvԐڃAhbVO

	MOVF	A1,W			; W = OLN^R[h
	MOVWF	INDF			; obt@ɏœdlAbvf[g

;
;	ϓdl  Oԍɕϊ  obt@ɏ
;	0 (=0) ` 40 (=40 )  8  5mA P
;

	MOVF	AVG_C,W
	BTFSS	STATUS,Z		; dl 0 
	GOTO	SET_C_FONT

	MOVLW	' '				; Xy[Xɒu
	MOVWF	A1
	GOTO	SET_C_FONT2

SET_C_FONT:

	MOVWF	A1				; q
	MOVLW	D'5'			; 8ꍇ 5mA Xebv
	MOVWF	B1				; 

	CALL	DIV8			; im Math16.libA A1

	MOVLW	D'8'
	SUBWF	A1,W			; A1 - W -> W
	BTFSS	STATUS,C		; if A1 >= W1, C=1, skip next line
	GOTO	SET_C_FONT2		; f[^␳KvȂ

	MOVLW	D'7'
	MOVWF	A1				; l␳

SET_C_FONT2:

	MOVLW	POS31
	MOVWF	FSR				; obt@ Bank 1 Ȃ̂ŗvԐڃAhbVO

	MOVF	A1,W			; W = OLN^R[h
	MOVWF	INDF			; obt@ɏœdlAbvf[g

;
;	dl\
;

	CALL	LCD_1L			; J[\擪

	MOVF	AVG_V,W
	CALL	PRINT_VOLTAGE	; dilj\AJ[\ʒu 6i

	MOVLW	D'10'			; 10\
	MOVWF	TMP

	MOVLW	POS6			; d\f[^擪AhX
	MOVWF	FSR

DISP_V_TRANS_LOOP:

	MOVF	INDF,W
	CALL	LCD_WRITE		; 1\
	INCF	FSR,F

	DECFSZ	TMP,F
	GOTO	DISP_V_TRANS_LOOP

;
;	dl\
;

	CALL	LCD_2L			; J[\2sڂ̐擪

	MOVF	AVG_C,W
	CALL	PRINT_CURRENT	; dilj\AJ[\ʒu 6i

	MOVLW	D'10'			; 10\
	MOVWF	TMP

	MOVLW	POS22			; d\f[^擪AhX
	MOVWF	FSR

DISP_C_TRANS_LOOP:

	MOVF	INDF,W
	CALL	LCD_WRITE		; 1\
	INCF	FSR,F

	DECFSZ	TMP,F
	GOTO	DISP_C_TRANS_LOOP

;
;	\I
;

	GOTO	MAIN_LOOP

;---------------------------------------------------------------------------
; dEdőlAŏl\
; ʃC[W
; |  12.5V - 13.5V |
; |    0mA -  50mA |
;---------------------------------------------------------------------------

DISP_MAX_MIN:

	CALL	LCD_CLR			; ʂNA

	CALL	LCD_1L			; J[\1sڐ擪

	MOVF	V_MIN,W
	CALL	PRINT_VOLTAGE	; dŏl\

	MOVLW	' '
	CALL	LCD_WRITE		; 1\
	MOVLW	'-'
	CALL	LCD_WRITE		; 1\
	MOVLW	' '
	CALL	LCD_WRITE		; 1\
	MOVLW	' '
	CALL	LCD_WRITE		; 1\

	MOVF	V_MAX,W
	CALL	PRINT_VOLTAGE	; dől\

	CALL	LCD_2L			; J[\1sڐ擪

	MOVF	C_MIN,W
	CALL	PRINT_CURRENT	; dŏl\

	MOVLW	' '
	CALL	LCD_WRITE		; 1\
	MOVLW	'-'
	CALL	LCD_WRITE		; 1\
	MOVLW	' '
	CALL	LCD_WRITE		; 1\
	MOVLW	' '
	CALL	LCD_WRITE		; 1\

	MOVF	C_MAX,W
	CALL	PRINT_CURRENT	; dől\

	CALL	WAIT_1sec
	CALL	WAIT_1sec		; 2b҂ă`^Oh~

;---------------------------------------------------------------------------
; L[͊ĎAL[ꂽ܂܂ƃf[^NA
;---------------------------------------------------------------------------

	MOVLW	D'20'			; 100ms x 20 = 2sec L[XL
	MOVWF	TMP

SCAN_RESET:

	CALL	WAIT_100ms

	CALL	KEY_CHECK
	BTFSC	KEY_STATUS
	GOTO	DATA_CLEAR		; L[Ă̂Ńf[^NAL[̃`FbN

	DECFSZ	TMP,F
	GOTO	SCAN_RESET		; 莞ԃXL

	CALL	LCD_CLR			; ʃNA

	GOTO	RESTART			; L[삪̂ŗNAđĊJ

;---------------------------------------------------------------------------
; őlAŏl̃NA
;---------------------------------------------------------------------------

DATA_CLEAR:

	CALL	RESET_DATA		; őlAŏl

	MOVLW	H'80'
	MOVWF	EEPROM_ADRS		; AhX擪ɃZbg

	CALL	LCD_PRINT_EEPROM_DATA	; \

	CALL	WAIT_1sec		; 莞ԕ\ێ
	CALL	WAIT_1sec
	CALL	WAIT_1sec

	CALL	LCD_CLR			; ʃNA

	GOTO	RESTART			; NAđĊJ

;---------------------------------------------------------------------------
; Tu[`Q
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;	ڃOtpf[^̃Abvf[g
;	obt@ Bank 1AFSR ł̊ԐڃANZXKv
;---------------------------------------------------------------------------

DATA_TRANSFER:

	MOVF	INDF,W			; ]f[^ǂݏo
	DECF	FSR,F			; ]AhXw
	MOVWF	INDF			; ]
	INCF	FSR,F
	INCF	FSR,F			; ]AhX +1

	DECFSZ	TMP,F			; oCg]
	GOTO	DATA_TRANSFER

	RETURN

;---------------------------------------------------------------------------
; dAdl A/D ϊœ
; RETURN:	V_DATAiǒl x 10j, C_DATAiǒlj
;---------------------------------------------------------------------------

READ_DATA:

;
;	d
;
	MOVLW	B'11000001'		; El, O Vref, AN0, A/D CONV Power ON
	MOVWF	ADCON0
	CALL	EXEC_AD_CONV	; f[^擾Al A1A2 Ŗ߂Ă

	CLRF	B1
	MOVLW	D'4'
	MOVWF	B2

	CALL	DIV16			; 4 ŊĒǒlx10𓾂

	MOVF	A2,W			; A2 = A8bit Ȃ̂ŏʕsv
	MOVWF	V_DATA			; ϊf[^XgA

	SUBWF	V_MAX,W			; V_MAX - V_DATA(W) -> W
	BTFSC	STATUS,C		;  V_MAX < V_DATA Ȃ؂ꂪ C=0 Ŏ̍sXLbv
	GOTO	CHECK_V_MIN		; őlύXȂAŏl`FbN

	MOVF	V_DATA,W
	MOVWF	V_MAX			; őlXV

	GOTO	READ_CURRENT	; dl

CHECK_V_MIN:

	MOVF	V_DATA,W
	SUBWF	V_MIN,W			; V_MIN - V_DATA(W) -> W
	BTFSS	STATUS,C		;  V_MIN >= V_DATA Ȃ؂ꂪ C=1 Ŏ̍sXLbv
	GOTO	READ_CURRENT	; ŏlύXȂ

	MOVF	V_DATA,W
	MOVWF	V_MIN			; ŏlXV
;
;	d
;

READ_CURRENT:

	MOVLW	B'11011001'		; El, O Vref, AN6, A/D CONV Power ON
	MOVWF	ADCON0
	CALL	EXEC_AD_CONV	; f[^擾Al A1A2 Ŗ߂Ă

	CLRF	B1
	MOVLW	D'8'
	MOVWF	B2

	CALL	DIV16			; 8 ŊĒǒl𓾂

	MOVF	A2,W			; A2 = A8bit Ȃ̂ŏʕsv
	MOVWF	C_DATA			; ϊf[^XgA

	SUBWF	C_MAX,W			; C_MAX - C_DATA(W) -> W
	BTFSC	STATUS,C		;  C_MAX < C_DATA Ȃ؂ꂪ C=0 Ŏ̍sXLbv
	GOTO	CHECK_C_MIN		; őlύXȂAŏl`FbN

	MOVF	C_DATA,W
	MOVWF	C_MAX			; őlXV

	RETURN

CHECK_C_MIN:

	MOVF	C_DATA,W
	SUBWF	C_MIN,W			; C_MIN - C_DATA(W) -> W
	BTFSS	STATUS,C		;  C_MIN >= C_DATA Ȃ؂ꂪ C=1 Ŏ̍sXLbv
	RETURN					; ŏlύXȂ

	MOVF	C_DATA,W
	MOVWF	C_MIN			; ŏlXV

	RETURN

;---------------------------------------------------------------------------
; xľijAXP[j
; i LOG XP[͂KXύXőΉj
; IN:	W			A/DlŁPԂ
; IN:	TMP			ϓdl͕ϓdl
; OUT:	W			xǐjA0 肤
;---------------------------------------------------------------------------

CALC_LEVEL:

	MOVWF	B1				; Ƃ肠XgA

	MOVF	TMP,W			; l 0 `FbN
	BTFSC	STATUS,Z
	RETURN					; l 0 Ȃ W=0 mł̂܂ܖ߂

	MOVWF	A1				; q

	CALL	DIV8			; in Math16.lib,  A1

	MOVLW	D'11'
	SUBWF	A1,W			; Ô߃NbsOBA1 - 11 -> W
	BTFSC	STATUS,C		; A1 < 11  Ȃ؂ꂪ C=0 ƂȂ莟̍sXLbv
	GOTO	MAX_LEVEL		; MAX LEVEL

	MOVF	A1,W
	RETURN

MAX_LEVEL:

	MOVLW	D'10'			; ől
	RETURN

;--------------------------------------------------------------------------------
; s[NvZ
;--------------------------------------------------------------------------------

SET_PEAK:					; d

	MOVF	V_LEVEL,W
	SUBWF	V_PEAK,W		; V_PEAK - V_LEVEL -> W
	BTFSS	STATUS,C		; if V_PEAK >= V_LEVEL, C=1, skip next line
	GOTO	RESET_PEAK_V	; s[Nl𒴂

	DECFSZ	V_PEAK_COUNT,F	; s[NlȉȂ̂Ńs[Nz[hԂ`FbN
	GOTO	SET_PEAK_C		; s[Nz[hȂ̂ŉȂ

RESET_PEAK_V:

	MOVF	V_LEVEL,W
	MOVWF	V_PEAK			; s[NlXV
	MOVLW	PEAK_INTERVAL
	MOVWF	V_PEAK_COUNT	; s[N\pJE^

SET_PEAK_C:					; d

	MOVF	C_LEVEL,W
	SUBWF	C_PEAK,W		; C_PEAK - V_LEVEL -> W
	BTFSS	STATUS,C		; if R_PEAL >= C_LEVEL, C=1, skip next line
	GOTO	RESET_PEAK_C	; s[Nl𒴂

	DECFSZ	C_PEAK_COUNT,F	; s[NlȉȂ̂Ńs[Nz[hԂ`FbN
	RETURN					; s[Nz[hȂ̂ŉȂ

RESET_PEAK_C:

	MOVF	C_LEVEL,W
	MOVWF	C_PEAK			; s[NlXV
	MOVLW	PEAK_INTERVAL
	MOVWF	C_PEAK_COUNT	; s[N\pJE^

	RETURN

;---------------------------------------------------------------------------
; x[^[\
; IN:	AVG_V, AVG_C		ϒl
;---------------------------------------------------------------------------

LEVEL_METER:
							; d
	CALL	LCD_1L			; J[\1sڐ擪

	MOVF	AVG_V,W
	CALL	PRINT_VOLTAGE	; dilj\AJ[\ʒu 6i

	MOVF	V_PEAK,W
	MOVWF	PEAK_LEVEL		; s[NlZbg
	MOVF	V_LEVEL,W		; xZbg
	CALL	DRAW_BAR		; o[`

							; d
	CALL	LCD_2L			; J[\2sڂ̐擪

	MOVF	AVG_C,W
	CALL	PRINT_CURRENT	; dilj\AJ[\ʒu 6i

	BTFSS	CHARGE_FLAG		; ݏ[d?
	GOTO	DISP_COOLING	; [d~Ȃ̂ŕ\ς

	MOVF	C_PEAK,W
	MOVWF	PEAK_LEVEL		; s[NlZbg
	MOVF	C_LEVEL,W		; xZbg
	CALL	DRAW_BAR		; o[`

	RETURN

;
;	ߏ[doɂ[d~iN[OjĂꍇ̕\
;

DISP_COOLING:

	MOVLW	'B'
	CALL	LCD_WRITE		; 1
	MOVLW	'a'
	CALL	LCD_WRITE		; 1
	MOVLW	't'
	CALL	LCD_WRITE		; 1
	MOVLW	't'
	CALL	LCD_WRITE		; 1
	MOVLW	'.'
	CALL	LCD_WRITE		; 1
	MOVLW	' '
	CALL	LCD_WRITE		; 1
	MOVLW	'F'
	CALL	LCD_WRITE		; 1
	MOVLW	'u'
	CALL	LCD_WRITE		; 1
	MOVLW	'l'
	CALL	LCD_WRITE		; 1
	MOVLW	'l'
	CALL	LCD_WRITE		; 1

	CLRF	C_PEAK			; s[Nl
	MOVLW	PEAK_INTERVAL
	MOVWF	C_PEAK_COUNT	; s[N\pJE^

	RETURN

;---------------------------------------------------------------------------
; xo[\Tu[`is[Nz[hΉj
; IN:	W			̕\
; IN:	PEAK_LEVEL	s[Nl
; V_PEAK = 0, C_PEAK = 0 Ȃo[\ɂȂ
;---------------------------------------------------------------------------

DRAW_BAR:

	MOVWF	SIG_LEVEL		; \񐔂ۑĂ
	MOVWF	BAR_COUNTER		; \񐔃Zbg

	MOVLW	D'1'
	MOVWF	LEVEL_COUNT		; \ʒu

	MOVF	SIG_LEVEL,W
	BTFSC	STATUS,Z		; 0łȂȂ瑱s
	GOTO	DRAW_SPACE		; 0ȂSXy[X

BAR_LOOP1:

	CALL	SET_BAR_CHAR	; LN^R[h߂
	CALL	LCD_WRITE		; 1
	INCF	LEVEL_COUNT,F	; JE^i߂

	DECFSZ	BAR_COUNTER,F
	GOTO	BAR_LOOP1

DRAW_SPACE:

	MOVF	SIG_LEVEL,W		; 
	SUBLW	D'10'			; 10 - W -> W = NA
	BTFSC	STATUS,Z
	RETURN					; SŖ߂ -> Z=1 ŏI

	MOVWF	BAR_COUNTER		; Xy[XŖ߂

BAR_LOOP2:

	MOVF	PEAK_LEVEL,W	; s[Nlǂݏo
	SUBWF	LEVEL_COUNT,W	; LEVEL_COUNT - PEAK_LEVEL -> W
	BTFSS	STATUS,Z		; s[Nl݂͌̕\ʒuƈv邩?
	GOTO	SET_SPACE		; vȂ̂ŃXy[X

	MOVF	PEAK_LEVEL,W	; s[Nlǂݏo
	BTFSC	STATUS,Z
	GOTO	SET_SPACE		; s[Nl 0 ̏ꍇ͋IɃXy[X

	CALL	SET_BAR_CHAR	; LN^R[h߂
	GOTO	BAR3

SET_SPACE:

	MOVLW	' '				; Xy[X ASCII R[h

BAR3:

	CALL	LCD_WRITE		; 1
	INCF	LEVEL_COUNT,F	; JE^i߂

	DECFSZ	BAR_COUNTER,F
	GOTO	BAR_LOOP2

	RETURN

;---------------------------------------------------------------------------
; o[Ot̕R[h (ASCII) \ʒuɏ]Č߂
; IN:		LEVEL_COUNTio[̈ʒu, 1-10j
; RETURN:	W  ASCII R[h
;---------------------------------------------------------------------------

SET_BAR_CHAR:

	MOVLW	D'2'
	SUBWF	LEVEL_COUNT,W	; LEVEL_COUNT - 2 -> W
	BTFSS	STATUS,C		;  LEVEL_COUNT >= 2 ȂL[ C=1 Ŏ̍sXLbv
	GOTO	SET_MIN_BAR		; LEVEL_COUNT < 2 Ȃ̂ŃLN^R[h␳

	MOVLW	D'9'
	SUBWF	LEVEL_COUNT,W	; LEVEL_COUNT - 9 -> W
	BTFSC	STATUS,C		;  LEVEL_COUNT < 9 ȂL[ C=0 Ŏ̍sXLbv
	GOTO	SET_MAX_BAR		; LEVEL_COUNT >= 9 Ȃ̂ŃLN^R[h␳

	MOVLW	D'2'
	SUBWF	LEVEL_COUNT,W	; l 3-9 Ȃ̂Œʏ폈B LEVEL_COUNT - W(2) -> W
	RETURN

SET_MIN_BAR:

	CLRW					; LN^R[h &H00 ɏC
	RETURN

SET_MAX_BAR:

	MOVLW	H'07'			; LN^R[h &H07 ɏC
	RETURN

;---------------------------------------------------------------------------
; ݂̃J[\ʒudilj\
; IN:	W = ǒlx10
;---------------------------------------------------------------------------

PRINT_VOLTAGE:

	MOVWF	prm1a			;  8bit XgA
	CLRF	prm1b			; 8bit 0 m

	CALL	HEX2DEC16		; in Math16.lib, BCD ϊ5̒10i
	CALL	BCD2ASCII16		; in Math16.lib, BCD  ASCII ϊ

	MOVLW	'0'				; ASCII code 0
	SUBWF	prm3c,W			; prm3c - '0' -> W
	BTFSS	STATUS,Z		; 100̈ʂ ASCII  '0' Ȃ Z=1 Ŏ̍sXLbv
	GOTO	PRINT_VOLTAGE3	; ̂܂܏p

	MOVLW	' '				; Xy[Xɒu
	MOVWF	prm3c

PRINT_VOLTAGE3:

	MOVF	prm3c,W			; 10̈
	CALL	LCD_WRITE		; 1\

	MOVF	prm3b,W			; 1̈
	CALL	LCD_WRITE		; 1\

	MOVLW	'.'
	CALL	LCD_WRITE		; 1\

	MOVF	prm3a,W			; 0.1̈
	CALL	LCD_WRITE		; 1\

	MOVLW	'V'
	CALL	LCD_WRITE		; 1\

	MOVLW	' '
	CALL	LCD_WRITE		; 1\

	RETURN

;---------------------------------------------------------------------------
; ݂̃J[\ʒudilj\
; IN:	W = ǒl
;---------------------------------------------------------------------------

PRINT_CURRENT:

	MOVWF	prm1a			;  8bit XgA
	CLRF	prm1b			; 8bit 0 m

	CALL	HEX2DEC16		; in Math16.lib, BCD ϊ5̒10i
	CALL	BCD2ASCII16		; in Math16.lib, BCD  ASCII ϊ
;
;	100 ̈
;
	BCF		CUR100_Z_FLAG	; tONAĂ

	MOVLW	'0'				; ASCII code 0
	SUBWF	prm3c,W			; prm3c - '0' -> W
	BTFSS	STATUS,Z		; 100̈ʂ ASCII  '0' Ȃ Z=1 Ŏ̍sXLbv
	GOTO	PRINT_CURRENT2	; ̂܂܏p

	BSF		CUR100_Z_FLAG	; tOZbg
	MOVLW	' '				; '0' Xy[Xɒu
	MOVWF	prm3c

PRINT_CURRENT2:

	MOVF	prm3c,W			; AXL[R[hǂݏo
	CALL	LCD_WRITE		; 1\
;
;	10 ̈
;
	BTFSS	CUR100_Z_FLAG	; 100̈ʂ '0'  ?
	GOTO	PRINT_CURRENT3	; 0 ł͂Ȃ = 10 ̈ʂ 0 ł̂ł̂܂ܑs
;
;	10 ̈ʂ 0 `FbN
;
	MOVLW	'0'				; ASCII code 0
	SUBWF	prm3b,W			; prm3b - '0' -> W
	BTFSS	STATUS,Z		; 10̈ʂ ASCII  '0' Ȃ Z=1 Ŏ̍sXLbv
	GOTO	PRINT_CURRENT3	; ̂܂܏p

	MOVLW	' '				; '0' Xy[Xɒu
	MOVWF	prm3b

PRINT_CURRENT3:

	MOVF	prm3b,W			; 10̈
	CALL	LCD_WRITE		; 1\
;
;	1 ̈
;
	MOVF	prm3a,W			; 1̈
	CALL	LCD_WRITE		; 1\

	MOVLW	'm'
	CALL	LCD_WRITE		; 1\

	MOVLW	'A'
	CALL	LCD_WRITE		; 1\

	MOVLW	' '
	CALL	LCD_WRITE		; 1\

	RETURN

;--------------------------------------------------------------------------------
;	LED \FAߏ[do
;	 < VZONE1 <  < VZONE2 < 
;	IN: AVG_V (obedϒl)
;--------------------------------------------------------------------------------

DISP_LED:

	BCF		V_HIGH_FLAG			; ߏ[ddtOЂƂ܂Zbg

	MOVF	AVG_V,W				; AVG_V = BATTERY 
	SUBLW	VZONE1				; VZONE1 - BATTERY -> W
	BTFSS	STATUS,C			; if BATTERY <= VZONE1, C=1 -> skip next line
	GOTO	ZONE2

	BSF		RED_LED_PORT
	NOP
	BCF		GREEN_LED_PORT

	RETURN

ZONE2:

	MOVF	AVG_V,W
	SUBLW	VZONE2				; VZONE2 - BATTERY -> W
	BTFSS	STATUS,C			; if BATTERY <= VZONE2, C=1 -> skip next line
	GOTO	ZONE3

	BSF		GREEN_LED_PORT		; vӓdA_
	NOP
	BSF		RED_LED_PORT

	RETURN

ZONE3:

	BCF		RED_LED_PORT
	NOP
	BSF		GREEN_LED_PORT		; dAΓ_

	MOVF	AVG_V,W
	SUBLW	V_HIGH				; V_HIGH - BATTERY -> W
	BTFSS	STATUS,C			; if BATTERY <= V_HIGH, C=1 -> skip next line
	BSF		V_HIGH_FLAG			; ߏ[ddɒBĂ̂ŃtOZbg

	RETURN

;--------------------------------------------------------------------------------
;	10 bit A/D ϊs
;	RETURN: A1, A2
;--------------------------------------------------------------------------------

EXEC_AD_CONV:

	CALL	WAIT_100us		; v`[W҂
	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	A1				; ɃXgA

	BANKSEL	ADRESL			; Bank 1
	MOVF	ADRESL,W		; A/D ϊliʁjǂݏo

	BANKSEL	PORTA			; Bank 0
	MOVWF	A2				; ɃXgA (BANK0ɂ_ɒӁj

	RETURN

;--------------------------------------------------------------------------------
;	[d
;--------------------------------------------------------------------------------

CHARGE_CTRL:

	BTFSS	V_HIGH_FLAG			; ߏ[ddɒBĂ邩
	GOTO	EXEC_CHARGE			; BĂȂ̂ŏ[d

	BCF		CHG_CTRL_PORT		; FET OFF ŏ[d~
	BCF		CHARGE_FLAG			; [dtONA

	MOVLW	CHARGE_WAIT			; [d~JE^lǂݏo
	MOVWF	COOLING_COUNTER		; 

	RETURN

EXEC_CHARGE:

	DECFSZ	COOLING_COUNTER,F	; ʏ[d̓JE^ 1 Ȃ̂Ŏ̍sXLbv
	RETURN						; N[OȂ珊񐔂܂ł͉Ȃ

	BSF		CHG_CTRL_PORT		; FET ON ď[d
	BSF		CHARGE_FLAG			; [dtOZbg

;--------------------------------------------------------------------------------
;	N[OJE^
;--------------------------------------------------------------------------------

RESET_COOLING:

	MOVLW	D'1'
	MOVWF	COOLING_COUNTER		; DECFSZ 1񂾂ʉ߂悤ɃZbg

	RETURN

;--------------------------------------------------------------------------------
;	f[^JE^
;--------------------------------------------------------------------------------

RESET_MES_CNT:

	MOVLW	AVG_CONST			; 񑪒肷邩
	MOVWF	MESURE_CNT

	RETURN

;--------------------------------------------------------------------------------
;	dőlEŏl̏
;--------------------------------------------------------------------------------

RESET_DATA:

	CLRF	V_MAX			; dől
	MOVLW	D'255'
	MOVWF	V_MIN			; dŏl

	CLRF	C_MAX			; dől
	MOVLW	D'255'
	MOVWF	C_MIN			; dŏl

	RETURN

;--------------------------------------------------------------------------------
;	ώZl̃NA
;--------------------------------------------------------------------------------

RESET_ACC_DATA:

	CLRF	ACCUM_V_H
	CLRF	ACCUM_V_L
	CLRF	ACCUM_C_H
	CLRF	ACCUM_C_L

	RETURN

;--------------------------------------------------------------------------------
;	L[`FbN
;	RETURN: KEYS_STATUS = 0  L[͉ĂȂA1  L[ꂽ
;--------------------------------------------------------------------------------

KEY_CHECK:

	BCF		KEY_STATUS		; tOZbgĂ

	BTFSC	SW_PORT			; {^ꂽ? L = ꂽ
	RETURN					; H = ĂȂ

	CALL	WAIT_100ms		; ꂽ炵΂炭҂i`^Oh~j

	BTFSC	SW_PORT			; ܂{^Ă邩?
	RETURN					; H = ĂȂ

	BSF		KEY_STATUS		; L[Ă̂ŃtO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	Nʕ\
;--------------------------------------------------------------------------------

STARTUP:

	CLRF		EEPROM_ADRS					; AhX EEPROM 擪ɃZbg
	CALL		LCD_PRINT_EEPROM_DATA		; EEPROM_ADRS ͎Iɐi

	CALL		WAIT_1sec
	CALL		WAIT_1sec

	CALL		LCD_PRINT_EEPROM_DATA

	CALL		WAIT_1sec
	CALL		WAIT_1sec

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		LCD_v4.lib
	INCLUDE		TIME-8MHz.lib
	INCLUDE		Math16.lib

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	ORG		H'2100'							; EEPROM JnԒnw

	DE	'B','a','t','t','e','r','y',' ','M','o','n','i','t','o','r',' '		; &H00-
	DE	' ','&',' ','C','h','a','r','g','e','r',' ','v','3','.','0','0'		; &H10-
	DE	'P','r','o','g','r','a','m','m','e','d',' ','b','y',' ',' ',' '		; &H20-
	DE	'G','R','A','N','A','D','A',' ','2','0','1','0','/','1','2',' '		; &H30-

;	Of[^ &H40`

	DE	B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00011111'	; &H40-
	DE	B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00011111', B'00011111'	; &H48
	DE	B'00000000', B'00000000', B'00000000', B'00000000', B'00000000', B'00011111', B'00011111', B'00011111'	; &H50-
	DE	B'00000000', B'00000000', B'00000000', B'00000000', B'00011111', B'00011111', B'00011111', B'00011111'	; &H58-
	DE	B'00000000', B'00000000', B'00000000', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111'	; &H60-
	DE	B'00000000', B'00000000', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111'	; &H68-
	DE	B'00000000', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111'	; &H70-
	DE	B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111', B'00011111'	; &H78-

;	bZ[Wf[^

	DE	'M','a','x',' ','&',' ','M','i','n',' ','d','a','t','a',' ',' '		; &H80-
	DE	'c','l','e','a','r','e','d','.',' ',' ',' ',' ',' ',' ',' ',' '		; &H90-

	END
