;--------------------------------------------------------------------------------
;	PIC16F887EHdgvOtJ_[ Programmed by GRANADA
;
;	Ver	1.0		2010/12/21 - 2011/01/04
;	Ver	1.1		2011/01/05					DP ZOggpɕύX
;	Ver	1.2		2011/01/05					P̏ꍇ̕\ʒuύXAؗjΗjɂȂoOC
;	Ver	1.3		2011/01/09 - 2011/01/10		G[`FbNA}gNX_hbgɉċPx
;	Ver	2.0		2011/01/11					\[XhCoΉɂPxsv
;	Ver	2.1		2011/01/14					␳ςݓt܂ŁuHv\AjG[oOtBbNX
;
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Calender.htm
;--------------------------------------------------------------------------------

	LIST		P=16F887
	INCLUDE		P16F887.INC
	INCLUDE		Original_Macro.lib

	ERRORLEVEL	-205
	ERRORLEVEL	-302

    __CONFIG    _CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_ON & _IESO_OFF & _BOR_ON & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _EC_OSC

    __CONFIG    _CONFIG2, _WRT_OFF & _BOR40V

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	MONTH_H				; \pf[^
	MONTH_L				; \pf[^
	DAY_H				; \pf[^
	DAY_L				; \pf[^

	WEEK				; j

	ROW					; }gNXs\Ǘp[N

	WORK				; ėp[N
	CNT					; ėpJE^

	COUNTER1			; ԑ҂p[N
	COUNTER2			; ԑ҂p[N
	COUNTER3			; ԑ҂p[N

	CLB_WAIT_CNT		; Zςݓt擾gCp[N

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; ݑޔp
	ST_WORK				; ݑޔp
	FSR_WORK			; ݑޔp

	USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		FONT_DATA_TOP	H'40'		; tHgf[^ EEPROM 擪AhX

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		RS232C_STR_END		USER_FLAG,0	; 1 = RS232C 𐳏ɎMI
#DEFINE		KEY_FLAG			USER_FLAG,1	; 1 = L[ꂽ
#DEFINE		DATA_ERROR			USER_FLAG,2	; 1 = Mf[^CM[l܂
#DEFINE		CALIB_FLAG			USER_FLAG,3	; 1 = Zꂽf[^Ă

#DEFINE		LCD_CMD_PORT	PORTA
#DEFINE		LCD_DATA_PORT	PORTA		; LCD_CMD_PORT  LCD_DATA_PORT ͓łǂ
#DEFINE		E				0			; LCD E  Mq|[gԍ
#DEFINE		RS				1			; LCD RS Mq|[gԍ
#DEFINE		DB4				2			; LCD DB4 ̃|[gԍ
#DEFINE		DB5				3			; LCD DB5 ̃|[gԍ
#DEFINE		DB6				4			; LCD DB6 ̃|[gԍ
#DEFINE		DB7				5			; LCD DB7 ̃|[gԍ

#DEFINE		DAY_SIG_PORT	PORTC,5		; tύXM̓|[g`
#DEFINE		SW_PORT			PORTE,3		; XCb`̓|[g`

#DEFINE		BCD_A			PORTC,0		; 74LS247 ւ BCD f[^|[g
#DEFINE		BCD_B			PORTC,1		; 74LS247 ւ BCD f[^|[g
#DEFINE		BCD_C			PORTC,2		; 74LS247 ւ BCD f[^|[g
#DEFINE		BCD_D			PORTC,3		; 74LS247 ւ BCD f[^|[g
#DEFINE		DP_PORT			PORTA,6		; DP LED |[g

#DEFINE		C1_PORT			PORTE,0		; 7 ZO LED 1 ڐ|[g
#DEFINE		C2_PORT			PORTE,1		; 7 ZO LED 2 ڐ|[g
#DEFINE		C3_PORT			PORTE,2		; 7 ZO LED 3 ڐ|[g
#DEFINE		C4_PORT			PORTC,4		; 7 ZO LED 4 ڐ|[g

#DEFINE		ROW_PORT		PORTB		; hbg}gNX LED s|[g
#DEFINE		COL_PORT		PORTD		; hbg}gNX LED 񐧌|[g

#DEFINE		ROW0			ROW_PORT,0	; hbg}gbNX ROW0 |[g
#DEFINE		ROW1			ROW_PORT,1	; hbg}gbNX ROW1 |[g
#DEFINE		ROW2			ROW_PORT,2	; hbg}gbNX ROW2 |[g
#DEFINE		ROW3			ROW_PORT,3	; hbg}gbNX ROW3 |[g
#DEFINE		ROW4			ROW_PORT,4	; hbg}gbNX ROW4 |[g
#DEFINE		ROW5			ROW_PORT,5	; hbg}gbNX ROW5 |[g
#DEFINE		ROW6			ROW_PORT,6	; hbg}gbNX ROW6 |[g
#DEFINE		ROW7			ROW_PORT,7	; hbg}gbNX ROW7 |[g

#DEFINE		COL0			COL_PORT,0	; hbg}gbNX COL0 |[g
#DEFINE		COL1			COL_PORT,1	; hbg}gbNX COL1 |[g
#DEFINE		COL2			COL_PORT,2	; hbg}gbNX COL2 |[g
#DEFINE		COL3			COL_PORT,3	; hbg}gbNX COL3 |[g
#DEFINE		COL4			COL_PORT,4	; hbg}gbNX COL4 |[g
#DEFINE		COL5			COL_PORT,5	; hbg}gbNX COL5 |[g
#DEFINE		COL6			COL_PORT,6	; hbg}gbNX COL6 |[g
#DEFINE		COL7			COL_PORT,7	; hbg}gbNX COL7 |[g

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏigpj
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX

	MOVWF	W_WORK			; WX^Ҕ
	SWAPF	STATUS,W		; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK			; STATUS WX^ۑ Bank A\
	MOVF	FSR,W
	MOVWF	FSR_WORK

	BANK0					; Bank Iɖ߂ĂBݏIɂ̓oN͎Iɖ߂

;
;	ݏ{
;


;
;	ݏI
;

POP_REG:					; WX^A`荞ݏI

	MOVF	FSR_WORK,W
	MOVWF	FSR
	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	CLRF	PIR1			; ݌NA

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

INITIALIZE:

	CLRF	INTCON			; Bank 0, 荞݂͋Ȃ

	BANK1

	CLRF	PIE1			; Bank 1, 荞݂͑Sĕs

	CLRF	TRISA			; Bank 1, ЂƂ܂S|[go͂Ɏw
	CLRF	TRISB			; Bank 1
	CLRF	TRISC			; Bank 1
	CLRF	TRISD			; Bank 1
	CLRF	TRISE			; Bank 1

	BSF		TRISC,5			; Bank 1, tύXM|[g͂֍Đݒ
	BSF		TRISA,7			; Bank 1, OSC1

	BANK3

	CLRF	ANSEL			; Bank 3, S|[gfW^ɐݒ
	CLRF	ANSELH			; Bank 3

;--------------------------------------------------------------------------------
;	RS232C ֘AWX^̏ݒ
;--------------------------------------------------------------------------------

	CALL	INIT_PIC_RESISTER	; in RS232C.lib

;--------------------------------------------------------------------------------
;	̑ݒ (Bank0)
;--------------------------------------------------------------------------------

	BANK0

	CLRF	USER_FLAG			; etO

	CALL	CLR_7SEG			; 7ZO LED NA
	CALL	CLR_MATRIX			; }gNX LED NA

;--------------------------------------------------------------------------------
;	LCD `Nʕ\
;--------------------------------------------------------------------------------

	CALL	LCD_INI				; LCD 
	CALL	STARTUP				; Nʕ\
	CALL	LCD_CLR				; LCD NA

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

UPDATE:

	CALL	GET_DATA			; f[^擾
	CALL	DISP_LCD			; LCD \itbVsvj

;
;	f[^\i_Ci~bN_Ȃ̂ŃtbVKvj
;

MAIN_LOOP:

	CALL	DISP_MONTH			; \
	CALL	DISP_WEEK			; j\

;
;	tύXM`FbN
;

	BTFSC	DAY_SIG_PORT
	GOTO	CHK_SW				; tXVM͂ĂȂ

	CALL	WAIT_5ms_16MHz
	CALL	WAIT_5ms_16MHz		; 10ms ҂

	BTFSC	DAY_SIG_PORT		; x`FbN
	GOTO	CHK_SW				; tXVM͂ĂȂ

;
;	tXVM
;

	CALL	WAIT_100ms_16MHz	; pX 100ms ȏ҂
	CALL	WAIT_100ms_16MHz

	GOTO	UPDATE				; f[^XV

;
;	L[`FbN
;

CHK_SW:

	CALL	KEY_SCAN

	BTFSC	KEY_FLAG
	GOTO	UPDATE				; 1 = ꂽ̂Ńf[^XVs

	GOTO	MAIN_LOOP			; 0 = ĂȂ̂Ń_Ci~bN\p

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	Ɠ 7 ZO LED \
;	IN:		MONTH_H/L				8bit l
;	IN:		DAY_H/L					8bit l
;--------------------------------------------------------------------------------

DISP_MONTH:

	CALL	CLR_7SEG

	MOVF	MONTH_H,W		; 1ڂ 0  ?
	BTFSC	STATUS,Z
	GOTO	DISP_MONTH3		; 0 Ȃ\ʒuC

	CALL	DISP_NUM
	BCF		C1_PORT			; 1ړ_
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

DISP_MONTH2:

	MOVF	MONTH_L,W
	CALL	DISP_NUM
	BCF		C2_PORT			; 2
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

	GOTO	DISP_DP

DISP_MONTH3:				;  1Ȃ1ڂɕ\ʒuC

	MOVF	MONTH_L,W
	CALL	DISP_NUM
	BCF		C1_PORT			; 1
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

	MOVLW	D'15'			; 2ڂ̓uNȂ̂ 15
	CALL	DISP_NUM
	BCF		C2_PORT			; 2
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

DISP_DP:

	CALL	DP_ON
	CALL	LED_HOLD_LONG
	CALL	DP_OFF
	CALL	LED_HOLD_SHORT

DISP_DAY:

	CALL	CLR_7SEG

	MOVF	DAY_H,W
	BTFSC	STATUS,Z
	MOVLW	D'15'			; 0 Ȃ15 ɍĐݒ

	CALL	DISP_NUM
	BCF		C3_PORT			; 1ړ_
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

DISP_DAY2:

	MOVF	DAY_L,W
	CALL	DISP_NUM
	BCF		C4_PORT			; 2
	CALL	LED_HOLD_LONG

	CALL	CLR_7SEG
	CALL	LED_HOLD_SHORT

	RETURN

DP_ON:

	BCF		DP_PORT			; DP L = ON
	BCF		C2_PORT
	RETURN

DP_OFF:

	BSF		C2_PORT			; DP H = OFF
	BSF		DP_PORT
	RETURN

;--------------------------------------------------------------------------------
;	LED ̏Ԃ莞ԕێ
;	ɂĂ͎Mxቺ̋ꂠv
;--------------------------------------------------------------------------------

LED_HOLD_LONG:

	CALL	WAIT_100us_16MHz
	CALL	WAIT_500us_16MHz
	CALL	WAIT_500us_16MHz
	CALL	WAIT_500us_16MHz
	CALL	WAIT_500us_16MHz	; v 2.1ms
	RETURN

LED_HOLD_LONG2:

	CALL	WAIT_500us_16MHz
	CALL	WAIT_500us_16MHz
	CALL	WAIT_500us_16MHz
	CALL	WAIT_100us_16MHz
	CALL	WAIT_100us_16MHz	; v 1.7ms
	RETURN

LED_HOLD_SHORT:

	CALL	WAIT_25us_16MHz
	RETURN

;--------------------------------------------------------------------------------
;	BCD f[^ 74LS247 ɑBWORK ͉B
;	IN:		W				\鐔 (BCD)
;--------------------------------------------------------------------------------

DISP_NUM:

	MOVWF	WORK			; lޔ

	CALL	CLR_7SEG		; 7 ZOSA74LS247 A-D ւ̃|[g H ɂȂĂ

	BTFSS	WORK,0
	BCF		BCD_A			; BCD f[^o

	BTFSS	WORK,1
	BCF		BCD_B

	BTFSS	WORK,2
	BCF		BCD_C

	BTFSS	WORK,3
	BCF		BCD_D

	RETURN

;--------------------------------------------------------------------------------
;	7ZO LED S OFFA74LS247  15 𑗂
;--------------------------------------------------------------------------------

CLR_7SEG:

	BSF		BCD_A
	NOP
	BSF		BCD_B
	NOP
	BSF		BCD_C
	NOP
	BSF		BCD_D
	BSF		DP_PORT			; DP H = OFF

	BSF		C1_PORT			;  OFF ( H = OFF)
	NOP
	BSF		C2_PORT			;  OFF ( H = OFF)
	NOP
	BSF		C3_PORT			;  OFF ( H = OFF)
	BSF		C4_PORT			;  OFF ( H = OFF)

	RETURN

;--------------------------------------------------------------------------------
;	j̃}gNX LED \
;	Bank 1 ̃ɗ\߃tHgZbgĂ
;	WORK, ROW ͉
;--------------------------------------------------------------------------------

DISP_WEEK:

	CALL	CLR_MATRIX		; hbg}gbNXS

	MOVLW	D'8'
	MOVWF	WORK

	MOVLW	B'00000001'		; ROW0 X^[g
	MOVWF	ROW				; \sǗp[N

	MOVLW	POS0			; Bank 1
	MOVWF	FSR				; obt@擪X^[g

MATRIX_ROW_LOOP:

	COMF	INDF,W			; COL ̓J\[hȂ̂Ńrbg]
	MOVWF	COL_PORT		; CɃf[^Zbg

	MOVF	ROW,W			; _sǂݏo
	MOVWF	ROW_PORT		; ws ON

	CALL	LED_HOLD_LONG2	; _

	CALL	CLR_MATRIX		; hbg}gbNXS
	CALL	LED_HOLD_SHORT

	BCF		STATUS,C
	RLF		ROW,F			; VtgĎ̕\sZbg

	INCF	FSR,F

	DECFSZ	WORK,F
	GOTO	MATRIX_ROW_LOOP	; 8sԂJԂ

	RETURN

;--------------------------------------------------------------------------------
;	}gNX LED OFF
;--------------------------------------------------------------------------------

CLR_MATRIX:

	MOVLW	B'11111111'
	MOVWF	COL_PORT		; COLiJ\[hjH

	CLRF	ROW_PORT		; ROWiAm[hjL

	RETURN

;--------------------------------------------------------------------------------
;	Ɠ LCD ɕ\
;
;	IN:		MONTH_H/L
;	IN:		DAY_H/L
;	IN:		WEEK				8bit lA0= ` 6=y, 7=G[
;--------------------------------------------------------------------------------

DISP_LCD:

;
;	\
;

	CALL	LCD_1L			; J[\1sڐ擪

	MOVLW	'M'
	CALL	LCD_WRITE		; 1\

	MOVLW	'O'
	CALL	LCD_WRITE		; 1\

	MOVLW	'N'
	CALL	LCD_WRITE		; 1\

	MOVLW	'T'
	CALL	LCD_WRITE		; 1\

	MOVLW	'H'
	CALL	LCD_WRITE		; 1\

	MOVLW	':'
	CALL	LCD_WRITE		; 1\

	MOVF	MONTH_H,W
	BTFSS	STATUS,Z
	GOTO	MONTH1			; 0 ł͂Ȃ̂Ń[TvXsv

	MOVLW	' '				; [TvX
	GOTO	MONTH2

MONTH1:

	MOVLW	'0'
	ADDWF	MONTH_H,W		; ASCII R[hɕϊ

MONTH2:

	CALL	LCD_WRITE		; 1\

	MOVLW	'0'
	ADDWF	MONTH_L,W		; ASCII R[hɕϊ
	CALL	LCD_WRITE		; 1\

	MOVLW	' '
	CALL	LCD_WRITE		; 1\

;
;	\
;

	MOVLW	'D'
	CALL	LCD_WRITE		; 1\

	MOVLW	'A'
	CALL	LCD_WRITE		; 1\

	MOVLW	'Y'
	CALL	LCD_WRITE		; 1\

	MOVLW	':'
	CALL	LCD_WRITE		; 1\

	MOVF	DAY_H,W
	BTFSS	STATUS,Z
	GOTO	DAY1			; 0 łȂȂ[TvXsv

	MOVLW	' '				; [TvX
	GOTO	DAY2

DAY1:

	MOVLW	'0'
	ADDWF	DAY_H,W			; ASCII R[hɕϊ

DAY2:

	CALL	LCD_WRITE		; 1\

	MOVLW	'0'
	ADDWF	DAY_L,W			; ASCII R[hɕϊ
	CALL	LCD_WRITE		; 1\

;
;	T\
;

	CALL	LCD_2L			; J[\2sڐ擪

	MOVF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	SUNDAY

	MOVLW	D'1'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	MONDAY

	MOVLW	D'2'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	TUESDAY

	MOVLW	D'3'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	WEDNESDAY

	MOVLW	D'4'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	THURSDAY

	MOVLW	D'5'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	FRIDAY

	MOVLW	D'6'
	SUBWF	WEEK,W
	BTFSC	STATUS,Z
	GOTO	SATURDAY

	MOVLW	'?'				; js
	CALL	LCD_WRITE		; 1\
	MOVLW	'?'
	CALL	LCD_WRITE		; 1\
	MOVLW	'?'
	CALL	LCD_WRITE		; 1\
	RETURN

SATURDAY:

	MOVLW	'S'
	CALL	LCD_WRITE		; 1\
	MOVLW	'A'
	CALL	LCD_WRITE		; 1\
	MOVLW	'T'
	CALL	LCD_WRITE		; 1\
	RETURN

FRIDAY:

	MOVLW	'F'
	CALL	LCD_WRITE		; 1\
	MOVLW	'R'
	CALL	LCD_WRITE		; 1\
	MOVLW	'I'
	CALL	LCD_WRITE		; 1\
	RETURN

THURSDAY:

	MOVLW	'T'
	CALL	LCD_WRITE		; 1\
	MOVLW	'H'
	CALL	LCD_WRITE		; 1\
	MOVLW	'U'
	CALL	LCD_WRITE		; 1\
	RETURN

WEDNESDAY:

	MOVLW	'W'
	CALL	LCD_WRITE		; 1\
	MOVLW	'E'
	CALL	LCD_WRITE		; 1\
	MOVLW	'D'
	CALL	LCD_WRITE		; 1\
	RETURN

TUESDAY:

	MOVLW	'T'
	CALL	LCD_WRITE		; 1\
	MOVLW	'U'
	CALL	LCD_WRITE		; 1\
	MOVLW	'E'
	CALL	LCD_WRITE		; 1\
	RETURN

MONDAY:

	MOVLW	'M'
	CALL	LCD_WRITE		; 1\
	MOVLW	'O'
	CALL	LCD_WRITE		; 1\
	MOVLW	'N'
	CALL	LCD_WRITE		; 1\
	RETURN

SUNDAY;

	MOVLW	'S'
	CALL	LCD_WRITE		; 1\
	MOVLW	'U'
	CALL	LCD_WRITE		; 1\
	MOVLW	'N'
	CALL	LCD_WRITE		; 1\
	RETURN

;--------------------------------------------------------------------------------
;	dgvtEjf[^擾
;--------------------------------------------------------------------------------

GET_DATA:

	CALL	LCD_CLR
	CALL	LCD_1L

	MOVLW	H'80'					; AhXZbg
	MOVWF	EEPROM_ADRS
	CALL	LCD_PRINT_EEPROM_DATA	; EEPROM_ADRS ͕\Ԃ񎩓Iɐi

GET_DATA2:

	CALL	DP_ON					; DP LED _
	CALL	SEND_DATE_CMD			; R}ho

	MOVLW	RX_BUFFER				; Mobt@擪AhXiBANK 2 Ӂj
	MOVWF	FSR

READ_LOOP:

	CALL	READ_CHAR_232C			; CALL  FSR_BANK23 ɐݒ肳

	BTFSC	RS232C_STR_END			; ԓɕMłtO`FbN
	GOTO	DECODE_DATA				; M OKA͏

;--------------------------------------------------------------------------------
;	^CAEĝŃgC
;--------------------------------------------------------------------------------

RETRY:

	CALL	LCD_CLR
	CALL	LCD_1L

	MOVLW	H'C0'					; AhXZbg
	MOVWF	EEPROM_ADRS
	CALL	LCD_PRINT_EEPROM_DATA	; EEPROM_ADRS ͕\Ԃ񎩓Iɐi

	CALL	WAIT_500ms_16MHz		; LCD \ێ
	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz

	GOTO	GET_DATA2				; ēxR}ho蒼

;--------------------------------------------------------------------------------
;	f[^MA͊Jn
;--------------------------------------------------------------------------------

DECODE_DATA:

	BCF		DATA_ERROR			; G[tONAĂ
	BCF		CALIB_FLAG			; ZtONAĂ

	CALL	DP_OFF				; DP LED 

	FSR_BANK23					; macro

	MOVLW	RX_BUFFER			; Mobt@擪AhXiBANK 2 Ӂj
	MOVWF	FSR					; N1
	INCF	FSR,F				; N2

	INCF	FSR,F				; N3
	MOVLW	'0'
	SUBWF	INDF,W				; N3ڂ 0 Ȃ疢Z
	BTFSS	STATUS,Z
	BSF		CALIB_FLAG			; Zς݂Ȃ̂ŃtO𗧂Ă

	INCF	FSR,F				; N4
	INCF	FSR,F				; /

	INCF	FSR,F				; 
	MOVLW	'0'					; ASCII 0
	SUBWF	INDF,W
	MOVWF	MONTH_H

	MOVLW	D'2'
	SUBWF	MONTH_H,W			; MONTH_H - 2 -> W
	BTFSC	STATUS,C			; if MONTH_H < 2, C=0, skip next line
	BSF		DATA_ERROR			; sf[^Ȃ̂ŃtO𗧂ĂĂ

	INCF	FSR,F				; 
	MOVLW	'0'					; ASCII 0
	SUBWF	INDF,W
	MOVWF	MONTH_L

	MOVLW	D'10'
	SUBWF	MONTH_L,W			; MONTH_L - 10 -> W
	BTFSC	STATUS,C			; if MONTH_L < 10, C=0, skip next line
	BSF		DATA_ERROR			; sf[^Ȃ̂ŃtO𗧂ĂĂ

	INCF	FSR,F				; '/'

	INCF	FSR,F				; 
	MOVLW	'0'					; ASCII 0
	SUBWF	INDF,W
	MOVWF	DAY_H

	MOVLW	D'4'
	SUBWF	DAY_H,W				; DAY_H - 4 -> W
	BTFSC	STATUS,C			; if DAY_H < 4, C=0, skip next line
	BSF		DATA_ERROR			; sf[^Ȃ̂ŃtO𗧂ĂĂ

	INCF	FSR,F				; 
	MOVLW	'0'					; ASCII 0
	SUBWF	INDF,W
	MOVWF	DAY_L

	MOVLW	D'10'
	SUBWF	DAY_L,W				; DAY_L - 10 -> W
	BTFSC	STATUS,C			; if DAY_L < 10, C=0, skip next line
	BSF		DATA_ERROR			; sf[^Ȃ̂ŃtO𗧂ĂĂ
;
;								; jfR[h
;
	INCF	FSR,F				; ' '
	INCF	FSR,F				; jf[^擪

	MOVLW	'M'
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	MON					; jm

	MOVLW	'W'
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	WED					; jm

	MOVLW	'F'
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	FRI					; jm

	MOVLW	'S'
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	SUN_SAT				; yjjAɃ`FbN

	MOVLW	'T'
	SUBWF	INDF,W
	BTFSS	STATUS,Z
	GOTO	WEEK_ERROR			; ؗjłΗjłȂ̂ŃG[

	INCF	FSR,F				; ̕
	MOVLW	'U'					; TU ?
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	TUE					; Ηjm

	MOVLW	'H'					; TH ?
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	THU					; ؗjm

	GOTO	WEEK_ERROR			; TU ł TH łȂ̂ŃG[

SUN_SAT:

	INCF	FSR,F				; ̕
	MOVLW	'U'					; SU ?
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	SUN					; jm

	MOVLW	'A'					; SA ?
	SUBWF	INDF,W
	BTFSC	STATUS,Z
	GOTO	SAT					; yjm

	GOTO	WEEK_ERROR			; SU ł SA łȂ̂ŃG[

SUN:
	CLRW
	GOTO	SET_WEEK_DATA

MON:
	MOVLW	D'1'
	GOTO	SET_WEEK_DATA

TUE:
	MOVLW	D'2'
	GOTO	SET_WEEK_DATA

WED:
	MOVLW	D'3'
	GOTO	SET_WEEK_DATA

THU:
	MOVLW	D'4'
	GOTO	SET_WEEK_DATA

FRI:
	MOVLW	D'5'
	GOTO	SET_WEEK_DATA

SAT:
	MOVLW	D'6'
	GOTO	SET_WEEK_DATA

WEEK_ERROR:

	BSF		DATA_ERROR			; sf[^Ȃ̂ŃtO𗧂ĂĂ

	MOVLW	D'7'				; j = uHv

SET_WEEK_DATA:

	MOVWF	WEEK				; jf[^𐔒lŃZbg

;--------------------------------------------------------------------------------
;	obt@ɎMf[^ LCD ɕ\
;	iCM[lĂĂ\j
;--------------------------------------------------------------------------------

	FSR_BANK01

	CALL	LCD_CLR				; \NA
	CALL	LCD_1L				; J[\擪s

	MOVLW	H'A0'					; AhXZbg
	MOVWF	EEPROM_ADRS
	CALL	LCD_PRINT_EEPROM_DATA	; EEPROM_ADRS ͎Iɐił

	CALL	LCD_2L				; J[\2sڐ擪

	FSR_BANK23

	MOVLW	RX_BUFFER			; Bank 2 
	MOVWF	FSR

	MOVLW	D'14'				; 14\
	MOVWF	WORK

DISP_RX_BUFFER:

	MOVF	INDF,W
	CALL	LCD_WRITE			; 1ÂMf[^\
	INCF	FSR,F

	DECFSZ	WORK,F
	GOTO	DISP_RX_BUFFER

	MOVLW	' '
	CALL	LCD_WRITE			; 1\

	MOVLW	' '
	CALL	LCD_WRITE			; 1\

	FSR_BANK01

	BTFSC	CALIB_FLAG
	GOTO	DISP_RECIEVED_WEEK	; Zς݃f[^Ȃ炻̂܂ܕ\

	MOVLW	D'7'
	MOVWF	WEEK				; ZOȂ̂ŁuHvɏC

DISP_RECIEVED_WEEK:

	CALL	SET_WEEK_FONT		; hbg}gNXptHgZbg

	CALL	DISP_WEEK_500ms		; hbg}gNX͎擾j\
	CALL	DISP_WEEK_500ms		; CM[lĂƁuHvɂȂ
	CALL	DISP_WEEK_500ms
	CALL	DISP_WEEK_500ms		; LCD f[^v 2 b\

	BTFSC	DATA_ERROR			; CM[l܂܂Ă
	GOTO	RETRY				; CM[lĂēx擾

	CALL	LCD_CLR
	CALL	LCD_1L

	BTFSC	CALIB_FLAG			; Zς݃f[^ ?
	RETURN						; 1 = Zς݂Ȃ̂ŐI

;--------------------------------------------------------------------------------
;	dgɂZςłȂꍇ
;--------------------------------------------------------------------------------

	MOVLW	H'E0'				; Non calibrated \
	MOVWF	EEPROM_ADRS
	CALL	LCD_PRINT_EEPROM_DATA

	MOVLW	D'7'				; uHv̗jԍ
	MOVWF	WEEK
	CALL	SET_WEEK_FONT		; }gNXptHgɃZbg

	MOVLW	D'120'				; 悻 120b҂ăgCALCD \͕ێ
	MOVWF	CLB_WAIT_CNT

CALIB_WAIT_LOOP:

	CALL	KEY_SCAN			; L[`FbN
	BTFSC	KEY_FLAG
	GOTO	EXIT_CALIB_WAIT		; ĂR}ho

	CALL	DP_ON				; DP _
	CALL	DISP_WEEK_500ms		; hbg}gNX\
	CALL	DP_OFF				; DP 

	CALL	KEY_SCAN			; L[`FbN
	BTFSC	KEY_FLAG
	GOTO	EXIT_CALIB_WAIT		; ĂR}ho

	CALL	DISP_WEEK_500ms		; hbg}gNX\Av悻 1b

	DECFSZ	CLB_WAIT_CNT,F
	GOTO	CALIB_WAIT_LOOP		; 񐔃[v

EXIT_CALIB_WAIT:

	CALL	CLR_MATRIX			; hbg}gNX\

	GOTO	GET_DATA			; ēxR}ho蒼

;--------------------------------------------------------------------------------
;	hbg}gNXŗj 500ms \
;	tHgf[^͂炩߃ZbgĂ
;--------------------------------------------------------------------------------

DISP_WEEK_500ms:

	MOVLW	D'39'				; 12.8ms x 39  500ms
	MOVWF	CNT

DISP_WK500:

	CALL	DISP_WEEK			; 12.8ms

	DECFSZ	CNT,F
	GOTO	DISP_WK500

	RETURN

;--------------------------------------------------------------------------------
;	EEPROM  j̃tHgf[^ǂݏoABank 1 ̃ɃZbgBWORK ͉
;	IN:		WEEK				8bit lA0= ` 6=yA7 =u?v
;--------------------------------------------------------------------------------

SET_WEEK_FONT:

	MOVLW	FONT_DATA_TOP		; jtHge[u̐擪AhX
	MOVWF	EEPROM_ADRS

	MOVF	WEEK,W
	MOVWF	WORK

CALC_FONT_ADRS:

	MOVLW	D'8'
	ADDWF	EEPROM_ADRS,F		; AhXvZ

	DECFSZ	WORK,F
	GOTO	CALC_FONT_ADRS

DISP_MATRIX:					; EEPROM_ADRS = tHgf[^AhX

	MOVLW	POS0				; Bank 1 obt@̐擪]Ɏw
	MOVWF	START_POS
	MOVLW	D'8'				; 8oCg擾
	MOVWF	EEPROM_LENGTH

	CALL	COPY_EEPROM_DATA	; f[^]s

	RETURN

;--------------------------------------------------------------------------------
;	dgvɃR}h𑗂
;	R}h Bank 2 ̃obt@ɃZbgA00H I[R[h
;	FSR ͉
;--------------------------------------------------------------------------------

SEND_DATE_CMD:

	FSR_BANK23						; macro

	MOVLW	TX_BUFFER				; Mobt@擪AhXiBANK 2 Ӂj
	MOVWF	FSR

	MOVLW	'D'
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	'A'
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	'T'
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	'E'
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	H'0D'
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	H'0A'
	MOVWF	INDF
	INCF	FSR,F

	CLRF	INDF					; I[R[h

	MOVLW	TX_BUFFER				; Mobt@擪AhXiBANK 2 Ӂj
	MOVWF	FSR

	CALL	SEND_STR_232C			; 񑗏o, in RS232C.lib

	RETURN

;--------------------------------------------------------------------------------
;	Nʕ\
;--------------------------------------------------------------------------------

STARTUP:

	CLRF	EEPROM_ADRS				; AhX EEPROM 擪ɃZbg
	CALL	LCD_PRINT_EEPROM_DATA	; EEPROM_ADRS ͎Iɐi

	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz

	CALL	LCD_PRINT_EEPROM_DATA

	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz
	CALL	WAIT_500ms_16MHz

	CALL	LCD_CLR

	RETURN

;--------------------------------------------------------------------------------
;	L[̓`FbN
;	Ă KEY_FLAG = 1 Ŗ߂
;--------------------------------------------------------------------------------

KEY_SCAN:

	BCF		KEY_FLAG			; tONAĂ

	BTFSC	SW_PORT				; L[ꂽ
	RETURN						; H = ĂȂ

	CALL	WAIT_50ms_16MHz		; `^Oh~

	BTFSC	SW_PORT				; ܂L[Ă邩
	RETURN						; H = ĂȂ

	CALL	WAIT_100ms_16MHz	; Ah~

	BSF		KEY_FLAG			; tO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		LCD_v4.lib			; LCD \pCu
	INCLUDE		RS232C.lib			; RS232C pCu
	INCLUDE		Wait.lib			; ԑ҂[vCu

;--------------------------------------------------------------------------------
;	EEPROM f[^`
;--------------------------------------------------------------------------------

	ORG		H'2100'		; EEPROM JnԒnw

	DE	'C','a','l','e','n','d','e','r',' ','V','e','r',' ','2','.','1'		; &H00-
	DE	'f','o','r',' ','W','a','v','e',' ','C','l','o','c','k',' ',' '		; &H10-
	DE	'P','r','o','g','r','a','m','m','e','d',' ','b','y',' ',' ',' '		; &H20-
	DE	'G','R','A','N','A','D','A',' ','2','0','1','1','/','0','1',' '		; &H30-

;	hbg}gNXtHgf[^
;	̃rbgp^[1oCgŒ`A8oCgōs`A1 = ON

	DE	B'00111110',B'00100010',B'00100010',B'00111110',B'00100010',B'00100010',B'00100010',B'00111110'	; &H40- 
	DE	B'00111110',B'00100010',B'00111110',B'00100010',B'00111110',B'00100010',B'00100010',B'01000110'	; &H48- 
	DE	B'00001000',B'01001001',B'01001001',B'00001000',B'00001000',B'00010100',B'00100010',B'01000001'	; &H50- 
	DE	B'00001001',B'00001010',B'01111100',B'00011100',B'00101010',B'01001001',B'00001000',B'00011000'	; &H58- 
	DE	B'00001000',B'00001000',B'01111111',B'00011100',B'00101010',B'01001001',B'00001000',B'00001000'	; &H60- 
	DE	B'00011100',B'00100010',B'01000001',B'00011100',B'00001000',B'01011101',B'00101010',B'01111111'	; &H68- 
	DE	B'00000000',B'00001000',B'00001000',B'00111110',B'00001000',B'00001000',B'00001000',B'01111111'	; &H70- y
	DE	B'00011100',B'00100010',B'00100010',B'00000010',B'00000100',B'00001000',B'00000000',B'00001000'	; &H78- H

;	fobOp LCD \

	DE	'D','A','T','E',' ','C','M','D',' ','s','e','n','d',' ','O','K'		; &H80-
	DE	'R','e','c','i','e','v','i','n','g',' ','d','a','t','a',' ',' '		; &H90-
	DE	'R','e','c','i','e','v','e','d',' ','S','t','r','i','n','g',':'		; &HA0-
	DE	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '		; &HB0-
	DE	'R','e','c','i','e','v','e',' ','f','a','i','l','e','d','.',' '		; &HC0-
	DE	'R','e','t','r','y','i','n','g','.','.','.',' ',' ',' ',' ',' '		; &HD0-
	DE	'N','o','t',' ','C','a','l','i','b','r','a','t','e','d','.',' '		; &HE0-
	DE	'R','e','t','r','y','i','n','g','.','.','.',' ',' ',' ',' ',' '		; &HF0-

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
