;--------------------------------------------------------------------------------
;	PIC16F785ExExEswv Programmed by GRANADA
;	Ver 1.0		2009/10/19 ` 2009/10/20         For K-common LED
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/16F785-TH-Meter.htm
;--------------------------------------------------------------------------------

	LIST		P=16F785
	INCLUDE		P16F785.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF 

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'		; [U[pt@CWX^iϐ̈j擪AhX

	TEMPERATURE_H		; xꎞXgAp
	TEMPERATURE_L

	HUMIDITY_H			; xꎞXgAp
	HUMIDITY_L

	TEMPERATURE_WORK	; swvZp[N
	HUMIDITY_WORK		; swvZp[N

	INDEX_H				; swvZp[N
	INDEX_M
	INDEX_L

	VOLTAGE_H			; A/D ϊlʈꎞXgAp
	VOLTAGE_L			; A/D ϊlʈꎞXgAp

	TH_LOW				; Lo臒l胏[N
	TH_HIGH				; Hi臒l胏[N

	BCD_H				; BCD ϊl
	BCD_L				; BCD ϊl

	PATTERN_H			; xHrbgp^[E}X^[p^[
	PATTERN_L			; xLrbgp^[E}X^[p^[

	START_COLUMN		; _Ci~bN_\JnJ

	SEGMENT				; \rbgp^[

ENDC

CBLOCK	H'70'		; SoNʃt@CWX^擪AhX

	TEMPERATURE			; xiǒljXgAp
	HUMIDITY			; xiǒljXgAp
	INDEX				; swiǒljXgAp
	VALUE				; Fp[N

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	INT_WORK1			; 荞ݎ̑ޔp
	INT_WORK2			; 荞ݎ̑ޔp
	INT_WORK3			; 荞ݎ̑ޔp

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	SECOND_COUNTER		; 4bvpJE^[
	MINUTE_COUNTER		; 1vpJE^[

	USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------

;RA0	LED a		DIGITAL OUT
;RA1	LED b		DIGITAL OUT
;RA2	LED c		DIGITAL OUT
;RA3	L[	DIGITAL IN		KEY
;RA4	LED d		DIGITAL OUT
;RA5	LED e		DIGITAL OUT

;RC0	LED f		DIGITAL OUT
;RC1	LED g		DIGITAL OUT
;RC2	AN6			ANALOG IN		x
;RC3	AN7			ANALOG IN		x

;RC4	LED3		DIGITAL OUT		C3
;RC5	LED4		DEGITAL OUT		C4

;RB6	LED1		DIGITAL OUT		C1
;RB7	LED2		DEGITAL OUT		C2

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		T_SENS_P	D'2'	; xZT̓|[gԍ(PORTC)
#DEFINE		H_SENS_P	D'3'	; xZT̓|[gԍ(PORTC)

#DEFINE		T_SENSOR	D'6'	; xZTANԍ
#DEFINE		H_SENSOR	D'7'	; xZTANԍ

#DEFINE		KEY			D'3'	; L[̓|[gԍ(PORTA)

#DEFINE		C1			D'6'	; LED1|[gԍ (PORTB)
#DEFINE		C2			D'7'	; LED2|[gԍ (PORTB)
#DEFINE		C3			D'4'	; LED3|[gԍ (PORTC)
#DEFINE		C4			D'5'	; LED4|[gԍ (PORTC)

								; x
#DEFINE		T_LOW_V		D'3'	; 3ȉLo
#DEFINE		T_HIGH_V	D'99'	; 99ȏ Hi

								; x
#DEFINE		H_LOW_V		D'3'	; 3ȉLo
#DEFINE		H_HIGH_V	D'99'	; 99ȏ Hi

								; sw
								; x0ȏ̏ꍇ̗_̕swŏl = 32.5
#DEFINE		I_COOL_V	D'55'	; 55ȉLoij, 55-59 ́uvA
#DEFINE		I_GOOD_V	D'60'	; 60-74 ́uȂAAȂv
#DEFINE		I_HOT_V		D'75'	; 75ȏ́u⏋AoAҏv
#DEFINE		I_HIGH_V	D'99'	; 99ȏ Hi

;						   gfedcba
#DEFINE		E_PATTERN	B'01111001'	; E \̃rbgp^[
#DEFINE		R_PATTERN	B'01010000'	; r \̃rbgp^[

#DEFINE		L_PATTERN	B'00111000'	; L \̃rbgp^[
#DEFINE		o_PATTERN	B'01011100'	; o \̃rbgp^[

#DEFINE		H_PATTERN	B'01110110'	; H \̃rbgp^[
#DEFINE		i_PATTERN	B'00010000'	; i \̃rbgp^[

#DEFINE		g_PATTERN	B'01101111'	; g \̃rbgp^[
#DEFINE		d_PATTERN	B'01011110'	; d \̃rbgp^[
#DEFINE		C_PATTERN	B'00111001'	; C \̃rbgp^[
#DEFINE		c_PATTERN	B'01011000'	; o \̃rbgp^[
#DEFINE		l_PATTERN	B'00110000'	; l \̃rbgp^[
#DEFINE		t_PATTERN	B'01111000'	; t \̃rbgp^[
#DEFINE		BL_PATTERN	B'00000000'	; uN\̃rbgp^[

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		KEY_PORT	PORTA,KEY	; L[͂̃|[g`

#DEFINE		KEY_STATUS	USER_FLAG,0	; L[XL̃tO
#DEFINE		INDEX_FLAG	USER_FLAG,1	; Iȕsw\tOA1=\
#DEFINE		MANUAL_FLAG	USER_FLAG,2	; XCb`Ă邩̃tOA1=}jAŕsw\

#DEFINE		C1_PORT	PORTB,C1		; LED1̌|[g
#DEFINE		C2_PORT	PORTB,C2		; LED2̌|[g
#DEFINE		C3_PORT	PORTC,C3		; LED3̌|[g
#DEFINE		C4_PORT	PORTC,C4		; LED4̌|[g

#DEFINE		A_SEG	PORTA,0			; LED a ZOg̃|[gԍ
#DEFINE		B_SEG	PORTA,1			; LED b ZOg̃|[gԍ
#DEFINE		C_SEG	PORTA,2			; LED c ZOg̃|[gԍ
#DEFINE		D_SEG	PORTA,4			; LED d ZOg̃|[gԍ
#DEFINE		E_SEG	PORTA,5			; LED e ZOg̃|[gԍ
#DEFINE		F_SEG	PORTC,0			; LED f ZOg̃|[gԍ
#DEFINE		G_SEG	PORTC,1			; LED g ZOg̃|[gԍ

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ (32ms ɔłj
;--------------------------------------------------------------------------------

	ORG		H'4'				; 荞ݏ擪AhX

	MOVWF	W_WORK				; WX^Ҕ
	SWAPF	STATUS,W			; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK				; STATUS WX^ۑ Bank A\

	BANKSEL	PORTA				; Ô Bank 0 ɂ

	MOVF	COUNTER1,W
	MOVWF	INT_WORK1
	MOVF	COUNTER2,W
	MOVWF	INT_WORK2
	MOVF	COUNTER3,W
	MOVWF	INT_WORK3

	MOVLW	D'5'				; 32ms x 120 = 3.8boߎ SECOND_COUNTER = 5
	SUBWF	SECOND_COUNTER,W	; SECOND_COUNTER - 5 -> W
	BTFSC	STATUS,Z
	BCF		INDEX_FLAG			; 3.8bosw\tONAĕ\߂

								; 32ms̔
	DECFSZ	SECOND_COUNTER,F	; JE^`FbN
	GOTO	POP_REG				; 4b̊荞݂̏ꍇ͉ȂŖ߂

								; 4b̊荞ݏ
	CALL	GET_DATA			; f[^

	CALL	RESET_1st_COUNTER	; 4bJE^̃Zbg

	DECFSZ	MINUTE_COUNTER,F	; JE^`FbN
	GOTO	POP_REG				; 1Ȃ犄荞ݏI

								; 1̊荞ݏ
	CALL	CLEAR_EVENT			; JE^
	CALL	RESET_1st_COUNTER

	BSF		INDEX_FLAG			; sw\tO𗧂Ă

POP_REG:						; WX^A`荞ݏI

	MOVF	INT_WORK3,W
	MOVWF	COUNTER3
	MOVF	INT_WORK2,W
	MOVWF	COUNTER2
	MOVF	INT_WORK1,W
	MOVWF	COUNTER1

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	BCF		INTCON,T0IF			; TMR0荞݃tONAĂ

	RETFIE						; 荞ݏI

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:

	ADDWF	PCL,F

	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	BANK0

	CALL	ALL_LED_OFF

	BANKSEL	OSCCON			; Bank 1
	MOVLW	B'01110101'		; NbN 8MHz
	MOVWF	OSCCON

	CLRF	PIE1			; Bank 1, 荞݂͂ЂƂ܂Sĕs

	CLRF	TRISA			; Bank 1, ЂƂ܂S|[go͂Ɏw

	MOVLW	B'00110000'		; OP2 +,- ͂ɍĐݒAAiOݒ͕sv
	MOVWF	TRISB			; Bank 1

	MOVLW	B'11000000'		; OP1 +,- ͂ɍĐݒAAiOݒ͕sv
	MOVWF	TRISC			; Bank 1
	BSF		TRISC,T_SENS_P	; xZT|[g͂ɍĐݒ
	BSF		TRISC,H_SENS_P	; xZT|[g͂ɍĐݒ

	CLRF	ANSEL1			; Bank 1
	CLRF	ANSEL0			; Bank 1, ЂƂ܂S|[gfW^ɐݒ
	BSF		ANSEL0,T_SENSOR	; xANݒ
	BSF		ANSEL0,H_SENSOR	; xANݒ

;--------------------------------------------------------------------------------
;	A/D Ro[^[ݒ (10bit)
;--------------------------------------------------------------------------------

	MOVLW	B'00100000'		; Bank 1, 32 Tosc
	MOVWF	ADCON1

	BANKSEL ADCON0			; Bank 0
	MOVLW	B'10011101'		; El(10bit A/Dϊ), Vref=VDD, AN7 (bit 5-2) gp, AD Ro[^d ON
	MOVWF	ADCON0

	BANK2

	BSF		OPA1CON,OPAON	; OP1 ON
	BSF		OPA2CON,OPAON	; OP2 ON

	BANK0

;--------------------------------------------------------------------------------
;	[Nit@CWX^ߖ̓sA荞݊JnOɎsKvj
;--------------------------------------------------------------------------------

	CALL	WAIT_1sec		; ZTo͂肷܂ŏ҂

	CLRF	USER_FLAG		; etO
	CALL	CLEAR_EVENT		; 荞݊֌WJE^
	CALL	RESET_1st_COUNTER

	CALL	GET_DATA		; \pxx擾

;--------------------------------------------------------------------------------
;	TMR0 ݒ, 32ms 荞ݔݒ
;--------------------------------------------------------------------------------

	BANKSEL	OPTION_REG		; Bank 1
	MOVLW	B'10000111'		; PORTA pull up disable, TMR0 interanal clock, PSA = TMR0, PS = 1:256
	MOVWF	OPTION_REG

	BANKSEL	TMR0			; Bank 0
	BSF		INTCON,T0IE		; TMR0I[o[t[荞ݔ
	NOP
	BSF		INTCON,GIE		; 荞݋

	CLRF	TMR0			; Bank 0, ^C}

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

	BTFSC	MANUAL_FLAG		; XCb`Ă?
	GOTO	DISP_INDEX_NUM	; Ă琔lŕsw\

	BTFSC	INDEX_FLAG		; sw\[h
	GOTO	DISP_INDEX_STR	; ŕsw\

	CALL	CONV_DATA		; A/Dl𒼓ǒl֕ϊ

;	x

	MOVF	TEMPERATURE,W	; xZbg
	MOVWF	VALUE

	MOVLW	T_LOW_V
	MOVWF	TH_LOW

	MOVLW	T_HIGH_V
	MOVWF	TH_HIGH

	CALL	SET_PARAMETERS

	CLRW					; 0J\
	CALL	DISPLAY			; LED _Ci~bN_

;	x

	MOVF	HUMIDITY,W		; xZbg
	MOVWF	VALUE

	MOVLW	H_LOW_V
	MOVWF	TH_LOW

	MOVLW	H_HIGH_V
	MOVWF	TH_HIGH

	CALL	SET_PARAMETERS

	MOVLW	D'2'			; 2J\
	CALL	DISPLAY			; LED _Ci~bN_

	BCF		MANUAL_FLAG		; tONAĂ

;	L[`FbN

	CALL	KEY_CHECK
	BTFSS	KEY_STATUS		; L[ꂽ ?
	GOTO	MAIN_LOOP		; NO

; L[ꂽꍇ̏

	BSF		MANUAL_FLAG		; }jAł̕sw\tOZbg
	BCF		INDEX_FLAG		; ł̕sw\tO̓NAĂA
							; L[𗣂ʏ탂[hɂA
	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	sw\ilj
;--------------------------------------------------------------------------------

DISP_INDEX_NUM:

	CALL	CALC_INDEX		; swvZ
							; X^bN̂ߊ荞ݏŌvZs
	MOVF	INDEX,W
	MOVWF	VALUE

	MOVLW	I_COOL_V
	MOVWF	TH_LOW

	MOVLW	I_HIGH_V
	MOVWF	TH_HIGH

	CALL	SET_PARAMETERS	; sw\p^[Zbg

	MOVLW	D'2'			; 2J\
	CALL	DISPLAY			; LED _Ci~bN_

SCAN_KEY:

	BCF		MANUAL_FLAG		; tONAĂ

;	L[`FbN

	CALL	KEY_CHECK
	BTFSS	KEY_STATUS		; L[ꂽ ?
	GOTO	MAIN_LOOP		; NO

; L[ꂽꍇ̏

	BSF		MANUAL_FLAG		; }jAł̕sw\tOZbg

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	sw\ij
;--------------------------------------------------------------------------------

DISP_INDEX_STR:

	CALL	CALC_INDEX		; swvZ
							; X^bN̂ߊ荞ݏŌvZs
	MOVF	INDEX,W
	MOVWF	VALUE

	MOVLW	I_GOOD_V
	SUBWF	VALUE,W			; VALUE - TH_GOOD -> W
	BTFSS	STATUS,C		; TH_GOOD <= VALUE Ȃ؂ꔭ C=1  ̖߃XLbv
	GOTO	DISP_COOL		; 

	MOVLW	I_HOT_V
	SUBWF	VALUE,W			; VALUE - TH_HOT -> W
	BTFSS	STATUS,C		; TH_HOT <= VALUE Ȃ؂ꔭ C=1  ̖߃XLbv
	GOTO	DISP_good		; K

DISP_HOT:

	MOVLW	H_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'H' p^[Zbg
	MOVLW	o_PATTERN
	MOVWF	PATTERN_L		; ɒ 'o' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	CLRW					; 0J\
	CALL	DISPLAY			; LED _Ci~bN_

	MOVLW	t_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 't' p^[Zbg
	MOVLW	BL_PATTERN
	MOVWF	PATTERN_L		; ɒڃuNp^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	MOVLW	D'2'			; 2J\
	CALL	DISPLAY			; LED _Ci~bN_

	GOTO	SCAN_KEY

DISP_good:

	MOVLW	g_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'g' p^[Zbg
	MOVLW	o_PATTERN
	MOVWF	PATTERN_L		; ɒ 'o' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	CLRW					; 0J\
	CALL	DISPLAY			; LED _Ci~bN_

	MOVLW	o_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'o' p^[Zbg
	MOVLW	d_PATTERN
	MOVWF	PATTERN_L		; ɒ 'd' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	MOVLW	D'2'			; 2J\
	CALL	DISPLAY			; LED _Ci~bN_

	GOTO	SCAN_KEY

DISP_COOL:

	MOVLW	C_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'C' p^[Zbg
	MOVLW	o_PATTERN
	MOVWF	PATTERN_L		; ɒ 'o' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	CLRW					; 0J\
	CALL	DISPLAY			; LED _Ci~bN_

	MOVLW	o_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'o' p^[Zbg
	MOVLW	l_PATTERN
	MOVWF	PATTERN_L		; ɒ 'L' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	MOVLW	D'2'			; 2J\
	CALL	DISPLAY			; LED _Ci~bN_

	GOTO	SCAN_KEY

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	LED \ZOgp^[A\F̌
;
;	IN		VALUE			ǒl
;			TH_LOW			Lo臒l
;			TH_HIGH			Hi臒l
;			BCD_H			BCD
;			BCD_L			BCD
;
;	RETURN	H_PATTERN	ʂ̃ZOgp^[
;			L_PATTERN	ʂ̃ZOgp^[
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	CLRF	PATTERN_H		; \p^[
	CLRF	PATTERN_L		; \p^[

	MOVF	VALUE,F
	BTFSC	STATUS,Z		; if VALUE <> 0, Z=0, skip next line.
	GOTO	SET_BLANK		; uN𒼐ڃZbg

;--------------------------------------------------------------------------------
;	xf[^
;--------------------------------------------------------------------------------

	CLRF	prm1b			; ʃNA
	MOVF	VALUE,W
	MOVWF	prm1a			; ʃZbg

	CALL	HEX2DEC16		; 16bitl -> 5 BCD ϊ

	MOVF	prm3a,W			; BCD
	MOVWF	BCD_L			; XgA
	MOVF	prm3b,W			; BCD 
	MOVWF	BCD_H			; XgA

							; BCD ϊl`FbN

	MOVF	BCD_H,W			; 10̈ʂÔ߃`FbN
	SUBLW	D'9'			; 9 - ϊl -> W (10̈ʂ9ȏɂ͂ȂȂ)
	BTFSS	STATUS,C		; ϊl < 9  ؂ꔭȂ  C=1  ̖߃XLbv
	GOTO	SET_ERROR		; ER \ݒ

	MOVF	BCD_L,W			; 1̈ʂÔ߃`FbN
	SUBLW	D'9'			; 9 - ϊl -> W (1̈ʂ9ȏɂ͂ȂȂ)
	BTFSS	STATUS,C		; ϊl < 9  ؂ꔭȂ  C=1  ̖߃XLbv
	GOTO	SET_ERROR		; ER \ݒ

							; Fݒ菈
	MOVF	TH_LOW,W
	SUBWF	VALUE,W			; VALUE - TH_LOW -> W
	BTFSS	STATUS,C		; TH_GREEN <= VALUE Ȃ؂ꔭ C=1  ̖߃XLbv
	GOTO	SET_LOW

	MOVF	TH_HIGH,W
	SUBWF	VALUE,W			; VALUE - TH_HIGH -> W
	BTFSS	STATUS,C		; TH_HIGH <= VALUE Ȃ؂ꔭ C=1 ̖߃XLbv
	GOTO	GET_LED_PATTERN	; 

SET_HIGH:

	MOVLW	H_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'H' p^[Zbg
	MOVLW	i_PATTERN
	MOVWF	PATTERN_L		; ɒ 'i' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	RETURN

SET_LOW:

	MOVLW	L_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'L' p^[Zbg
	MOVLW	o_PATTERN
	MOVWF	PATTERN_L		; ɒ 'o' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	RETURN

SET_BLANK:

	CLRF	L_PATTERN		; uN
	CLRF	H_PATTERN		; uN

	RETURN

SET_ERROR:

	MOVLW	E_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'E' p^[Zbg
	MOVLW	R_PATTERN
	MOVWF	PATTERN_L		; ɒ 'r' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	RETURN

;--------------------------------------------------------------------------------
;	BCD lɊÂ LED \p^[ɃZbg
;--------------------------------------------------------------------------------

GET_LED_PATTERN:

	MOVF	BCD_H,W				; 10̈ʂ𓾂
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_H			; p^[ۑ

	MOVF	BCD_L,W				; 1̈ʂ𓾂
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_L			; p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	_Ci~bN_
;	IN			W = X^[gʒu
;	BCD_H = 0 Əʌ\Ȃ
;	PATTERN_H	ʌZOgp^[
;	PATTERN_L	ʌZOgp^[
;--------------------------------------------------------------------------------

DISPLAY:

	MOVWF	START_COLUMN		; \Jnʒuۑ

	CALL	ALL_LED_OFF			; S

	MOVF	START_COLUMN,F
	BTFSS	STATUS,Z			; 0J\Jn -> Z=1 -> Skip next line
	GOTO	COLUMN2				; ȊO 2 J\Jn

;--------------------------------------------------------------------------------
;	0J̕\
;--------------------------------------------------------------------------------

	MOVF	BCD_H,W				; H̒l 0 ? iZtOݒj
	BTFSC	STATUS,Z			; H 0 ȊO  Z=0  ̖߃XLbv
	GOTO	T_L_COLUMN			; H 0 Ȃ̂ H\XLbv

;--------------------------------------------------------------------------------
;	0J\
;--------------------------------------------------------------------------------

	BCF		C1_PORT				; ON

	MOVF	PATTERN_H,W			; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	1J\
;--------------------------------------------------------------------------------

T_L_COLUMN:

	BCF		C2_PORT				; ON

	MOVF	PATTERN_L,W			; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	CALL	ALL_LED_OFF			; S

	RETURN

;--------------------------------------------------------------------------------
;	2Jڂ̕\
;--------------------------------------------------------------------------------

COLUMN2:

	MOVF	BCD_H,W				; H̒l 0 ? iZtOݒj
	BTFSC	STATUS,Z			; H 0 ȊO  Z=0  ̖߃XLbv
	GOTO	H_L_COLUMN			; H 0 Ȃ̂ H\XLbv

;--------------------------------------------------------------------------------
;	2J\
;--------------------------------------------------------------------------------

	BCF		C3_PORT				; ON

	MOVF	PATTERN_H,W			; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	3J\
;--------------------------------------------------------------------------------

H_L_COLUMN:

	BCF		C4_PORT				; ON

	MOVF	PATTERN_L,W			; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	CALL	ALL_LED_OFF			; S

	RETURN

;--------------------------------------------------------------------------------
;	ZOg
;	IN: W = rbgp^[
;--------------------------------------------------------------------------------

SEG_A:

	MOVWF	SEGMENT				; ZOgp^[ۑĂ

	BTFSS	SEGMENT,0			; a ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_B				; ̃ZOg

	BSF		A_SEG				; a ZOg_
	CALL	HOLD_LED
	BCF		A_SEG				; a ZOg
	CALL	HOLD_LED_SHORT

SEG_B:

	BTFSS	SEGMENT,1			; b ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_C				; ̃ZOg

	BSF		B_SEG				; b ZOg_
	CALL	HOLD_LED
	BCF		B_SEG				; b ZOg
	CALL	HOLD_LED_SHORT

SEG_C:

	BTFSS	SEGMENT,2			; c ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_D				; ̃ZOg

	BSF		C_SEG				; c ZOg_
	CALL	HOLD_LED
	BCF		C_SEG				; c ZOg
	CALL	HOLD_LED_SHORT

SEG_D:

	BTFSS	SEGMENT,3			; d ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_E				; ̃ZOg

	BSF		D_SEG				; d ZOg_
	CALL	HOLD_LED
	BCF		D_SEG				; d ZOg
	CALL	HOLD_LED_SHORT

SEG_E:

	BTFSS	SEGMENT,4			; e ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_F				; ̃ZOg

	BSF		E_SEG				; e ZOg_
	CALL	HOLD_LED
	BCF		E_SEG				; e ZOg
	CALL	HOLD_LED_SHORT

SEG_F:

	BTFSS	SEGMENT,5			; f ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_G				; ̃ZOg

	BSF		F_SEG				; f ZOg_
	CALL	HOLD_LED
	BCF		F_SEG				; f ZOg
	CALL	HOLD_LED_SHORT

SEG_G:

	BTFSS	SEGMENT,6			; g ZOgrbg 1 Ȃ玟̖߂XLbv
	RETURN						; g ZOg_ȂȂ߂

	BSF		G_SEG				; g ZOg_
	CALL	HOLD_LED
	BCF		G_SEG				; g ZOg

	RETURN

;--------------------------------------------------------------------------------
;	xAxf[^擾
;	RETURN: TEMERATURE, HUMIDITY iÂ10iǒlj
;--------------------------------------------------------------------------------

GET_DATA:

; x

	MOVLW	B'10011101'		; AN7, A/D CONV Power ON
	MOVWF	ADCON0			; Bank 0
	CALL	WAIT_100us		; v`[W҂

	CALL	READ_VOLTAGE10	; xf[^擾

	MOVF	VOLTAGE_H,W
	MOVWF	TEMPERATURE_H	; lۑ
	MOVF	VOLTAGE_L,W
	MOVWF	TEMPERATURE_L

; x

	MOVLW	B'10011001'		; AN6, A/D CONV Power ON
	MOVWF	ADCON0			; Bank 0
	CALL	WAIT_100us		; v`[W҂

	CALL	READ_VOLTAGE10	; xf[^擾

	MOVF	VOLTAGE_H,W
	MOVWF	HUMIDITY_H		; lۑ
	MOVF	VOLTAGE_L,W
	MOVWF	HUMIDITY_L

	RETURN

;--------------------------------------------------------------------------------
;	xAx A/D l𒼓ǒlɕϊ
;	IN:		TEMPERATURE_H/L, HUMIDITY_H/L
;	RETURN:	TEMERATURE, HUMIDITY iÂ10iǒlj
;--------------------------------------------------------------------------------

CONV_DATA:

	CLRF	A1
	MOVF	TEMPERATURE_H,W	; x
	MOVWF	A2
	MOVF	TEMPERATURE_L,W
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'10'			; 10 ŊĒǒl𓾂
	MOVWF	B3

	CALL	DIV24			; in math16.lib, returns A1A2A3

	MOVF	A3,W			; x(8bitm)ۑĂ
	MOVWF	TEMPERATURE

	CLRF	A1
	MOVF	HUMIDITY_H,W	; x
	MOVWF	A2
	MOVF	HUMIDITY_L,W
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'10'			; 10 ŊĒǒl𓾂
	MOVWF	B3

	CALL	DIV24			; in math16.lib, returns A1A2

	MOVF	A3,W			; x(8bitm)ۑĂ
	MOVWF	HUMIDITY

	RETURN

;--------------------------------------------------------------------------------
;	swvZ  0.81T + 0.01H ( 0.99T - 14.3 ) + 46.3
;                = (( 8100 + 99*H )*T + 463000 + 5000 - 1430*H ) / 10000
;				_1ʂľܓ邽 5000/10000 𑫂
;	IN:		TEMPERATURE, HUMIDITYiǒlj
;	RETURN:	INDEXiǒlj
;--------------------------------------------------------------------------------

CALC_INDEX:

	MOVF	TEMPERATURE,W	; vZɊ荞݂ĒlȂ悤ɕۑ
	MOVWF	TEMPERATURE_WORK
	MOVF	HUMIDITY,W		; vZɊ荞݂ĒlȂ悤ɕۑ
	MOVWF	HUMIDITY_WORK

	CLRF	A1
	CLRF	A2			; 
	MOVF	HUMIDITY_WORK,W
	MOVWF	A3			; 

	CLRF	B1
	CLRF	B2			; 
	MOVLW	D'99'
	MOVWF	B3			; 

	CALL	MUL24		; x x 99,  B1B2B3

	CLRF	A1
	MOVLW	H'1F'		; 8100 ̏
	MOVWF	A2
	MOVLW	H'A4'		; 8100 ̉
	MOVWF	A3

	CALL	ADD24		;  A1A2A3

	CLRF	B1
	CLRF	B2
	MOVF	TEMPERATURE_WORK,W
	MOVWF	B3

	CALL	MUL24		;  B1B2B3

	MOVLW	H'07'		; 468000
	MOVWF	A1
	MOVLW	H'24'
	MOVWF	A2
	MOVLW	H'20'
	MOVWF	A3

	CALL	ADD24		;  A1A2A3

	MOVF	A1,W
	MOVWF	INDEX_H		; ۑĂ
	MOVF	A2,W
	MOVWF	INDEX_M
	MOVF	A3,W
	MOVWF	INDEX_L

	CLRF	A1
	CLRF	A2
	MOVF	HUMIDITY_WORK,W
	MOVWF	A3

	CLRF	B1
	MOVLW	H'05'		; 1430 ̏
	MOVWF	B2
	MOVLW	H'96'		; 1430 ̉
	MOVWF	B3

	CALL	MUL24		;  B1B2B3

	MOVF	INDEX_H,W
	MOVWF	A1
	MOVF	INDEX_M,W
	MOVWF	A2
	MOVF	INDEX_L,W
	MOVWF	A3

	CALL	SUB24		;  A1A2A3

	CLRF	B1			; 10000
	MOVLW	H'27'
	MOVWF	B2
	MOVLW	H'10'
	MOVWF	B3

	CALL	DIV24		;  A1A2A3

	MOVF	A3,W
	MOVWF	INDEX		; swXgA

	RETURN

;--------------------------------------------------------------------------------
;	10 bit A/D ϊs
;	RETURN: VOLTAGE_H, VOLTAGE_L
;--------------------------------------------------------------------------------

READ_VOLTAGE10:

	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	VOLTAGE_H		; ɃXgA

	BANKSEL	ADRESL			; Bank 1
	MOVF	ADRESL,W		; A/D ϊliʁjǂݏo

	BANKSEL	PORTA			; Bank 0
	MOVWF	VOLTAGE_L		; ɃXgA (BANK0ɂ_ɒӁj

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێi߁j
;--------------------------------------------------------------------------------

HOLD_LED:

	CALL	WAIT_500us
	CALL	WAIT_100us
	CALL	WAIT_100us
	CALL	WAIT_100us

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێiZ߁j
;--------------------------------------------------------------------------------

HOLD_LED_SHORT:

	CALL	WAIT_5us

	RETURN

;--------------------------------------------------------------------------------
;	LED S
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	CLRF	PORTA				; a-e ZOg OFF
	MOVLW	B'00110000'			; f,g ZOg, C3, C4 OFF
	MOVWF	PORTC
	MOVLW	B'11000000'			; C1, C2 OFF
	MOVWF	PORTB

	RETURN

;--------------------------------------------------------------------------------
;	ԃJE^̏
;--------------------------------------------------------------------------------

CLEAR_EVENT:

	MOVLW	D'15'			; 4 b x 15 = 60b
	MOVWF	MINUTE_COUNTER
	RETURN

RESET_1st_COUNTER:

	MOVLW	D'125'			; 32ms ̊荞 x 125 = 4 b
	MOVWF	SECOND_COUNTER

	RETURN

;--------------------------------------------------------------------------------
;	L[`FbN
;	RETURN: KEYS_STATUS = 0  L[͉ĂȂA1  L[ꂽ
;--------------------------------------------------------------------------------

KEY_CHECK:

	BCF		KEY_STATUS		; tOZbgĂ

	BTFSC	KEY_PORT		; XCb`ꂽ? L = ꂽ
	RETURN					; H = ĂȂ

	CALL	WAIT_10ms		; ₩ȃ`^Oh~

	BTFSC	KEY_PORT		; ܂XCb`Ă邩?
	RETURN					; H = ĂȂ

	BSF		KEY_STATUS		; L[Ă̂ŃtO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu
	INCLUDE		Math24.lib		; 24bit lZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
