/*
 * Copyright (c) 2004 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef ifhtml_h
#define ifhtml_h

#include "critsect.h"
#include "ImageExtract.hpp"

static const char *pluginfo[] = {
	"00IN",
    "HTML to DIB v0.1.0",
    "*.html;*.htm",
    "HTML file",
};

typedef struct{
  DWORD width;
  DWORD height;
  DWORD flag1;
  DWORD flag2;
} IFHTMLVAR_STRUCT;

bool __fastcall MatchesExt(const AnsiString &filename, char *ext);

class ifhtmlVar
{
public:
    ifhtmlVar()
    {
        m_var.width = 800;
        m_var.height = 600;
        m_var.flag1 = IEIFLAG_OFFLINE | IEIFLAG_ASPECT | IEIFLAG_QUALITY;
        m_var.flag2 = IEIFLAG_OFFLINE;

        m_ext = pluginfo[2];
    };
    ~ifhtmlVar() {};
    DWORD GetPictureFlag(void)
    {
        CriticalSection cs;
        return m_var.flag1;
    };
    DWORD GetPreviewFlag(void)
    {
        CriticalSection cs;
        return m_var.flag2;
    };
    void setVar(IFHTMLVAR_STRUCT *ps)
    {
        CriticalSection cs;
        m_var = *ps;
    };
    void getVar(IFHTMLVAR_STRUCT *ps)
    {
        CriticalSection cs;
        *ps = m_var;
    };
    void setExt(const char *ext)
    {
        CriticalSection cs;
        m_ext = ext;
    };
    char* getExt(void)
    {
        CriticalSection cs;
        return m_ext.c_str();
    };
private:
    IFHTMLVAR_STRUCT m_var;
    AnsiString m_ext;
};

extern ifhtmlVar g_var;

#endif
