/*
 * Copyright (c) 2004 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <vcl.h>
#include <Registry.hpp>
#include <Masks.hpp>
#pragma hdrstop

#include "spi00in.h"
#include "ifhtml.h"
#include "DialogUnit.h"

#pragma argsused
ifhtmlVar g_var;
//---------------------------------------------------------------------------
//ݒǂ݂
void __fastcall LoadOptions(void)
{
    TRegistry *Reg = new TRegistry(KEY_EXECUTE);
    //Reg->RootKey = HKEY_CURRENT_USER;
try {
if ( Reg->OpenKey("\\Software\\shimitei\\ifhtml", false) ) {
    IFHTMLVAR_STRUCT var;
    AnsiString ext = g_var.getExt();
    g_var.getVar(&var);

    if (Reg->ValueExists("width")) {
        var.width = Reg->ReadInteger("width");
    }
    if (Reg->ValueExists("height")) {
        var.height = Reg->ReadInteger("height");
    }

    if (Reg->ValueExists("flag1")) {
        var.flag1 = Reg->ReadInteger("flag1");
    }
    if (Reg->ValueExists("flag2")) {
        var.flag2 = Reg->ReadInteger("flag2");
    }

    if (Reg->ValueExists("ext")) {
        ext = Reg->ReadString("ext");
    }

    Reg->CloseKey();
    g_var.setVar(&var);
    g_var.setExt(ext.c_str());
}
} catch (...) {
    //throw;
}
    delete Reg;
}
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
    switch (reason) {
        case DLL_PROCESS_ATTACH:
            LoadOptions();
            break;
    }

    return 1;
}
//---------------------------------------------------------------------------
//̃vOC̏Ԃ
int __stdcall GetPluginInfo(int infono, LPSTR buf, int buflen)
{
	if (infono < 0 || infono >= (sizeof(pluginfo) / sizeof(char *)))
		return 0;

    if (infono == 2) {
	    lstrcpyn(buf, g_var.getExt(), buflen);
    } else {
	    lstrcpyn(buf, pluginfo[infono], buflen);
    }
	return lstrlen(buf);
}
//---------------------------------------------------------------------------
// }b`trueԂ
// ext̓J}؂ "*.html;*.htm;*.eml"
// ext ̓e *j* .
bool __fastcall MatchesExt(const AnsiString &filename, char *ext)
{
    char *msk = ext;
    for (;;) {
        if (*msk == '\0') return false;
        char *p = AnsiStrScan(msk, ';');
        if (p) {
            *p = '\0';
        }
        if (MatchesMask(filename, msk)) return true;
        if (p == NULL) {
            return false;
        }
        msk = p+1;
    }
}
//---------------------------------------------------------------------------
//ΉĂ`ȂΔ0Ԃ
//*gq݂̂Ŕf
int __stdcall IsSupported(LPSTR filename, DWORD dw)
{
    if (filename) {
        AnsiString ext = g_var.getExt();
try{
        if ( MatchesExt(ExtractFileName(filename), ext.c_str()) ) return 1;
}catch(...){}
    }

	return 0;
}
//---------------------------------------------------------------------------
//摜Ԃ
//*Ԃ̓_~[
int __stdcall GetPictureInfo
(LPSTR buf, long len, unsigned int flag, struct PictureInfo *lpInfo)
{
	int ret = SPI_OTHER_ERROR;

    lpInfo->left		= 0;
    lpInfo->top			= 0;
    lpInfo->width		= 640;
    lpInfo->height		= 480;
    lpInfo->x_density	= 0;
    lpInfo->y_density	= 0;
    lpInfo->colorDepth	= 24;
    lpInfo->hInfo		= NULL;

	return ret;
}
//---------------------------------------------------------------------------
//DIBԂ
//Ƃ肠24bitŒ
int __fastcall GetPictureEx(
		LPSTR filename, HANDLE *pHBInfo, HANDLE *pHBm,
		DWORD flag)
{
    IFHTMLVAR_STRUCT var;
    g_var.getVar(&var);

	DWORD width = var.width;
	DWORD height = var.height;
	DWORD bit = 24;
	DWORD infosize = sizeof(BITMAPINFOHEADER);
	DWORD linesize = (width * (bit / 8) +3) & ~3; /*4byteE*/
	DWORD imgsize = linesize * height;

	*pHBInfo = LocalAlloc(LMEM_MOVEABLE, infosize);
	*pHBm    = LocalAlloc(LMEM_MOVEABLE, imgsize);

	if (*pHBInfo == NULL || *pHBm == NULL) {
		if (*pHBInfo != NULL) LocalFree(*pHBInfo);
		if (*pHBm != NULL) LocalFree(*pHBm);
		return SPI_NO_MEMORY;
	}

	BITMAPINFO *pinfo  = (BITMAPINFO *)LocalLock(*pHBInfo);
	char *pbmdat = (char *)LocalLock(*pHBm);
	if (pinfo == NULL || pbmdat == NULL) {
		LocalFree(*pHBInfo);
		LocalFree(*pHBm);
		return SPI_MEMORY_ERROR;
	}

    Graphics::TBitmap *bmp = NULL;
    bmp = new (Graphics::TBitmap);
try {
    bmp->Width       = width;
    bmp->Height      = height;
    bmp->PixelFormat = pf24bit;

    if ( !ExtractImage(filename, bmp, flag) ) {
        delete bmp;
        LocalFree(*pHBInfo);
        LocalFree(*pHBm);
    	return SPI_OTHER_ERROR;
    }
} catch(...) {
    delete bmp;
    LocalFree(*pHBInfo);
    LocalFree(*pHBm);
	return SPI_OTHER_ERROR;
}
	/* *pHBInfoɂBITMAPINFO */
	pinfo->bmiHeader.biSize				= sizeof(BITMAPINFOHEADER);
	pinfo->bmiHeader.biWidth			= width;
	pinfo->bmiHeader.biHeight			= height;
	pinfo->bmiHeader.biPlanes			= 1;
	pinfo->bmiHeader.biBitCount			= bit;
	pinfo->bmiHeader.biCompression		= BI_RGB;
	pinfo->bmiHeader.biSizeImage		= 0;
	pinfo->bmiHeader.biXPelsPerMeter	= 0;
	pinfo->bmiHeader.biYPelsPerMeter	= 0;
	pinfo->bmiHeader.biClrUsed			= 0;
	pinfo->bmiHeader.biClrImportant		= 0;
	/* *pHBmɂ̓rbg}bvf[^ */
    char *pd = pbmdat +imgsize;
    for (DWORD y=0; y<height; y++) {
        char *ps = (char *)bmp->ScanLine[y];
        pd -= linesize;
	    memcpy(pd, ps, linesize);
    }
    delete bmp;

	//AbN
	LocalUnlock(*pHBInfo);
	LocalUnlock(*pHBm);

	return SPI_ALL_RIGHT;
}
//---------------------------------------------------------------------------
int __stdcall GetPicture(
		LPSTR buf, long len, unsigned int flag,
		HANDLE *pHBInfo, HANDLE *pHBm,
		SPI_PROGRESS lpPrgressCallback, long lData)
{
	char *filename;
	if ((flag & 7) == 0) {
	/* buf̓t@C */
		filename = buf;
	} else {
	/* buf̓t@CC[Wւ̃|C^ */
        //͂̓t@CsȂ̂őΉłȂ
		return SPI_NOT_SUPPORT;
	}

	if (lpPrgressCallback != NULL)
		if (lpPrgressCallback(0, 1, lData)) /* 0% */
			return SPI_ABORT;

    int ret = GetPictureEx(filename, pHBInfo, pHBm, g_var.GetPictureFlag());

	if (lpPrgressCallback != NULL)
		if (lpPrgressCallback(1, 1, lData)) /* 100% */
			return SPI_ABORT;

	return ret;
}
//---------------------------------------------------------------------------
int __stdcall GetPreview(
	LPSTR buf, long len, unsigned int flag,
	HANDLE *pHBInfo, HANDLE *pHBm,
	SPI_PROGRESS lpPrgressCallback, long lData)
{
	char *filename;
	if ((flag & 7) == 0) {
	/* buf̓t@C */
		filename = buf;
	} else {
	/* buf̓t@CC[Wւ̃|C^ */
        //͂̓t@CsȂ̂őΉłȂ
		return SPI_NOT_SUPPORT;
	}

	if (lpPrgressCallback != NULL)
		if (lpPrgressCallback(0, 1, lData)) /* 0% */
			return SPI_ABORT;

    int ret = GetPictureEx(filename, pHBInfo, pHBm, g_var.GetPreviewFlag());

	if (lpPrgressCallback != NULL)
		if (lpPrgressCallback(1, 1, lData)) /* 100% */
			return SPI_ABORT;

	return ret;
}
//---------------------------------------------------------------------------
int __stdcall ConfigurationDlg(HWND parent, int fnc)
{
#define SPI_CFGDLG_ABOUT    0
#define SPI_CFGDLG_SETTING  1
#define SPI_CFGDLG_RESERVED 2

    if (fnc == SPI_CFGDLG_SETTING) {
        TDialogForm *DialogForm = new TDialogForm(parent);
        DialogForm->formInit();
        DialogForm->ShowModal();
        delete DialogForm;
        return SPI_ALL_RIGHT;
    }
    
    return SPI_NO_FUNCTION;
}
//---------------------------------------------------------------------------
