/*
 * Copyright (c) 2004 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <vcl.h>
#include <Registry.hpp>
#include <Masks.hpp>
#pragma hdrstop

#include "DialogUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TDialogForm *DialogForm;
//---------------------------------------------------------------------------
__fastcall TDialogForm::TDialogForm(HWND ParentWindow)
    : TSetDlgForm(ParentWindow)
{
    //Jɕʂ̂ƂANeBuɂĂ邩Ȃ̂
    optionPC->ActivePage = optionTS;
}
//---------------------------------------------------------------------------
//Ń_CAȌs
//ݒɃ`FbNꂽƂ
void __fastcall TDialogForm::formInit(void)
{
    IFHTMLVAR_STRUCT var;
    g_var.getVar(&var);

    widthUD->Position = var.width;
    heightUD->Position = var.height;

    cacheCB->Checked = var.flag1 & IEIFLAG_CACHE;
    aspectCB->Checked = var.flag1 & IEIFLAG_ASPECT;
    offlineCB->Checked = var.flag1 & IEIFLAG_OFFLINE;
    //gleamCB->Checked = var.flag1 & IEIFLAG_GLEAM;
    screenCB->Checked = var.flag1 & IEIFLAG_SCREEN;
    origsizeCB->Checked = var.flag1 & IEIFLAG_ORIGSIZE;
    //nostampCB->Checked = var.flag1 & IEIFLAG_NOSTAMP;
    //noborderCB->Checked = var.flag1 & IEIFLAG_NOBORDER;
    qualityCB->Checked = var.flag1 & IEIFLAG_QUALITY;

    PcacheCB->Checked = var.flag2 & IEIFLAG_CACHE;
    PaspectCB->Checked = var.flag2 & IEIFLAG_ASPECT;
    PofflineCB->Checked = var.flag2 & IEIFLAG_OFFLINE;
    //PgleamCB->Checked = var.flag2 & IEIFLAG_GLEAM;
    PscreenCB->Checked = var.flag2 & IEIFLAG_SCREEN;
    PorigsizeCB->Checked = var.flag2 & IEIFLAG_ORIGSIZE;
    //PnostampCB->Checked = var.flag2 & IEIFLAG_NOSTAMP;
    //PnoborderCB->Checked = var.flag2 & IEIFLAG_NOBORDER;
    PqualityCB->Checked = var.flag2 & IEIFLAG_QUALITY;

    extEdit->Text = g_var.getExt();
}
//---------------------------------------------------------------------------
//ݒۑ
void __fastcall TDialogForm::okButtonClick(TObject *Sender)
{
    IFHTMLVAR_STRUCT var;

    DWORD width,height;
    bool err=false;
try{
    width = widthEdit->Text.ToInt();
}catch(...){
    err=true;
}
    if (err || width < 1) {
        Application->MessageBox("̒lsłB\n1ȏ̐͂ĂB", "ifhtml.spi", MB_OK | MB_ICONERROR);
        return;
    }
    var.width = width;
    err=false;
try{
    height = heightEdit->Text.ToInt();
}catch(...){
    err=true;
}
    if (err || height < 1) {
        Application->MessageBox("̒lsłB\n1ȏ̐͂ĂB", "ifhtml.spi", MB_OK | MB_ICONERROR);
        return;
    }
    var.height = height;

try{//\eXĝ
    AnsiString test = extEdit->Text;
    MatchesExt("ifhtml.spi", test.c_str());
}catch(...){//\łΗO
    Application->MessageBox("gq̍\łB", "ifhtml.spi", MB_OK | MB_ICONERROR);
    return;
}

    var.flag1 = 0;
    var.flag1 |= (cacheCB->Checked)? IEIFLAG_CACHE: 0;
    var.flag1 |= (aspectCB->Checked)? IEIFLAG_ASPECT: 0;
    var.flag1 |= (offlineCB->Checked)? IEIFLAG_OFFLINE: 0;
    //var.flag1 |= (gleamCB->Checked)? IEIFLAG_GLEAM: 0;
    var.flag1 |= (screenCB->Checked)? IEIFLAG_SCREEN: 0;
    var.flag1 |= (origsizeCB->Checked)? IEIFLAG_ORIGSIZE: 0;
    //var.flag1 |= (nostampCB->Checked)? IEIFLAG_NOSTAMP: 0;
    //var.flag1 |= (noborderCB->Checked)? IEIFLAG_NOBORDER: 0;
    var.flag1 |= (qualityCB->Checked)? IEIFLAG_QUALITY: 0;

    var.flag2 = 0;
    var.flag2 |= (PcacheCB->Checked)? IEIFLAG_CACHE: 0;
    var.flag2 |= (PaspectCB->Checked)? IEIFLAG_ASPECT: 0;
    var.flag2 |= (PofflineCB->Checked)? IEIFLAG_OFFLINE: 0;
    //var.flag2 |= (PgleamCB->Checked)? IEIFLAG_GLEAM: 0;
    var.flag2 |= (PscreenCB->Checked)? IEIFLAG_SCREEN: 0;
    var.flag2 |= (PorigsizeCB->Checked)? IEIFLAG_ORIGSIZE: 0;
    //var.flag2 |= (PnostampCB->Checked)? IEIFLAG_NOSTAMP: 0;
    //var.flag2 |= (PnoborderCB->Checked)? IEIFLAG_NOBORDER: 0;
    var.flag2 |= (PqualityCB->Checked)? IEIFLAG_QUALITY: 0;

    g_var.setVar(&var);
    AnsiString ext = extEdit->Text;
    g_var.setExt(ext.c_str());

    TRegistry *Reg = new TRegistry;
    //Reg->RootKey = HKEY_CURRENT_USER;
if ( Reg->OpenKey("\\Software\\shimitei\\ifhtml", true) ) {
    Reg->WriteInteger("width", var.width);
    Reg->WriteInteger("height", var.height);

    Reg->WriteInteger("flag1", var.flag1);
    Reg->WriteInteger("flag2", var.flag2);

    Reg->WriteString("ext", ext);

    Reg->CloseKey();
} else {
    Application->MessageBox("WXgG[!\nݒۑł܂łB", "ifhtml.spi", MB_OK | MB_ICONERROR);
}
    delete Reg;

    Close();
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::cancelButtonClick(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------

