#!/bin/sh
echo "[NFTABLES.SH] **** start ****" > /dev/kmsg
# === initial ===
nft flush ruleset
# === ipv4 ===
nft add table arp my_arp
nft add chain arp my_arp input { type filter hook input priority 0 \; policy accept \; }
nft add table ip my_filter
nft add chain ip my_filter INPUT { type filter hook input priority 0 \; policy drop \; }
nft add chain ip my_filter FORWARD {  type filter hook forward priority 0 \; policy drop \; }
nft add chain ip my_filter OUTPUT {  type filter hook output priority 0 \; policy drop \; }
nft add chain ip my_filter POSTROUTING { type nat hook postrouting priority 100 \; policy accept \; }
nft add rule ip my_filter INPUT accept
nft add rule ip my_filter OUTPUT accept
nft add rule ip my_filter FORWARD accept
# === ipv6 ===
nft add table ip6 my_filter
nft add chain ip6 my_filter INPUT { type filter hook input priority 0 \; policy drop \; }
nft add chain ip6 my_filter FORWARD {  type filter hook forward priority 0 \; policy drop \; }
nft add chain ip6 my_filter OUTPUT {  type filter hook output priority 0 \; policy drop \; }
nft add chain ip6 my_filter POSTROUTING { type nat hook postrouting priority 100 \; policy accept \; }
nft add rule ip6 my_filter INPUT accept
nft add rule ip6 my_filter OUTPUT accept
nft add rule ip6 my_filter FORWARD accept
# === bridge ===
nft add table bridge my_filter
nft add chain bridge my_filter INPUT { type filter hook input priority 0 \; policy drop \; }
nft add chain bridge my_filter FORWARD {  type filter hook forward priority 0 \; policy drop \; }
nft add chain bridge my_filter OUTPUT {  type filter hook output priority 0 \; policy drop \; }
nft add rule bridge my_filter FORWARD ip protocol tcp log prefix \"[FORWARD br0]\" group 1
nft add rule bridge my_filter FORWARD accept
nft add rule bridge my_filter INPUT ip protocol tcp log prefix \"[INPUT br0]\" group 1
nft add rule bridge my_filter INPUT accept
nft add rule bridge my_filter OUTPUT ip protocol tcp log prefix \"[OUTPUT br0]\" group 1
nft add rule bridge my_filter OUTPUT accept
# === END ===
