DROP VIEW IF EXISTS `my_ulogflt`;
CREATE SQL SECURITY INVOKER VIEW `my_ulogflt` AS
        SELECT _id,
        FROM_UNIXTIME(oob_time_sec) as time,
        oob_prefix as prefix,
        oob_in as II,
        oob_out as IO,
        t_af_family.af_family as LFM,
        replace(INET6_NTOA(ip_saddr_bin),'::ffff:','') as SRC_Adr,
        replace(INET6_NTOA(ip_daddr_bin),'::ffff:','') as DST_Adr,
        t_ip_prot.header_prot as PP,
        t_oob_prot.frame_format as oob_Proto,
        ip_totlen as TOL,
        ip_id as ID,
        ip6_payloadlen as I6PL,
        ip6_priority as I6PO,
        ip6_hoplimit as I6HLMT,
        ip6_flowlabel as I6FLL,
        ip6_fragoff as I6FOF,
        ip6_fragid as I6FID,
        tcp_sport as SPORT,
        tcp_dport as DPORT,
        tcp_seq as SEQ,
        tcp_ackseq as ASEQ,
        tcp_window as WIN,
        concat(tcp_ack,tcp_psh,tcp_rst,tcp_syn,tcp_fin) as "Flag_(aprsf)",
        udp_sport as udp_SPORT,
        udp_dport as udp_DPORT,
        udp_len as ULEN,
        icmp_type as ICMP,
        icmp_code as ICC,
        icmpv6_type as I6ICMP,
        icmpv6_code as I6ICC,
        mac_saddr_str as SRC,
        mac_daddr_str as DST,
        sctp_sport as SCTS,
        sctp_dport as SCTD
        FROM ulog2
                left outer join t_oob_prot on ulog2.oob_protocol = t_oob_prot.id
                left outer join t_af_family on ulog2.oob_family = t_af_family.id
                left outer join t_ip_prot on ulog2.ip_protocol = t_ip_prot.id ;

