unit mas_result;

interface

uses
   mas_put,mas_form,mas_hira,mas_hiscore,
   SysUtils;
   
procedure savettlhsc;
procedure loadttlhsc;
procedure clearttlhsc;
procedure putttlhiscore;
procedure initresult;
procedure moveresult;
procedure putresult;

implementation

uses mas_main,mas_title;

var
   resultcou: integer;
   ttlhsc: array [1..3] of Hscdat;

procedure clearttlhsc;
var
   i: integer;
begin
   for i:=1 to 3 do begin
      ttlhsc[i].rec:=0;
      ttlhsc[i].name:='---';
   end;
end;

procedure loadttlhsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'ttl.hsc');
   try
      reset(F);
   except
      on EInOutError do begin
         clearttlhsc;
         exit;
      end;
   end;
   for i:=1 to 3 do
      system.read(F,ttlhsc[i]);
   system.close(F);
end;

procedure savettlhsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'ttl.hsc');
   rewrite(F);
   for i:=1 to 3 do
      system.write(F,ttlhsc[i]);
   system.close(F);
end;

procedure setttlhiscore(rec: integer);
var
   i,n: integer;
begin
   n:=0;
   for i:=1 to 3 do
      if rec>ttlhsc[i].rec then begin
         n:=i; break;
      end;
   if n=0 then exit;
   for i:=3 downto n+1 do
      ttlhsc[i]:=ttlhsc[i-1];
   ttlhsc[n].rec:=rec;
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(ttlhsc[i].rec)+'point',ttlhsc[i].name);
   Form3.settitle('Best of Masashi');
   ttlhsc[n].name:=Form3.entername(n,inttostr(rec)+'point');
end;

procedure putttlhiscore;
var
   i:integer;
begin
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(ttlhsc[i].rec)+'point',ttlhsc[i].name);
   Form3.settitle('Best of Masashi');
   Form3.show;
end;

procedure initresult;
begin
   clearhira;
   resultcou:=0;
   setmainloopspe(16);
end;

procedure moveresult;
const
   KYONUM: array [0..4] of string = (
      'ǹ','޺','','Ź','̱԰');
var
   i,y: integer;
   sc: integer;
   mmv,mbt: integer;
   s: string;
   c: integer;
begin
   inc(resultcou);
   sethira2('',100,0,40,1);
   y:=64;
   c:=(resultcou-16) div 16;
   if c>4 then c:=4;
   if resultcou>=16 then
      for i:=0 to c do begin
         sethira2(KYONUM[i],0,y,42,1);
         s:=inttostr(score[i]);
         sethira2(s,540-length(s)*50,y-8,50,1);
         sethira2('',540,y,42,1);
         inc(y,64);
      end;
   if resultcou=112 then begin
      sc:=0;
      for i:=0 to 4 do inc(sc,score[i]);
      s:=inttostr(sc);
      sethira2(s,540-length(s)*50,380-8,50,9999);
      sethira2('',540,380,42,9999);
      setttlhiscore(sc);
   end;
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (((resultcou>112) and (mbt=1)) or (resultcou>350)) and not hscsf then
      inittitle;
end;

procedure putresult;
begin
   case resultcou of
      96..350:begin
         setthicklinefirst2(8,365);
         putthickline2(632,365);
      end;
   end;
end;

end.











