unit mas_put;

interface

uses
   mas_form;

procedure setlcolor(c: integer);
procedure setzoom(x:integer; y:integer; zoom:integer);
procedure setthicklinefirst(x:integer; y:integer);
function putthickline(x:integer; y:integer):boolean;
procedure setthicklinefirst2(x:integer; y:integer);
function putthickline2(x:integer; y:integer):boolean;
procedure putmount(pmount: integer; ox:integer; oy:integer);
procedure putmount2(pmount: integer; ox:integer; oy:integer);
procedure putman(xc:integer; yc:integer; d:integer; p:integer);
procedure puthngman(xc: integer; yc: integer; wx:integer; p:integer);
procedure movemount(pmount: integer);

const
   MOULEN = 1024;

type
   Moudat = record
      d,obj:integer;
   end;

var
   LWidth: integer;
   mountdata: array [0..MOULEN-1] of Moudat;
   scd: integer;

implementation

uses
   mas_main;

var
   tlx,tly: integer;
   xwd,ywd,zoomwd: integer;
   lcolor: integer;

const
   DftWidth = 640*256;
   DftHeight = 480*256;
   DftWidth2 = 640;
   DftHeight2 = 480;

procedure setlcolor(c: integer);
begin
   lcolor:=c;
end;

procedure setzoom(x:integer; y:integer; zoom:integer);
begin
   xwd:=x; ywd:=y; zoomwd:=zoom;
end;

procedure setthicklinefirst(x:integer; y:integer);
begin
   tlx:=(x-xwd)*Mas_Main_Form.sxmax*zoomwd div DftWidth+random(3)-1;
   tly:=(y-ywd)*Mas_Main_Form.symax*zoomwd div DftHeight+random(3)-1;
//   tlx:=(x-xwd+random(5)-2)*Mas_Main_Form.sxmax*zoomwd div DftWidth;
//   tly:=(y-ywd+random(5)-2)*Mas_Main_Form.symax*zoomwd div DftHeight;
end;

function putthickline(x:integer; y:integer):boolean;
var
   sx,sy,scx,scy:integer;
begin
   sx:=(x-xwd)*Mas_Main_Form.sxmax*zoomwd div DftWidth+random(3)-1;
   sy:=(y-ywd)*Mas_Main_Form.symax*zoomwd div DftHeight+random(3)-1;
//   sx:=(x-xwd+random(5)-2)*Mas_Main_Form.sxmax*zoomwd div DftWidth;
//   sy:=(y-ywd+random(5)-2)*Mas_Main_Form.symax*zoomwd div DftHeight;
   scx:=(sx+tlx)div 2 + random(3)-1;
   scy:=(sy+tly)div 2 + random(3)-1;
   Result:=Mas_Main_Form.putline(tlx,tly,scx,scy,LWidth,lcolor);
   Result:=Mas_Main_Form.putline(scx,scy,sx,sy,LWidth,lcolor) and Result;
   tlx:=sx; tly:=sy;
end;

procedure setthicklinefirst2(x:integer; y:integer);
begin
   tlx:=x*Mas_Main_Form.sxmax div DftWidth2+random(3)-1;
   tly:=y*Mas_Main_Form.symax div DftHeight2+random(3)-1;
end;

function putthickline2(x:integer; y:integer):boolean;
var
   sx,sy,scx,scy:integer;
begin
   sx:=x*Mas_Main_Form.sxmax div DftWidth2+random(3)-1;
   sy:=y*Mas_Main_Form.symax div DftHeight2+random(3)-1;
   scx:=(sx+tlx)div 2 + random(3)-1;
   scy:=(sy+tly)div 2 + random(3)-1;
   Result:=Mas_Main_Form.putline(tlx,tly,scx,scy,LWidth,lcolor);
   Result:=Mas_Main_Form.putline(scx,scy,sx,sy,LWidth,lcolor) and Result;
   tlx:=sx; tly:=sy;
end;

procedure movemount(pmount: integer);
begin
   scd:=(scd*3+mountdata[pmount].d) div 4;
end;

procedure putmount(pmount: integer; ox:integer; oy:integer);
var
   d,i,spe: integer;
   x1,y1,xo,yo: integer;
   p: integer;
begin
   x1:=ox; y1:=oy; p:=pmount;
   setthicklinefirst(x1,y1);
   while true do begin
      d:=(mountdata[p].d-scd) and 1023;
      if mountdata[p].obj<>-1 then begin
         xo:=x1; yo:=y1;
         setthicklinefirst(xo,yo);
         i:=0; spe:=mountdata[p].obj;
         while obd[spe].pd[i].x<>-32768 do begin
            inc(xo,obd[spe].pd[i].x*dcos[d] div 256-obd[spe].pd[i].y*dsin[d] div 256);
            inc(yo,obd[spe].pd[i].x*dsin[d] div 256+obd[spe].pd[i].y*dcos[d] div 256);
            putthickline(xo,yo);
            inc(i);
         end;
         setthicklinefirst(x1,y1);
      end;
      x1:=x1+dcos[d] div 8;
      y1:=y1+dsin[d] div 8;
      if putthickline(x1,y1)=FALSE then break;
      inc(p);
   end;
   x1:=ox; y1:=oy; p:=pmount;
   setthicklinefirst(x1,y1);
   while true do begin
      dec(p);
      d:=(mountdata[p].d-scd) and 1023;
      dec(x1,dcos[d] div 8);
      dec(y1,dsin[d] div 8);
      if putthickline(x1,y1)=FALSE then break;
      if mountdata[p].obj<>-1 then begin
         xo:=x1; yo:=y1;
         setthicklinefirst(xo,yo);
         i:=0; spe:=mountdata[p].obj;
         while obd[spe].pd[i].x<>-32768 do begin
            inc(xo,obd[spe].pd[i].x*dcos[d] div 256-obd[spe].pd[i].y*dsin[d] div 256);
            inc(yo,obd[spe].pd[i].x*dsin[d] div 256+obd[spe].pd[i].y*dcos[d] div 256);
            putthickline(xo,yo);
            inc(i);
         end;
         setthicklinefirst(x1,y1);
      end;
   end;
end;

procedure putmount2(pmount: integer; ox:integer; oy:integer);
var
   d,i,spe: integer;
   x1,y1,xo,yo: integer;
   p: integer;
   pf: boolean;
begin
   pf:=FALSE;
   x1:=ox; y1:=oy; p:=pmount;
   setthicklinefirst(x1,y1);
   while true do begin
      d:=(mountdata[p].d-scd) and 1023;
      if mountdata[p].obj<>-1 then begin
         xo:=x1; yo:=y1;
         setthicklinefirst(xo,yo);
         i:=0; spe:=mountdata[p].obj;
         while obd[spe].pd[i].x<>-32768 do begin
            inc(xo,obd[spe].pd[i].x*dcos[d] div 256-obd[spe].pd[i].y*dsin[d] div 256);
            inc(yo,obd[spe].pd[i].x*dsin[d] div 256+obd[spe].pd[i].y*dcos[d] div 256);
            putthickline(xo,yo);
            inc(i);
         end;
         setthicklinefirst(x1,y1);
      end;
      x1:=x1+dcos[d] div 8;
      y1:=y1+dsin[d] div 8;
      if p>960 then break;
      if (putthickline(x1,y1)=FALSE) then begin
         if pf then break;
      end else pf:=TRUE;
      inc(p);
   end;
   x1:=ox; y1:=oy; p:=pmount;
   setthicklinefirst(x1,y1);
   while true do begin
      dec(p);
      d:=(mountdata[p].d-scd) and 1023;
      dec(x1,dcos[d] div 8);
      dec(y1,dsin[d] div 8);
      if putthickline(x1,y1)=FALSE then break;
      if mountdata[p].obj<>-1 then begin
         xo:=x1; yo:=y1;
         setthicklinefirst(xo,yo);
         i:=0; spe:=mountdata[p].obj;
         while obd[spe].pd[i].x<>-32768 do begin
            inc(xo,obd[spe].pd[i].x*dcos[d] div 256-obd[spe].pd[i].y*dsin[d] div 256);
            inc(yo,obd[spe].pd[i].x*dsin[d] div 256+obd[spe].pd[i].y*dcos[d] div 256);
            putthickline(xo,yo);
            inc(i);
         end;
         setthicklinefirst(x1,y1);
      end;
   end;
end;

procedure puthngman(xc: integer; yc: integer; wx:integer; p:integer);
var
   x,y: integer;
   i: integer;
begin
   i:=0;
   while md[p].pd[i].x<>-32768 do begin
      if md[p].pd[i].x=-32700 then begin
         inc(i);
         inc(x,wx*(y-yc) div 53);
         while md[p].pd[i].x<>-32760 do begin
            inc(x,md[p].pd[i].x);
            inc(y,md[p].pd[i].y);
            putthickline(x,y);
            inc(i);
         end;
         inc(i);
      end else begin
         x:=xc+md[p].pd[i].x;
         y:=yc+md[p].pd[i].y;
         setthicklinefirst(x+wx*(y-yc) div 53,y);
         inc(i);
         while md[p].pd[i].x<>-32760 do begin
            inc(y,md[p].pd[i].y);
            inc(x,md[p].pd[i].x);
            putthickline(x+wx*(y-yc) div 53,y);
            inc(i);
         end;
         inc(i);
      end;
   end;
end;

procedure putman(xc:integer; yc:integer; d:integer; p:integer);
var
   x,y: integer;
   i: integer;
begin
   i:=0;
   while md[p].pd[i].x<>-32768 do begin
      x:=xc+md[p].pd[i].x*dcos[d] div 256-md[p].pd[i].y*dsin[d] div 256;
      y:=yc+md[p].pd[i].x*dsin[d] div 256+md[p].pd[i].y*dcos[d] div 256;
      setthicklinefirst(x,y);
      inc(i);
      while md[p].pd[i].x<>-32760 do begin
         inc(x,md[p].pd[i].x*dcos[d] div 256-md[p].pd[i].y*dsin[d] div 256);
         inc(y,md[p].pd[i].x*dsin[d] div 256+md[p].pd[i].y*dcos[d] div 256);
         putthickline(x,y);
         inc(i);
      end;
      inc(i);
   end;
end;

end.
