unit mas_ook;

interface

uses SysUtils,
   mas_put,mas_form,mas_hira,mas_hiscore,mas_hng;

procedure saveookhsc;
procedure loadookhsc;
procedure clearookhsc;
procedure putookhiscore;
procedure initooktitle;
procedure initookex;
procedure initookdemo;
procedure initook;
procedure moveooktitle;
procedure moveookex;
procedure moveook;
procedure putooktitle;
procedure putookex;
procedure putook;

implementation

uses
   mas_main,mas_title;

const
   XCENT = 230;
   YCENT = 300;

var
   ookhsc: array [1..3] of Hscdat;
   myx,myy,myp,myc,mychar,speed,mvsum,myhng: integer;
   dist: integer;
   endist,enhng,enspeed: integer;
   plcou,enplcou: integer;
   time: integer;
   zm: integer;
   ookcou,ookdemocou: integer;

procedure clearookhsc;
var
   i: integer;
begin
   for i:=1 to 3 do begin
      ookhsc[i].rec:=99999;
      ookhsc[i].name:='---';
   end;
end;

procedure loadookhsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'ook.hsc');
   try
      reset(F);
   except
      on EInOutError do begin
         clearookhsc;
         exit;
      end;
   end;
   for i:=1 to 3 do
      system.read(F,ookhsc[i]);
   system.close(F);
end;

procedure saveookhsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'ook.hsc');
   rewrite(F);
   for i:=1 to 3 do
      system.write(F,ookhsc[i]);
   system.close(F);
end;

procedure setookhiscore(rec: integer);
var
   i,n: integer;
   s: string;
begin
   n:=0;
   for i:=1 to 3 do
      if rec<ookhsc[i].rec then begin
         n:=i; break;
      end;
   if n=0 then exit;
   for i:=3 downto n+1 do
      ookhsc[i]:=ookhsc[i-1];
   ookhsc[n].rec:=rec;
   for i:=1 to 3 do begin
      s:=inttostr(ookhsc[i].rec mod 1000+1000);
      delete(s,1,1);
      s:=inttostr(ookhsc[i].rec div 1000)+'sec'+s;
      Form3.sethiscore(i,s,ookhsc[i].name);
   end;
   Form3.settitle('Oooka Sabaki');
   s:=inttostr(rec mod 1000+1000);
   delete(s,1,1);
   s:=inttostr(rec div 1000)+'sec'+s;
   ookhsc[n].name:=Form3.entername(n,s);
end;

procedure putookhiscore;
var
   i:integer;
   s:string;
begin
   for i:=1 to 3 do begin
      s:=inttostr(ookhsc[i].rec mod 1000+1000);
      delete(s,1,1);
      s:=inttostr(ookhsc[i].rec div 1000)+'sec'+s;
      Form3.sethiscore(i,s,ookhsc[i].name);
   end;
   Form3.settitle('Oooka Sabaki');
   Form3.show;
end;

procedure initook;
var
   i: integer;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   for i:=0 to MOULEN-1 do begin
      mountdata[i].d:=0;
      if (random(12)=0) then
         mountdata[i].obj:=random(4)+1
      else
         mountdata[i].obj:=-1;
      case i of
         520:mountdata[i].obj:=5;
         509..519:mountdata[i].obj:=-1;
         508:mountdata[i].obj:=5;
         450:mountdata[i].obj:=6;
      end;
   end;

   myp:=512; myx:=0; speed:=0;
   mvsum:=0; mychar:=0; myc:=23;
   myy:=0;
   zm:=128;
   dist:=0; myhng:=0;
   endist:=0; enhng:=0; enspeed:=0;
   plcou:=0; enplcou:=0;
   time:=0;

   ookcou:=0;
   ookdemocou:=0;
   lcolor:=255;
   setmainloopspe(10);
end;

procedure initookdemo;
var
   i: integer;
begin
   clearhira;
   for i:=0 to MOULEN-1 do begin
      mountdata[i].d:=0;
      if (random(12)=0) then
         mountdata[i].obj:=random(4)+1
      else
         mountdata[i].obj:=-1;
      case i of
         520:mountdata[i].obj:=5;
         509..519:mountdata[i].obj:=-1;
         508:mountdata[i].obj:=5;
//         450:mountdata[i].obj:=6;
      end;
   end;

   myp:=512; myx:=0; speed:=0;
   mvsum:=0; mychar:=0; myc:=23;
   myy:=0;
   zm:=128;
   dist:=0; myhng:=0;
   endist:=0; enhng:=0; enspeed:=0;
   plcou:=0; enplcou:=0;
   time:=0;

   ookcou:=0;
   ookdemocou:=-1;
   lcolor:=255;
   setmainloopspe(-5);
   sethira2('޷',0,0,24,640);
   sethira2('2',120,400,40,640);
end;

procedure initookex;
var
   i: integer;
begin
   clearhira;
   for i:=0 to MOULEN-1 do begin
      mountdata[i].d:=0;
      if (random(12)=0) then
         mountdata[i].obj:=random(4)+1
      else
         mountdata[i].obj:=-1;
      case i of
         520:mountdata[i].obj:=5;
         509..519:mountdata[i].obj:=-1;
         508:mountdata[i].obj:=5;
//         450:mountdata[i].obj:=6;
      end;
   end;

   myp:=512; myx:=0; speed:=0;
   mvsum:=0; mychar:=0; myc:=23;
   myy:=0;
   zm:=128;
   dist:=0; myhng:=0;
   endist:=0; enhng:=0; enspeed:=0;
   plcou:=0; enplcou:=0;
   time:=0;

   ookcou:=0;
   ookdemocou:=0;
   lcolor:=255;
   setmainloopspe(12);
end;

procedure initooktitle;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   setzoom(0,0,256);
   ookcou:=0;
   lcolor:=255;
   setmainloopspe(11);
end;

procedure moveooktitle;
var
   mmv,mbt: integer;
begin
   inc(ookcou);
   sethira2('޷',128,200,50,1);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (ookcou>165) then initookex;
end;

procedure putooktitle;
begin
   puthngman(-ookcou*5+640,YCENT+128,0,23+(ookcou and 3));
   setthicklinefirst2(-ookcou*5+640+30,YCENT+128-52);
   putthickline2(640,YCENT+128-52);
end;

procedure moveook;
const
   HIKMES: array [0..7] of string = (
      '','','ֲ','','˹','ج','','');
//   HIKMES: array [0..7] of string = (
//      '˲','ʳ','','¶','','޲','ʱ','ӳ');
   ITAMES: array [0..7] of string = (
      '','ެ','۰','ٰ','ܰ','˴','޶','');
   LSTMES: array [0..7] of string = (
      'ò','ݲŻ','ϳ޺','ƽ',
      'Ƕĵӯ','޼','ʲخ','');
var
   mmv,mbt: integer;
   s: string;
   sc,d: integer;
begin
   if ookdemocou=0 then begin
      Mas_Main_Form.getmousestatus(mmv,mbt);
   end else if ookdemocou>0 then begin
      inc(speed);
      mmv:=0; mbt:=0;
      case ookdemocou of
         8:sethira2('ϳظؼöަѹ',32,80,30,52);
         70:sethira2('ò޶Ѳ',32,80,30,64);
         141:sethira2('˷־',32,80,30,80);
         142:mbt:=1;
         241:sethira2('ڦض˯',32,80,30,80);
         250:mbt:=1;
         360:sethira2('÷˯ݽ',32,80,30,72);
         300:mbt:=1;
         350:mbt:=1;
         400:mbt:=1;
      end;
      case ookdemocou of
         70..140:exit;
         155..240:exit;
      end;
   end else begin
      inc(speed);
      mbt:=0; mmv:=0;
      if (random(20)=0) then mbt:=1;
      dec(ookdemocou);
      if ookdemocou<-640 then inittitle;
   end;
   case ookcou of
   48:begin
      inc(time,33);
      if plcou=0 then begin
         inc(speed,(mmv+mousesense div 2) div mousesense);
         dec(speed,speed*dist div 2000);
         dec(myx,speed);
         inc(dist,speed);
         inc(zm,(180-zm) div 16);
         inc(mvsum,speed);
         myhng:=-dist;
      end else begin
         dec(myhng,myhng div 6);
         dec(dist,(dist+myhng) div 6);
         dec(plcou);
         if plcou=0 then dist:=-myhng;
         inc(zm,(320-zm) div 8);
      end;
      if enplcou=0 then begin
         if ((ookdemocou<=0) or (ookdemocou>250)) and (time<20000) then inc(enspeed,1);
         dec(enspeed,enspeed*endist div 2000);
         inc(endist,enspeed);
         enhng:=endist;
         if random(16)=0 then begin
            enplcou:=16; enspeed:=0;
         end;
      end else begin
         dec(enhng,enhng div 6);
         inc(myx,(endist-enhng) div 6);
         dec(endist,(endist-enhng) div 6);
         dec(enplcou);
         if enplcou=0 then endist:=enhng;
      end;

      d:=(dist-(dist+myhng+endist-enhng) div 2);
      dec(dist,d div 64);
      inc(endist,d div 64);
      d:=(dist+myhng+endist-enhng) div 128;
      dec(dist,d); dec(myx,d);
      dec(endist,d);
      if myx<-31 then begin
         inc(myx,32); dec(myp);
      end
      else if myx<-63 then begin
         inc(myx,64); dec(myp,2);
      end
      else if myx>31 then begin
         dec(myx,32); inc(myp);
      end
      else if myx>63 then begin
         dec(myx,64); inc(myp,2);
      end;
 	   if mvsum>7 then begin
		   mvsum:=0; inc(mychar);
      end;
      myc:=(mychar and 3)+23;

      if ((plcou>0) or (enplcou>0)) and (random(16)=0) and (ookdemocou<=0) then
         sethira(ITAMES[random(8)],XCENT+dist+myhng+64,YCENT-40,80,5-random(9));
      if plcou=0 then begin
         if mbt=1 then begin
            sethira(HIKMES[random(8)],XCENT,YCENT-40,32+random(32),-random(9));
            plcou:=16; speed:=0;
         end;
      end;

      if ((512-myp)*32-myx-dist-64>1984) and (ookdemocou=0) then ookcou:=65;
    end;
    65..1000:begin
      inc(ookcou);
      dec(dist,dist div 8);
      dec(endist,endist div 8);
      dec(myhng,myhng div 8);
      dec(enhng,enhng div 8);
      inc(zm,(256-zm) div 16);
      if ookcou>128 then begin
         dec(lcolor,4); if lcolor<0 then lcolor:=0;
      end;
      case ookcou of
         72:sethira(LSTMES[random(8)],XCENT+dist+myhng+64,YCENT-40,56,0);
         128:sethira2('۸',32,100,64,170);
         140:begin
            s:=inttostr(time div 1000);
            sethira2(s,220-length(s)*64,200,64,160);
         end;
         150:
            sethira2('ޮ',240,210,52,150);
         160:begin
            s:=inttostr(time mod 1000+1000);
            delete(s,1,1);
            sethira2(s,400,200,64,140);
            if sucf and (ookdemocou=0) then begin
               sethira2('',0,428,42,250);
//               sc:=40000000 div (time-12000);
//               sc:=60000000 div (time-10000);
//               sc:=100000000 div (time-5000);
               sc:=150000000 div time;
               if sc>20000 then sc:=20000
               else if sc<0 then sc:=20000;
               score[2]:=sc;
               s:=inttostr(sc);
               sethira2(s,520-length(s)*50,420,50,250);
               sethira2('',520,428,42,250);
            end;
            if ookdemocou=0 then setookhiscore(time);
         end;
      end;
      if (((ookcou>160) and (mbt=1)) or (ookcou>410)) and not hscsf then
         if sucf then inithngtitle
         else inittitle;
   end;
   else begin
      if ookcou>0 then begin
         sethira2('޷',ookcou*16,100,64,1);
         inc(ookcou);
         if ookcou=48 then sethira('',280,240,100,0);
      end;
   end;
   end;
   if (ookcou<65) and (ookdemocou=0) then begin
      d:=(1984-((512-myp)*32-myx-dist-64))*13;
      if d<0 then d:=0;
      s:=inttostr(d);
      sethira2('',200,440,32,1);
      sethira2(s,528-length(s)*50,420,50,1);
      sethira2('',540,440,32,1);
      s:=inttostr(time mod 1000+1000);
      delete(s,1,1);
      sethira2(s,500,0,48,1);
      s:=inttostr(time div 1000);
      sethira2(s,410-length(s)*48,0,48,1);
      sethira2('ޮ',420,24,24,1);
   end;
   movemount(myp);
end;

procedure moveookex;
var
   mmv,mbt: integer;
begin
   sethira2('޾Ҳ',0,0,48,1);
   moveook;
   inc(ookdemocou);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (ookdemocou>460) then initook;
end;

procedure putookex;
var
   nd: integer;
begin
   if ookcou=0 then ookcou:=48;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   setlcolor(lcolor);
   putmount2(myp,XCENT-myx+myhng,YCENT-myy);
   puthngman(XCENT+myhng,YCENT,myhng,myc);
   nd:=dist+myhng+endist-enhng;
   puthngman(XCENT+dist+myhng+64,YCENT,dist+myhng-nd div 2,27);
   setthicklinefirst(XCENT+32,YCENT-52);
   putthickline(XCENT+32+(nd+64) div 2,YCENT-50);
   putthickline(XCENT+32+nd+64,YCENT-52);
   puthngman(XCENT+64+nd+enhng+64,YCENT,enhng,28);
   setlcolor(255);
end;

procedure putook;
var
   nd: integer;
begin
   if ookcou=0 then ookcou:=1;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   setlcolor(lcolor);
   putmount2(myp,XCENT-myx+myhng,YCENT-myy);
   puthngman(XCENT+myhng,YCENT,myhng,myc);
   nd:=dist+myhng+endist-enhng;
   puthngman(XCENT+dist+myhng+64,YCENT,dist+myhng-nd div 2,27);
   setthicklinefirst(XCENT+32,YCENT-52);
   putthickline(XCENT+32+(nd+64) div 2,YCENT-50);
   putthickline(XCENT+32+nd+64,YCENT-52);
   puthngman(XCENT+64+nd+enhng+64,YCENT,enhng,28);
   setlcolor(255);
end;

end.
