unit mas_main;

interface

uses
   Windows,SysUtils,Dialogs,
   mas_title,mas_hira,mas_put,mas_hiscore,
   mas_kak,mas_hng,mas_tob,mas_ook,mas_gfi,
   mas_result,
   mas_form;

{const
   MOULEN = 1024;}

type
{   Moudat = record
      d,obj:integer;
   end;}
   Objdat = record
      pd: array [0..31] of TPoint;
   end;
   Mandat = record
      pd: array [0..63] of TPoint;
   end;
   Hscdat = record
      rec: integer;
      name: string[255];
   end;
   Cfgdat = record
      x,y: integer;
      wx,wy: integer;
   end;

var
   dsin,dcos: array [0..1023] of Integer;
   tantab: array [0..255] of Integer;
   mlspe: integer;
//   mountdata: array [0..MOULEN-1] of Moudat;
   obd: array [0..13] of Objdat;
   md: array [0..31] of Mandat;
   mousesense: integer;
   lcolor: integer;
   cfg: Cfgdat;
   sucf: boolean;
   score: array [0..4] of integer;

procedure initall;
procedure closeall;
function setmainloopspe(spe: integer):integer;
procedure moveall;
procedure putall;
function getdeg(x:integer; y:integer):integer;

implementation

//uses
//   mas_title,mas_kak;

procedure loadobjdata;
var
   F: File of Objdat;
   i: integer;
begin
   i:=0;
   assignfile(F,'dlch.ldt');
   try
      reset(F);
   except
      on EInOutError do begin
         MessageDlg('Can''t find file dlch.ldt',mtError,[mbOk],0);
         Mas_Main_Form.close; halt;
      end;
   end;
   while not EOF(F) do begin
      system.read(F,obd[i]);
      inc(i);
   end;
   close(F);
end;

procedure loadmandata;
var
   F: File of Mandat;
   i: integer;
begin
   i:=0;
   assignfile(F,'man.ldt');
   try
      reset(F);
   except
      on EInOutError do begin
         MessageDlg('Can''t find file man.ldt',mtError,[mbOk],0);
         Mas_Main_Form.close; halt;
      end;
   end;
   while not EOF(F) do begin
      system.read(F,md[i]);
      inc(i);
   end;
   close(F);
end;

procedure loadcfgfile;
var
   F: File of Cfgdat;
begin
   assignfile(F,'mas.cfg');
   try
      reset(F);
   except
      on EinOutError do begin
         cfg.x:=20; cfg.y:=20;
         cfg.wx:=640; cfg.wy:=480;
         exit;
      end;
   end;
   read(F,cfg);
   close(F);
end;

procedure savecfgfile;
var
   F: File of Cfgdat;
begin
   assignfile(F,'mas.cfg');
   rewrite(F);
   write(F,cfg);
   close(F);
end;

procedure initsc;
var
   r,d:integer;
begin
   for r:=0 to 1023 do begin
       dsin[r]:=round(sin(r*0.006136)*256);
       dcos[r]:=round(cos(r*0.006136)*256);
   end;
   dsin[0]:=0; dcos[0]:=256;
   dsin[256]:=256; dcos[256]:=0;
   dsin[512]:=0; dcos[512]:=-256;
   dsin[768]:=-256; dcos[768]:=0;
   d:=0;
   for r:=0 to 255 do begin
      while ( round(sin(d*0.006136)/cos(d*0.006136)*256)<r ) do inc(d);
      tantab[r]:=d;
   end;
end;

procedure initall;
begin
   randomize;
   initsc;
   inithira;
   inithsc;
   setzoom(0,0,256);
   setlcolor(255);
   //   initkak;
   inittitle;
   loadobjdata;
   loadmandata;
   loadkakhsc;
   loadhnghsc;
   loadtobhsc;
   loadookhsc;
   loadgfihsc;
   loadttlhsc;
   loadcfgfile;

   Mas_Main_Form.setwindowsize(cfg.wx,cfg.wy);
   Mas_Main_Form.setwindowpos(cfg.x,cfg.y);
   mousesense:=128;
end;

procedure closeall;
begin
   savekakhsc;
   savehnghsc;
   savetobhsc;
   saveookhsc;
   savegfihsc;
   savettlhsc;
   savecfgfile;
end;

function setmainloopspe(spe: integer):integer;
begin
   Result:=mlspe;
   mlspe:=spe;
end;

function getdeg(x:integer; y:integer):integer;
var
   tx,ty,f,od,tn:integer;
begin
   if (x=0) and (y=0) then begin
      Result:=0; exit;
   end;
   if x<0 then begin
      tx:=-x;
      if y<0 then begin
         ty:=-y;
         if tx>ty then begin
            f:=1;
            od:=896-128; tn:=ty*256 div tx;
         end else begin
            f:=-1;
            od:=896+128; tn:=tx*256 div ty;
         end;
      end else begin
         ty:=y;
         if tx>ty then begin
            f:=-1;
            od:=640+128; tn:=ty*256 div tx;
         end else begin
            f:=1;
            od:=640-128; tn:=tx*256 div ty;
         end;
      end;
   end else begin
      tx:=x;
      if y<0 then begin
         ty:=-y;
         if tx>ty then begin
            f:=-1;
            od:=128+128; tn:=ty*256 div tx;
         end else begin
            f:=1;
            od:=128-128; tn:=tx*256 div ty;
         end;
      end else begin
         ty:=y;
         if tx>ty then begin
            f:=1;
            od:=384-128; tn:=ty*256 div tx;
         end else begin
            f:=-1;
            od:=384+128; tn:=tx*256 div ty;
         end;
      end;
   end;
   Result:=(od+tantab[tn]*f) and 1023;
end;

procedure moveall;
{var
   mmv,mbt: integer;
   i: integer;}
begin
{   if (mlspe<=0) and (not palf) then begin
      Mas_Main_Form.getmousestatus(mmv,mbt);
      if mbt=1 then begin
         for i:=0 to 255 do inc(Mas_Main_Form.table[i]);
      end;
   end;}
   movehira;
   case mlspe of
      0:movetitle;
      1,-2:movekak;
      2:movekaktitle;
      3:movekakex;
      4,-3:movehng;
      5:movehngtitle;
      6:movehngex;
      7,-4:movetob;
      8:movetobtitle;
      9:movetobex;
      10,-5:moveook;
      11:moveooktitle;
      12:moveookex;
      13,-6:movegfi;
      14:movegfititle;
      15:movegfiex;
      16:moveresult;
   end;
end;

procedure putall;
begin
   case mlspe of
      1,-2:putkak;
      2:putkaktitle;
      3:putkakex;
      4,-3:puthng;
      5:puthngtitle;
      6:puthngex;
      7,-4:puttob;
      8:puttobtitle;
      9:puttobex;
      10,-5:putook;
      11:putooktitle;
      12:putookex;
      13,-6:putgfi;
      14:putgfititle;
      15:putgfiex;
      16:putresult;
   end;
   puthira;
end;

end.
