unit mas_hng;

interface

uses
   mas_put,mas_form,mas_hira,mas_hiscore,mas_gfi
   ,SysUtils;

procedure inithngdemo;
procedure inithngtitle;
procedure inithngex;
procedure inithng;
procedure movehngtitle;
procedure movehngex;
procedure movehng;
procedure puthngtitle;
procedure puthngex;
procedure puthng;
procedure loadhnghsc;
procedure savehnghsc;
procedure puthnghiscore;
procedure clearhnghsc;

implementation

uses mas_main,mas_title;

const
   XCENT = 230;
   YCENT = 300;
var
   myp,myx,myy,myd,mymx,mymy,mytd,speed,tmpsp,mypt,dist: integer;
   flx,fly,flmx,flmy: integer;
   zm: integer;
   hngcou,hngdemocou: integer;
   dmmbtcou: integer;
   hngtry: integer;
   hngdist: array [1..3] of integer;
   hnghsc: array [1..3] of Hscdat;

procedure clearhnghsc;
var
   i: integer;
begin
   for i:=1 to 3 do begin
      hnghsc[i].rec:=-99999;
      hnghsc[i].name:='---';
   end;
end;

procedure loadhnghsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'hng.hsc');
   try
      reset(F);
   except
      on EInOutError do begin
         clearhnghsc;
         exit;
      end;
   end;
   for i:=1 to 3 do
      system.read(F,hnghsc[i]);
   system.close(F);
end;

procedure savehnghsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'hng.hsc');
   rewrite(F);
   for i:=1 to 3 do
      system.write(F,hnghsc[i]);
   system.close(F);
end;

procedure sethnghiscore(rec: integer);
var
   i,n: integer;
begin
   n:=0;
   for i:=1 to 3 do
      if rec>hnghsc[i].rec then begin
         n:=i; break;
      end;
   if n=0 then exit;
   for i:=3 downto n+1 do
      hnghsc[i]:=hnghsc[i-1];
   hnghsc[n].rec:=rec;
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(hnghsc[i].rec)+'mm',hnghsc[i].name);
   Form3.settitle('Hitonage');
   hnghsc[n].name:=Form3.entername(n,inttostr(rec)+'mm');
end;

procedure puthnghiscore;
var
   i:integer;
begin
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(hnghsc[i].rec)+'mm',hnghsc[i].name);
   Form3.settitle('Hitonage');
   Form3.show;
end;

procedure makehngmountdata;
var
   r: integer;
const
   gakedat: array [0..31] of integer = (
      300,295,293,290,292,290,290,288,
      280,270,275,277,276,280,271,272,
      278,271,260,266,270,275,270,269,
      268,256,250,248,252,262,265,256);
begin
	for r:=0 to MOULEN-1 do begin
		if (r>48) and (r<48+33) then begin
         mountdata[r].d:=gakedat[r-48];
         mountdata[r].obj:=-1;
      end else begin
         mountdata[r].d:=0;
         mountdata[r].obj:=-1;
         if r<48 then begin
            if random(8)=0 then mountdata[r].obj:=4
         end else if random(20)=0 then mountdata[r].obj:=2
      end;
   end;
end;

procedure inithng;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   makehngmountdata;
   myp:=32; myx:=0; myy:=0; myd:=512; speed:=0; tmpsp:=0;
   mytd:=0; mypt:=0;
   zm:=256;
   flx:=-32768;
   hngcou:=0; hngdemocou:=0;
   dist:=-17*32;
   setmainloopspe(4);
   lcolor:=255;
   hngtry:=1;
end;

procedure inithng2;
begin
//   Mas_Main_Form.hidemousecursor;
   clearhira;
//   makehngmountdata;
   myp:=32; myx:=0; myy:=0; myd:=512; speed:=0; tmpsp:=0;
   mytd:=0; mypt:=0;
   zm:=256;
   flx:=-32768;
   hngcou:=0; hngdemocou:=0;
   dist:=-17*32;
//   setmainloopspe(4);
   lcolor:=255;
end;

procedure putrollman(xc:integer; yc:integer; d:integer; p:integer);
var
   x,y: integer;
   i: integer;
begin
   i:=0;
   while md[p].pd[i].x<>-32768 do begin
      if md[p].pd[i].x=-32700 then begin
         inc(i);
         while md[p].pd[i].x<>-32760 do begin
            inc(x,md[p].pd[i].x);
            inc(y,md[p].pd[i].y);
            putthickline(x,y);
            inc(i);
         end;
         inc(i);
      end else begin
         x:=xc+md[p].pd[i].x*dcos[d] div 256;
         y:=yc+md[p].pd[i].y+dsin[d] div 64;
         setthicklinefirst(x,y);
         inc(i);
         while md[p].pd[i].x<>-32760 do begin
            inc(x,md[p].pd[i].x*dcos[d] div 256);
            inc(y,md[p].pd[i].y);
            putthickline(x,y);
            inc(i);
         end;
         inc(i);
      end;
   end;
end;

procedure inithngtitle;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   setzoom(0,0,256);
   hngcou:=0;
   lcolor:=255;
   setmainloopspe(5);
end;

procedure movehngtitle;
var
   mmv,mbt: integer;
begin
   inc(hngcou);
   sethira2('Ź',200,200,50,1);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (hngcou>165) then inithngex;
end;

procedure puthngtitle;
 var
   x: integer;
begin
   x:=hngcou*5;
   putrollman(x,YCENT+128,(x*16) and 1023,17);
end;

procedure inithngex;
begin
   clearhira;
   makehngmountdata;
   myp:=32; myx:=0; myy:=0; myd:=512; speed:=0; tmpsp:=0;
   mytd:=0; mypt:=0;
   zm:=256;
   flx:=-32768;
   hngcou:=0;
   dist:=-17*32;
   setmainloopspe(6);
   hngdemocou:=1;
end;

procedure movehngex;
var
   mmv,mbt: integer;
begin
   sethira2('޾Ҳ',0,0,48,1);
   movehng;
   inc(hngdemocou);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (hngdemocou>360) then inithng;
end;

procedure puthngex;
begin
   if hngcou=0 then hngcou:=48;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   if hngcou<=49 then begin
      putmount(myp,XCENT-myx,YCENT-myy);
      putrollman(XCENT,YCENT,myd,17);
      if hngcou=49 then begin
         setthicklinefirst(XCENT,YCENT);
         putthickline(XCENT+dcos[mytd] div 4,YCENT-dsin[mytd] div 4);
      end;
   end else begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(mymx,mymy),8+mypt);
      if flx>-32768 then
         putman(XCENT-myx+flx,YCENT-myy+fly,(getdeg(flmx,flmy)-256)and 1023,19)
      else
         putrollman(XCENT-myx,YCENT-myy,myd,18);
   end;
end;

procedure inithngdemo;
begin
   clearhira;
   makehngmountdata;
   myp:=32; myx:=0; myy:=0; myd:=512; speed:=0; tmpsp:=0;
   mytd:=0; mypt:=0;
   zm:=256;
   flx:=-32768;
   hngcou:=0;
   dist:=-17*32;
   sethira2('Ź',0,0,24,640);
   sethira2('2',120,400,40,640);
   lcolor:=255;
   setmainloopspe(-3);
   hngdemocou:=-1; dmmbtcou:=0;
   hngtry:=1;
end;

procedure movehng;
const
   ROLMES: array [0..7] of string = (
      'ٰ','۰','ٸ','','ǰ','ް','˲','ܰ');
   FALMES: array [0..7] of string = (
      'ٰ','ð','ܰ','˲','ް','','ż','');
   TCHMES: array [0..7] of string = (
      '','','޻','޼','','','','');
var
   mmv,mbt: integer;
   tp,d: integer;
   s: string;
   i,n: integer;
   sc :integer;
begin
   if hngdemocou=0 then begin
      Mas_Main_Form.getmousestatus(mmv,mbt);
      inc(speed,(mmv+mousesense div 2) div mousesense);
   end else if hngdemocou>0 then begin
      inc(speed); mbt:=0;
      case hngdemocou of
         8:sethira2('ϳظĦܼϽ',32,80,30,48);
         64:sethira2('޹ʼطޯ',32,80,30,48);
         115:sethira2('϶޶޹Ѳķ',32,80,30,110);
         120:mbt:=1;
         121..290:begin
            mbt:=2;
            if hngdemocou=121 then sethira2('Ź',320,120,30,105);
            if hngdemocou=230 then sethira2('ݦŶ޻',32,80,30,100);
            if hngdemocou=235 then sethira2('޶޷',180,120,30,95);
         end;
      end;
      case hngdemocou of
         121..230: exit;
         235..280:begin
            d:=mytd*360 div 1024;
            s:=inttostr(d);
            s:=s+'';
            sethira2(s,350,200,64,1);
            exit;
         end;
      end;
{         120:mbt:=1;
         121..220:begin
            mbt:=2;
            if hngdemocou=125 then sethira2('Ź',320,120,30,78);
            if hngdemocou=210 then sethira2('ݦŶ޻',32,80,30,100);
            if hngdemocou=215 then sethira2('޶޷',180,120,30,95);
         end;
      end;
      if (hngdemocou>130) and (hngdemocou<=215) then begin
         d:=mytd*360 div 1024;
         s:=inttostr(d);
         s:=s+'';
         sethira2(s,350,200,64,1);
         exit;
      end;}
   end else begin
      inc(speed); mbt:=0;
      if dmmbtcou>0 then begin
         inc(dmmbtcou);
         if (dmmbtcou>10) and (random(5)=0) then mbt:=0
         else mbt:=2;
      end else begin
         if (hngdemocou<-140) then begin
            if (myd<200) or (myd>800) then begin
               if (random(14)=0) then mbt:=1;
            end else begin
               if (random(56)=0) then mbt:=1;
            end;
         end;
         if mbt=1 then dmmbtcou:=1;
      end;
      dec(hngdemocou);
      if hngcou>170 then inittitle;
   end;
   case hngcou of
	48:begin
      if speed<64 then inc(myd,speed)
      else begin
         if random(16)=0 then sethira(ROLMES[random(8)],240,240,36+random(24),random(15)-7);
         inc(myd,64);// myd:=myd and (1023-63);
         dec(speed,(speed-64) div 32);
      end;
//      Form2.Memo1.Lines.Add(inttostr(speed));
      myd:=myd and 1023;
      inc(myx,4); inc(dist,4);
//      Form2.Memo1.Lines.Add(InttoStr(dist));
      if myx>31 then begin
         dec(myx,32); inc(myp);
         if myp>48 then begin
            dec(myp); inc(myx,32);
         end;
      end;
      inc(zm,((128+speed)-zm) div 8);
      if mbt=1 then begin
         if myd>512 then d:=1024-myd
         else d:=myd;
         d:=d*360 div 1024;
         s:=inttostr(d);
         s:=s+'';
         sethira2(s,100,128,48,64);
         hngcou:=49;
      end;
      if dist>=0 then begin
         sethira2('ݸޱ',128,200,64,100);
         hngcou:=50;
         mymx:=8; mymy:=-4;
         flx:=myx; fly:=myy;
         flmx:=4; flmy:=-8;
      end;
   end;
   49:begin
      if (myd>256) and (myd<768) then begin
         mymx:=-16; mymy:=-10;
         hngcou:=50;
      end;
      inc(mytd,8);
      d:=mytd*360 div 1024;
      s:=inttostr(d);
      s:=s+'';
      sethira2(s,350,200,64,1);
      if (mbt=0) or (mytd>250) then begin
         if mytd>250 then mytd:=250;
         tp:=speed*dcos[myd];
         mymx:=dcos[mytd]*tp div 80000;//160000;
         mymy:=-dsin[mytd]*tp div 80000;//160000;
         hngcou:=50;
         sethira2(s,350,200,64,32);
      end;
   end;
   50:begin
      inc(myx,mymx); inc(dist,mymx);
      inc(myy,mymy);
      inc(mymy,1);
      if random(12)=0 then
         sethira(FALMES[random(8)],240,240,148+random(100),random(25)-12);
      if (dist<0) and (myy>0) then begin
         sethira2('',150,200,80,80);
         hngcou:=52;
      end;
      if myy>920{896} then hngcou:=51;
      if myx>64 then zm:=20000 div myx+32;
      mypt:=(mypt+1) and 7;
   end;
   51:begin
      sethira(TCHMES[random(8)],240,240,64,0);
      myy:=920{896}; mymx:=0;
      hngcou:=53;
   end;
   52:begin
      myy:=0; mymx:=0;
      hngcou:=53;
   end;
   else
      if hngcou>52 then begin
         inc(zm,(256-zm) div 64);
         inc(hngcou);
         if hngcou>128 then begin
            dec(lcolor,4); if lcolor<0 then lcolor:=0;
         end;
         case hngcou of
            128:sethira2('۸',32,100,64,170);
            140:begin
               if dist>=0 then
                  s:=inttostr(dist*13)
               else begin
                  s:=inttostr(-dist*13);
                  sethira2('ϲŽ',400-128-length(s)*50,220,32,160);
               end;
               sethira2(s,400-length(s)*50,200,50,160);
            end;
            150:begin
               sethira2('',420,220,32,150);
               hngdist[hngtry]:=dist;
               if hngtry=3 then begin
                  dist:=-999999;
                  for i:=1 to 3 do begin
                     if hngdist[i]>dist then begin
                        dist:=hngdist[i];
                        n:=i;
                     end;
                  end;
                  if hngdist[3]>=0 then
                     s:=inttostr(hngdist[3]*13)
                  else begin
                     s:=inttostr(-hngdist[3]*13);
                     sethira2('ϲŽ',640-128-length(s)*32,3*32-32,32,960);
                  end;
                  sethira2(s,640-length(s)*32,3*32-32,32,960);
                  sethira2('ձ޽',256,n*32-32,32,960);
                  if sucf then begin
                     sethira2('Ź',0,428,42,250);
                     sc:=800000000 div (260000-dist*13);
                     if sc>20000 then sc:=20000
                     else if sc<0 then sc:=20000;
                     if dist*13<5000 then sc:=0;
                     score[3]:=sc;
                     s:=inttostr(sc);
                     sethira2(s,540-length(s)*50,420,50,250);
                     sethira2('',540,428,42,250);
                  end;
                  sethnghiscore(dist*13);
               end;
            end;
         end;
         if (((hngcou>150) and (mbt=1)) or (hngcou>400)) and not hscsf then begin
            inc(hngtry);
            if hngtry>3 then begin
               if sucf then initgfititle
               else inittitle;
            end else inithng2;
         end;
      end else if hngcou>0 then begin
         if hngcou=1 then begin
            for i:=1 to hngtry-1 do begin
               if hngdist[i]>=0 then
                  s:=inttostr(hngdist[i]*13)
               else begin
                  s:=inttostr(-hngdist[i]*13);
                  sethira2('ϲŽ',640-128-length(s)*32,i*32-32,32,960);
               end;
               sethira2(s,640-length(s)*32,i*32-32,32,960);
            end;
         end;
         case hngtry of
         2:
            sethira2('ƶ',hngcou*16,100,64,1);
         3:
            sethira2('ݶ',hngcou*16,100,64,1);
         else
            sethira2('',hngcou*16,100,64,1);
         end;
         inc(hngcou);
         if hngcou=48 then sethira('ʼ',240,240,100,0);
      end;
   end;
   if flx>-32768 then begin
      inc(flx,flmx);
      inc(fly,flmy);
      inc(flmy,1);
      if fly>980{940} then begin
         fly:=980{940}; flmx:=0;
      end;
   end;
   if (hngcou<=48) and (hngdemocou=0) then begin
      sethira2('ϲޮ',256,360,32,1);
   	inc(tmpsp,((speed*10)-tmpsp-7) div 8);
      s:=inttostr(tmpsp);
      sethira2(s,520-length(s)*64,400,64,1);
      sethira2('',540,420,50,1);
   end;
   if (hngcou=50) and (hngdemocou=0) then begin
      if dist>=0 then
        s:=inttostr(dist*13)
      else begin
        s:=inttostr(-dist*13);
        sethira2('ϲŽ',528-128-length(s)*50,440,32,1);
      end;
      sethira2(s,528-length(s)*50,420,50,1);
      sethira2('',540,440,32,1);
   end;
   movemount(myp);
end;

procedure puthng;
begin
   if hngcou=0 then hngcou:=1;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   setlcolor(lcolor);
   if hngcou<=49 then begin
      putmount(myp,XCENT-myx,YCENT-myy);
      putrollman(XCENT,YCENT,myd,17);
      if hngcou=49 then begin
         setthicklinefirst(XCENT,YCENT);
         putthickline(XCENT+dcos[mytd] div 4,YCENT-dsin[mytd] div 4);
      end;
   end else begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(mymx,mymy),8+mypt);
      if flx>-32768 then
         putman(XCENT-myx+flx,YCENT-myy+fly,(getdeg(flmx,flmy)-256)and 1023,19)
      else
         putrollman(XCENT-myx,YCENT-myy,myd,18);
   end;
   setlcolor(255);
end;

end.
