unit mas_hira;

interface

uses Windows,SysUtils,Dialogs,
   mas_put,mas_form;

procedure inithira;
procedure clearhira;
procedure sethira(mes:string; x:integer; y:integer; zoom:integer; mx:integer);
procedure sethira2(mes:string; x:integer; y:integer; zoom:integer; cou:integer);
procedure movehira;
procedure puthira;

implementation

const
   HIRANUM = 8-1;
   HIRA2NUM = 32-1;
type
   Hiradat = record
      pd: array [0..31] of TPoint;
   end;
   DHira = record
      mes: string;
      x,y,zoom,cou: integer;
      mx: integer;
   end;
   DHira2 = record
      mes: string;
      x,y,zoom,cou: integer;
   end;

var
  hd: array [0..60] of Hiradat;
  hira : array [0..HIRANUM] of DHira;
  hira2: array [0..HIRA2NUM] of DHira2;
  hc,hc2: integer;

procedure loadhiradata;
var
   F: File of Hiradat;
   i: integer;
begin
   i:=0;
   system.assign(F,'hira.ldt');
   try
      reset(F);
   except
      on EInOutError do begin
         MessageDlg('Can''t fine file hira.ldt',mtError,[mbOk],0);
         Mas_Main_Form.close; halt;
      end;
   end;
   while not EOF(F) do begin
      system.read(F,hd[i]);
      inc(i);
   end;
   system.close(F);
end;

procedure inithira;
var
   i: integer;
begin
   loadhiradata;
   hc:=0; hc2:=0;
   for i:=0 to HIRANUM do hira[i].cou:=0;
   for i:=0 to HIRA2NUM do hira2[i].cou:=0;
end;

procedure clearhira;
var
   i: integer;
begin
   for i:=0 to HIRANUM do hira[i].cou:=0;
   for i:=0 to HIRA2NUM do hira2[i].cou:=0;
end;

procedure sethira(mes:string; x:integer; y:integer; zoom:integer; mx:integer);
begin
   hira[hc].mes:=mes;
   hira[hc].x:=x; hira[hc].y:=y; hira[hc].zoom:=zoom;
   hira[hc].cou:=32;
   hira[hc].mx:=mx;
   hc:=(hc+1) and HIRANUM;
end;

procedure sethira2(mes:string; x:integer; y:integer; zoom:integer; cou:integer);
var
   i: integer;
begin
   for i:=0 to HIRA2NUM do begin
      hc2:=(hc2+1) and HIRA2NUM;
      if hira2[hc2].cou=0 then begin
         hira2[hc2].mes:=mes;
         hira2[hc2].x:=x; hira2[hc2].y:=y; hira2[hc2].zoom:=zoom;
         hira2[hc2].cou:=cou;
         break;
      end;
   end;
end;

procedure movehira;
var
   r:integer;
   zoom:integer;
begin
   for r:=0 to HIRANUM do begin
      if hira[r].cou>0 then begin
         case hira[r].cou of
            17..32:
               zoom:=hira[r].zoom*(32-hira[r].cou) div 16;
            9..16:
               zoom:=hira[r].zoom*hira[r].cou div 16;
            0..8:
               zoom:=hira[r].zoom*(16-hira[r].cou) div 16;
         end;
         inc(hira[r].x,hira[r].mx);
         dec(hira[r].y,100*zoom div 256);
         dec(hira[r].cou);
      end;
   end;
   for r:=0 to HIRA2NUM do begin
      if hira2[r].cou>0 then dec(hira2[r].cou);
   end;
end;

procedure puthira;
var
   r: integer;
   x,y,stx,sty,tsty: integer;
   i,n,p,zoom,tzm,len: integer;
begin
   for r:=0 to HIRANUM do begin
      if hira[r].cou>0 then begin
         stx:=hira[r].x; sty:=hira[r].y;
         case hira[r].cou of
            17..32:
               zoom:=hira[r].zoom*(32-hira[r].cou) div 16;
            9..16:
               zoom:=hira[r].zoom*hira[r].cou div 16;
            0..8:
               zoom:=hira[r].zoom*(16-hira[r].cou) div 16;
         end;
         len:=length(hira[r].mes);
         dec(stx,zoom*len div 2);
         for n:=1 to len do begin
            i:=0; p:=integer(hira[r].mes[n]);
            case p of
               $30..$39:
                  begin
                     dec(p,$30-49);
                     tzm:=zoom; tsty:=sty;
                  end;
               $ac:
                  begin
                     p:=$24;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $ad:
                  begin
                     p:=$25;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $ae:
                  begin
                     p:=$26;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $af:
                  begin
                     p:=$12;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $de:
                  begin
                     p:=$2e;
                     tzm:=zoom; tsty:=sty;
                     dec(stx,zoom);
                  end;
               $df:
                  begin
                     p:=$2f;
                     tzm:=zoom; tsty:=sty;
                     dec(stx,zoom);
                  end;
               $a6:
                  begin
                     p:=$30;
                     tzm:=zoom; tsty:=sty;
                  end;
               $68:
                  begin
                     p:=59;
                     tzm:=zoom; tsty:=sty;
                  end;
               $69:
                  begin
                     p:=60;
                     tzm:=zoom; tsty:=sty;
                  end;
               else begin
                  dec(p,$b0);
                  tzm:=zoom; tsty:=sty;
               end;
            end;
            while hd[p].pd[i].x<>-32768 do begin
               x:=stx+hd[p].pd[i].x*tzm div 256;
               y:=tsty+hd[p].pd[i].y*tzm div 256;
               setthicklinefirst(x,y);
               inc(i);
               while hd[p].pd[i].x<>-32760 do begin
                  x:=stx+hd[p].pd[i].x*tzm div 256;
                  y:=tsty+hd[p].pd[i].y*tzm div 256;
                  putthickline(x,y);
                  inc(i);
               end;
               inc(i);
            end;
            inc(stx,zoom);
         end;
      end;
   end;
   for r:=0 to HIRA2NUM do begin
      if hira2[r].cou>0 then begin
         stx:=hira2[r].x; sty:=hira2[r].y;
         zoom:=hira2[r].zoom;
         len:=length(hira2[r].mes);
         for n:=1 to len do begin
            i:=0; p:=integer(hira2[r].mes[n]);
            case p of
               $30..$39:
                  begin
                     dec(p,$30-49);
                     tzm:=zoom; tsty:=sty;
                  end;
               $ac:
                  begin
                     p:=$24;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $ad:
                  begin
                     p:=$25;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $ae:
                  begin
                     p:=$26;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $af:
                  begin
                     p:=$12;
                     tzm:=zoom div 2; tsty:=sty+tzm;
                  end;
               $de:
                  begin
                     p:=$2e;
                     tzm:=zoom; tsty:=sty;
                     dec(stx,zoom);
                  end;
               $df:
                  begin
                     p:=$2f;
                     tzm:=zoom; tsty:=sty;
                     dec(stx,zoom);
                  end;
               $a6:
                  begin
                     p:=$30;
                     tzm:=zoom; tsty:=sty;
                  end;
               $68:
                  begin
                     p:=59;
                     tzm:=zoom; tsty:=sty;
                  end;
               $69:
                  begin
                     p:=60;
                     tzm:=zoom; tsty:=sty;
                  end;
               else begin
                  dec(p,$b0);
                  tzm:=zoom; tsty:=sty;
               end;
            end;
            while hd[p].pd[i].x<>-32768 do begin
               x:=stx+hd[p].pd[i].x*tzm div 256;
               y:=tsty+hd[p].pd[i].y*tzm div 256;
               setthicklinefirst2(x,y);
               inc(i);
               while hd[p].pd[i].x<>-32760 do begin
                  x:=stx+hd[p].pd[i].x*tzm div 256;
                  y:=tsty+hd[p].pd[i].y*tzm div 256;
                  putthickline2(x,y);
                  inc(i);
               end;
               inc(i);
            end;
            inc(stx,zoom);
         end;
      end;
   end;
end;

end.

