unit mas_gfi;

interface

uses
   mas_put,mas_form,mas_hira,mas_hiscore,mas_result
   ,SysUtils;

procedure savegfihsc;
procedure loadgfihsc;
procedure cleargfihsc;
procedure putgfihiscore;
procedure initgfidemo;
procedure initgfititle;
procedure initgfiex;
procedure initgfi;
procedure movegfititle;
procedure movegfiex;
procedure movegfi;
procedure putgfititle;
procedure putgfiex;
procedure putgfi;

implementation

uses mas_main,mas_title;

const
   XCENT = 230;
   YCENT = 300;
   MAXSPEED = 30;
var
   myp,myx,maxmymy,myy,tpy,myd,mymy,myc,speed,tmpsp,dist,mvsum,mychar: integer;
   flx,fly: integer;
   kkx: integer;
   zm: integer;
   gficou,gfidemocou: integer;
   gfihsc: array [1..3] of Hscdat;

procedure cleargfihsc;
var
   i: integer;
begin
   for i:=1 to 3 do begin
      gfihsc[i].rec:=0;
      gfihsc[i].name:='---';
   end;
end;

procedure loadgfihsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'gfi.hsc');
   try
      reset(F);
   except
      on EInOutError do begin
         cleargfihsc;
         exit;
      end;
   end;
   for i:=1 to 3 do
      system.read(F,gfihsc[i]);
   system.close(F);
end;

procedure savegfihsc;
var
   F: File of Hscdat;
   i: integer;
begin
   system.assignfile(F,'gfi.hsc');
   rewrite(F);
   for i:=1 to 3 do
      system.write(F,gfihsc[i]);
   system.close(F);
end;

procedure setgfihiscore(rec: integer);
var
   i,n: integer;
begin
   n:=0;
   for i:=1 to 3 do
      if rec>gfihsc[i].rec then begin
         n:=i; break;
      end;
   if n=0 then exit;
   for i:=3 downto n+1 do
      gfihsc[i]:=gfihsc[i-1];
   gfihsc[n].rec:=rec;
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(gfihsc[i].rec)+'mm',gfihsc[i].name);
   Form3.settitle('Gyaku Fire');
   gfihsc[n].name:=Form3.entername(n,inttostr(rec)+'mm');
end;

procedure putgfihiscore;
var
   i:integer;
begin
   for i:=1 to 3 do
      Form3.sethiscore(i,inttostr(gfihsc[i].rec)+'mm',gfihsc[i].name);
   Form3.settitle('Gyaku Fire');
   Form3.show;
end;

procedure initgfidemo;
var
   i: integer;
begin
   clearhira;
   for i:=0 to MOULEN-1 do begin
      if (i>128) and (i<256) then mountdata[i].d:=256
      else mountdata[i].d:=0;
      if (i>256) and (random(16)=0) then mountdata[i].obj:=3
      else if (i<128) and (random(12)=0) then mountdata[i].obj:=12
      else mountdata[i].obj:=-1;
   end;
   mountdata[128].obj:=13;

   myp:=32; myx:=0; myy:=0; speed:=0; mvsum:=0; tmpsp:=0;
   myc:=0; myd:=0;
   kkx:=-1024;
   flx:=0; fly:=0;
   zm:=256;
   gficou:=0; gfidemocou:=-1;
   dist:=0;
   lcolor:=255;
   setmainloopspe(-6);
   sethira2('ެ̱԰',0,0,24,640);
   sethira2('2',120,400,40,640);
end;

procedure initgfi;
var
   i: integer;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   for i:=0 to MOULEN-1 do begin
      if (i>128) and (i<256) then mountdata[i].d:=256
      else mountdata[i].d:=0;
      if (i>256) and (random(16)=0) then mountdata[i].obj:=3
      else if (i<128) and (random(12)=0) then mountdata[i].obj:=12
      else mountdata[i].obj:=-1;
   end;
   mountdata[128].obj:=13;

   myp:=32; myx:=0; myy:=0; speed:=0; mvsum:=0; tmpsp:=0;
   myc:=0; myd:=0;
   kkx:=-1024;
   flx:=0; fly:=0;
   zm:=256;
   gficou:=0; gfidemocou:=0;
   dist:=0;
   setmainloopspe(13);
   lcolor:=255;
end;

procedure initgfititle;
begin
   Mas_Main_Form.hidemousecursor;
   clearhira;
   setzoom(0,0,256);
   gficou:=0;
   lcolor:=255;
   setmainloopspe(14);
end;

procedure movegfititle;
var
   mmv,mbt: integer;
begin
   inc(gficou);
   sethira2('ެ̱԰',128,200,50,1);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (gficou>165) then initgfiex;
end;

procedure putgfititle;
begin
   puthngman(gficou*5-64,YCENT+128,(3-(gficou and 7))*3,23);
   puthngman(gficou*5+128,YCENT+128,(3-(gficou and 7))*3,28);
   setthicklinefirst(gficou*5-32,YCENT+128-52);
   putthickline(gficou*5+96,YCENT+128-52);
end;

procedure initgfiex;
var
   i: integer;
begin
   clearhira;
   for i:=0 to MOULEN-1 do begin
      if (i>128) and (i<256) then mountdata[i].d:=256
      else mountdata[i].d:=0;
      if (i>256) and (random(16)=0) then mountdata[i].obj:=3
      else if (i<128) and (random(12)=0) then mountdata[i].obj:=12
      else mountdata[i].obj:=-1;
   end;
   mountdata[128].obj:=13;

   myp:=32; myx:=0; myy:=0; speed:=0; mvsum:=0; tmpsp:=0;
   myc:=0; myd:=0;
   kkx:=-1024;
   flx:=0; fly:=0;
   zm:=256;
   gficou:=0; gfidemocou:=0;
   dist:=0;
   setmainloopspe(15);
   lcolor:=255;
end;

procedure movegfi;
const
   DSHMES: array [0..7] of string = (
      'ޯ','ƹ','ԯ','޲','','ް','','');
   OCHMES: array [0..7] of string = (
      'ܰ','ð','˰','','ް','','','');
var
   mmv,mbt: integer;
   s: string;
   sc: integer;
begin
   if gfidemocou=0 then begin
      Mas_Main_Form.getmousestatus(mmv,mbt);
   end else if gfidemocou>0 then begin
      inc(speed);
      mmv:=0; mbt:=0;
      case gfidemocou of
         8:sethira2('ϳظؼʼ',32,80,30,64);
         80:sethira2('ޯ¼öϳԽ',32,80,30,48);
         175:sethira2('ϯĦָ',32,80,30,50);
         240:sethira2('ĺݦ',32,80,30,64);
         281:mbt:=1;
         350:sethira2('ެƼ߲',32,80,30,64);
         420:sethira2('õ',32,80,30,64);
      end;
      case gfidemocou of
         175..225:exit;
         240..280:exit;
      end;
   end else begin
      inc(speed);
      mmv:=0; mbt:=0;
      if (gficou=50) and (mymy<16) and (random(8)=0) then mbt:=1;
      if gficou>170 then inittitle;
   end;
   case gficou of
   48:begin
      inc(speed,(mmv+mousesense div 2) div mousesense);
      if speed>MAXSPEED then begin
         myd:=MAXSPEED*4;
         dec(speed,(speed-MAXSPEED) div 32);
      end else begin
         myd:=speed*4;
      end;
      inc(myx,speed);
      inc(zm,(128-zm) div 16);
      inc(mvsum,speed);
      while myx>31 do begin
         dec(myx,32); inc(myp);
      end;
 	   if mvsum>7 then begin
		   mvsum:=0; inc(mychar);
      end;
      if (myp>=128) then begin
         sethira(DSHMES[random(8)],280,240,200,random(9));
         myx:=0; myp:=128;
         gficou:=49; mymy:=0;
      end;
      myc:=(mychar and 7);
   end;
   49:begin
      inc(speed,(mmv+mousesense div 2) div mousesense);
      dec(speed,speed div 32);
      inc(zm,(20000 div (4000-myy)-zm) div 16);
      inc(myx,speed div 4); inc(dist,speed div 4);
      inc(myy,mymy);
      inc(mymy);
      inc(mychar);
      if myy>3920 then begin
         myy:=3920; gficou:=50;
         maxmymy:=mymy; tpy:=0;
      end;
      myc:=(mychar and 7)+8;
      if random(16)=0 then
         sethira(OCHMES[random(8)],XCENT,YCENT,100+random(100),10-random(21));
   end;
   50:begin
      inc(zm,(320-zm) div 16);
      dec(mymy,4);
      inc(tpy,mymy div 10);
      if (mbt=1) or (mymy<-maxmymy) then begin
         sethira('ެ',XCENT,YCENT,160,0);
         mymy:=(abs(mymy)-maxmymy)*4 div 5;
         if mymy<-16 then gficou:=49
         else begin
            myy:=3920;
            gficou:=51; mymy:=-32;
         end;
      end;
      if random(6)=0 then
         sethira('',XCENT-64,YCENT+4064-myy-tpy-64,32,5-random(9));
      if random(6)=0 then
         sethira('',XCENT+128,YCENT+4064-myy-tpy-64,32,5-random(9));
   end;
   51:begin
      inc(zm,(80-zm) div 8);
      inc(myy,mymy);
      inc(mymy);
      inc(mychar);
      if myy>3920 then gficou:=52;
      myc:=(mychar and 7)+8;
      inc(kkx,64);
      if kkx=-128 then
            sethira('',XCENT,YCENT+4096-myy,120,7+random(15));
      if kkx>=0 then begin
         kkx:=0;
         inc(flx,48); dec(fly,32);
      end;
   end;
   52..1000:begin
      inc(gficou);
      inc(zm,(200-zm) div 16);
      if gficou>118 then begin
         dec(lcolor,4); if lcolor<0 then lcolor:=0;
      end;
      case gficou of
         118:sethira2('۸',32,100,64,170);
         130:begin
            s:=inttostr(dist*13);
            sethira2(s,400-length(s)*50,200,50,160);
         end;
         140:begin
            sethira2('',420,220,32,150);
            if sucf and (gfidemocou=0) then begin
               sethira2('̱԰',0,428,42,250);
               sc:=700000000 div (170000-dist*13);
               if sc>20000 then sc:=20000
               else if sc<0 then sc:=20000;
               score[4]:=sc;
               s:=inttostr(sc);
               sethira2(s,540-length(s)*50,420,50,250);
               sethira2('',540,428,42,250);
            end;
            if gfidemocou=0 then setgfihiscore(dist*13);
         end;
      end;
      if (((gficou>140) and (mbt=1)) or (gficou>390)) and not hscsf then
         if sucf then initresult
         else inittitle;
   end;
   else begin
      if gficou>0 then begin
         sethira2('',gficou*16,100,64,1);
         inc(gficou);
         if gficou=48 then sethira('ƹ',280,240,100,0);
      end;
   end;
   end;

   if (gficou<49) and (gfidemocou=0) then begin
      sethira2('ϲ',256,360,32,1);
   	inc(tmpsp,((speed*14)-tmpsp-7) div 8);
      s:=inttostr(tmpsp);
      sethira2(s,520-length(s)*64,400,64,1);
      sethira2('',540,420,50,1);
      if (myp<110) and (random(4)=0) then
         sethira('',random(640),YCENT,32+random(32),11-random(23));
   end;
   if (gficou>48) and (gficou<51) and (gfidemocou=0) then begin
      s:=inttostr(dist*13);
      sethira2(s,528-length(s)*50,420,50,1);
      sethira2('',540,440,32,1);
   end;
   movemount(myp);
end;

procedure putobject(x: integer; y: integer; spe: integer);
var
   i: integer;
begin
   setthicklinefirst(x,y);
   i:=0;
   while obd[spe].pd[i].x<>-32768 do begin
      inc(x,obd[spe].pd[i].x);
      inc(y,obd[spe].pd[i].y);
      putthickline(x,y);
      inc(i);
   end;
end;

procedure movegfiex;
var
   mmv,mbt: integer;
begin
   sethira2('޾Ҳ',0,0,48,1);
   movegfi;
   inc(gfidemocou);
   Mas_Main_Form.getmousestatus(mmv,mbt);
   if (mbt=1) or (gfidemocou>520) then initgfi;
end;

procedure putgfiex;
begin
   if gficou=0 then gficou:=48;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   setlcolor(lcolor);
   case gficou of
   0..48:begin
      putmount(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,myd,myc);
   end;
   49:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(speed,mymy),myc);
      puthngman(XCENT-64,YCENT+4064-myy,0,23);
      puthngman(XCENT+128,YCENT+4064-myy,0,28);
      setthicklinefirst(XCENT-32,YCENT+4064-52-myy);
      putthickline(XCENT+96,YCENT+4064-52-myy);
   end;
   50:begin
      putmount2(myp,XCENT-myx,YCENT-myy-tpy);
      putman(XCENT,YCENT,getdeg(speed,maxmymy),myc);
      puthngman(XCENT-64,YCENT+4064-myy-tpy,0,23);
      puthngman(XCENT+128,YCENT+4064-myy-tpy,0,28);
      setthicklinefirst(XCENT-32,YCENT+4064-52-myy-tpy);
      putthickline(XCENT+32,YCENT+4064-50-myy);
      putthickline(XCENT+96,YCENT+4064-52-myy-tpy);
   end;
   51:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(speed,mymy),myc);
      if flx=0 then begin
         puthngman(XCENT-64,YCENT+4064-myy,0,23);
         puthngman(XCENT+128,YCENT+4064-myy,0,28);
         setthicklinefirst(XCENT-32,YCENT+4064-52-myy);
         putthickline(XCENT+96,YCENT+4064-52-myy);
      end else begin
         puthngman(XCENT-64+flx,YCENT+4064-myy+fly,-flx div 8,23);
         puthngman(XCENT+128+flx,YCENT+4064-myy+fly,-flx div 8,28);
      end;
      putobject(XCENT-64+kkx,YCENT+4064-myy,11);
   end;
   52..1000:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putobject(XCENT-64+kkx,YCENT+4064-myy,11);
   end;
   end;
   setlcolor(255);
end;

procedure putgfi;
begin
   if gficou=0 then gficou:=1;
   setzoom(XCENT-XCENT*256 div zm,YCENT-YCENT*256 div zm,zm);
   setlcolor(lcolor);
   case gficou of
   0..48:begin
      putmount(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,myd,myc);
   end;
   49:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(speed,mymy),myc);
      puthngman(XCENT-64,YCENT+4064-myy,0,23);
      puthngman(XCENT+128,YCENT+4064-myy,0,28);
      setthicklinefirst(XCENT-32,YCENT+4064-52-myy);
      putthickline(XCENT+96,YCENT+4064-52-myy);
   end;
   50:begin
      putmount2(myp,XCENT-myx,YCENT-myy-tpy);
      putman(XCENT,YCENT,getdeg(speed,maxmymy),myc);
      puthngman(XCENT-64,YCENT+4064-myy-tpy,0,23);
      puthngman(XCENT+128,YCENT+4064-myy-tpy,0,28);
      setthicklinefirst(XCENT-32,YCENT+4064-52-myy-tpy);
      putthickline(XCENT+32,YCENT+4064-50-myy);
      putthickline(XCENT+96,YCENT+4064-52-myy-tpy);
   end;
   51:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putman(XCENT,YCENT,getdeg(speed,mymy),myc);
      if flx=0 then begin
         puthngman(XCENT-64,YCENT+4064-myy,0,23);
         puthngman(XCENT+128,YCENT+4064-myy,0,28);
         setthicklinefirst(XCENT-32,YCENT+4064-52-myy);
         putthickline(XCENT+96,YCENT+4064-52-myy);
      end else begin
         puthngman(XCENT-64+flx,YCENT+4064-myy+fly,-flx div 8,23);
         puthngman(XCENT+128+flx,YCENT+4064-myy+fly,-flx div 8,28);
      end;
      putobject(XCENT-64+kkx,YCENT+4064-myy,11);
   end;
   52..1000:begin
      putmount2(myp,XCENT-myx,YCENT-myy);
      putobject(XCENT-64+kkx,YCENT+4064-myy,11);
   end;
   end;
   setlcolor(255);
end;

end.
