unit mas_form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus;

type
  TMas_Main_Form = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    KS1: TMenuItem;
    N1: TMenuItem;
    K1: TMenuItem;
    K2: TMenuItem;
    P1: TMenuItem;
    N2: TMenuItem;
    KH1: TMenuItem;
    K3: TMenuItem;
    K4: TMenuItem;
    O1: TMenuItem;
    K5: TMenuItem;
    N3: TMenuItem;
    N400x3001: TMenuItem;
    N640x4801: TMenuItem;
    N800x6001: TMenuItem;
    K6: TMenuItem;
    K7: TMenuItem;
    K8: TMenuItem;
    K9: TMenuItem;
    K10: TMenuItem;
    K11: TMenuItem;
    K12: TMenuItem;
    N4: TMenuItem;
    Help1: TMenuItem;
    SearchforHelpOn1: TMenuItem;
    About1: TMenuItem;
    N5: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure AppDeact(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Exit1Click(Sender: TObject);
    procedure KS1Click(Sender: TObject);
    procedure P1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure K1Click(Sender: TObject);
    procedure K2Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure K3Click(Sender: TObject);
    procedure K4Click(Sender: TObject);
    procedure K5Click(Sender: TObject);
    procedure N400x3001Click(Sender: TObject);
    procedure N640x4801Click(Sender: TObject);
    procedure N800x6001Click(Sender: TObject);
    procedure K6Click(Sender: TObject);
    procedure K7Click(Sender: TObject);
    procedure K8Click(Sender: TObject);
    procedure K9Click(Sender: TObject);
    procedure K10Click(Sender: TObject);
    procedure K11Click(Sender: TObject);
    procedure K12Click(Sender: TObject);
    procedure SearchforHelpOn1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private 錾 }
   lasttime,thistime: dword;
   SCenterX,SCenterY: integer;
   MouseX,MouseY: integer;
   dibSect: HBITMAP;
   info: ^TBITMAPINFO;
   bitmap: Pointer;
   hp: HPALETTE;
   clientSize: TRECT;
   backbrush: HBRUSH;
   mousemv,mousebt:integer;
   hidef: boolean;
   keymv: integer;
   keyf: boolean;
   quad: array [0..255] of TRGBQUAD;
   closing: boolean;
  public
    { Public 錾 }
    table: array [0..255] of Byte;
    sxmax,symax: integer;
    function putline(x1:integer; y1:integer; x2:integer; y2:integer;
    width:integer; color:integer): boolean;
    procedure getmousestatus(var mmv:integer; var mbt:integer);
    procedure showmousecursor;
    procedure hidemousecursor;
    procedure setwindowsize(wx: integer; wy: integer);
    procedure setwindowpos(x: integer; y: integer);
  end;

var
  Mas_Main_Form: TMas_Main_Form;

implementation

uses
   mas_put,mas_main,mas_title,mas_hira,
   mas_kak,mas_hng,mas_tob,mas_ook,mas_gfi,mas_result,mas_ver;

const
     Interval = 33;
     DftWidth = 640;
     DftHeight = 480;

{$R *.DFM}

function TMas_Main_Form.putline(x1:integer; y1:integer; x2:integer; y2:integer; width:integer; color:integer): boolean;
var
   tx,ty: integer;
   c: byte;
   bp,oldbp: ^byte;
   mx,my,mm: integer;
   wx,wy,rx,ry,cx,cy,lpn: integer;
   tmp: integer;
   i,j: integer;
begin
     if (x2<0) or (x2>=sxmax) or (y2<0) or (y2>=symax) then begin
        Result:=FALSE;
        if (x1<0) or (x1>=sxmax) or (y1<0) or (y1>=symax) then exit
     end else
        if (x1<0) or (x1>=sxmax) or (y1<0) or (y1>=symax) then begin
             tx:=x1; ty:=y1;
             x1:=x2; y1:=y2; x2:=tx; y2:=ty;
             Result:=FALSE;
        end
        else Result:=TRUE;
     c:=table[color];
     bp:=bitmap;
     inc(bp,(x1+y1*sxmax));
     wx:=abs(x1-x2); wy:=abs(y1-y2);
     if (wx=0) and (wy=0) then exit;
     if wx>wy then begin
        if y1>y2 then my:=-1
        else if y1<y2 then my:=1
        else my:=0;
        mm:=my*sxmax;
        ry:=(wy*256) div wx;
        cy:=0;
        if x1>x2 then begin
//           mx:=-1;
           if wx>x1 then rx:=x1
           else rx:=wx;
           while true do begin
               if (y1<0) or (y1>=symax-width) then break;
               lpn:=0;
               while cy<256 do begin
                     if rx<=0 then begin
                        tmp:=sxmax+lpn;
                        for j:=2 to width do begin
                           inc(bp,tmp);
                           for i:=1 to lpn do begin
                           bp^:=c;
                           dec(bp);
                           end;
                        end;
                        exit;
                     end;
                     bp^:=c;
                     dec(bp);
                     dec(rx);
                     inc(cy,ry);
                     inc(lpn);
               end;
               oldbp:=bp;
               tmp:=sxmax+lpn;
               for j:=2 to width do begin
                   inc(bp,tmp);
                   for i:=1 to lpn do begin
                       bp^:=c;
                       dec(bp);
                   end;
               end;
               dec(cy,256);
               bp:=oldbp;
               inc(bp,mm);
               inc(y1,my);
           end;
        end else begin
//            mx:=1;
            if wx>(sxmax-x1) then rx:=sxmax-x1
            else rx:=wx;
            while true do begin
               if (y1<0) or (y1>=symax-width) then break;
               lpn:=0;
               while cy<256 do begin
                     if rx<=0 then begin
                        tmp:=sxmax-lpn;
                        for j:=2 to width do begin
                           inc(bp,tmp);
                           for i:=1 to lpn do begin
                              bp^:=c;
                              inc(bp);
                           end;
                        end;
                        exit;
                     end;
                     bp^:=c;
                     inc(bp);
                     dec(rx);
                     inc(cy,ry);
                     inc(lpn);
               end;
               oldbp:=bp;
               tmp:=sxmax-lpn;
               for j:=2 to width do begin
                   inc(bp,tmp);
                   for i:=1 to lpn do begin
                       bp^:=c;
                       inc(bp);
                   end;
               end;
               dec(cy,256);
               bp:=oldbp;
               inc(bp,mm);
               inc(y1,my);
            end;
        end;
     end else begin
        if y1>y2 then begin
           my:=-1;
           if wy>y1 then ry:=y1
           else ry:=wy;
        end else begin
            my:=1;
            if wy>(symax-y1) then ry:=symax-y1
            else ry:=wy;
        end;
        if x1>x2 then mx:=-1
        else if x1<x2 then mx:=1
        else mx:=0;
        mm:=my*sxmax-width;
        rx:=(wx*256) div wy;
        cx:=0;
        while true do begin
              if (x1<0) or (x1>=sxmax-width) then break;
              while cx<256 do begin
                  if ry<=0 then exit;
                  for j:=1 to width do begin
                      bp^:=c;
                      inc(bp);
                  end;
                  inc(bp,mm);
                  inc(cx,rx);
                  dec(ry);
              end;
              dec(cx,256);
              inc(bp,mx);
              inc(x1,mx);
        end;
     end;
end;

procedure TMas_Main_Form.showmousecursor;
var
   WRect: PRect;
begin
     if not hidef then exit;
     hidef:=FALSE;
     WRect:=nil;
     Windows.ClipCursor(WRect);
     repeat until Windows.ShowCursor(true)>=0;
end;

procedure TMas_Main_Form.hidemousecursor;
var
   WRect: TRect;
   Po,SPo: TPoint;
begin
     if hidef then exit;
     hidef:=TRUE;
     Po:=Point(0,0);
     SPo:=ClientToScreen(Po);
     WRect.left:=SPo.x;
     WRect.top:=SPo.y;
     WRect.right:=WRect.left+Mas_Main_Form.ClientWidth;
     WRect.bottom:=WRect.top+Mas_Main_Form.ClientHeight;
     SCenterX:=(WRect.left+WRect.right) div 2;
     SCenterY:=(WRect.top+WRect.bottom) div 2;
     Windows.SetCursorPos(SCenterX,SCenterY);
     mousex:=Mas_Main_Form.ClientWidth div 2; mouseY:=Mas_Main_Form.ClientHeight div 2;
     Windows.ClipCursor(@WRect);
     repeat until Windows.ShowCursor(false)<0;
end;

procedure TMas_Main_Form.setwindowsize(wx: integer; wy: integer);
begin
   Mas_Main_Form.ClientWidth:=wx;
   Mas_Main_Form.ClientHeight:=wy;
end;

procedure TMas_Main_Form.setwindowpos(x: integer; y: integer);
begin
   Mas_Main_Form.Left:=x;
   Mas_Main_Form.Top:=y;
end;

procedure TMas_Main_Form.FormCreate(Sender: TObject);

procedure CreateBm;
var
   i,iSysColors,iPalEntries: Integer;
   pal: ^TLOGPALETTE;
   hdcScreen: HDC;
   hwndScreen: HWND;
   oldPal: HPALETTE;
   pe: array [0..255] of TPALETTEENTRY;
   qd:^WORD;
begin
     quad[0].rgbRed:=0;
     quad[0].rgbBlue:=96;
     quad[0].rgbGreen:=0;
     for i:=1 to 255 do begin
         quad[i].rgbRed:=i;
         quad[i].rgbBlue:=i+96*(255-i) div 256;
         quad[i].rgbGreen:=i;
     end;

     getmem(info,sizeof(TBITMAPINFOHEADER)+(256*sizeof(TRGBQUAD)));
     info^.bmiHeader.biSize:=sizeof(TBITMAPINFOHEADER);
     info^.bmiHeader.biWidth:=(clientSize.right div 4)*4;
     info^.bmiHeader.biHeight:=-clientSize.bottom;
     info^.bmiHeader.biPlanes:=1;
     info^.bmiHeader.biBitCount:=8;
     info^.bmiHeader.biCompression:=BI_RGB;
     info^.bmiHeader.biSizeImage:=0;
     info^.bmiHeader.biXPelsPerMeter:=0;
     info^.bmiHeader.biYPelsPerMeter:=0;
     info^.bmiHeader.biClrUsed:=0;
     info^.bmiHeader.biClrImportant:=0;
     sxmax:=info^.bmiHeader.biWidth;
     symax:=-info^.bmiHeader.biHeight;

     hwndScreen:=Mas_Main_Form.Handle;
//     GetActiveWindow();
     hdcScreen:=GetDC(hwndScreen);

     if ( (GetDeviceCaps(hdcScreen,RASTERCAPS) and RC_PALETTE)<>0 ) then begin
        getmem(pal,sizeof(TLOGPALETTE)+sizeof(TPALETTEENTRY)*256);
        pal^.palVersion:=$300;
        pal^.palNumEntries:=256;
        for i:=0 to 255 do begin
            pal^.palPalEntry[i].peRed:=quad[i].rgbRed;
            pal^.palPalEntry[i].peBlue:=quad[i].rgbBlue;
            pal^.palPalEntry[i].peGreen:=quad[i].rgbGreen;
            pal^.palPalEntry[i].peFlags:=0;
        end;
        hp:=CreatePalette(pal^);
        freemem(pal);

        iSysColors:=GetDeviceCaps(hdcScreen,NUMCOLORS);
        iPalEntries:=GetDeviceCaps(hdcScreen,SIZEPALETTE);

        SetSystemPaletteUse(hdcScreen,SYSPAL_NOSTATIC);
        SetSystemPaletteUse(hdcScreen,SYSPAL_STATIC);

        oldPal:=SelectPalette(hdcScreen,hp,FALSE);
        RealizePalette(hdcScreen);
        SelectPalette(hdcScreen,oldPal,FALSE);

        GetSystemPaletteEntries(hdcScreen,0,iPalEntries,pe);

        for i:=0 to ((iSysColors div 2)-1) do
            pe[i].peFlags:=0;
        for i:=(iSysColors div 2) to (iPalEntries-(iSysColors div 2)-1) do
            pe[i].peFlags:=PC_NOCOLLAPSE;
        for i:=(iPalEntries-(iSysColors div 2)) to (iPalEntries-1) do
            pe[i].peFlags:=0;

        ResizePalette(hp,iPalEntries);
        SetPaletteEntries(hp,0,iPalEntries,pe);
        ReleaseDC(hwndScreen,hdcScreen);

        for i:=0 to 255 do
            table[i]:=Byte(GetNearestPaletteIndex(hp,RGB(
            quad[i].rgbRed,
            quad[i].rgbGreen,
            quad[i].rgbBlue)));

        qd:=@(info^.bmiColors[0]);
        for i:=0 to 255 do begin
            qd^:=word(i);
            inc(qd);
        end;

{        qptr:=@(info^.bmiColors[0]);

        for i:=0 to 255 do begin
            qptr^.rgbRed:=quad[i].rgbRed;
            qptr^.rgbGreen:=quad[i].rgbGreen;
            qptr^.rgbBlue:=quad[i].rgbBlue;
            inc(qptr);
        end;}
        backbrush:=CreateSolidBrush(PALETTEINDEX(table[0]));
        palf:=TRUE;
     end
     else begin
        for i:=0 to 255 do table[i]:=i;
        backbrush:=CreateSolidBrush(PALETTEINDEX(table[0]));
//        backbrush:=CreateSolidBrush(RGB(0,0,64));
//        PALETTERGB(0,0,64));
        palf:=FALSE;
        ReleaseDC(hwndScreen,hdcScreen);
     end;
end;

procedure initmasform;
begin
   clientSize:=Mas_Main_Form.ClientRect;
   LWidth:=4;
   setzoom(0,0,256);
   Mas_Main_Form.showmousecursor;
   //   hidef:=FALSE;
   keymv:=0; keyf:=TRUE;
   closing:=FALSE;
end;

begin
     initmasform;
     CreateBm;
     initall;

     mlspe:=0;
     lasttime:=GetTickCount;
     Application.OnIdle:=AppIdle;
     Application.OnDeactivate:=AppDeact;
     Application.HelpFile:='mas.hlp';
end;

procedure TMas_Main_Form.FormDestroy(Sender: TObject);
begin
     closing:=TRUE;
     cfg.x:=Mas_Main_Form.Left; cfg.y:=Mas_Main_Form.Top;
     closeall;
     showmousecursor;
     if dibSect<>HBITMAP(nil) then DeleteObject(dibSect);
     if hp<>HPALETTE(nil) then DeleteObject(hp);
     if backbrush<>HBRUSH(nil) then DeleteObject(backbrush);
     if info<>nil then freemem(info);
     halt;
end;

procedure TMas_Main_Form.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   mouseX:=X; mouseY:=Y;
end;

procedure TMas_Main_Form.FormResize(Sender: TObject);

procedure RenderReset;
var
   thdc: HDC;
begin
     if closing=TRUE then exit;
     thdc:=GetDC(Mas_Main_Form.Handle);
     if dibSect<>HBITMAP(nil) then begin
        DeleteObject(dibSect);
        info^.bmiHeader.biWidth:=(clientSize.right div 4)*4;
        info^.bmiHeader.biHeight:=-clientSize.bottom;
        sxmax:=info^.bmiHeader.biWidth;
        symax:=-info^.bmiHeader.biHeight;
     end;
     if hp<>HPALETTE(nil) then begin
        SelectPalette(thdc,hp,FALSE);
        RealizePalette(thdc);
        dibSect:=CreateDIBSection(
        thdc,info^,DIB_PAL_COLORS,bitmap,0,0);
     end else begin
         dibSect:=CreateDIBSection(
         thdc,info^,DIB_RGB_COLORS,bitmap,0,0);
     end;
     ReleaseDC(Mas_Main_Form.Handle,thdc);
end;

begin
     clientSize:=Mas_Main_Form.ClientRect;
     cfg.wx:=Mas_Main_Form.ClientWidth;
     cfg.wy:=Mas_Main_Form.ClientHeight;
     RenderReset;
end;

procedure TMas_Main_Form.FormPaint(Sender: TObject);
var
   thdc,memDC: HDC;
   old: HBITMAP;
begin
     if closing=TRUE then exit;
//     thdc:=BeginPaint(Mas_Main_Form.Handle,ps);
     thdc:=GetDC(Mas_Main_Form.Handle);
     memDC:=CreateCompatibleDC(thdc);
     old:=SelectObject(memDC,dibSect);
     if ( hp<>HPALETTE(nil) ) then begin
        SelectPalette(memDC,hp,FALSE);
        SelectPalette(thdc,hp,FALSE);
        RealizePalette(thdc);
     end else begin
        SetDIBColorTable(memDC,0,256,quad);
     end;

     FillRect(memDC,clientSize,backbrush);//GetStockObject(BLACK_BRUSH));
     GdiFlush;
     putall;
     GdiFlush;
     BitBlt(thdc,
     0,0,clientSize.right,clientSize.bottom,
     memDC,0,0,SRCCOPY);
     SelectObject(memDC,old);
     DeleteDC(memDC);
     ReleaseDC(Mas_Main_Form.Handle,thdc);
//     EndPaint(Mas_Main_Form.Handle,ps);
end;

procedure TMas_Main_Form.AppIdle(Sender:TObject;var Done:Boolean);
var
   delay:dword;
begin
     thistime:=GetTickCount;
     delay:=thistime-lasttime;
     if delay>=Interval then begin
        if hidef then begin
            mousemv:=Round(sqrt(sqr((Mas_Main_Form.ClientWidth div 2)-mouseX)+sqr((Mas_Main_Form.ClientHeight div 2)-mouseY)));
            inc(mousemv,keymv); keymv:=0;
            Windows.SetCursorPos(SCenterX,SCenterY);
        end else mousemv:=0;
        mouseX:=Mas_Main_Form.ClientWidth div 2; mouseY:=Mas_Main_Form.ClientHeight div 2;
        while delay>=Interval do begin
            moveall;
            dec(delay,Interval);
            if mousebt=1 then mousebt:=2;
            mousemv:=0;
        end;
        InvalidateRect(Mas_Main_Form.Handle,nil,FALSE);

        lasttime:=thistime-delay;
     end;
     Done:=false;
end;

procedure TMas_Main_Form.getmousestatus(var mmv:integer; var mbt:integer);
begin
   mmv:=mousemv; mbt:=mousebt;
end;

procedure TMas_Main_Form.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   if mousebt=0 then mousebt:=1;
end;

procedure TMas_Main_Form.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   mousebt:=0;
end;

procedure TMas_Main_Form.Exit1Click(Sender: TObject);
begin
   close;
end;

procedure TMas_Main_Form.KS1Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=TRUE;
   initkaktitle;
end;

procedure TMas_Main_Form.P1Click(Sender: TObject);
begin
   if Mas_Main_Form.P1.Checked then begin
      endpause;
      Mas_Main_Form.P1.Checked:=FALSE;
   end else begin
      startpause;
      Mas_Main_Form.P1.Checked:=TRUE;
   end;
end;

procedure TMas_Main_Form.AppDeact(Sender: TObject);
begin
   if mlspe>0 then begin
      if not Mas_Main_Form.P1.Checked then begin
         startpause;
         Mas_Main_Form.P1.Checked:=TRUE;
      end;
   end;
end;

procedure TMas_Main_Form.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if Shift=[ssAlt] then begin
      Mas_Main_Form.AppDeact(Sender);
   end;
   if (Key=VK_SPACE) and (mousebt<>1) then mousebt:=1;
   if (Shift=[ssShift]) and keyf then begin
      inc(keymv,768); keyf:=FALSE;
   end;
end;

procedure TMas_Main_Form.K1Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=FALSE;
   initkak;
end;

procedure TMas_Main_Form.K2Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=FALSE;
   inittob;
end;

procedure TMas_Main_Form.K6Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=FALSE;
   initook
end;

procedure TMas_Main_Form.K8Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=FALSE;
   inithng;
end;

procedure TMas_Main_Form.K10Click(Sender: TObject);
begin
   Mas_Main_Form.P1.Checked:=FALSE;
   sucf:=FALSE;
   initgfi;
end;

procedure TMas_Main_Form.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if Shift<>[ssShift] then keyf:=TRUE;
   if Key=VK_SPACE then mousebt:=0;
end;

procedure TMas_Main_Form.K3Click(Sender: TObject);
begin
   putkakhiscore;
end;

procedure TMas_Main_Form.K4Click(Sender: TObject);
begin
   puttobhiscore;
end;

procedure TMas_Main_Form.K7Click(Sender: TObject);
begin
   putookhiscore
end;

procedure TMas_Main_Form.K9Click(Sender: TObject);
begin
   puthnghiscore;
end;

procedure TMas_Main_Form.K11Click(Sender: TObject);
begin
   putgfihiscore;
end;

procedure TMas_Main_Form.K12Click(Sender: TObject);
begin
   putttlhiscore;
end;

procedure TMas_Main_Form.K5Click(Sender: TObject);
begin
   if MessageDlg('Clear High Score',mtWarning,[mbOK,mbCancel],0)
      =mrCancel then exit;
   clearkakhsc;
   clearhnghsc;
   cleartobhsc;
   clearookhsc;
   cleargfihsc;
   clearttlhsc;
end;

procedure TMas_Main_Form.N400x3001Click(Sender: TObject);
begin
   cfg.wx:=400; cfg.wy:=300;
   setwindowsize(cfg.wx,cfg.wy);
end;

procedure TMas_Main_Form.N640x4801Click(Sender: TObject);
begin
   cfg.wx:=640; cfg.wy:=480;
   setwindowsize(cfg.wx,cfg.wy);
end;

procedure TMas_Main_Form.N800x6001Click(Sender: TObject);
begin
   cfg.wx:=800; cfg.wy:=600;
   setwindowsize(cfg.wx,cfg.wy);
end;

procedure TMas_Main_Form.SearchforHelpOn1Click(Sender: TObject);
begin
   Application.HelpCommand(HELP_FINDER,0);
end;

procedure TMas_Main_Form.About1Click(Sender: TObject);
begin
   VerForm.ShowModal;
end;

end.
