package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Roll</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="roll">
 *   <sequence occurs="*">
 *     <ref label="r"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="roll"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="roll"&gt;
 *   &lt;sequence occurs="*"&gt;
 *     &lt;ref label="r"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="roll"/&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Roll implements java.io.Serializable {
    // List<Sequence2>
    private java.util.List sequence2_ = new java.util.ArrayList();

    /**
     * Creates a <code>Roll</code>.
     *
     */
    public Roll() {
    }

    /**
     * Creates a <code>Roll</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Roll(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Roll</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Roll(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Roll</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Roll(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Roll</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Roll</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Roll</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Roll</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Roll</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Roll</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Roll(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Roll</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Roll</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Roll</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        sequence2_.clear();
        while (!stack.isEmptyElement()) {
            Sequence2 node = new Sequence2(stack);
            if (node == null) {
                break;
            }
            addSequence2(node);
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("roll");
        int size;
        size = this.sequence2_.size();
        for (int i = 0;i < size;i++) {
            Sequence2 value = (Sequence2)this.sequence2_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Roll</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Roll</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Roll</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Roll</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Roll</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Roll</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Sequence2 property <b>sequence2</b>.
     *
     * @return Sequence2[]
     */
    public final Sequence2[] getSequence2() {
        Sequence2[] array = new Sequence2[sequence2_.size()];
        return ((Sequence2[])sequence2_.toArray(array));
    }

    /**
     * Sets the Sequence2 property <b>sequence2</b>.
     *
     * @param sequence2
     */
    public final void setSequence2(Sequence2[] sequence2) {
        this.sequence2_.clear();
        this.sequence2_.addAll(java.util.Arrays.asList(sequence2));
    }

    /**
     * Sets the Sequence2 property <b>sequence2</b>.
     *
     * @param sequence2
     */
    public final void setSequence2(Sequence2 sequence2) {
        this.sequence2_.clear();
        this.sequence2_.add(sequence2);
    }

    /**
     * Adds the Sequence2 property <b>sequence2</b>.
     *
     * @param sequence2
     */
    public final void addSequence2(Sequence2 sequence2) {
        this.sequence2_.add(sequence2);
    }

    /**
     * Gets number of the Sequence2 property <b>sequence2</b>.
     *
     * @return int
     */
    public final int getSequence2Count() {
        return (sequence2_.size());
    }

    /**
     * Gets the Sequence2 property <b>sequence2</b> by index.
     *
     * @param index
     * @return Sequence2
     */
    public final Sequence2 getSequence2(int index) {
        return ((Sequence2)sequence2_.get(index));
    }

    /**
     * Sets the Sequence2 property <b>sequence2</b> by index.
     *
     * @param index
     * @param sequence2
     */
    public final void setSequence2(int index, Sequence2 sequence2) {
        this.sequence2_.set(index, sequence2);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<roll");
        buffer.append(">");
        size = this.sequence2_.size();
        for (int i = 0;i < size;i++) {
            Sequence2 value = (Sequence2)this.sequence2_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</roll>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<roll");
        buffer.print(">");
        size = this.sequence2_.size();
        for (int i = 0;i < size;i++) {
            Sequence2 value = (Sequence2)this.sequence2_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</roll>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Roll</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "roll")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Sequence2.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Roll</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Roll</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
