package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>R</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="r" type="string"/>
 * 
 * <tag name="r">
 *   <attribute name="d" required="true" type="string"/>
 *   <attribute name="t" required="true" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="r" type="string"/&gt;
 * &lt;tag name="r"&gt;
 *   &lt;attribute name="d" required="true" type="string"/&gt;
 *   &lt;attribute name="t" required="true" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class R implements java.io.Serializable {
    private String content_;
    private String d_;
    private String t_;

    /**
     * Creates a <code>R</code>.
     *
     */
    public R() {
    }

    /**
     * Creates a <code>R</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public R(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>R</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public R(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>R</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public R(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>R</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>R</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>R</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>R</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>R</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>R</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public R(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>R</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>R</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>R</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        d_ = URelaxer.getAttributePropertyAsString(element, "d");
        t_ = URelaxer.getAttributePropertyAsString(element, "t");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("r");
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        URelaxer.setAttributePropertyByString(element, "d", this.d_);
        URelaxer.setAttributePropertyByString(element, "t", this.t_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>R</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>R</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>R</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>R</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>R</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>R</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public final String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>d</b>.
     *
     * @return String
     */
    public final String getD() {
        return (d_);
    }

    /**
     * Sets the String property <b>d</b>.
     *
     * @param d
     */
    public final void setD(String d) {
        this.d_ = d;
    }

    /**
     * Gets the String property <b>t</b>.
     *
     * @return String
     */
    public final String getT() {
        return (t_);
    }

    /**
     * Sets the String property <b>t</b>.
     *
     * @param t
     */
    public final void setT(String t) {
        this.t_ = t;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<r");
        buffer.append(" d=\"");
        buffer.append(URelaxer.escapeAttrQuot(getD()));
        buffer.append("\"");
        buffer.append(" t=\"");
        buffer.append(URelaxer.escapeAttrQuot(getT()));
        buffer.append("\"");
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(getContent()));
        buffer.append("</r>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<r");
        buffer.print(" d=\"");
        buffer.print(URelaxer.escapeAttrQuot(getD()));
        buffer.print("\"");
        buffer.print(" t=\"");
        buffer.print(URelaxer.escapeAttrQuot(getT()));
        buffer.print("\"");
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(getContent()));
        buffer.print("</r>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDAsString() {
        return (URelaxer.getString(getD()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTAsString() {
        return (URelaxer.getString(getT()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDByString(String string) {
        setD(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTByString(String string) {
        setT(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>R</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "r")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>R</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>R</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
